/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.control.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.control.bean.ControlEntity;
import com.ejianc.business.control.service.IControlService;
import com.ejianc.business.control.vo.ControlDetailFiveVO;
import com.ejianc.business.control.vo.ControlDetailFourVO;
import com.ejianc.business.control.vo.ControlDetailThreeVO;
import com.ejianc.business.control.vo.ControlDetailTwoVO;
import com.ejianc.business.control.vo.ControlDetailVO;
import com.ejianc.business.control.vo.ControlVO;
import com.ejianc.business.prosub.enums.ProsubBillTypeEnum;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareLabsubApi;
import com.ejianc.foundation.share.api.IShareProsubApi;
import com.ejianc.foundation.share.vo.LabsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"control"})
public class ControlController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IExecutionApi executionApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IControlService service;
    @Autowired
    private IShareProsubApi shareProsubApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareLabsubApi shareLabsubApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ControlVO> saveOrUpdate(@RequestBody ControlVO saveOrUpdateVO) {
        List contractDetailVOS;
        ControlVO vo = this.service.saveOrUpdate(saveOrUpdateVO, false);
        if (CollectionUtils.isNotEmpty((Collection)vo.getControlDetailList())) {
            contractDetailVOS = vo.getControlDetailList().stream().sorted(Comparator.comparing(ControlDetailVO::getSort)).collect(Collectors.toList());
            vo.setControlDetailList(contractDetailVOS);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getControlDetailTwoList())) {
            contractDetailVOS = vo.getControlDetailTwoList().stream().sorted(Comparator.comparing(ControlDetailTwoVO::getSort)).collect(Collectors.toList());
            vo.setControlDetailTwoList(contractDetailVOS);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getControlDetailThreeList())) {
            contractDetailVOS = vo.getControlDetailThreeList().stream().sorted(Comparator.comparing(ControlDetailThreeVO::getSort)).collect(Collectors.toList());
            vo.setControlDetailThreeList(contractDetailVOS);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getControlDetailFourList())) {
            contractDetailVOS = vo.getControlDetailFourList().stream().sorted(Comparator.comparing(ControlDetailFourVO::getSort)).collect(Collectors.toList());
            vo.setControlDetailFourList(contractDetailVOS);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getControlDetailFiveList())) {
            contractDetailVOS = vo.getControlDetailFiveList().stream().sorted(Comparator.comparing(ControlDetailFiveVO::getSort)).collect(Collectors.toList());
            vo.setControlDetailFiveList(contractDetailVOS);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ControlVO> queryDetail(Long id) {
        List contractDetailVOS;
        ControlVO vo = this.service.queryDetail(id);
        if (CollectionUtils.isNotEmpty((Collection)vo.getControlDetailList())) {
            contractDetailVOS = vo.getControlDetailList().stream().sorted(Comparator.comparing(ControlDetailVO::getSort)).collect(Collectors.toList());
            vo.setControlDetailList(contractDetailVOS);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getControlDetailTwoList())) {
            contractDetailVOS = vo.getControlDetailTwoList().stream().sorted(Comparator.comparing(ControlDetailTwoVO::getSort)).collect(Collectors.toList());
            vo.setControlDetailTwoList(contractDetailVOS);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getControlDetailThreeList())) {
            contractDetailVOS = vo.getControlDetailThreeList().stream().sorted(Comparator.comparing(ControlDetailThreeVO::getSort)).collect(Collectors.toList());
            vo.setControlDetailThreeList(contractDetailVOS);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getControlDetailFourList())) {
            contractDetailVOS = vo.getControlDetailFourList().stream().sorted(Comparator.comparing(ControlDetailFourVO::getSort)).collect(Collectors.toList());
            vo.setControlDetailFourList(contractDetailVOS);
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getControlDetailFiveList())) {
            contractDetailVOS = vo.getControlDetailFiveList().stream().sorted(Comparator.comparing(ControlDetailFiveVO::getSort)).collect(Collectors.toList());
            vo.setControlDetailFiveList(contractDetailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryTwoCategoryByIds"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ControlDetailFiveVO>> queryDetail(@RequestBody ControlVO controlVO) {
        ProsubCategoryVO prosubCategoryVO1;
        ControlDetailFiveVO controlDetailFiveVO;
        long parseLong;
        String[] parts;
        String innerCode2;
        Map twoCategoryMap;
        List listTwoCommonResponseData;
        CommonResponse listTwoCommonResponse;
        List secondLevelIds;
        List prosubCategoryVOS;
        CommonResponse listCommonResponse;
        List categorgIds = controlVO.getCategorgIds();
        Integer subType = controlVO.getSubType();
        ArrayList<ControlDetailFiveVO> detailFiveVOList = new ArrayList<ControlDetailFiveVO>();
        if (subType == 1) {
            listCommonResponse = this.shareProsubApi.queryCategoryListByIds(categorgIds);
            if (!listCommonResponse.isSuccess()) {
                throw new BusinessException("\u6839\u636e\u5206\u5305\u5206\u7c7bid\u67e5\u8be2\u5206\u7c7b\u5931\u8d25");
            }
            prosubCategoryVOS = (List)listCommonResponse.getData();
            secondLevelIds = prosubCategoryVOS.stream().map(vo -> vo.getInnerCode()).filter(innerCode -> innerCode != null && !innerCode.isEmpty()).map(innerCode -> {
                String[] parts = innerCode.split("\\|");
                if (parts.length >= 2) {
                    try {
                        return Long.parseLong(parts[1]);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                return null;
            }).filter(id -> id != null).distinct().collect(Collectors.toList());
            listTwoCommonResponse = this.shareProsubApi.queryCategoryListByIds(secondLevelIds);
            if (!listTwoCommonResponse.isSuccess()) {
                throw new BusinessException("\u6839\u636e\u5206\u5305\u5206\u7c7bid\u67e5\u8be2\u5206\u7c7b\u5931\u8d25");
            }
            listTwoCommonResponseData = (List)listTwoCommonResponse.getData();
            twoCategoryMap = listTwoCommonResponseData.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            for (ProsubCategoryVO prosubCategoryVO : prosubCategoryVOS) {
                innerCode2 = prosubCategoryVO.getInnerCode();
                parts = innerCode2.split("\\|");
                parseLong = Long.parseLong(parts[1]);
                controlDetailFiveVO = new ControlDetailFiveVO();
                controlDetailFiveVO.setDocCategoryId(prosubCategoryVO.getId());
                if (twoCategoryMap.containsKey(parseLong)) {
                    prosubCategoryVO1 = (ProsubCategoryVO)twoCategoryMap.get(parseLong);
                    controlDetailFiveVO.setCategoryTwoId(prosubCategoryVO1.getId());
                    controlDetailFiveVO.setCategoryTwoName(prosubCategoryVO1.getName());
                }
                detailFiveVOList.add(controlDetailFiveVO);
            }
        }
        if (subType == 2 || subType == 3 || subType == 4) {
            listCommonResponse = this.shareLabsubApi.getCategoryListByIds(categorgIds);
            if (!listCommonResponse.isSuccess()) {
                throw new BusinessException("\u6839\u636e\u5206\u5305\u5206\u7c7bid\u67e5\u8be2\u5206\u7c7b\u5931\u8d25");
            }
            prosubCategoryVOS = (List)listCommonResponse.getData();
            secondLevelIds = prosubCategoryVOS.stream().map(vo -> vo.getInnerCode()).filter(innerCode -> innerCode != null && !innerCode.isEmpty()).map(innerCode -> {
                String[] parts = innerCode.split("\\|");
                if (parts.length >= 2) {
                    try {
                        return Long.parseLong(parts[1]);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                return null;
            }).filter(id -> id != null).distinct().collect(Collectors.toList());
            listTwoCommonResponse = this.shareLabsubApi.queryCategoryListByIds(secondLevelIds);
            if (!listTwoCommonResponse.isSuccess()) {
                throw new BusinessException("\u6839\u636e\u5206\u5305\u5206\u7c7bid\u67e5\u8be2\u5206\u7c7b\u5931\u8d25");
            }
            listTwoCommonResponseData = (List)listTwoCommonResponse.getData();
            twoCategoryMap = listTwoCommonResponseData.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            for (ProsubCategoryVO prosubCategoryVO : prosubCategoryVOS) {
                innerCode2 = prosubCategoryVO.getInnerCode();
                parts = innerCode2.split("\\|");
                parseLong = Long.parseLong(parts[1]);
                controlDetailFiveVO = new ControlDetailFiveVO();
                controlDetailFiveVO.setDocCategoryId(prosubCategoryVO.getId());
                if (twoCategoryMap.containsKey(parseLong)) {
                    prosubCategoryVO1 = (LabsubCategoryVO)twoCategoryMap.get(parseLong);
                    controlDetailFiveVO.setCategoryTwoId(prosubCategoryVO1.getId());
                    controlDetailFiveVO.setCategoryTwoName(prosubCategoryVO1.getCategoryName());
                }
                detailFiveVOList.add(controlDetailFiveVO);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", detailFiveVOList);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ControlVO vo : vos) {
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                for (ControlVO contractVO : vos) {
                    ControlEntity controlEntity = (ControlEntity)((Object)this.service.selectById(contractVO.getId()));
                    if (!ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(controlEntity.getType())) continue;
                    ExecutionVO executionVO = this.service.targetCost((ControlVO)BeanMapper.map((Object)((Object)controlEntity), ControlVO.class), this.service.getLinkUrl(controlEntity.getId(), controlEntity.getType()), controlEntity.getSubType(), ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(controlEntity.getType()) ? ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7.getBillTypeCode() : ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae.getBillTypeCode());
                    totalExecutionVOList.add(executionVO.getTotalVO());
                }
                if (!CollectionUtils.isNotEmpty(totalExecutionVOList)) continue;
                this.logger.info("\u7b56\u5212\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u7b56\u5212\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ControlVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List listvo = BeanMapper.mapList((Iterable)list, ControlVO.class);
        listvo.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            Integer bidType = vo.getBidType();
            if (bidType == null) {
                vo.setBidName("");
            } else if (bidType.equals(1)) {
                vo.setBidName("\u9879\u76ee\u62db\u6807");
            } else if (bidType.equals(2)) {
                vo.setBidName("\u6846\u67b6\u534f\u8bae\u62db\u6807");
            } else {
                vo.setBidName("");
            }
            String changeStateName = null;
            if (vo.getChangeState().equals(0)) {
                changeStateName = "\u672a\u53d8\u66f4";
            }
            if (vo.getChangeState().equals(1)) {
                changeStateName = "\u53d8\u66f4\u4e2d";
            }
            if (vo.getChangeState().equals(2)) {
                changeStateName = "\u5df2\u53d8\u66f4";
            }
            vo.setChangeStateName(changeStateName);
            String subTypeName = null;
            if (vo.getSubType().equals(1)) {
                subTypeName = "\u4e13\u4e1a\u5206\u5305";
            }
            if (vo.getSubType().equals(2)) {
                subTypeName = "\u52b3\u52a1\u5206\u5305";
            }
            vo.setSubTypeName(subTypeName);
        });
        beans.put("records", listvo);
        ExcelExport.getInstance().export("Control-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody ControlVO vo) {
        ControlVO cv = this.service.saveOrUpdate(vo, true);
        CommonResponse response = new CommonResponse();
        if (ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(vo.getType())) {
            ExecutionVO executionVO = this.service.targetCost(cv, this.service.getLinkUrl(cv.getId(), cv.getType()), cv.getSubType(), ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(cv.getType()) ? ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7.getBillTypeCode() : ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae.getBillTypeCode());
            this.logger.error("\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\uff0c\u7b56\u5212\u6210\u672c\u6570\u636e\u6821\u9a8c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            response = this.executionApi.ctrlCheckVO(executionVO);
            this.logger.info("\u5206\u5305\u5408\u540c\uff0c\u7b56\u5212\u6210\u672c\u6570\u636e\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                this.logger.error("\u7b56\u5212\u6210\u672c\u53c2\u6570\u63a7\u5236\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f-{}", (Object)response.getMsg());
                return response;
            }
        }
        ParamsCheckVO paramsCheckVO = this.service.checkParams(vo, (CommonResponse<ParamsCheckVO>)response, null);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/refControlData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ControlVO>> refControlData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"contract-import-subcontractPrice.xlsx", (String)"\u5206\u5305\u660e\u7ec6\u8868");
    }

    @RequestMapping(value={"/downloadOther"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadOther(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"contractOther-import-subcontractPrice.xlsx", (String)"\u5176\u4ed6\u5206\u5305\u660e\u7ec6\u8868");
    }

    @RequestMapping(value={"/downloadEquipment"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadEquipment(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"contractEquipment-import-subcontractPrice.xlsx", (String)"\u7279\u79cd\u8bbe\u5907\u660e\u7ec6\u8868");
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importData(Long projectId, Integer type, String tabKey, HttpServletRequest request, HttpServletResponse response) {
        return this.service.importData(projectId, type, tabKey, request, response);
    }

    @RequestMapping(value={"/importKjxyData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importKjxyData(Integer type, HttpServletRequest request, HttpServletResponse response) {
        return this.service.importKjxyData(type, request, response);
    }

    @RequestMapping(value={"/importOtherData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importOtherData(Integer type, String tabKey, HttpServletRequest request, HttpServletResponse response) {
        return this.service.importOtherData(type, tabKey, request, response);
    }

    @RequestMapping(value={"/importEquipmentData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importEquipmentData(Long projectId, Integer type, String tabKey, HttpServletRequest request, HttpServletResponse response) {
        return this.service.importEquipmentData(projectId, type, tabKey, request, response);
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ControlVO controlVO, HttpServletRequest req) {
        ControlVO cv = this.service.saveOrUpdate(controlVO, true);
        CommonResponse response = new CommonResponse();
        if (ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(controlVO.getType())) {
            ExecutionVO executionVO = this.service.targetCost(cv, this.service.getLinkUrl(cv.getId(), cv.getType()), cv.getSubType(), ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(cv.getType()) ? ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7.getBillTypeCode() : ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae.getBillTypeCode());
            this.logger.error("\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\uff0c\u7b56\u5212\u6210\u672c\u6570\u636e\u6821\u9a8c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)executionVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            response = this.executionApi.ctrlCheckVO(executionVO);
            this.logger.info("\u5206\u5305\u5408\u540c\uff0c\u7b56\u5212\u6210\u672c\u6570\u636e\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                this.logger.error("\u7b56\u5212\u6210\u672c\u53c2\u6570\u63a7\u5236\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f-{}", (Object)response.getMsg());
                return response;
            }
        }
        ParamsCheckVO responseData = this.service.checkParams(controlVO, (CommonResponse<ParamsCheckVO>)response, null);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        ControlEntity entity = (ControlEntity)((Object)this.service.selectById(id));
        ControlVO cv = (ControlVO)BeanMapper.map((Object)((Object)entity), ControlVO.class);
        CommonResponse response = new CommonResponse();
        if (ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(cv.getType())) {
            String linkUrl = this.service.getLinkUrl(cv.getId(), cv.getType());
            ExecutionVO executionVO = this.service.targetCost(cv, linkUrl, cv.getSubType(), ControlVO.\u62db\u6807\u65b9\u5f0f_\u9879\u76ee\u62db\u6807.equals(cv.getType()) ? ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7.getBillTypeCode() : ProsubBillTypeEnum.\u5206\u5305\u62db\u6807\u63a7\u5236\u4ef7\u6846\u67b6\u534f\u8bae.getBillTypeCode());
            response = this.executionApi.ctrlCheckVO(executionVO);
            this.logger.info("\u5206\u5305\u5408\u540c\uff0c\u7b56\u5212\u6210\u672c\u6570\u636e\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
            if (!response.isSuccess()) {
                this.logger.error("\u7b56\u5212\u6210\u672c\u53c2\u6570\u63a7\u5236\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f-{}", (Object)response.getMsg());
                return response;
            }
        }
        ParamsCheckVO responseData = this.service.checkParams(cv, (CommonResponse<ParamsCheckVO>)response, null);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)responseData);
    }
}

