/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.prosub.equip.service.impl;

import com.ejianc.business.prosub.equip.bean.EquipUseApplyEntity;
import com.ejianc.business.prosub.equip.service.IEquipUseApplyService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="equipUseApply")
public class EquipUseApplyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IEquipUseApplyService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        EquipUseApplyEntity entity = (EquipUseApplyEntity)((Object)this.service.selectById(billId));
        UserContext user = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(user.getUserCode());
        entity.setCommitUserName(user.getUserName());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.doBack(billId, state, billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        EquipUseApplyEntity entity = (EquipUseApplyEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            UserContext user = this.sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(user.getUserCode());
            entity.setCommitUserName(user.getUserName());
        }
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.doBack(billId, state, billTypeCode);
        return CommonResponse.success();
    }

    private void doBack(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            this.logger.error("\u5206\u5305\u673a\u68b0\u4f7f\u7528\u7533\u8bf7 \u5f03\u5ba1\u5931\u8d25\uff0c\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528, {}", (Object)resp.getMsg());
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\uff01");
        }
        EquipUseApplyEntity entity = (EquipUseApplyEntity)((Object)this.service.selectById(billId));
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
        this.service.saveOrUpdate((Object)entity, false);
    }
}

