/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.process.service.impl;

import com.ejianc.business.process.bean.ApplicationEntity;
import com.ejianc.business.process.bean.RegistrationDeductEntity;
import com.ejianc.business.process.bean.RegistrationEntity;
import com.ejianc.business.process.enums.ApplicationStateEnum;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.enums.UseFlagEnum;
import com.ejianc.business.process.service.IApplicationService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="registration")
public class RegistrationBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRegistrationService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IApplicationService applicationService;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        RegistrationEntity e = (RegistrationEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u96f6\u5de5\u7533\u8bf7\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse cooperateResp;
        List<RegistrationDeductEntity> deductList;
        RegistrationEntity entity = (RegistrationEntity)((Object)this.service.selectById(billId));
        if (entity != null) {
            entity.setEffectiveDate(new Date());
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        if (!(deductList = entity.getDeductList()).isEmpty()) {
            // empty if block
        }
        if (!(cooperateResp = this.shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode)).isSuccess()) {
            this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25, \u4e0d\u8fdb\u884c\u5355\u636e\u63a8\u9001\u64cd\u4f5c\uff0c{}", (Object)billTypeCode, (Object)cooperateResp.getMsg());
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        ApplicationEntity applicationEntity = (ApplicationEntity)((Object)this.applicationService.selectById(entity.getApplicationId()));
        if (ApplicationStateEnum.\u8d85\u65f6\u672a\u529e\u7406.getCode() == applicationEntity.getVisaState()) {
            this.service.updateUseFlag(entity.getApplicationId(), UseFlagEnum.\u96f6\u5de5\u5df2\u767b\u8bb0.getCode(), ApplicationStateEnum.\u8d85\u65f6\u529e\u7406.getCode());
        } else {
            this.service.updateUseFlag(entity.getApplicationId(), UseFlagEnum.\u96f6\u5de5\u5df2\u767b\u8bb0.getCode(), ApplicationStateEnum.\u529e\u7406\u5b8c\u6210.getCode());
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (cooperateResp.isSuccess()) {
            this.service.pushBillToSupCenter((RegistrationEntity)((Object)BeanMapper.map((Object)((Object)entity), RegistrationEntity.class)), billTypeCode, (CooperateVO)cooperateResp.getData());
        }
        return CommonResponse.success((String)"\u96f6\u5de5\u767b\u8bb0\u5355\u636e\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        RegistrationEntity entity = (RegistrationEntity)((Object)this.service.selectById(billId));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode().equals(entity.getSupplierSignStatus())) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5df2\u7b7e\u5b57\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            boolean pushResult = this.service.delPushBill(entity, billTypeCode);
            if (!pushResult) {
                return CommonResponse.error((String)"\u96f6\u5de5\u767b\u8bb0\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5220\u9664\u534f\u540c\u670d\u52a1\u5355\u636e\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.service.saveOrUpdate((Object)entity, false);
        }
        ApplicationEntity applicationEntity = (ApplicationEntity)((Object)this.applicationService.selectById(entity.getApplicationId()));
        if (ApplicationStateEnum.\u8d85\u65f6\u529e\u7406.getCode() == applicationEntity.getVisaState()) {
            this.service.updateUseFlag(entity.getApplicationId(), UseFlagEnum.\u96f6\u5de5\u672a\u767b\u8bb0.getCode(), ApplicationStateEnum.\u8d85\u65f6\u672a\u529e\u7406.getCode());
        } else {
            this.service.updateUseFlag(entity.getApplicationId(), UseFlagEnum.\u96f6\u5de5\u672a\u767b\u8bb0.getCode(), ApplicationStateEnum.\u529e\u7406\u4e2d.getCode());
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

