/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.settle.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractFlagEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleUltimateFlagEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.process.enums.BillPushStatusEnum;
import com.ejianc.business.process.enums.SupplierSignStatusEnum;
import com.ejianc.business.process.service.IDeductionService;
import com.ejianc.business.process.service.IMeasureService;
import com.ejianc.business.process.service.IPickingService;
import com.ejianc.business.process.service.IRegistrationService;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.profinance.api.ISalaryApi;
import com.ejianc.business.profinance.vo.SalaryVO;
import com.ejianc.business.prosub.bean.ChangeEntity;
import com.ejianc.business.prosub.bean.ContractEntity;
import com.ejianc.business.prosub.enums.ContractFilingTypeEnum;
import com.ejianc.business.prosub.service.IChangeService;
import com.ejianc.business.prosub.service.IContractService;
import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.business.prosub.vo.ContractVO;
import com.ejianc.business.settle.bean.SettleDeductEntity;
import com.ejianc.business.settle.bean.SettleDetailEntity;
import com.ejianc.business.settle.bean.SettleEntity;
import com.ejianc.business.settle.bean.SettleOddjobEntity;
import com.ejianc.business.settle.bean.SettleOtherEntity;
import com.ejianc.business.settle.bean.SettlePickingEntity;
import com.ejianc.business.settle.bean.SettleSalaryEntity;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settle.mapper.SettleMapper;
import com.ejianc.business.settle.service.ISettleDeductService;
import com.ejianc.business.settle.service.ISettleDetailService;
import com.ejianc.business.settle.service.ISettleOddjobService;
import com.ejianc.business.settle.service.ISettleOtherService;
import com.ejianc.business.settle.service.ISettlePickingService;
import com.ejianc.business.settle.service.ISettleSalaryService;
import com.ejianc.business.settle.service.ISettleService;
import com.ejianc.business.settle.vo.SettleDeductVO;
import com.ejianc.business.settle.vo.SettleRecordVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    private final String OPERATE = "SETTLE_BILL_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settle/billSync";
    private final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/settle/billDel";
    private final String processBillType = "BT220114000000002";
    private final String finishBillType = "BT220114000000004";
    private final String nodeBillType = "BT220114000000003";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    @Autowired
    private IMeasureService measureService;
    @Autowired
    ISettleDetailService settleDetailService;
    @Autowired
    ISettlePickingService settlePickingService;
    @Autowired
    ISettleOddjobService settleOddjobService;
    @Autowired
    ISettleDeductService settleDeductService;
    @Autowired
    ISettleOtherService settleOtherService;
    @Autowired
    ISettleSalaryService settleSalaryService;
    @Autowired
    private SettleMapper settleMapper;
    @Autowired
    private IPickingService pickingService;
    @Autowired
    private IRegistrationService oddjobService;
    @Autowired
    private IDeductionService deductService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISalaryApi salaryApi;
    private static final String SUB_CONTRACT_TOTAL_SETTLE_MNY_COUNT_SYS_PARAM = "P-Vm30230110";
    private final String SALARY_PARAMETER_CODE = "P-3r5moF0111";
    private final String FINISH_SETTLE_DIFFERENCE_CONFIG = "P-2hiWQQ0131";

    @Override
    public CommonResponse<SettleVO> queryUnusedContract(Long contractId, Date settleDate, Integer settleType, Long changeId) {
        Date resultDate;
        SettleVO settleVO = new SettleVO();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SettleEntity::getContractId, (Object)contractId);
        lambda.eq(SettleEntity::getSettleType, (Object)SettleTypeEnum.\u5b8c\u5de5.getCode());
        lambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        int resultCount = super.count((Wrapper)lambda);
        if (resultCount > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5df2\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
        }
        if (null != changeId && settleType.equals(SettleTypeEnum.\u5b8c\u5de5.getCode())) {
            LambdaQueryWrapper changeContractLambda = new LambdaQueryWrapper();
            changeContractLambda.eq(BaseEntity::getId, (Object)changeId);
            changeContractLambda.and(c -> (LambdaQueryWrapper)c.in(ChangeEntity::getBillState, new Object[]{BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}));
            int changeResultCount = this.changeService.count((Wrapper)changeContractLambda);
            if (changeResultCount > 0) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u6b63\u5728\u8fdb\u884c\u53d8\u66f4\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
            }
        }
        LambdaQueryWrapper settleLambda = new LambdaQueryWrapper();
        settleLambda.eq(SettleEntity::getContractId, (Object)contractId);
        settleLambda.and(c -> (LambdaQueryWrapper)c.notIn(SettleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}));
        List resultList = super.list((Wrapper)settleLambda);
        if (resultList.size() > 0 && null != resultList.get(0)) {
            String settleTypeName = null != ((SettleEntity)((Object)resultList.get(0))).getSettleType() ? SettleTypeEnum.getDescriptionByCode(((SettleEntity)((Object)resultList.get(0))).getSettleType()).getDescription() : "";
            return CommonResponse.error((String)("\u5f53\u524d\u5408\u540c\u6709\u672a\u5ba1\u6279\u7684" + settleTypeName + "\u7ed3\u7b97\u5355\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002"));
        }
        if (null != settleType && SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
            queryParam.getParams().put("bill_state", new Parameter("eq", (Object)BillStateEnum.APPROVING_HAS_STATE));
            List measureEntityList = this.measureService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)measureEntityList)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5728\u5206\u5305\u8ba1\u91cf\u8fd8\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
            }
            List picKingEntityList = this.pickingService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)picKingEntityList)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5728\u9886\u6599\u7ed3\u7b97\u8fd8\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
            }
            List registrationEntityList = this.oddjobService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)registrationEntityList)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5728\u96f6\u5de5\u767b\u8bb0\u8fd8\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
            }
            List deductionEntityList = this.deductService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)deductionEntityList)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5728\u5956\u7f5a\u6263\u6b3e\u5355\u8fd8\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u5355\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5408\u540c\u3002");
            }
            QueryWrapper contractQuery = new QueryWrapper();
            contractQuery.eq((Object)"contract_id", (Object)contractId);
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper changeContractLambda = new LambdaQueryWrapper();
                changeContractLambda.eq(BaseEntity::getId, (Object)contractEntity.getChangeId());
                changeContractLambda.and(c -> (LambdaQueryWrapper)c.in(ChangeEntity::getBillState, new Object[]{BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}));
                int changeResultCount = this.changeService.count((Wrapper)changeContractLambda);
                if (changeResultCount > 0) {
                    return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u6b63\u5728\u8fdb\u884c\u53d8\u66f4\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff01");
                }
            }
        }
        if (null == (resultDate = this.queryMaxSettleDate(contractId))) {
            resultDate = null != settleDate ? settleDate : new Date();
            settleVO.setMinSettleDate(null);
        } else {
            resultDate = DateUtils.addDays((Date)resultDate, (int)1);
            settleVO.setMinSettleDate(resultDate);
            if (null != settleDate && settleDate.compareTo(resultDate) > 0) {
                resultDate = settleDate;
            }
        }
        settleVO.setSettleDate(resultDate);
        settleVO.setSettleDate(resultDate);
        return CommonResponse.success((String)"\u5f53\u524d\u5408\u540c\u53ef\u7528\uff01", (Object)settleVO);
    }

    @Override
    public Date queryMaxSettleDate(Long contractId) {
        return this.settleMapper.selectMaxSettleDate(contractId);
    }

    @Override
    public String salaryParameterFlag() {
        CommonResponse response = this.paramConfigApi.getByCode("P-3r5moF0111");
        if (!response.isSuccess() || response.getData() == null) {
            this.logger.error("\u6839\u636e\u7cfb\u7edf\u53c2\u6570\u7f16\u7801-{}\uff0c\u67e5\u8be2\u7cfb\u7edf\u53c2\u6570\uff08\u5206\u5305\u5408\u540c\u6708\u5ea6\u7ed3\u7b97\u662f\u5426\u63a8\u9001\u534f\u540c\uff09\u914d\u7f6e\u4fe1\u606f\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)"P-3r5moF0111", (Object)response.getMsg());
            return "0";
        }
        return ((ParamRegisterSetVO)response.getData()).getValueData();
    }

    @Override
    public void fillOtherSettlePoolAttr(SettleEntity dbEntity, SettlePoolVO poolVO) {
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(dbEntity.getContractId()));
        poolVO.setMaiContractId(contract.getMainContractId());
        poolVO.setMaiContractName(contract.getMainContractName());
        poolVO.setMaiContractCode(contract.getMainContractCode());
        poolVO.setPartyaId(contract.getFirstPartyId());
        poolVO.setPartyaName(contract.getFirstPartyName());
        poolVO.setSignDate(contract.getSignDate());
        poolVO.setCreateTime(dbEntity.getCreateTime());
        poolVO.setCreateUserCode(dbEntity.getCreateUserCode());
        poolVO.setUpdateTime(dbEntity.getUpdateTime());
        poolVO.setUpdateUserCode(dbEntity.getUpdateUserCode());
    }

    @Override
    public int queryContractSettleNumOfNode(Long contractId) {
        return ((SettleMapper)this.baseMapper).queryContractSettleNumOfNode(contractId);
    }

    @Override
    public SettleEntity querySubTableList(Integer settleType, Long contractId, Date settleDate) {
        SettleEntity e = new SettleEntity();
        if (!SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
            e.setSettleDetailList(this.settleDetailService.queryDetailList(settleType, contractId, settleDate));
        } else {
            e.setSettleDetailList(this.settleDetailService.queryContractDetail(contractId));
        }
        e.setSettlePickingList(this.settlePickingService.queryPickingList(settleType, contractId, settleDate));
        e.setSettleOddjobList(this.settleOddjobService.queryOddjobList(settleType, contractId, settleDate));
        e.getSettleOddjobList().addAll(this.settleOddjobService.queryOddjobDeductList(settleType, contractId, settleDate));
        e.setSettleDeductList(this.settleDeductService.queryDeductList(settleType, contractId, settleDate));
        if (2 != settleType) {
            String salaryParameter = this.salaryParameterFlag();
            if ("0".equals(salaryParameter)) {
                e.setSettleSalaryList(this.settleSalaryService.querySalaryList(settleType, contractId, settleDate));
            } else {
                List zzyjSalaryList;
                CommonResponse salaryData = this.salaryApi.querySalaryList(contractId, settleType, DateUtil.formatDate((Date)settleDate));
                ArrayList<SettleSalaryEntity> settleSalaryList = new ArrayList<SettleSalaryEntity>();
                if (salaryData.isSuccess() && CollectionUtils.isNotEmpty((Collection)(zzyjSalaryList = (List)salaryData.getData()))) {
                    for (SalaryVO salaryVO : zzyjSalaryList) {
                        SettleSalaryEntity settleSalaryEntity = new SettleSalaryEntity();
                        settleSalaryEntity.setContractId(salaryVO.getContractId());
                        settleSalaryEntity.setBelongMonth(salaryVO.getBelongMonth());
                        settleSalaryEntity.setSumSalaryMny(salaryVO.getTotalSalaryMny());
                        settleSalaryEntity.setSalaryMny(salaryVO.getTotalSalaryMny());
                        settleSalaryEntity.setSourceId(salaryVO.getId());
                        settleSalaryEntity.setSourceBillCode(salaryVO.getBillCode());
                        settleSalaryList.add(settleSalaryEntity);
                    }
                }
                e.setSettleSalaryList(settleSalaryList);
            }
        }
        SettleVO processPickingVO = this.selectPickingProcessTaxMny(contractId);
        SettleVO processOddjobVO = this.selectOddjobProcessTaxMny(contractId);
        List<SettleDeductVO> SettleDeductList = this.selectDeductList(contractId);
        SettleVO processOtherVO = this.selectOtherProcessTaxMny(contractId);
        if (null != processPickingVO) {
            e.setPickingProcessTaxMny(null != processPickingVO.getPickingProcessTaxMny() ? processPickingVO.getPickingProcessTaxMny() : BigDecimal.ZERO);
            e.setPickingProcessMny(null != processPickingVO.getPickingProcessMny() ? processPickingVO.getPickingProcessMny() : BigDecimal.ZERO);
        } else {
            e.setPickingProcessTaxMny(BigDecimal.ZERO);
            e.setPickingProcessMny(BigDecimal.ZERO);
        }
        if (null != processOddjobVO) {
            e.setOddjobProcessTaxMny(null != processOddjobVO.getOddjobProcessTaxMny() ? processOddjobVO.getOddjobProcessTaxMny() : BigDecimal.ZERO);
            e.setOddjobProcessMny(null != processOddjobVO.getOddjobProcessMny() ? processOddjobVO.getOddjobProcessMny() : BigDecimal.ZERO);
        } else {
            e.setOddjobProcessTaxMny(BigDecimal.ZERO);
            e.setOddjobProcessMny(BigDecimal.ZERO);
        }
        if (CollectionUtils.isNotEmpty(SettleDeductList)) {
            BigDecimal processTaxMny = BigDecimal.ZERO;
            BigDecimal processMny = BigDecimal.ZERO;
            for (SettleDeductVO settleDeduct : SettleDeductList) {
                if (settleDeduct.getRewardDeductionType().equals(0)) {
                    processTaxMny = processTaxMny.add(settleDeduct.getDeductTaxMny());
                    processMny = processMny.add(settleDeduct.getDeductMny());
                    continue;
                }
                processTaxMny = processTaxMny.subtract(settleDeduct.getDeductTaxMny());
                processMny = processMny.subtract(settleDeduct.getDeductMny());
            }
            e.setDeductProcessTaxMny(processTaxMny);
            e.setDeductProcessMny(processMny);
        } else {
            e.setDeductProcessTaxMny(BigDecimal.ZERO);
            e.setDeductProcessMny(BigDecimal.ZERO);
        }
        if (null != processOtherVO) {
            e.setOtherProcessTaxMny(null != processOtherVO.getOtherProcessTaxMny() ? processOtherVO.getOtherProcessTaxMny() : BigDecimal.ZERO);
            e.setOtherProcessMny(null != processOtherVO.getOtherProcessMny() ? processOtherVO.getOtherProcessMny() : BigDecimal.ZERO);
        } else {
            e.setOtherProcessTaxMny(BigDecimal.ZERO);
            e.setOtherProcessMny(BigDecimal.ZERO);
        }
        return e;
    }

    @Override
    public SettleVO selectPickingProcessTaxMny(Long contractId) {
        return this.settleMapper.selectPickingProcessTaxMny(contractId);
    }

    @Override
    public SettleVO selectOddjobProcessTaxMny(Long contractId) {
        return this.settleMapper.selectOddjobProcessTaxMny(contractId);
    }

    @Override
    public List<SettleDeductVO> selectDeductList(Long contractId) {
        return this.settleMapper.selectDeductList(contractId);
    }

    @Override
    public SettleVO selectOtherProcessTaxMny(Long contractId) {
        return this.settleMapper.selectOtherProcessTaxMny(contractId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean pushBillToSupCenter(SettleEntity settleEntity, String billTypeCode, CooperateVO cooperate) {
        boolean locked = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + settleEntity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.executeUpdate(settleEntity.getId(), false);
            this.logger.error("\u63a8\u9001\u7ed3\u7b97\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)settleEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
            return false;
        }
        settleEntity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        settleEntity.setTenantId(null);
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLE_BILL_SYNC", (int)600);
            if (!locked) {
                this.executeUpdate(settleEntity.getId(), false);
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "SETTLE_BILL_SYNC");
                Boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", JSONObject.toJSONString((Object)((Object)settleEntity)));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(settleEntity.getId(), null, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                HashMap<String, String> fileSourceTypeMap = new HashMap<String, String>();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        HashMap file = new HashMap(1);
                        file.put((String)fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u7ed3\u7b97\u5355\u636e\u53c2\u6570-{}", (Object)settleEntity.getSupplierId(), (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-supbusiness-web/openapi/settle/billSync", paramMap, settleEntity.getSupplierId().toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        this.executeUpdate(settleEntity.getId(), true);
                        Boolean bl = true;
                        return bl;
                    }
                    this.executeUpdate(settleEntity.getId(), false);
                    this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u7ed3\u7b97\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{settleEntity.getSupplierId(), settleEntity.getId(), billPushResp.getMsg()});
                    Boolean bl = false;
                    return bl;
                }
                this.executeUpdate(settleEntity.getId(), false);
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u7ed3\u7b97\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{settleEntity.getId(), settleEntity.getSupplierId(), syncReqResp.getMsg()});
                Boolean bl = false;
                return bl;
            }
            this.executeUpdate(settleEntity.getId(), false);
            this.logger.error("\u83b7\u53d6\u7ed3\u7b97\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)settleEntity.getId(), (Object)fileResp.getMsg());
            Boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.executeUpdate(settleEntity.getId(), false);
            this.logger.error("\u63a8\u9001\u7ed3\u7b97\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{settleEntity.getId(), settleEntity.getSupplierId(), e});
            Boolean bl = false;
            return bl;
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLE_BILL_SYNC");
        }
    }

    private void executeUpdate(Long id, Boolean flag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            updateWrapper.set((Object)"bill_push_flag", (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public void executeUpdatePool(Long id, Boolean flag) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        if (Boolean.TRUE.equals(flag)) {
            updateWrapper.set((Object)"push_pool_flag", (Object)BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            updateWrapper.set((Object)"push_pool_flag", (Object)BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        super.update((Wrapper)updateWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        SettleEntity settleEntity = (SettleEntity)((Object)super.selectById((Serializable)((Object)billId)));
        settleEntity.setSupOperateTime(supOperateTime);
        settleEntity.setSupOperatorName(supOperatorName);
        settleEntity.setSupOperatorPhone(supOperatorPhone);
        settleEntity.setSupOperatorUserCode(supOperatorUserCode);
        String billType = null;
        if (settleEntity.getSettleType() == 0) {
            billType = "BT220114000000002";
        } else if (settleEntity.getSettleType() == 1) {
            billType = "BT220114000000004";
        } else if (settleEntity.getSettleType() == 2) {
            billType = "BT220114000000003";
        }
        String key = billType + "::" + settleEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLE_BILL_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)settleEntity.getId());
                this.releaseLock(jedis, false, key, "SETTLE_BILL_SYNC");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, billType, authority, settleEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            settleEntity.setAttachIds(attchIdsList);
            settleEntity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
            super.saveOrUpdate((Object)settleEntity, false);
            String msgSendResult = this.sendMsg(settleEntity, "\u4f9b\u65b9\u5df2\u7b7e\u5b57\u63d0\u9192", "\u7ed3\u7b97\u5355\u636e[" + settleEntity.getBillCode() + "]\u4f9b\u65b9\u5df2\u7b7e\u5b57\u5b8c\u6210");
            if (null != msgSendResult) {
                this.logger.error("\u5411\u7528\u6237-{}\u53d1\u9001\u5355\u636eid-{}\u7b7e\u5b57\u63d0\u9192\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{StringUtils.join((Object[])new Long[]{settleEntity.getCreateUserId(), settleEntity.getEmployeeId()}), settleEntity.getId(), msgSendResult});
            }
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)settleEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLE_BILL_SYNC");
        }
        return msg;
    }

    private String sendMsg(SettleEntity settleEntity, String subject, String content) {
        Object[] msgRecUserIds = new String[]{settleEntity.getCreateUserId().toString(), settleEntity.getEmployeeId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(settleEntity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delPushBill(SettleEntity settleEntity, String billTypeCode) {
        boolean locked = false;
        boolean delSuc = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + settleEntity.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u7ed3\u7b97\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)settleEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
        }
        settleEntity.setSourceSystemId((String)ejcCloudSystemCode.getData());
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"SETTLE_BILL_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u7ed3\u7b97\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01", (Object)settleEntity.getId());
                this.releaseLock(jedis, false, key, "SETTLE_BILL_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sourceId", settleEntity.getId().toString());
            paramMap.put("sourceSystemId", settleEntity.getSourceSystemId());
            this.logger.info("\u7ed3\u7b97\u5355\u636eid-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", (Object)settleEntity.getId(), (Object)settleEntity.getSupplierId());
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem("/ejc-supbusiness-web/openapi/settle/billDel", RequestMethod.POST, JSONObject.toJSONString(paramMap), settleEntity.getSupplierId().toString());
            if (syncReqResp.isSuccess()) {
                CommonResponse supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    delSuc = true;
                } else {
                    this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u7ed3\u7b97\u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{settleEntity.getSupplierId(), settleEntity.getId(), supHandleResp.getMsg()});
                }
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{settleEntity.getSupplierId(), settleEntity.getId(), syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)settleEntity.getId(), (Object)e);
        }
        finally {
            this.releaseLock(jedis, locked, key, "SETTLE_BILL_SYNC");
        }
        return delSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public String delCheck(List<Long> billIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", billIds);
        query.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()});
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return "\u975e\u81ea\u7531\u6001\u6216\u9a73\u56de\u6001\u7684\u5355\u636e\u4e0d\u80fd\u5220\u9664\uff01";
        }
        return null;
    }

    @Override
    public SettleRecordVO queryDetailRecord(Long contractId, Integer settleType) {
        SettleRecordVO settleRecordVO = new SettleRecordVO();
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractId));
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractMny(contract.getContractMny());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getPerformanceStatus());
        QueryWrapper listQuery = new QueryWrapper();
        listQuery.eq((Object)"contract_id", (Object)contractId);
        listQuery.eq((Object)"settle_type", (Object)settleType);
        listQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        listQuery.orderByDesc((Object)"create_time");
        List list = super.list((Wrapper)listQuery);
        settleRecordVO.setSettleList(BeanMapper.mapList((Iterable)list, SettleVO.class));
        SettleEntity lastSettleRecord = CollectionUtils.isNotEmpty((Collection)list) ? (SettleEntity)((Object)list.get(0)) : null;
        switch (settleType) {
            case 0: {
                BigDecimal TotalProcessSettleMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    TotalProcessSettleMny = list.stream().map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                settleRecordVO.setTotalProcessSettleMny(TotalProcessSettleMny);
                if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
                    settleRecordVO.setSettleRatio(BigDecimal.ZERO);
                    break;
                }
                settleRecordVO.setSettleRatio(settleRecordVO.getTotalProcessSettleMny().multiply(BigDecimal.valueOf(100L)).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
                break;
            }
            case 1: {
                settleRecordVO.setContractSettleMny(null != lastSettleRecord && null != lastSettleRecord.getTaxMny() ? lastSettleRecord.getTaxMny() : BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
                    settleRecordVO.setSettleRatio(BigDecimal.ZERO);
                    break;
                }
                settleRecordVO.setSettleRatio(settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100L)).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
                break;
            }
            default: {
                QueryWrapper processListQuery = new QueryWrapper();
                processListQuery.eq((Object)"contract_id", (Object)contractId);
                processListQuery.eq((Object)"settle_type", (Object)0);
                processListQuery.in((Object)"bill_state", new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
                processListQuery.orderByDesc((Object)"create_time");
                List processList = super.list((Wrapper)processListQuery);
                SettleEntity processLastSettleRecord = CollectionUtils.isNotEmpty((Collection)processList) ? (SettleEntity)((Object)processList.get(0)) : null;
                settleRecordVO.setTotalProcessSettleMny(null != processLastSettleRecord && null != processLastSettleRecord.getTotalTaxMny() ? processLastSettleRecord.getTotalTaxMny() : BigDecimal.ZERO);
                BigDecimal TotalNodeSettleMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    TotalNodeSettleMny = list.stream().map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                settleRecordVO.setTotalNodeSettleMny(TotalNodeSettleMny);
                if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
                    settleRecordVO.setSettleRatio(BigDecimal.ZERO);
                } else {
                    settleRecordVO.setSettleRatio(settleRecordVO.getTotalNodeSettleMny().multiply(BigDecimal.valueOf(100L)).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
                }
                settleRecordVO.setSettleBalanceMny(settleRecordVO.getTotalNodeSettleMny().subtract(settleRecordVO.getTotalProcessSettleMny()));
            }
        }
        Boolean contractFilingFlag = this.contractService.checkFilingType(contractId, ContractFilingTypeEnum.\u5206\u5305\u5408\u540c\u6708\u5ea6\u7ed3\u7b97.getTypeCode());
        if (StringUtils.isBlank((CharSequence)this.beforeNewSettleCheck(contractId, settleType)) && contractFilingFlag.booleanValue()) {
            settleRecordVO.setCanAddNewSettleFlag(true);
        } else {
            settleRecordVO.setCanAddNewSettleFlag(false);
        }
        return settleRecordVO;
    }

    @Override
    public String beforeNewSettleCheck(Long contractId, Integer settleType) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        ((QueryWrapper)((QueryWrapper)query.and(q -> (QueryWrapper)((QueryWrapper)q.in((Object)"settle_type", new Object[]{SettleTypeEnum.\u8282\u70b9.getCode(), SettleTypeEnum.\u8fc7\u7a0b.getCode()})).in((Object)"bill_state", new Object[]{BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}))).or()).and(q -> (QueryWrapper)q.eq((Object)"settle_type", (Object)SettleTypeEnum.\u5b8c\u5de5));
        List billList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)billList)) {
            if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
                return "\u5408\u540c\u5df2\u7ecf\u751f\u6210\u4e86\u5b8c\u5de5\u7ed3\u7b97\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c " + (Object)((Object)SettleTypeEnum.getDescriptionByCode(settleType)) + "\u7ed3\u7b97";
            }
            return "\u6709\u672a\u751f\u6548\u7684\u8fc7" + (Object)((Object)SettleTypeEnum.getDescriptionByCode(SettleTypeEnum.\u8282\u70b9.getCode())) + "\u7b97\u5355\u636e\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c" + (Object)((Object)SettleTypeEnum.getDescriptionByCode(settleType)) + "\u7ed3\u7b97";
        }
        if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleType)) {
            List deductionEntityList;
            List registrationEntityList;
            List picKingEntityList;
            StringBuffer sp = new StringBuffer();
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
            queryParam.getParams().put("bill_state", new Parameter("eq", (Object)BillStateEnum.APPROVING_HAS_STATE));
            List measureEntityList = this.measureService.queryList(queryParam, false);
            if (CollectionUtils.isNotEmpty((Collection)measureEntityList)) {
                sp.append("\u5206\u5305\u8ba1\u91cf\u3001");
            }
            if (CollectionUtils.isNotEmpty((Collection)(picKingEntityList = this.pickingService.queryList(queryParam, false)))) {
                sp.append("\u9886\u6599\u7ed3\u7b97\u3001");
            }
            if (CollectionUtils.isNotEmpty((Collection)(registrationEntityList = this.oddjobService.queryList(queryParam, false)))) {
                sp.append("\u96f6\u5de5\u767b\u8bb0\u3001");
            }
            if (CollectionUtils.isNotEmpty((Collection)(deductionEntityList = this.deductService.queryList(queryParam, false)))) {
                sp.append("\u5956\u7f5a\u6263\u6b3e\u3001");
            }
            if (sp.length() > 0) {
                return "\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684" + sp.substring(0, sp.length() - 1) + "\u5355\u636e\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff01";
            }
            QueryWrapper contractQuery = new QueryWrapper();
            contractQuery.eq((Object)"contract_id", (Object)contractId);
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
            if (null != contractEntity && null != contractEntity.getChangeId()) {
                LambdaQueryWrapper changeContractLambda = new LambdaQueryWrapper();
                changeContractLambda.eq(BaseEntity::getId, (Object)contractEntity.getChangeId());
                changeContractLambda.and(c -> (LambdaQueryWrapper)c.in(ChangeEntity::getBillState, new Object[]{BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()}));
                int changeResultCount = this.changeService.count((Wrapper)changeContractLambda);
                if (changeResultCount > 0) {
                    return "\u5f53\u524d\u5408\u540c\u6b63\u5728\u8fdb\u884c\u53d8\u66f4\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u5b8c\u5de5\u7ed3\u7b97\uff01";
                }
            }
        }
        return null;
    }

    @Override
    public SettleVO queryTotalNodeAndFin(Long contractId, Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("project_id", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("settle_type", new Parameter("in", (Object)"0,2"));
        queryParam.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        List settleEntities = super.queryList(queryParam, false);
        BigDecimal totalMny = BigDecimal.ZERO;
        for (SettleEntity entity : settleEntities) {
            totalMny = totalMny.add(entity.getTaxMny());
        }
        SettleVO settleVO = new SettleVO();
        settleVO.setMny(totalMny);
        return settleVO;
    }

    @Override
    public String pushSettleToPool(SettleVO s) {
        SettlePoolVO spv = new SettlePoolVO();
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
            BeanConvertorUtil.convert((Object)s, (Object)spv);
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 s->{}", (Object)JSONObject.toJSONString((Object)s));
            this.logger.info("\u7ed3\u7b97\u6c60\u5bf9\u8c61 spv->{}", (Object)JSONObject.toJSONString((Object)spv));
            spv.setTotalSettlePaymentTaxMny(s.getTotalSettlePaymentTaxMny());
            spv.setTotalSettlePaymentMny(s.getTotalSettlePaymentMny());
            this.logger.info("\u7ed3\u7b97\u6c60\u5bf9\u8c61-\u7d2f\u8ba1\u7ed3\u7b97\u652f\u4ed8\u91d1\u989d{}", (Object)spv.getTotalSettlePaymentMny());
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u7ed3\u675f\uff0c\u4e0b\u9762\u5f00\u59cb\u624b\u52a8\u8f6c\u6362");
            this.convertSettleVOToSettlePoolVO(s, spv);
            String settleType = "";
            String contractType = "";
            if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(s.getSettleType())) {
                settleType = "processSettle";
                spv.setUltimateFlag(SettleUltimateFlagEnum.\u975e\u6700\u7ec8\u7ed3\u7b97.getCode());
            } else if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(s.getSettleType())) {
                settleType = "finishSettle";
                spv.setUltimateFlag(SettleUltimateFlagEnum.\u6700\u7ec8\u7ed3\u7b97.getCode());
                spv.setFinishCurTaxMny(s.getTaxMny());
                spv.setFinishCurMny(s.getMny());
                spv.setCurTax(s.getTax());
                CommonResponse response = this.paramConfigApi.getByCode("P-2hiWQQ0131");
                if (!response.isSuccess() || response.getData() == null) {
                    throw new BusinessException("\u83b7\u53d6\u5b8c\u5de5\u5355\u5dee\u989d\u53d6\u503c\u65b9\u5f0f\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                }
                String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
                if ("1".equals(valueData)) {
                    spv.setCurTaxMny(s.getTotalProcessTaxDifference());
                    spv.setCurMny(s.getTotalProcessDifference());
                    spv.setCurTax(s.getTotalProcessTaxDifference().subtract(s.getTotalProcessDifference()));
                    spv.setResidueApplyMny(s.getTotalProcessTaxDifference());
                } else {
                    spv.setCurTaxMny(s.getTotalNodeTaxDifference());
                    spv.setCurMny(s.getTotalNodeDifference());
                    spv.setCurTax(s.getTotalNodeTaxDifference().subtract(s.getTotalNodeDifference()));
                    spv.setResidueApplyMny(s.getTotalNodeTaxDifference());
                }
            } else if (SettleTypeEnum.\u8282\u70b9.getCode().equals(s.getSettleType())) {
                settleType = "nodeSettle";
                spv.setUltimateFlag(SettleUltimateFlagEnum.\u975e\u6700\u7ec8\u7ed3\u7b97.getCode());
            }
            if (s.getContractType() == 0) {
                contractType = "laborsub";
                if (StringUtils.isBlank((CharSequence)spv.getContractType())) {
                    spv.setContractType(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
                    spv.setContractTypeName(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeName());
                }
            } else if (s.getContractType() == 1) {
                contractType = "prosub";
                if (StringUtils.isBlank((CharSequence)spv.getContractType())) {
                    spv.setContractType(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
                    spv.setContractTypeName(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeName());
                }
            } else {
                this.logger.info("\u7ed3\u7b97\u5355\u5408\u540c\u7c7b\u578b\u672a\u77e5\u7ed3\u7b97\u5355id-{}", (Object)s.getId());
            }
            spv.setBillCodeUrl("/ejc-prosub-frontend/#/" + settleType + "/" + contractType + "/card?id=" + s.getId());
            spv.setContractFlag(ContractFlagEnum.\u6709\u5408\u540c\u7ed3\u7b97.getContractFlagCode());
            spv.setContractFlagName(ContractFlagEnum.\u6709\u5408\u540c\u7ed3\u7b97.getContractFlagCodeName());
            spv.setHandleType(Integer.valueOf(0));
            this.fillOtherSettlePoolAttr((SettleEntity)((Object)BeanMapper.map((Object)s, SettleEntity.class)), spv);
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(spv);
            if (res.isSuccess()) {
                this.executeUpdatePool(s.getId(), true);
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)s.getId());
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u6c60\u5bf9\u8c61-{}", (Object)JSONObject.toJSONString((Object)spv));
                return null;
            }
            this.executeUpdatePool(s.getId(), false);
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)s.getId(), (Object)JSONObject.toJSONString((Object)res));
            return StringUtils.isNotBlank((CharSequence)res.getMsg()) ? res.getMsg() : "\u7f51\u7edc\u95ee\u9898\uff0c\u7ed3\u7b97\u6c60\u5931\u8d25\uff01";
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)s.getId(), (Object)e);
            return "\u7ed3\u7b97\u5355\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25";
        }
    }

    @Override
    public String delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        spv.setSourceId(id);
        CommonResponse res = this.settlePoolApi.deleteSettle(spv);
        if (res.isSuccess()) {
            this.logger.info("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)id);
            return null;
        }
        this.logger.error("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
        return StringUtils.isNotBlank((CharSequence)res.getMsg()) ? res.getMsg() : "\u7f51\u7edc\u95ee\u9898\uff0c\u5355\u636e\u5904\u7406\u5931\u8d25\uff01";
    }

    @Override
    public void convertSettleVOToSettlePoolVO(SettleVO s, SettlePoolVO spv) {
        if (null == s || null == spv) {
            this.logger.error("\u5c06\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u5931\u8d25\uff01\u539f\u56e0\uff1a\u7ed3\u7b97\u5355\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7ed3\u7b97\u6c60\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u65e0\u6cd5\u8f6c\u6362\uff01");
            return;
        }
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5f00\u59cb");
        Integer contractType = s.getContractType();
        Integer settleType = s.getSettleType();
        BigDecimal lastTaxMny = BigDecimal.ZERO;
        BigDecimal lastMny = BigDecimal.ZERO;
        switch (settleType) {
            case 0: {
                lastTaxMny = s.getLastTaxMny();
                lastMny = s.getLastMny();
                spv.setSourceType(contractType == 0 ? SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode() : SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6708\u5ea6\u7ed3\u7b97.getCode());
                spv.setSettleProperty(Integer.valueOf(0));
                spv.setUltimateFlag(Integer.valueOf(0));
                break;
            }
            case 1: {
                lastTaxMny = s.getTotalProcessTaxMny();
                lastMny = s.getTotalProcessMny();
                spv.setSourceType(contractType == 0 ? SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode() : SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u6700\u7ec8\u7ed3\u7b97.getCode());
                spv.setSettleProperty(Integer.valueOf(0));
                spv.setUltimateFlag(Integer.valueOf(1));
                break;
            }
            case 2: {
                lastTaxMny = s.getLastNodeTaxMny();
                lastMny = s.getLastNodeMny();
                spv.setSourceType(contractType == 0 ? SettleSourceTypeEnum.\u52b3\u52a1\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode() : SettleSourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u8282\u70b9\u7ed3\u7b97.getCode());
                spv.setSettleProperty(Integer.valueOf(0));
                spv.setUltimateFlag(Integer.valueOf(0));
                break;
            }
        }
        spv.setLastTaxMny(lastTaxMny);
        spv.setLastMny(lastMny);
        spv.setLastTax(this.getSubStractAbs(lastTaxMny, lastMny));
        spv.setContractType(contractType == 0 ? "laborSub" : "proSub");
        ContractEntity ce = (ContractEntity)((Object)this.contractService.selectById(s.getContractId()));
        this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u8fc7\u7a0b\u4e2d\uff0c\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\uff0c\u5408\u540cid-{}", (Object)s.getContractId());
        if (ce == null) {
            this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u8fc7\u7a0b\u4e2d\uff0c\u6839\u636e\u5408\u540cid\u67e5\u8be2\u5408\u540c\uff0c\u5408\u540cid-{}\uff0c\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f\uff0c\u6545\u7ed3\u7b97\u5355\u7684 \u4e3b\u5408\u540c/\u7532\u65b9/\u4e59\u65b9/\u7b7e\u8ba2\u65e5\u671f/\u521b\u5efa\u65f6\u95f4\u548c\u4eba\u5458/\u66f4\u65b0\u65f6\u95f4\u548c\u4eba\u5458 \u7b49\u4fe1\u606f\u65e0\u6cd5\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60", (Object)s.getContractId());
            return;
        }
        spv.setMaiContractId(ce.getMainContractId());
        spv.setMaiContractName(ce.getMainContractName());
        spv.setMaiContractCode(ce.getMainContractCode());
        spv.setPartyaId(ce.getFirstPartyId());
        spv.setPartyaName(ce.getFirstPartyName());
        spv.setSignDate(ce.getSignDate());
        spv.setCreateTime(s.getCreateTime());
        spv.setCreateUserCode(s.getCreateUserCode());
        spv.setUpdateTime(s.getUpdateTime());
        spv.setUpdateUserCode(s.getUpdateUserCode());
        this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u624b\u52a8\u8f6c\u6362\u5b8c\u6210\uff0c\u4e0b\u9762\u5f00\u59cb\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60");
    }

    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer contractType) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setOrgId(contractVO.getOrgId());
        if (contractType == 0) {
            totalVO.setBillType("BT220114000000004");
            totalVO.setBussinessType(BussinessTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getCode());
        } else {
            totalVO.setBillType("BT220307000000009");
            totalVO.setBussinessType(BussinessTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getCode());
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        if (contractVO.getProjectId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(contractVO.getProjectId());
        if (contractVO.getOrgId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (contractVO.getDetailList() != null) {
            for (ContractDetailVO contractDetailVO : contractVO.getDetailList()) {
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(contractDetailVO.getId());
                detailExecutionVO.setSourceBillId(contractDetailVO.getContractId());
                detailExecutionVO.setCategoryId(contractDetailVO.getSourceId());
                if (contractDetailVO.getDocCategoryId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                }
                detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                TemplateCategoryVO categoryVO = (TemplateCategoryVO)this.templateCategoryApi.queryTmplCategoryById(contractDetailVO.getDocCategoryId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocId(Long.valueOf(contractDetailVO.getSourceId() == null ? 1439116437228298666L : contractDetailVO.getSourceId()));
                if (contractType == 0) {
                    detailExecutionVO.setDocType(DocTypeEnum.\u52b3\u52a1\u5206\u5305\u6863\u6848.getCode());
                } else {
                    detailExecutionVO.setDocType(DocTypeEnum.\u4e13\u4e1a\u5206\u5305\u6863\u6848.getCode());
                }
                detailExecutionVO.setCode(contractDetailVO.getDetailCode());
                detailExecutionVO.setName(contractDetailVO.getDetailName());
                detailExecutionVO.setUnitName(contractDetailVO.getDetailUnit());
                detailExecutionVO.setNum(contractDetailVO.getDetailNum());
                detailExecutionVO.setMoney(contractDetailVO.getDetailMny());
                detailExecutionVO.setTaxMoney(contractDetailVO.getDetailTaxMny());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public BigDecimal getLastTaxMny(Long contractId, Integer settleType, BigDecimal taxMny, Boolean flag) {
        Assert.notNull((Object)contractId, (String)"\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)settleType, (String)"\u7ed3\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)taxMny, (String)"\u672c\u671f\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<Integer> billState = new ArrayList<Integer>();
        billState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"contract_id", (Object)contractId);
        qw.eq((Object)"settle_type", (Object)settleType);
        qw.in((Object)"bill_state", billState);
        List settles = super.list((Wrapper)qw);
        if (CollectionUtils.isEmpty((Collection)settles)) {
            return taxMny;
        }
        if (Boolean.TRUE.equals(flag)) {
            taxMny = BigDecimal.ZERO;
        }
        return settles.stream().map(SettleEntity::getTaxMny).reduce(taxMny, BigDecimal::add);
    }

    @Override
    public BigDecimal getOverTaxMny(BigDecimal totalTaxMny, BigDecimal contractTaxMny) {
        Assert.notNull((Object)totalTaxMny, (String)"\u542b\u672c\u671f\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)contractTaxMny, (String)"\u5408\u540c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        return totalTaxMny.subtract(contractTaxMny);
    }

    @Override
    public BigDecimal getContractTaxMny(BigDecimal contractTaxMny, BigDecimal roleValue) {
        Assert.notNull((Object)contractTaxMny, (String)"\u5408\u540c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)roleValue, (String)"\u63a7\u5236\u89c4\u5219\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        return contractTaxMny.multiply(roleValue.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
    }

    private String associatedFlag(SettleEntity settleEntity) {
        List<SettleDetailEntity> detailList = settleEntity.getSettleDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getSettleOtherList();
        List<SettleOddjobEntity> oddjobList = settleEntity.getSettleOddjobList();
        List<SettlePickingEntity> pickingList = settleEntity.getSettlePickingList();
        List<SettleDeductEntity> deductList = settleEntity.getSettleDeductList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (SettleDetailEntity detailEntity : detailList) {
                if (detailEntity.getSettleNum() == null || null != detailEntity.getDetailWbsId() && null != detailEntity.getDetailSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherEntity otherEntity : otherList) {
                if (null != otherEntity.getOtherWbsId() && null != otherEntity.getOtherSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (CollectionUtils.isNotEmpty(oddjobList)) {
            for (SettleOddjobEntity oddjobEntity : oddjobList) {
                if (null != oddjobEntity.getOddjobWbsId() && null != oddjobEntity.getOddjobSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (CollectionUtils.isNotEmpty(pickingList)) {
            for (SettlePickingEntity pickingEntity : pickingList) {
                if (null != pickingEntity.getPickingWbsId() && null != pickingEntity.getPickingSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (CollectionUtils.isNotEmpty(deductList)) {
            for (SettleDeductEntity deductEntity : deductList) {
                if (deductEntity.getInputCostFlag() != 0 || null != deductEntity.getDeductWbsId() && null != deductEntity.getDeductSubjectId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (CollectionUtils.isEmpty(deductList) && CollectionUtils.isEmpty(pickingList) && CollectionUtils.isEmpty(oddjobList) && CollectionUtils.isEmpty(otherList) && CollectionUtils.isEmpty(detailList)) {
            newRelationFlag = "0";
        }
        return newRelationFlag;
    }

    @Override
    public CommonResponse<SettleVO> pushCost(SettleVO settleVO) {
        SettleEntity settleEntity = (SettleEntity)((Object)((SettleMapper)this.baseMapper).selectById(settleVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleDetailList())) {
            List detailEntityList = BeanMapper.mapList((Iterable)settleVO.getSettleDetailList(), SettleDetailEntity.class);
            settleEntity.setSettleDetailList(detailEntityList);
        }
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleDeductList())) {
            List deductEntities = BeanMapper.mapList((Iterable)settleVO.getSettleDeductList(), SettleDeductEntity.class);
            settleEntity.setSettleDeductList(deductEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleOddjobList())) {
            List oddjobEntities = BeanMapper.mapList((Iterable)settleVO.getSettleOddjobList(), SettleOddjobEntity.class);
            settleEntity.setSettleOddjobList(oddjobEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettleOtherList())) {
            List otherEntities = BeanMapper.mapList((Iterable)settleVO.getSettleOtherList(), SettleOtherEntity.class);
            settleEntity.setSettleOtherList(otherEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)settleVO.getSettlePickingList())) {
            List pickingEntities = BeanMapper.mapList((Iterable)settleVO.getSettlePickingList(), SettlePickingEntity.class);
            settleEntity.setSettlePickingList(pickingEntities);
        }
        super.saveOrUpdate((Object)settleEntity, false);
        this.costPush(settleEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)settleEntity), SettleVO.class));
    }

    @Override
    public List<Long> autoPushCost(List<Long> ids) {
        for (Long id : ids) {
            SettleEntity settleEntity = (SettleEntity)((Object)((SettleMapper)this.baseMapper).selectById(id));
            if (settleEntity == null) continue;
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("settle_id", new Parameter("eq", (Object)settleEntity.getId()));
            BigDecimal detailTaxMny = BigDecimal.ZERO;
            BigDecimal detailMny = BigDecimal.ZERO;
            List detailList = this.settleDetailService.queryList(queryParam);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                for (SettleDetailEntity detail : detailList) {
                    if (detail.getSettleNum() == null) continue;
                    if (Integer.valueOf("1").equals(settleEntity.getSettleType())) {
                        detailTaxMny = detailTaxMny.add(detail.getProcessTaxDifference() == null ? BigDecimal.ZERO : detail.getProcessTaxDifference());
                        detailMny = detailMny.add(detail.getProcessDifference() == null ? BigDecimal.ZERO : detail.getProcessDifference());
                        continue;
                    }
                    detailTaxMny = detailTaxMny.add(detail.getSettleTaxMny() == null ? BigDecimal.ZERO : detail.getSettleTaxMny());
                    detailMny = detailMny.add(detail.getSettleMny() == null ? BigDecimal.ZERO : detail.getSettleMny());
                }
            }
            List settleOddjobEntities = this.settleOddjobService.queryList(queryParam);
            BigDecimal oddjobTaxMny = BigDecimal.ZERO;
            BigDecimal oddjobMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)settleOddjobEntities)) {
                for (SettleOddjobEntity detail : settleOddjobEntities) {
                    if (detail.getOddjobType() == 0) {
                        oddjobTaxMny = oddjobTaxMny.add(detail.getOddjobTaxMny() == null ? BigDecimal.ZERO : detail.getOddjobTaxMny());
                        oddjobMny = oddjobMny.add(detail.getOddjobMny() == null ? BigDecimal.ZERO : detail.getOddjobMny());
                        continue;
                    }
                    oddjobTaxMny = oddjobTaxMny.subtract(detail.getOddjobTaxMny() == null ? BigDecimal.ZERO : detail.getOddjobTaxMny());
                    oddjobMny = oddjobMny.subtract(detail.getOddjobMny() == null ? BigDecimal.ZERO : detail.getOddjobMny());
                }
            }
            List settleOtherEntities = this.settleOtherService.queryList(queryParam);
            BigDecimal otherTaxMny = BigDecimal.ZERO;
            BigDecimal otherMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)settleOtherEntities)) {
                for (SettleOtherEntity other : settleOtherEntities) {
                    otherTaxMny = otherTaxMny.add(other.getTaxMny() == null ? BigDecimal.ZERO : other.getTaxMny());
                    otherMny = otherMny.add(other.getMny() == null ? BigDecimal.ZERO : other.getMny());
                }
            }
            List settlePickingEntities = this.settlePickingService.queryList(queryParam);
            BigDecimal pickingTaxMny = BigDecimal.ZERO;
            BigDecimal pickingMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)settlePickingEntities)) {
                for (SettlePickingEntity pick : settlePickingEntities) {
                    pickingTaxMny = pickingTaxMny.add(pick.getCostTaxMny() == null ? BigDecimal.ZERO : pick.getCostTaxMny());
                    pickingMny = pickingMny.add(pick.getCostMny() == null ? BigDecimal.ZERO : pick.getCostMny());
                }
            }
            List settleDeductEntities = this.settleDeductService.queryList(queryParam);
            BigDecimal deductTaxMny = BigDecimal.ZERO;
            BigDecimal deductMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)settleDeductEntities)) {
                for (SettleDeductEntity deduct : settleDeductEntities) {
                    if (deduct.getInputCostFlag() != 0) continue;
                    deductTaxMny = deductTaxMny.add(deduct.getDeductTaxMny() == null ? BigDecimal.ZERO : deduct.getDeductTaxMny());
                    deductMny = deductMny.add(deduct.getDeductMny() == null ? BigDecimal.ZERO : deduct.getDeductMny());
                }
            }
            BigDecimal costTaxMny = BigDecimal.ZERO;
            BigDecimal costMny = BigDecimal.ZERO;
            BigDecimal costTax = BigDecimal.ZERO;
            costTaxMny = costTaxMny.add(detailTaxMny);
            costTaxMny = costTaxMny.add(otherTaxMny);
            costTaxMny = costTaxMny.add(oddjobTaxMny);
            costTaxMny = costTaxMny.add(pickingTaxMny);
            costTaxMny = costTaxMny.add(deductTaxMny);
            costMny = costMny.add(detailMny);
            costMny = costMny.add(otherMny);
            costMny = costMny.add(oddjobMny);
            costMny = costMny.add(pickingMny);
            costMny = costMny.add(deductMny);
            costTax = costTaxMny.subtract(costMny);
            settleEntity.setPushCostMny(costMny);
            settleEntity.setPushCostTaxMny(costTaxMny);
            settleEntity.setPushCostTax(costTax);
            this.saveCost(settleEntity);
            super.saveOrUpdate((Object)settleEntity);
        }
        return ids;
    }

    @Override
    public void costPush(SettleEntity settleEntity) {
        boolean b;
        this.logger.info("\u5f00\u59cbcostPush");
        String newRelationFlag = this.associatedFlag(settleEntity);
        this.logger.info("newRelationFlag---{}", (Object)newRelationFlag);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{settleEntity.getId()});
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = settleEntity.getRelationFlag();
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(settleEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9886\u6599\u51fa\u5e93Id---{}", (Object)settleEntity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(settleEntity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag) && !(b = this.saveCost(settleEntity))) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef \u63a8\u9001\u5b9e\u9645\u6210\u672c\u5931\u8d25");
        }
    }

    @Override
    public void costDeletePush(SettleEntity settleEntity) {
        this.logger.info("\u5f03\u5ba1\u63a8\u9001\u6210\u672c---");
        this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u7ed3\u7b97\u5355Id---{}", (Object)settleEntity.getId());
        CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(settleEntity.getId());
        this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException(stringCommonResponse.getMsg());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{settleEntity.getId()});
        updateWrapper.set(SettleEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
    }

    private boolean saveCost(SettleEntity settleEntity) {
        CostDetailVO costDetailVO;
        this.logger.info("\u63a8\u9001\u7ed3\u7b97\u5b9e\u4f53\uff1a" + JSONObject.toJSONString((Object)((Object)settleEntity)));
        String sourceType = "";
        String sourceTypeName = "";
        String linkUrl = "";
        if (settleEntity.getContractType() == 1) {
            sourceType = "PRO_SETTLE";
            if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleEntity.getSettleType())) {
                sourceTypeName = SourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u5b8c\u5de5\u7ed3\u7b97.getTypeName();
            } else if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(settleEntity.getSettleType())) {
                sourceTypeName = SourceTypeEnum.\u4e13\u4e1a\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97.getTypeName();
            }
        } else {
            sourceType = "LAP_SETTLE";
            if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleEntity.getSettleType())) {
                sourceTypeName = SourceTypeEnum.\u52b3\u52a1\u5206\u5305\u5b8c\u5de5\u7ed3\u7b97.getTypeName();
            } else if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(settleEntity.getSettleType())) {
                sourceTypeName = SourceTypeEnum.\u52b3\u52a1\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97.getTypeName();
            }
        }
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<SettleDetailEntity> detailList = settleEntity.getSettleDetailList();
        List<SettleOtherEntity> otherList = settleEntity.getSettleOtherList();
        List<SettleOddjobEntity> oddjobList = settleEntity.getSettleOddjobList();
        List<SettlePickingEntity> pickingList = settleEntity.getSettlePickingList();
        List<SettleDeductEntity> deductList = settleEntity.getSettleDeductList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (SettleDetailEntity detailEntity : detailList) {
                if (detailEntity.getSettleNum() == null) continue;
                costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(detailEntity.getDetailSubjectId());
                costDetailVO.setSubjectCode(detailEntity.getDetailSubjectCode());
                costDetailVO.setSubjectName(detailEntity.getDetailSubjectName());
                costDetailVO.setWbsId(detailEntity.getDetailWbsId());
                costDetailVO.setWbsCode(detailEntity.getDetailWbsCode());
                costDetailVO.setWbsName(detailEntity.getDetailWbsName());
                costDetailVO.setSourceId(detailEntity.getSettleId());
                costDetailVO.setSourceDetailId(detailEntity.getId());
                if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleEntity.getSettleType())) {
                    costDetailVO.setHappenTaxMny(detailEntity.getProcessTaxDifference());
                    costDetailVO.setHappenMny(detailEntity.getProcessDifference());
                    costDetailVO.setSourceTabType("SET_FIN_DETAIL");
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/finishSettle/card?id=" + settleEntity.getId());
                }
                if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(settleEntity.getSettleType())) {
                    costDetailVO.setHappenTaxMny(detailEntity.getSettleTaxMny());
                    costDetailVO.setHappenMny(detailEntity.getSettleMny());
                    costDetailVO.setSourceTabType("SET_PRO_DETAIL");
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/processSettle/card?id=" + settleEntity.getId());
                }
                costDetailVO.setSourceBillCode(settleEntity.getBillCode());
                costDetailVO.setSourceBillName(sourceTypeName);
                costDetailVO.setSourceType(sourceType);
                costDetailVO.setHappenDate(detailEntity.getSettleDate());
                costDetailVO.setCreateUserName(detailEntity.getCreateUserCode());
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(otherList)) {
            for (SettleOtherEntity otherEntity : otherList) {
                costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(otherEntity.getOtherSubjectId());
                costDetailVO.setSubjectCode(otherEntity.getOtherSubjectCode());
                costDetailVO.setSubjectName(otherEntity.getOtherSubjectName());
                costDetailVO.setWbsId(otherEntity.getOtherWbsId());
                costDetailVO.setWbsCode(otherEntity.getOtherWbsCode());
                costDetailVO.setWbsName(otherEntity.getOtherWbsName());
                costDetailVO.setSourceId(otherEntity.getSettleId());
                costDetailVO.setSourceDetailId(otherEntity.getId());
                costDetailVO.setHappenTaxMny(otherEntity.getTaxMny());
                costDetailVO.setHappenMny(otherEntity.getMny());
                costDetailVO.setHappenDate(otherEntity.getSettleDate());
                costDetailVO.setCreateUserName(otherEntity.getCreateUserCode());
                costDetailVO.setSourceType(sourceType);
                if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(settleEntity.getSettleType())) {
                    costDetailVO.setSourceTabType("SET_PRO_OTHER");
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/processSettle/card?id=" + settleEntity.getId());
                }
                if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleEntity.getSettleType())) {
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/finishSettle/card?id=" + settleEntity.getId());
                    costDetailVO.setSourceTabType("SET_FIN_OTHER");
                }
                costDetailVO.setSourceBillCode(settleEntity.getBillCode());
                costDetailVO.setSourceBillName(sourceTypeName);
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(oddjobList)) {
            for (SettleOddjobEntity oddjobEntity : oddjobList) {
                costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(oddjobEntity.getOddjobSubjectId());
                costDetailVO.setSubjectCode(oddjobEntity.getOddjobSubjectCode());
                costDetailVO.setSubjectName(oddjobEntity.getOddjobSubjectName());
                costDetailVO.setWbsId(oddjobEntity.getOddjobWbsId());
                costDetailVO.setWbsCode(oddjobEntity.getOddjobWbsCode());
                costDetailVO.setWbsName(oddjobEntity.getOddjobWbsName());
                costDetailVO.setSourceId(oddjobEntity.getSettleId());
                costDetailVO.setSourceDetailId(oddjobEntity.getId());
                if (Integer.valueOf(1).equals(oddjobEntity.getOddjobType())) {
                    costDetailVO.setHappenTaxMny(oddjobEntity.getOddjobTaxMny().negate());
                    costDetailVO.setHappenMny(oddjobEntity.getOddjobMny().negate());
                } else {
                    costDetailVO.setHappenTaxMny(oddjobEntity.getOddjobTaxMny());
                    costDetailVO.setHappenMny(oddjobEntity.getOddjobMny());
                }
                costDetailVO.setHappenDate(oddjobEntity.getSettleDate());
                costDetailVO.setCreateUserName(oddjobEntity.getCreateUserCode());
                costDetailVO.setSourceType(sourceType);
                if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(settleEntity.getSettleType())) {
                    costDetailVO.setSourceTabType("SET_PRO_ODDJOB");
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/processSettle/card?id=" + settleEntity.getId());
                }
                if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleEntity.getSettleType())) {
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/finishSettle/card?id=" + settleEntity.getId());
                    costDetailVO.setSourceTabType("SET_FIN_ODDJOB");
                }
                costDetailVO.setSourceBillCode(settleEntity.getBillCode());
                costDetailVO.setSourceBillName(sourceTypeName);
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(pickingList)) {
            for (SettlePickingEntity pickingEntity : pickingList) {
                costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(pickingEntity.getPickingSubjectId());
                costDetailVO.setSubjectCode(pickingEntity.getPickingSubjectCode());
                costDetailVO.setSubjectName(pickingEntity.getPickingSubjectName());
                costDetailVO.setWbsId(pickingEntity.getPickingWbsId());
                costDetailVO.setWbsCode(pickingEntity.getPickingWbsCode());
                costDetailVO.setWbsName(pickingEntity.getPickingWbsName());
                costDetailVO.setSourceId(pickingEntity.getSettleId());
                costDetailVO.setSourceDetailId(pickingEntity.getId());
                costDetailVO.setHappenTaxMny(pickingEntity.getCostTaxMny().negate());
                costDetailVO.setHappenMny(pickingEntity.getCostMny().negate());
                costDetailVO.setHappenDate(pickingEntity.getSettleDate());
                costDetailVO.setCreateUserName(pickingEntity.getCreateUserCode());
                costDetailVO.setSourceType(sourceType);
                if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(settleEntity.getSettleType())) {
                    costDetailVO.setSourceTabType("SET_PRO_PICKING");
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/processSettle/card?id=" + settleEntity.getId());
                }
                if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleEntity.getSettleType())) {
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/finishSettle/card?id=" + settleEntity.getId());
                    costDetailVO.setSourceTabType("SET_FIN_PICKING");
                }
                costDetailVO.setSourceBillCode(settleEntity.getBillCode());
                costDetailVO.setSourceBillName(sourceTypeName);
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(deductList)) {
            for (SettleDeductEntity deductEntity : deductList) {
                if (deductEntity.getInputCostFlag() != 0) continue;
                costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(deductEntity.getDeductSubjectId());
                costDetailVO.setSubjectCode(deductEntity.getDeductSubjectCode());
                costDetailVO.setSubjectName(deductEntity.getDeductSubjectName());
                costDetailVO.setWbsId(deductEntity.getDeductWbsId());
                costDetailVO.setWbsCode(deductEntity.getDeductWbsCode());
                costDetailVO.setWbsName(deductEntity.getDeductWbsName());
                costDetailVO.setSourceId(deductEntity.getSettleId());
                costDetailVO.setSourceDetailId(deductEntity.getId());
                costDetailVO.setHappenDate(deductEntity.getHappenDate());
                costDetailVO.setCreateUserName(deductEntity.getCreateUserCode());
                costDetailVO.setSourceType(sourceType);
                if (SettleTypeEnum.\u8fc7\u7a0b.getCode().equals(settleEntity.getSettleType())) {
                    costDetailVO.setSourceTabType("SET_PRO_DEDUCT");
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/processSettle/card?id=" + settleEntity.getId());
                }
                if (SettleTypeEnum.\u5b8c\u5de5.getCode().equals(settleEntity.getSettleType())) {
                    costDetailVO.setSourceBillUrl("/ejc-prosub-frontend/#/finishSettle/card?id=" + settleEntity.getId());
                    costDetailVO.setSourceTabType("SET_FIN_DEDUCT");
                }
                costDetailVO.setSourceBillCode(settleEntity.getBillCode());
                BigDecimal happenMny = BigDecimal.ZERO;
                BigDecimal happenTaxMny = BigDecimal.ZERO;
                if (deductEntity.getRewardDeductionType() == 0) {
                    happenMny = deductEntity.getDeductMny();
                    happenTaxMny = deductEntity.getDeductTaxMny();
                } else {
                    happenMny = deductEntity.getDeductMny().negate();
                    happenTaxMny = deductEntity.getDeductTaxMny().negate();
                }
                costDetailVO.setHappenTaxMny(happenTaxMny);
                costDetailVO.setHappenMny(happenMny);
                costDetailVO.setSourceBillName(sourceTypeName);
                costDetailVO.setProjectId(settleEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            if (null != settleEntity.getPushCostTaxMny()) {
                this.logger.info("costDetailVOList--->{}", (Object)JSONObject.toJSONString(costDetailVOList));
                BigDecimal collectHappenTaxMny = costDetailVOList.stream().map(CostDetailVO::getHappenTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.logger.info("collectHappenTaxMny--->{}", (Object)collectHappenTaxMny);
                if (settleEntity.getPushCostTaxMny().compareTo(collectHappenTaxMny.subtract(new BigDecimal("0.5"))) < 0 || settleEntity.getPushCostTaxMny().compareTo(collectHappenTaxMny.add(new BigDecimal("0.5"))) > 0) {
                    throw new BusinessException("\u63a8\u9001\u5b9e\u9645\u6210\u672c\u6c60\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
                }
            }
            this.logger.info("\u63a8\u9001\u6570\u636e--------\uff1a{}", (Object)JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------\uff1a{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                this.logger.error("\u7f51\u7edc\u9519\u8bef \u63a8\u9001\u5b9e\u9645\u6210\u672c\u5931\u8d25 \u5931\u8d25\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
                throw new BusinessException(JSONObject.toJSONString((Object)stringCommonResponse));
            }
        }
        return true;
    }

    @Override
    public boolean updateContractPoolTotalSettleMnyAfterSettle(SettleEntity se, String type) {
        CommonResponse subConTotalSettleMnyParamRes = this.paramConfigApi.getByCode(SUB_CONTRACT_TOTAL_SETTLE_MNY_COUNT_SYS_PARAM);
        this.logger.info("\u67e5\u8be2\u7cfb\u7edf\u53c2\u6570\uff0c\u83b7\u53d6\u5206\u5305\u5408\u540c\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u8ba1\u7b97\u65b9\u5f0f\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)subConTotalSettleMnyParamRes));
        if (!subConTotalSettleMnyParamRes.isSuccess() || subConTotalSettleMnyParamRes.getData() == null) {
            this.logger.error("\u67e5\u8be2\u7cfb\u7edf\u53c2\u6570\uff0c\u83b7\u53d6\u5206\u5305\u5408\u540c\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u8ba1\u7b97\u65b9\u5f0f\u5931\u8d25");
            return false;
        }
        ParamRegisterSetVO paramRegisterSetVO = (ParamRegisterSetVO)subConTotalSettleMnyParamRes.getData();
        String defaultVal = paramRegisterSetVO.getValueData();
        if (StringUtils.isBlank((CharSequence)defaultVal)) {
            this.logger.error("\u67e5\u8be2\u7cfb\u7edf\u53c2\u6570\uff0c\u83b7\u53d6\u5206\u5305\u5408\u540c\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u8ba1\u7b97\u65b9\u5f0f\u5931\u8d25");
            return false;
        }
        Long tenantid = InvocationInfoProxy.getTenantid();
        Long seId = se.getId();
        Long contractId = se.getContractId();
        Integer settleType = se.getSettleType();
        String settleTypeName = SettleTypeEnum.getDescriptionByCode(settleType).getDescription();
        this.logger.info("ID\u4e3a\u3010" + contractId + "\u3011\u7684\u5408\u540c " + settleTypeName + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0csettleEntity={}, settleType={}, type={}", new Object[]{se, settleTypeName, type});
        QueryWrapper seWra = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)seWra.eq((Object)"dr", (Object)0)).eq((Object)"tenant_id", (Object)tenantid)).eq((Object)"contract_id", (Object)contractId)).in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        if ("back".equals(type)) {
            seWra.ne((Object)"id", (Object)seId);
        }
        switch (defaultVal) {
            case "1": {
                seWra.select(new String[]{"sum(if(settle_type = 2, ifnull(tax_mny, 0), 0)) as totalSettleTaxMny"});
                seWra.select(new String[]{"sum(if(settle_type = 2, ifnull(mny, 0), 0)) as totalSettleMny"});
                seWra.select(new String[]{"sum(if(settle_type = 2, ifnull(tax, 0), 0)) as totalSettleTax"});
                seWra.select(new String[]{"if(settle_type = 1, ifnull(total_node_tax_difference, 0), 0) totalTaxMnyDif"});
                seWra.select(new String[]{"if(settle_type = 1, ifnull(total_node_difference, 0), 0) totalMnyDif"});
                break;
            }
            case "2": {
                seWra.select(new String[]{"sum(if(settle_type = 0, ifnull(tax_mny, 0), 0)) as totalSettleTaxMny"});
                seWra.select(new String[]{"sum(if(settle_type = 0, ifnull(mny, 0), 0)) as totalSettleMny"});
                seWra.select(new String[]{"sum(if(settle_type = 0, ifnull(tax, 0), 0)) as totalSettleTax"});
                seWra.select(new String[]{"if(settle_type = 1, ifnull(total_process_tax_difference, 0), 0) totalTaxMnyDif"});
                seWra.select(new String[]{"if(settle_type = 1, ifnull(total_process_difference, 0), 0) totalMnyDif"});
                break;
            }
            default: {
                seWra.select(new String[]{"sum(ifnull(tax_mny, 0)) as totalSettleTaxMny, sum(ifnull(mny, 0)) as totalSettleMny, sum(ifnull(tax, 0)) as totalSettleTax, 0 as totalTaxMnyDif, 0 as totalMnyDif"});
            }
        }
        Map totalSettleMnyMap = super.getMap((Wrapper)seWra);
        this.logger.info("\u67e5\u8be2\u5f53\u524d\u5408\u540c\u4e0b\u7684\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)totalSettleMnyMap));
        BigDecimal totalSettleTaxMny = BigDecimal.ZERO;
        BigDecimal totalSettleMny = BigDecimal.ZERO;
        BigDecimal totalSettleTax = BigDecimal.ZERO;
        BigDecimal totalTaxMnyDif = BigDecimal.ZERO;
        BigDecimal totalMnyDif = BigDecimal.ZERO;
        BigDecimal totalTaxDif = BigDecimal.ZERO;
        if (MapUtils.isNotEmpty((Map)totalSettleMnyMap)) {
            totalSettleTaxMny = totalSettleMnyMap.get("totalSettleTaxMny") == null ? BigDecimal.ZERO : new BigDecimal(totalSettleMnyMap.get("totalSettleTaxMny").toString());
            totalSettleMny = totalSettleMnyMap.get("totalSettleMny") == null ? BigDecimal.ZERO : new BigDecimal(totalSettleMnyMap.get("totalSettleMny").toString());
            totalSettleTax = totalSettleMnyMap.get("totalSettleTax") == null ? BigDecimal.ZERO : new BigDecimal(totalSettleMnyMap.get("totalSettleTax").toString());
            totalTaxMnyDif = totalSettleMnyMap.get("totalTaxMnyDif") == null ? BigDecimal.ZERO : new BigDecimal(totalSettleMnyMap.get("totalTaxMnyDif").toString());
            totalMnyDif = totalSettleMnyMap.get("totalMnyDif") == null ? BigDecimal.ZERO : new BigDecimal(totalSettleMnyMap.get("totalMnyDif").toString());
            totalTaxDif = ComputeUtil.safeSub((BigDecimal)totalTaxMnyDif, (BigDecimal)totalMnyDif);
        }
        ContractPoolVO contractPoolVO = new ContractPoolVO();
        contractPoolVO.setSourceId(contractId);
        contractPoolVO.setTotalSettleTaxMny(ComputeUtil.safeAdd((BigDecimal)totalSettleTaxMny, (BigDecimal)totalTaxMnyDif));
        contractPoolVO.setTotalSettleMny(ComputeUtil.safeAdd((BigDecimal)totalSettleMny, (BigDecimal)totalMnyDif));
        contractPoolVO.setTotalSettleTax(ComputeUtil.safeAdd((BigDecimal)totalSettleTax, (BigDecimal)totalTaxDif));
        this.logger.info("ID\u4e3a\u3010" + contractId + "\u3011\u7684\u5408\u540c " + settleTypeName + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractPoolVO));
        CommonResponse updateConPoolRes = this.contractPoolApi.saveOrUpdateContract(contractPoolVO);
        this.logger.info("ID\u4e3a\u3010" + contractId + "\u3011\u7684\u5408\u540c " + settleTypeName + "\u7ed3\u7b97" + ("back".equals(type) ? "\u64a4\u56de" : "\u5ba1\u6279\u901a\u8fc7") + "\u540e\u66f4\u65b0\u5408\u540c\u6c60\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\uff08\u542b\u7a0e\u3001\u65e0\u7a0e\u3001\u7a0e\u989d\uff09\uff0c\u7ed3\u675f\uff0c\u66f4\u65b0\u5408\u540c\u6c60\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)updateConPoolRes));
        return true;
    }
}

