/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.plan.bean.PlanEntity;
import com.ejianc.business.plan.service.IPlanService;
import com.ejianc.business.plan.vo.PlanVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="plan")
public class PlanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPlanService planService;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        PlanEntity e = (PlanEntity)((Object)this.planService.selectById(billId));
        this.logger.info("\u5206\u5305\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5206\u5305\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6821\u9a8c\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\u7ed3\u679c\uff1a{}", new Object[]{billId, billTypeCode, JSONObject.toJSONString((Object)resp)});
        if (!resp.isSuccess()) {
            this.logger.info("\u5206\u5305\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", (Object)resp.getMsg());
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u64a4\u56de\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PlanEntity e = (PlanEntity)((Object)this.planService.selectById(billId));
        e.setEffectiveDate(new Date());
        this.planService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PlanEntity e = (PlanEntity)((Object)this.planService.selectById(billId));
        if (e != null) {
            if (e.getChangeState() == PlanVO.PLAN_CHANGE_STATE_CHANGING) {
                return CommonResponse.error((String)"\u53d8\u66f4\u4e2d\u5355\u636e\u65e0\u6cd5\u64a4\u56de");
            }
            if (e.getChangeState() == PlanVO.PLAN_CHANGE_STATE_CHANGED) {
                return CommonResponse.error((String)"\u5df2\u53d8\u66f4\u5355\u636e\u65e0\u6cd5\u64a4\u56de");
            }
        }
        this.logger.info("\u5206\u5305\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u5f03\u5ba1\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5206\u5305\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6821\u9a8c\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\u7ed3\u679c\uff1a{}", new Object[]{billId, billTypeCode, JSONObject.toJSONString((Object)resp)});
        if (!resp.isSuccess()) {
            this.logger.info("\u5206\u5305\u603b\u8ba1\u5212\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u5f03\u5ba1\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", (Object)resp.getMsg());
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u5f03\u5ba1\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray arr = new JSONArray();
        this.logger.info("sign:{}", (Object)sign);
        if ("choseCostUser".equals(sign)) {
            PlanEntity entity = (PlanEntity)((Object)this.planService.selectById(billId));
            Long projectId = entity.getProjectId();
            JSONObject jsonObject = new JSONObject();
            CommonResponse commonResponse = this.projectPoolApi.queryProjectPoolById(projectId);
            if (!commonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u5931\u8d25!");
            }
            JSONArray array = (JSONArray)commonResponse.getData();
            List vos = JSONObject.parseArray((String)array.toJSONString(), ProjectPoolSetVO.class);
            this.logger.info("vos:{}", (Object)JSONObject.toJSONString((Object)vos));
            ProjectPoolSetVO vo = (ProjectPoolSetVO)vos.get(0);
            Long costAdapter = vo.getCostAdapter();
            String costAdapterName = vo.getCostAdapterName();
            this.logger.info("userId:{}", (Object)costAdapter);
            this.logger.info("userName:{}", (Object)costAdapterName);
            jsonObject.put("userId", (Object)costAdapter);
            jsonObject.put("userName", (Object)costAdapterName);
            arr.add((Object)jsonObject);
        }
        return CommonResponse.success((Object)arr);
    }
}

