SET FOREIGN_KEY_CHECKS=0;

CREATE TABLE `ejc-prosub`.`ejc_custom_businessdata`  (
  `id` bigint(20) NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` int(1) NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` int(1) NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) NULL DEFAULT NULL,
  `business_id` bigint(20) NULL DEFAULT NULL COMMENT '单据id',
  `business_data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '单据扩展字段数据',
  `sequence` int(11) NULL DEFAULT NULL COMMENT '序号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '客户字段扩展表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract`  (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `target_result_id` bigint(20) NULL DEFAULT NULL COMMENT '定标结果Id',
  `target_result_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '定标结果名称',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_category_id` bigint(20) NULL DEFAULT NULL COMMENT '合同类别Id',
  `contract_category_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同类别名称',
  `first_party_id` bigint(20) NULL DEFAULT NULL COMMENT '甲方Id',
  `first_party_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方名称',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商Id',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商名称',
  `sign_date` date NULL DEFAULT NULL COMMENT '签订日期',
  `sign_place` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签约地点',
  `signature_status` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章',
  `performance_status` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人Id',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人名称',
  `employee_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方经办人电话',
  `supplier_employee` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方经办人',
  `supplier_employee_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方经办人电话',
  `project_address` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工程地点',
  `tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同税率',
  `quality_standard_id` bigint(20) NULL DEFAULT NULL COMMENT '质量标准Id',
  `quality_standard_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '质量标准名称',
  `project_tax_calc_type` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目计税方式名称:简易计税、一般计税',
  `pricing_type` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计价方式：1-可调单价、2-固定总价、3-成本加酬金；',
  `draft_type` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '起草方式：1、在线起草，2、上传合同，3、线下签订',
  `contract_file_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同附件路径',
  `contract_file_id` bigint(20) NULL DEFAULT NULL COMMENT '合同附件Id',
  `contract_template_id` bigint(20) NULL DEFAULT NULL COMMENT '合同模板Id',
  `contract_template_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同模板名称',
  `contract_file_version_id` bigint(20) NULL DEFAULT NULL COMMENT '合同附件版本Id',
  `contract_file_version` bigint(20) NULL DEFAULT NULL COMMENT '合同附件版本',
  `qualify_id` bigint(20) NULL DEFAULT NULL COMMENT '资质Id',
  `qualify_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资质名称',
  `qualify_certify_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资质证书编号',
  `qualify_licence_issuing_authority` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资质证书发证机关',
  `qualify_grant_date` date NULL DEFAULT NULL COMMENT '资质证书授予日期',
  `qualify_valid_till_date` date NULL DEFAULT NULL COMMENT '资质证书有效期至',
  `safety_production_license_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '安全生成许可证编号',
  `safety_certify_grant_date` date NULL DEFAULT NULL COMMENT '安全生产许可证授予日期',
  `safety_certify_valid_till_date` date NULL DEFAULT NULL COMMENT '安全许可证有效期至',
  `project_start_date` date NULL DEFAULT NULL COMMENT '开工日期',
  `planned_finish_date` date NULL DEFAULT NULL COMMENT '计划竣工日期',
  `contract_days_limit` int(11) NULL DEFAULT NULL COMMENT '合同工期:合同工期=计划竣工日期-开工日期+1（单位：天）',
  `first_party_project_manager_id` bigint(20) NULL DEFAULT NULL COMMENT '甲方项目经理Id',
  `first_party_project_manager_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方项目经理名称',
  `first_party_project_manager_link` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方项目经理联系电话',
  `first_party_project_manager_post` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方项目经理职务',
  `supplier_project_manager_id` bigint(20) NULL DEFAULT NULL COMMENT '乙方项目经理Id',
  `supplier_project_manager_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理名称',
  `supplier_project_manager_link` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理联系电话',
  `supplier_project_manager_post` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理职务',
  `supplier_project_manager_id_card` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理身份证号',
  `contract_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同金额（含税）',
  `contract_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同金额（无税）',
  `contract_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同税额',
  `sub_contract_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包金额（含税）',
  `sub_contract_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包金额（无税）',
  `sub_contract_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包税额',
  `other_cost_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '其他金额（含税）',
  `other_cost_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '其他金额（无税）',
  `other_cost_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '其他税额',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态',
  `commit_date` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `commit_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人名称',
  `commit_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人账号',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部Id',
  `org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部名称',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部上级组织Id',
  `parent_org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织名称',
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织编码',
  `contract_file_highlight_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同高亮附件路径',
  `contract_file_highlight_id` bigint(20) NULL DEFAULT NULL COMMENT '合同高亮附件Id',
  `base_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '初始版本金额',
  `base_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '初始版本(含税)金额',
  `before_change_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前金额',
  `before_change_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前金额（含税）',
  `changing_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更中金额',
  `changing_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更中金额（含税）',
  `change_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更单号',
  `change_version` int(11) NULL DEFAULT NULL COMMENT '变更版本',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `change_status` tinyint(4) NULL DEFAULT NULL COMMENT '变更状态(1-未变更 2-变更中 3-已变更)',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否补充协议(1:是，0：否)',
  `main_contract_id` bigint(20) NULL DEFAULT NULL COMMENT '主合同Id',
  `main_contract_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '主合同编码',
  `main_contract_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '主合同名称',
  `supplement_describe` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '补充项描述',
  `main_contract_create_date` datetime(0) NULL DEFAULT NULL COMMENT '主合同创建日期（用于合同、补充协议排序）\r\n',
  `change_date` date NULL DEFAULT NULL COMMENT '变更日期',
  `change_contract_signature_status` tinyint(4) NULL DEFAULT NULL COMMENT '变更合同签章状态',
  `change_draft_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更起草方式：1-上传附件，2-线下签订',
  `change_file_id` bigint(20) NULL DEFAULT NULL COMMENT '变更附件Id',
  `change_contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更合同名称',
  `signed_file_id` bigint(20) NULL DEFAULT NULL COMMENT '签章完成合同文件Id',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：劳务合同-0，专业合同-1',
  `add_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同新增方式：参照定标结果新增-0，直接新增-1',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编码',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_change`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `target_result_id` bigint(20) NULL DEFAULT NULL COMMENT '定标结果Id',
  `target_result_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '定标结果名称',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_category_id` bigint(20) NULL DEFAULT NULL COMMENT '合同类别Id',
  `contract_category_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同类别名称',
  `first_party_id` bigint(20) NULL DEFAULT NULL COMMENT '甲方Id',
  `first_party_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方名称',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商Id',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商名称',
  `sign_date` date NULL DEFAULT NULL COMMENT '签订日期',
  `sign_place` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签约地点',
  `signature_status` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章',
  `performance_status` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人Id',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人名称',
  `employee_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方经办人电话',
  `supplier_employee` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方经办人',
  `supplier_employee_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方经办人电话',
  `project_address` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工程地点',
  `tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同税率',
  `quality_standard_id` bigint(20) NULL DEFAULT NULL COMMENT '质量标准Id',
  `quality_standard_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '质量标准名称',
  `project_tax_calc_type` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目计税方式名称:简易计税、一般计税',
  `pricing_type` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计价方式：1-可调单价、2-固定总价、3-成本加酬金；',
  `draft_type` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '起草方式：1、在线起草，2、上传合同，3、线下签订',
  `contract_file_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同附件路径',
  `contract_file_id` bigint(20) NULL DEFAULT NULL COMMENT '合同附件Id',
  `contract_template_id` bigint(20) NULL DEFAULT NULL COMMENT '合同模板Id',
  `contract_template_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同模板名称',
  `contract_file_version_id` bigint(20) NULL DEFAULT NULL COMMENT '合同附件版本Id',
  `contract_file_version` bigint(20) NULL DEFAULT NULL COMMENT '合同附件版本',
  `qualify_id` bigint(20) NULL DEFAULT NULL COMMENT '资质id',
  `qualify_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资质名称',
  `qualify_certify_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资质证书编号',
  `qualify_licence_issuing_authority` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资质证书发证机关',
  `qualify_grant_date` date NULL DEFAULT NULL COMMENT '资质证书授予日期',
  `qualify_valid_till_date` date NULL DEFAULT NULL COMMENT '资质证书有效期至',
  `safety_production_license_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '安全生成许可证编号',
  `safety_certify_grant_date` date NULL DEFAULT NULL COMMENT '安全生产许可证授予日期',
  `safety_certify_valid_till_date` date NULL DEFAULT NULL COMMENT '安全许可证有效期至',
  `project_start_date` date NULL DEFAULT NULL COMMENT '开工日期',
  `planned_finish_date` date NULL DEFAULT NULL COMMENT '计划竣工日期',
  `contract_days_limit` int(11) NULL DEFAULT NULL COMMENT '合同工期:合同工期=计划竣工日期-开工日期+1',
  `first_party_project_manager_id` bigint(20) NULL DEFAULT NULL COMMENT '甲方项目经理Id',
  `first_party_project_manager_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方项目经理名称',
  `first_party_project_manager_link` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方项目经理联系电话',
  `first_party_project_manager_post` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方项目经理职务',
  `supplier_project_manager_id` bigint(20) NULL DEFAULT NULL COMMENT '乙方项目经理Id',
  `supplier_project_manager_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理名称',
  `supplier_project_manager_link` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理联系电话',
  `supplier_project_manager_post` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理职务',
  `supplier_project_manager_id_card` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理身份证号',
  `contract_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同金额（含税）',
  `contract_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同金额（无税）',
  `contract_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同税额',
  `sub_contract_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包金额（含税）',
  `sub_contract_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包金额（无税）',
  `sub_contract_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包税额',
  `other_cost_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '其他金额（含税）',
  `other_cost_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '其他金额（无税）',
  `other_cost_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '其他税额',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态',
  `commit_date` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `commit_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人名称',
  `commit_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人账号',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部Id',
  `org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部名称',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部上级组织Id',
  `parent_org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织名称',
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织编码',
  `contract_file_highlight_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同高亮附件路径',
  `contract_file_highlight_id` bigint(20) NULL DEFAULT NULL COMMENT '合同高亮附件Id',
  `base_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '初始版本金额',
  `base_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '初始版本(含税)金额',
  `before_change_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前金额',
  `before_change_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前金额（含税）',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否补充协议(1:是，0：否)',
  `main_contract_id` bigint(20) NULL DEFAULT NULL COMMENT '主合同Id',
  `main_contract_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '主合同编码',
  `main_contract_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '主合同名称',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同ID',
  `before_contract_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更前合同名称',
  `change_items` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更项：用、号隔开。如：数量、单价、税率、甲方、乙方；',
  `change_employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人',
  `change_employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更经办人名称',
  `change_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '本次变更金额',
  `change_scale` decimal(28, 8) NULL DEFAULT NULL COMMENT '本次变更比例',
  `change_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '本次变更税率',
  `change_reason` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更原因描述',
  `change_draft_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更起草方式：1-上传附件，2-线下签订',
  `change_file_id` bigint(20) NULL DEFAULT NULL COMMENT '变更附件Id',
  `change_file_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更附件路径',
  `change_date` date NULL DEFAULT NULL COMMENT '变更日期',
  `change_version` int(11) NULL DEFAULT NULL COMMENT '变更版本',
  `signed_file_id` bigint(20) NULL DEFAULT NULL COMMENT '签章完成合同文件Id',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：分包合同-0，专业合同-1',
  `add_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同新增方式：参照定标结果新增-0，直接新增-1',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编码',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-变更表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_change_clause`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `clause_name_id` bigint(20) NULL DEFAULT NULL COMMENT '合同条款名称Id',
  `clause_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同条款名称',
  `clause_content` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同条款内容',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `src_tbl_id` bigint(20) NULL DEFAULT NULL COMMENT '来源子表主键',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-合同条款-变更表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_change_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `detail_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单编号',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  `detail_work_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `detail_measurement_rules` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量规则',
  `detail_unit` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `detail_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '工程量',
  `detail_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（无税）',
  `detail_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `detail_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（无税）',
  `detail_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价(含税）',
  `detail_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（含税）',
  `detail_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税额',
  `detail_memo` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '来源数据Id',
  `source_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源类型：1-定标结果带入',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `src_tbl_id` bigint(20) NULL DEFAULT NULL COMMENT '来源子表主键',
  `before_change_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前工程量',
  `before_change_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前单价',
  `before_change_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前税率',
  `parent_id` bigint(20) NULL DEFAULT NULL COMMENT '父ID',
  `change_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  `doc_category_id` bigint(20) NULL DEFAULT NULL COMMENT '档案分类id',
  `doc_id` bigint(20) NULL DEFAULT NULL COMMENT '档案Id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-分包明细-变更表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_change_other_cost`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  `cost_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '费用名称',
  `cost_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '数量',
  `cost_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（无税）',
  `cost_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `cost_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（含税）',
  `cost_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额无税',
  `cost_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（含税）',
  `cost_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税金',
  `cost_memo` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `src_tbl_id` bigint(20) NULL DEFAULT NULL COMMENT '来源子表主键',
  `before_change_cost_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前数量',
  `before_change_cost_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前单价(无税)',
  `before_change_cost_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前税率',
  `change_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-其他费用-变更表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_change_payment`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `payment_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '付款阶段名称',
  `payment_scale` decimal(28, 8) NULL DEFAULT NULL COMMENT '付款阶段比例(%)',
  `mark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `src_tbl_id` bigint(20) NULL DEFAULT NULL COMMENT '来源子表主键',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-付款阶段-变更表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_clause`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `clause_name_id` bigint(20) NULL DEFAULT NULL COMMENT '合同条款名称Id',
  `clause_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同条款名称',
  `clause_content` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同条款内容',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `change_bid` bigint(20) NULL DEFAULT NULL COMMENT '变更子表主键',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-合同条款' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `detail_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单编号',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  `detail_work_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `detail_measurement_rules` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量规则',
  `detail_unit` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `detail_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '工程量',
  `detail_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（无税）',
  `detail_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `detail_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（无税）',
  `detail_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价(含税）',
  `detail_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（含税）',
  `detail_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税额',
  `detail_memo` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '来源数据Id',
  `source_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '来源类型：1-定标结果带入',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id(合同表主键相当于pid)',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更表主键',
  `change_bid` bigint(20) NULL DEFAULT NULL COMMENT '变更子表主键',
  `parent_id` bigint(20) NULL DEFAULT NULL COMMENT '父ID',
  `change_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型',
  `doc_category_id` bigint(20) NULL DEFAULT NULL COMMENT '档案分类id',
  `doc_id` bigint(20) NULL DEFAULT NULL COMMENT '档案Id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-分包明细' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_freeze`  (
  `id` bigint(20) UNSIGNED NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(1) NULL DEFAULT NULL COMMENT '乐观锁',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称（带入）',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编码',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `contract_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-主合同 1-补充协议',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部id',
  `org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部名称',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部编码',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部所属组织id',
  `parent_org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织名称',
  `parent_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织编码',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商id(乙方)',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商名称（乙方）',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '申请人 即经办人',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '申请人信息 即经办人',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办单位id',
  `department_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办单位',
  `department_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办单位编码',
  `first_party_name` varchar(68) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方',
  `first_party_id` bigint(20) NULL DEFAULT NULL COMMENT '甲方id',
  `freeze_cause` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '冻结/取消冻结 原因',
  `performance_status` tinyint(4) NULL DEFAULT NULL COMMENT '合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `freeze_date` datetime(0) NULL DEFAULT NULL COMMENT '冻结日期（默认当前时间 可修改）',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态',
  `bill_type_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据类型',
  `commit_date` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `commit_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人名称',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `commit_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人账号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合同冻结表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_other_cost`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  `cost_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '费用名称',
  `cost_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '数量',
  `cost_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（无税）',
  `cost_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `cost_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（含税）',
  `cost_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额无税',
  `cost_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（含税）',
  `cost_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税金',
  `cost_memo` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `change_bid` bigint(20) NULL DEFAULT NULL COMMENT '变更子表主键',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  `change_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-其他费用' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_payment`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `payment_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '付款阶段名称',
  `payment_scale` decimal(28, 8) NULL DEFAULT NULL COMMENT '付款阶段比例(%)',
  `mark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `change_bid` bigint(20) NULL DEFAULT NULL COMMENT '变更子表主键',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-付款阶段' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_record`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `target_result_id` bigint(20) NULL DEFAULT NULL COMMENT '定标结果Id',
  `target_result_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '定标结果名称',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_category_id` bigint(20) NULL DEFAULT NULL COMMENT '合同类别Id',
  `contract_category_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同类别名称',
  `first_party_id` bigint(20) NULL DEFAULT NULL COMMENT '甲方Id',
  `first_party_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方名称',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商Id',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商名称',
  `sign_date` date NULL DEFAULT NULL COMMENT '签订日期',
  `sign_place` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签约地点',
  `signature_status` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章',
  `performance_status` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人Id',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人名称',
  `employee_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方经办人电话',
  `supplier_employee` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方经办人',
  `supplier_employee_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方经办人电话',
  `project_address` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工程地点',
  `tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同税率',
  `quality_standard_id` bigint(20) NULL DEFAULT NULL COMMENT '质量标准Id',
  `quality_standard_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '质量标准名称',
  `project_tax_calc_type` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目计税方式名称:简易计税、一般计税',
  `pricing_type` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计价方式：1-可调单价、2-固定总价、3-成本加酬金；',
  `draft_type` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '起草方式：1、在线起草，2、上传合同，3、线下签订',
  `contract_file_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同附件路径',
  `contract_file_id` bigint(20) NULL DEFAULT NULL COMMENT '合同附件Id',
  `contract_template_id` bigint(20) NULL DEFAULT NULL COMMENT '合同模板Id',
  `contract_template_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同模板名称',
  `contract_file_version_id` bigint(20) NULL DEFAULT NULL COMMENT '合同附件版本Id',
  `contract_file_version` bigint(20) NULL DEFAULT NULL COMMENT '合同附件版本',
  `qualify_id` bigint(20) NULL DEFAULT NULL COMMENT '资质Id',
  `qualify_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资质名称',
  `qualify_certify_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资质证书编号',
  `qualify_licence_issuing_authority` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '资质证书发证机关',
  `qualify_grant_date` date NULL DEFAULT NULL COMMENT '资质证书授予日期',
  `qualify_valid_till_date` date NULL DEFAULT NULL COMMENT '资质证书有效期至',
  `safety_production_license_no` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '安全生成许可证编号',
  `safety_certify_grant_date` date NULL DEFAULT NULL COMMENT '安全生产许可证授予日期',
  `safety_certify_valid_till_date` date NULL DEFAULT NULL COMMENT '安全许可证有效期至',
  `project_start_date` date NULL DEFAULT NULL COMMENT '开工日期',
  `planned_finish_date` date NULL DEFAULT NULL COMMENT '计划竣工日期',
  `contract_days_limit` int(11) NULL DEFAULT NULL COMMENT '合同工期:合同工期=计划竣工日期-开工日期+1',
  `first_party_project_manager_id` bigint(20) NULL DEFAULT NULL COMMENT '甲方项目经理Id',
  `first_party_project_manager_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方项目经理名称',
  `first_party_project_manager_link` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方项目经理联系电话',
  `first_party_project_manager_post` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方项目经理职务',
  `supplier_project_manager_id` bigint(20) NULL DEFAULT NULL COMMENT '乙方项目经理Id',
  `supplier_project_manager_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理名称',
  `supplier_project_manager_link` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理联系电话',
  `supplier_project_manager_post` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理职务',
  `supplier_project_manager_id_card` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理身份证号',
  `contract_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同金额（含税）',
  `contract_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同金额（无税）',
  `contract_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同税额',
  `sub_contract_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包金额（含税）',
  `sub_contract_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包金额（无税）',
  `sub_contract_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包税额',
  `other_cost_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '其他金额（含税）',
  `other_cost_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '其他金额（无税）',
  `other_cost_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '其他税额',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态',
  `commit_date` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `commit_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人名称',
  `commit_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人账号',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部Id',
  `org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部名称',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部上级组织Id',
  `parent_org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织名称',
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织编码',
  `contract_file_highlight_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同高亮附件路径',
  `contract_file_highlight_id` bigint(20) NULL DEFAULT NULL COMMENT '合同高亮附件Id',
  `base_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '初始版本金额',
  `base_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '初始版本(含税)金额',
  `before_change_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前金额',
  `before_change_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更前金额（含税）',
  `changing_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更中金额',
  `changing_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更中金额（含税）',
  `change_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更单号',
  `change_version` int(11) NULL DEFAULT NULL COMMENT '变更版本',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `change_status` tinyint(4) NULL DEFAULT NULL COMMENT '变更状态(1-未变更 2-变更中 3-已变更)',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否补充协议(1:是，0：否)',
  `main_contract_id` bigint(20) NULL DEFAULT NULL COMMENT '主合同Id',
  `main_contract_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '主合同编码',
  `main_contract_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '主合同名称',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同ID',
  `supplement_describe` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '补充项描述',
  `main_contract_create_date` datetime(0) NULL DEFAULT NULL COMMENT '主合同创建日期（用于合同、补充协议排序）\r\n',
  `change_date` date NULL DEFAULT NULL COMMENT '变更日期',
  `change_contract_signature_status` tinyint(4) NULL DEFAULT NULL COMMENT '变更合同签章状态',
  `change_draft_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更起草方式：1-上传附件，2-线下签订',
  `change_file_id` bigint(20) NULL DEFAULT NULL COMMENT '变更附件Id',
  `change_contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更合同名称',
  `signed_file_id` bigint(20) NULL DEFAULT NULL COMMENT '签章完成合同文件Id',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：分包合同-0，专业合同-1',
  `add_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同新增方式：参照定标结果新增-0，直接新增-1',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编码',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-记录表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_record_clause`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `clause_name_id` bigint(20) NULL DEFAULT NULL COMMENT '合同条款名称Id',
  `clause_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同条款名称',
  `clause_content` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同条款内容',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `change_bid` bigint(20) NULL DEFAULT NULL COMMENT '变更子表主键',
  `record_id` bigint(20) NULL DEFAULT NULL COMMENT '记录表ID',
  `src_table_id` bigint(20) NULL DEFAULT NULL COMMENT '来源主合同子表id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-合同条款-记录表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_record_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `detail_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单编号',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  `detail_work_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `detail_measurement_rules` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量规则',
  `detail_unit` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `detail_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '工程量',
  `detail_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（无税）',
  `detail_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `detail_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（无税）',
  `detail_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价(含税）',
  `detail_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（含税）',
  `detail_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税额',
  `detail_memo` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '来源数据Id',
  `source_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源类型：1-定标结果带入',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `change_bid` bigint(20) NULL DEFAULT NULL COMMENT '变更子表主键',
  `parent_id` bigint(20) NULL DEFAULT NULL COMMENT '父ID',
  `change_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型',
  `record_id` bigint(20) NULL DEFAULT NULL COMMENT '记录表ID',
  `src_table_id` bigint(20) NULL DEFAULT NULL COMMENT '来源主合同子表id',
  `doc_category_id` bigint(20) NULL DEFAULT NULL COMMENT '档案分类id',
  `doc_id` bigint(20) NULL DEFAULT NULL COMMENT '档案Id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-分包明细-记录表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_record_other_cost`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  `cost_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '费用名称',
  `cost_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '数量',
  `cost_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（无税）',
  `cost_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `cost_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（含税）',
  `cost_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额无税',
  `cost_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（含税）',
  `cost_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税金',
  `cost_memo` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `change_bid` bigint(20) NULL DEFAULT NULL COMMENT '变更子表主键',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  `change_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型',
  `record_id` bigint(20) NULL DEFAULT NULL COMMENT '记录表ID',
  `src_table_id` bigint(20) NULL DEFAULT NULL COMMENT '来源主合同子表id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-其他费用-记录表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_record_payment`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `payment_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '付款阶段名称',
  `payment_scale` decimal(28, 8) NULL DEFAULT NULL COMMENT '付款阶段比例(%)',
  `mark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '所属合同Id',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '变更主键',
  `change_bid` bigint(20) NULL DEFAULT NULL COMMENT '变更子表主键',
  `record_id` bigint(20) NULL DEFAULT NULL COMMENT '记录表ID',
  `src_table_id` bigint(20) NULL DEFAULT NULL COMMENT '来源主合同子表id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '劳务分包合同-付款阶段-记录表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_contract_relieve`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `bill_state` tinyint(2) NULL DEFAULT 0 COMMENT '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部id',
  `org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部名称',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部编码',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部所属组织id',
  `parent_org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织名称',
  `parent_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织编码',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人id',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人名称',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办部门id',
  `department_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办部门名称',
  `department_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办部门编码',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编码',
  `first_party_id` bigint(20) NULL DEFAULT NULL COMMENT '甲方id',
  `first_party_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '甲方名称',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商id',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商名称',
  `relieve_date` datetime(0) NULL DEFAULT NULL COMMENT '解除日期',
  `relieve_cause` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '解除原因',
  `draft_type` tinyint(4) NULL DEFAULT NULL COMMENT '起草方式 1、上传解除协议，2、已签章；',
  `attachment_file_id` bigint(20) NULL DEFAULT NULL COMMENT '附件协议',
  `attachment_file_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '附件协议名称',
  `performance_status` tinyint(4) NULL DEFAULT NULL COMMENT '合同状态 1、未签订；2、履约中；3、已封账；4、已解除 ；5 已冻结',
  `signature_status` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1' COMMENT '签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章',
  `commit_date` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `commit_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人名称',
  `commit_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人账号',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合同解除表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_deduction`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编码',
  `bill_state` tinyint(2) NULL DEFAULT NULL COMMENT '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '组织id',
  `org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织编码',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '上级组织id',
  `parent_org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '上级组织名称',
  `parent_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '上级组织编码',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型:分包合同-0,专业合同-1',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类别：0-主合同 1-补充协议',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目id',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编码',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '乙方id',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方名称',
  `supplier_sign_status` tinyint(4) NULL DEFAULT NULL COMMENT '乙方签字状态:已签字-0,未签字-1',
  `happen_date` date NULL DEFAULT NULL COMMENT '发生日期',
  `reward_deduction_type` tinyint(4) NULL DEFAULT NULL COMMENT '奖罚单类型:默认奖励,奖励-0、扣款-1、罚款-2',
  `deduction_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '扣款类型,1-10个字',
  `tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人名称',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办部门id',
  `department_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办部门名称',
  `department_code` bigint(20) NULL DEFAULT NULL COMMENT '经办部门编码',
  `commit_date` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `commit_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人名称',
  `commit_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人账号',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '单据创建人Id',
  `sup_operator_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供方经办人名称',
  `sup_operator_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供方经办人手机号',
  `sup_operator_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供方经办人账号',
  `sup_operate_time` datetime(0) NULL DEFAULT NULL COMMENT '供方经办人签字时间',
  `mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（无税）',
  `tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税额',
  `tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '扣奖罚单' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_finish`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁标识',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '结算单号',
  `settle_date` datetime(0) NULL DEFAULT NULL COMMENT '结算日期：默认显示当天',
  `bill_state` tinyint(2) NULL DEFAULT 0 COMMENT '单据状态（审批必须字段）',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类别：0-主合同 1-补充协议',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '乙方id',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方名称',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称（带入）',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编号',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部组织ID',
  `org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部组织名称',
  `org_code` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部组织编码',
  `parent_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织编码',
  `parent_org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '组织id',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '申请人id 即经办人',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '申请人名 即经办人',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办部门id',
  `department_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办部门',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `finish_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '完工结算金额(含税)',
  `finish_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '完工结算金额(不含税)',
  `finish_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '完工结算税额',
  `detail_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包明细金额（含税）',
  `detail_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包明细金额(不含税)',
  `detail_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '分包明细税额',
  `picking_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '领料扣款金额(含税)',
  `picking_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '领料扣款金额(不含税)',
  `picking_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '领料扣款税额',
  `odd_job_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '零工金额金额(含税)',
  `odd_job_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '零工金额金额(不含税)',
  `odd_job_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '零工金额税额',
  `deduction_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '奖罚扣款单金额(含税)',
  `deduction_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '奖罚扣款单金额(无税)',
  `deduction_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '奖罚扣款单税额',
  `other_cost_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期其他费用结算金额(含税)',
  `other_cost_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期其他费用结算金额(无税)',
  `other_cost_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期其他费用税额',
  `contract_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同金额(含税)',
  `contract_mny1` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同金额',
  `contract_mny2` decimal(28, 8) NULL DEFAULT NULL COMMENT '工人工资金额',
  `contract_mny3` decimal(28, 8) NULL DEFAULT NULL COMMENT '过程结算金额',
  `contract_mny4` decimal(28, 8) NULL DEFAULT NULL COMMENT '过程结算差额',
  `contract_mny5` decimal(28, 8) NULL DEFAULT NULL COMMENT '节点结算金额',
  `contract_mny6` decimal(28, 8) NULL DEFAULT NULL COMMENT '节点结算差额',
  `contract_mny7` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同已付金额',
  `contract_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同收票金额',
  `picking_contract_mny1` decimal(28, 8) NULL DEFAULT NULL COMMENT '过程结算金额',
  `picking_contract_mny2` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期结算金额',
  `picking_contract_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '完工结算金额',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分包完工结算表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_material_apply`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型:分包合同-0,专业合同-1',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编号',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商id',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商名称',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人名称',
  `org_id` bigint(50) NULL DEFAULT NULL COMMENT '项目部id',
  `org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部编码\r\n',
  `org_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部名称',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部所属组织Id',
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织编码',
  `parent_org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织名称',
  `contract_category_id` bigint(20) NULL DEFAULT NULL COMMENT '合同类别Id',
  `contract_category_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同类别名称',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合同冻结表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_material_apply_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `material_apply_id` bigint(20) NULL DEFAULT NULL COMMENT '主表id',
  `material_type_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '材料分类名称',
  `material_type_id` bigint(20) NULL DEFAULT NULL COMMENT '材料分类id',
  `material_id` bigint(20) NULL DEFAULT NULL COMMENT '材料id',
  `material_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '材料名称',
  `model` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '规格型号',
  `unit` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量单位',
  `apply_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '领料限额量（申请数量）',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商品牌id',
  `supplier_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商品牌',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '合同冻结表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_measure`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '单据创建人ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编码',
  `bill_state` tinyint(2) NULL DEFAULT 0 COMMENT '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部id',
  `org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部名称',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部编码',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部所属组织id',
  `parent_org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织名称',
  `parent_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织编码',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型:分包合同-0,专业合同-1',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类别：0-主合同 1-补充协议',
  `contract_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同税率',
  `contract_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同金额（含税）',
  `contract_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同金额（无税）',
  `contract_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同税额',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目id',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编码',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '乙方id',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方名称',
  `supplier_sign_status` tinyint(4) NULL DEFAULT NULL COMMENT '乙方签字状态:已签字-1,未签字-0',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人名称',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办部门id',
  `department_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办部门名称',
  `department_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办部门编码',
  `total_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '总金额（含税）',
  `memo` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `commit_date` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `commit_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人名称',
  `commit_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人账号',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `sup_operator_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供方经办人名称',
  `sup_operator_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供方经办人手机号',
  `sup_operator_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供方经办人账号',
  `sup_operate_time` datetime(0) NULL DEFAULT NULL COMMENT '供方经办人签字时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分包计量' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_measure_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `list_contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `list_contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `list_contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `list_contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型:分包合同-0,专业合同-1',
  `list_supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类别：0-主合同 1-补充协议',
  `list_id` bigint(20) NULL DEFAULT NULL COMMENT '合同清单id',
  `list_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同清单名称',
  `work_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `unit` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量单位',
  `measure_rule` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量规则',
  `work_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同工程量',
  `tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（含税）',
  `price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（无税）',
  `total_measure` decimal(28, 8) NULL DEFAULT NULL COMMENT '含本次累计计量',
  `measure` decimal(28, 8) NULL DEFAULT NULL COMMENT '本次计量',
  `list_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '计量清单金额（含税）',
  `list_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '计量清单金额（无税）',
  `list_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '计量清单税额',
  `list_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '清单税率',
  `measure_id` bigint(20) NULL DEFAULT NULL COMMENT '分包计主键id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分包计量-计量清单' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_oldjob_application`  (
  `mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '零工总金额：自动计算子表的无税总金额不支持修改(无税)',
  `use_flag` tinyint(4) NULL DEFAULT NULL COMMENT '零工是否登记  1被引用：显示标识 零工已登记 0 未被引用：零工未登记',
  `tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '零工总金额：自动计算子表的含税总金额不支持修改（含税）',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `use_work_type` tinyint(4) NULL DEFAULT NULL COMMENT '用工类型 1-零星用工 2-临时机械 3-变更签证',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '申请人 即经办人',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '申请人信息 即经办人',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称',
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商名称（乙方）',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目id',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `parent_org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '上级组织名称',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编号',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编码',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办部门id',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '组织id',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织编码',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '上级组织id',
  `parent_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '上级组织编码',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类别：0-主合同 1-补充协议',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商id(乙方)',
  `department_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办部门',
  `use_work_detail` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用工内容 手动输入 1-50个字，必填项',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `commit_date` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `commit_user_name` varchar(68) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人名称',
  `commit_user_code` varchar(68) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人账号',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `applicat_date` datetime(0) NULL DEFAULT NULL COMMENT '申请时间',
  `applicant_date` datetime(0) NULL DEFAULT NULL COMMENT '申请时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '零工申请 主表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_oldjob_application_detail`  (
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价(含税)',
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '清单来源id 合同id',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `work_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '工程量',
  `list_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-主合同 1-补充协议',
  `list_id` bigint(20) NULL DEFAULT NULL COMMENT '清单id',
  `list_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `list_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '总额 自动计算 不支持修改',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `list_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税额',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `application_id` bigint(20) NULL DEFAULT NULL COMMENT '零工申请id',
  `list_type` tinyint(4) NULL DEFAULT NULL COMMENT '清单来源 0- 选择，1-新增',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `list_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '总额 自动计算 不支持修改(含税)',
  `detail_measurement_rules` varchar(68) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量规则',
  `detail_work_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `contract_work_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同工程量',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '零工申请 用工明细表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_oldjob_registration`  (
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商id(乙方)',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编码',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '申请人 即经办人',
  `use_work_detail` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用工内容 手动输入 1-50个字，必填项',
  `bill_type` tinyint(4) NULL DEFAULT NULL COMMENT '来源：0-自制、1-申请单—单据编号',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `parent_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织编码',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部所属组织id',
  `org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部名称',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `total_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '零工总金额：自动计算子表的无税总金额不支持修改(无税)',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称（带入）',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '申请人信息 即经办人',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商名称（乙方）',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部id',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类别：0-主合同 1-补充协议',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `supplier_sign_status` tinyint(4) NULL DEFAULT NULL COMMENT '签字状态 0:未签字显示：乙方未签字，1:签字显示：乙方已签字',
  `total_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '零工总金额：自动计算子表的含税总金额不支持修改（含税）',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `use_work_type` tinyint(4) NULL DEFAULT NULL COMMENT '用工类型 0-零星用工 1-临时机械 2-变更签证',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `parent_org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部所属组织名称',
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部编码',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人 部门id',
  `department_name` varchar(68) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人部门',
  `commit_date` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `commit_user_name` varchar(68) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人名称',
  `commit_user_code` varchar(68) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人账号',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `application_id` bigint(20) NULL DEFAULT NULL COMMENT '申请单id',
  `region_date` datetime(0) NULL DEFAULT NULL COMMENT '登记时间',
  `region_type` tinyint(4) NULL DEFAULT NULL COMMENT '登记类型 0- 零工登记； 1-零工转扣',
  `create_user_id` bigint(20) NULL DEFAULT NULL COMMENT '单据创建人Id',
  `sup_operator_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供方经办人名称',
  `sup_operator_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供方经办人手机号',
  `sup_operator_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供方经办人账号',
  `sup_operate_time` datetime(0) NULL DEFAULT NULL COMMENT '供方经办人签字时间',
  `total_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '零工总税额',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '零工登记' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_oldjob_registration_deduct`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `registration_id` bigint(20) NULL DEFAULT NULL COMMENT '零工登记id',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-主合同 1-补充协议',
  `deduct_tax_mny` decimal(20, 8) NULL DEFAULT NULL COMMENT '转扣金额(含税)',
  `deduct_tax_rate` decimal(20, 8) NULL DEFAULT NULL COMMENT '税率',
  `deduct_mny` decimal(20, 8) NULL DEFAULT NULL COMMENT '转扣金额',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '零工转扣' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_oldjob_registration_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `registration_id` bigint(20) NULL DEFAULT NULL COMMENT '零工登记id',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-主合同 1-补充协议',
  `list_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `list_id` bigint(20) NULL DEFAULT NULL COMMENT '清单id',
  `list_type` tinyint(4) NULL DEFAULT NULL COMMENT '清单来源 0- 选择，1-新增',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '清单来源id 合同id',
  `work_num` decimal(20, 8) NULL DEFAULT NULL COMMENT '工程量',
  `price` decimal(20, 8) NULL DEFAULT NULL COMMENT '单价',
  `tax_price` decimal(20, 8) NULL DEFAULT NULL COMMENT '单价(含税)',
  `list_tax_rate` decimal(20, 8) NULL DEFAULT NULL COMMENT '税率',
  `list_tax_mny` decimal(20, 8) NULL DEFAULT NULL COMMENT '总额 自动计算 不支持修改(含税)',
  `list_mny` decimal(20, 8) NULL DEFAULT NULL COMMENT '总额 自动计算 不支持修改',
  `list_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '税额',
  `end_date` datetime(0) NULL DEFAULT NULL COMMENT '结束时间 大于等于开始日期',
  `start_date` datetime(0) NULL DEFAULT NULL COMMENT '开始时间 小于等于结束日期',
  `detail_measurement_rules` varchar(68) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量规则',
  `detail_work_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `file_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '零工内容' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_plan`  (
  `id` bigint(20) NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) NULL DEFAULT NULL COMMENT '版本锁',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '所属项目Id',
  `project_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目名称',
  `project_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目编码',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计划编码',
  `total_plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '总计划金额',
  `total_plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '总计划金额无税',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '所属项目部Id',
  `org_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目部名称',
  `change_state` tinyint(4) NULL DEFAULT NULL COMMENT '变更状态',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态',
  `change_id` bigint(20) NULL DEFAULT NULL COMMENT '当前对应的变更计划Id',
  `create_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `modify_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人名称',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `change_version` int(11) NULL DEFAULT NULL COMMENT '变更版本',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人id',
  `employee_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办单位id',
  `department_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办单位',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部上级组织id',
  `parent_org_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织名称',
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织编码',
  `sub_type` tinyint(4) NULL DEFAULT NULL COMMENT '分包类型 0-劳务分包 1-专业分包',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_plan_change`  (
  `id` bigint(20) NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) NULL DEFAULT NULL COMMENT '版本锁',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '所属项目Id',
  `project_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目名称',
  `project_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目编码',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计划编码',
  `total_plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '现计划金额',
  `total_plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '现计划金额无税',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '所属项目部Id',
  `org_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目部名称',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态',
  `change_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更人',
  `change_reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更原因',
  `original_plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '原计划金额',
  `original_plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '原计划金额无税',
  `source_plan_id` bigint(20) NULL DEFAULT NULL COMMENT '源计划数据Id',
  `create_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `modify_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人名称',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `change_version` int(11) NULL DEFAULT NULL COMMENT '变更版本',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人id',
  `employee_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办单位id',
  `department_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办单位',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部上级组织id',
  `parent_org_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织名称',
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织编码',
  `sub_type` tinyint(4) NULL DEFAULT NULL COMMENT '分包类型 0-劳务分包 1-专业分包',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_plan_change_his`  (
  `id` bigint(20) NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) NULL DEFAULT NULL COMMENT '版本锁',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '所属项目Id',
  `project_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目名称',
  `project_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目编码',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人id',
  `employee_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办单位id',
  `department_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办单位',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计划编码',
  `total_plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '现计划金额',
  `total_plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '现计划金额无税',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '所属项目部Id',
  `org_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目部名称',
  `bill_state` int(11) NULL DEFAULT NULL COMMENT '单据状态',
  `change_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更人',
  `change_reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更原因',
  `original_plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '原计划金额',
  `original_plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '原计划金额无税',
  `source_plan_id` bigint(20) NULL DEFAULT NULL COMMENT '源计划数据Id',
  `create_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `modify_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人名称',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `change_version` int(11) NULL DEFAULT NULL COMMENT '变更版本',
  `sub_type` tinyint(4) NULL DEFAULT NULL COMMENT '分包类型 0-劳务分包 1-专业分包',
  `change_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '变更金额',
  `change_ratio` decimal(28, 8) NULL DEFAULT NULL COMMENT '本次变更比例',
  `change_plan_id` bigint(20) NULL DEFAULT NULL COMMENT '变更计划Id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_plan_detail`  (
  `id` bigint(20) NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) NULL DEFAULT NULL COMMENT '版本锁',
  `plan_id` bigint(20) NULL DEFAULT NULL COMMENT '所属总计划Id',
  `source_type` tinyint(4) NULL DEFAULT NULL COMMENT '来源：1-目标成本，2-分包档案',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '来源业务Id',
  `doc_category_id` bigint(20) NULL DEFAULT NULL COMMENT '档案分类Id',
  `doc_id` bigint(20) NULL DEFAULT NULL COMMENT '档案Id',
  `detail_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单编号',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `work_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `detail_measurement_rules` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量规则',
  `unit` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `target_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '目标量',
  `plan_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '计划量',
  `plan_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价',
  `tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额',
  `plan_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（含税）',
  `plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（含税）',
  `tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税额',
  `change_type` tinyint(4) NULL DEFAULT NULL COMMENT '变更类型: 1-增补项，2-删除项，3-变更项',
  `change_type_desc` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型描述',
  `target_id` bigint(20) NULL DEFAULT NULL COMMENT '变更项原数据Id',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `parent_id` bigint(20) NULL DEFAULT NULL COMMENT '父ID',
  `leaf_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否末级',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_plan_detail_change`  (
  `id` bigint(20) NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) NULL DEFAULT NULL COMMENT '版本锁',
  `plan_id` bigint(20) NULL DEFAULT NULL COMMENT '所属总计划Id',
  `source_type` tinyint(4) NULL DEFAULT NULL COMMENT '来源：1-目标成本，2，分包档案',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '来源业务Id',
  `doc_category_id` bigint(20) NULL DEFAULT NULL COMMENT '档案分类Id',
  `doc_id` bigint(20) NULL DEFAULT NULL COMMENT '档案Id',
  `detail_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单编号',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `job_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `detail_measure_rules` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量规则',
  `unit` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `target_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '目标量',
  `plan_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '计划量',
  `plan_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价',
  `tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额',
  `plan_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（含税）',
  `plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（含税）',
  `tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税额',
  `change_type` tinyint(4) NULL DEFAULT NULL COMMENT '变更类型: 1-增补项，2-删除项，3-变更项',
  `change_type_desc` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型描述',
  `target_id` bigint(20) NULL DEFAULT NULL COMMENT '变更项原数据Id',
  `original_target_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '原目标量',
  `original_plan_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '原计划量',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `parent_id` bigint(20) NULL DEFAULT NULL COMMENT '父ID',
  `leaf_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否末级',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_plan_detail_change_his`  (
  `id` bigint(20) NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) NULL DEFAULT NULL COMMENT '版本锁',
  `plan_id` bigint(20) NULL DEFAULT NULL COMMENT '所属总计划Id',
  `source_type` tinyint(4) NULL DEFAULT NULL COMMENT '来源：1-目标成本，2-分包档案',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '来源出业务Id',
  `doc_category_id` bigint(20) NULL DEFAULT NULL COMMENT '清单分类Id',
  `doc_id` bigint(20) NULL DEFAULT NULL COMMENT '清单Id',
  `detail_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单编号',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `job_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `detail_measure_rules` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '计量规则',
  `unit` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `target_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '目标量',
  `plan_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '计划量',
  `plan_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价',
  `tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `plan_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额',
  `plan_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（含税）',
  `plan_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额（含税）',
  `tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税额',
  `change_type` tinyint(4) NULL DEFAULT NULL COMMENT '变更类型: 1-增补项，2-删除项，3-变更项',
  `change_type_desc` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '变更类型描述',
  `target_id` bigint(20) NULL DEFAULT NULL COMMENT '变更项原数据Id',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `parent_id` bigint(20) NULL DEFAULT NULL COMMENT '父ID',
  `leaf_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否末级',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_process_picking`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `supplement_flag` tinyint(4) NULL DEFAULT NULL COMMENT '合同类别：0-主合同 1-补充协议',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称（带入）',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编号',
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '申请人名 即经办人',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '申请人id 即经办人',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办部门id',
  `department_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办部门',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '乙方id',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方名称',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目组织ID',
  `org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目组织名称',
  `parent_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织编码',
  `parent_org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '组织id',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `settle_date` datetime(0) NULL DEFAULT NULL COMMENT '结算日期：默认显示当天',
  `mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期扣款金额(无税)',
  `tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期扣款金额(含税)',
  `tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期扣款税额',
  `out_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT ' 出库结算金额(无税)',
  `out_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '出库结算金额（含税）',
  `out_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '出库结算税额',
  `exit_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '退库税额',
  `exit_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '退库金额（无税）',
  `exit_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '退库金额（含税）',
  `commit_data` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '编码',
  `commit_date` datetime(0) NULL DEFAULT NULL COMMENT '提交日期',
  `effective_date` datetime(0) NULL DEFAULT NULL COMMENT '生效日期',
  `commit_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人账号',
  `commit_user_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '提交人名字',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分包领料结算主表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_process_settlement`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `source_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `settle_date` datetime(0) NULL DEFAULT NULL COMMENT '结算日期：默认显示当天',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目名称（带入）',
  `project_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目编号',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '乙方id',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方名称',
  `worker_pay_slip_id` bigint(20) NULL DEFAULT NULL COMMENT '工人工资单id',
  `worker_pay_slip_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工人工资单名称',
  `operator_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人',
  `operator_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人名',
  `remark` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `current_settlement_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '本期结算金额',
  `current_settlement_no_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '本期结算金额(无税)',
  `current_settlement_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '本期结算税额',
  `subcontracting_list_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '分包清单金额',
  `subcontracting_list_no_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '分包清单金额(无税)',
  `subcontracting_list_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '分包清单税额',
  `picking_deduction_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '领料扣款金额',
  `picking_deduction_no_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '领料扣款金额(无税)',
  `picking_deduction_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '领料扣款税额',
  `odd_job_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '零工金额',
  `odd_job_no_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '零工金额(无税)',
  `odd_job_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '零工税额',
  `deduction_ticket_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '扣奖罚单金额',
  `deduction_ticket_no_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '扣奖罚单金额(无税)',
  `deduction_ticket_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '扣奖罚单税额',
  `other_fee_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '其他费用金额',
  `other_fee_no_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '其他费用金额(无税)',
  `other_fee_tax` decimal(20, 8) NULL DEFAULT NULL COMMENT '其他费用税额',
  `contract_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '合同金额',
  `worker_salary_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '工人工资金额',
  `including_current_settlement_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '含本期结算金额',
  `cumulative_paid_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '累计已付金额',
  `contract_paid_ratio` decimal(20, 8) NULL DEFAULT NULL COMMENT '合同已付比例',
  `cumulative_receipt_amount` decimal(20, 8) NULL DEFAULT NULL COMMENT '累计收票金额',
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '过程结算 编码',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '组织id',
  `org_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织名称',
  `bill_state` tinyint(4) NULL DEFAULT NULL COMMENT '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
  `operator_time` datetime(0) NULL DEFAULT NULL COMMENT '经办日期 单据的经办时间 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '专业分包过程结算表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_salary`  (
  `id` bigint(20) NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` int(11) NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `bill_state` int(11) NULL DEFAULT NULL COMMENT '单据状态',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编码',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` int(11) NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) NULL DEFAULT NULL COMMENT '版本锁',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  `contract_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同编码',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：劳务合同-0，专业合同-1',
  `org_id` bigint(20) NULL DEFAULT NULL COMMENT '所属项目部Id',
  `org_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目部名称',
  `parent_org_id` bigint(20) NULL DEFAULT NULL COMMENT '项目部上级组织Id',
  `parent_org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织名称',
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织编码',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '所属项目Id',
  `project_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目名称',
  `project_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目编码',
  `supplier_id` bigint(20) NULL DEFAULT NULL COMMENT '供应商Id（乙方id）',
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '供应商名称（乙方名称）',
  `supplier_project_manager_id` bigint(20) NULL DEFAULT NULL COMMENT '乙方项目经理Id（乙方负责人id）',
  `supplier_project_manager_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理名称（乙方负责人名称）',
  `belong_month` date NULL DEFAULT NULL COMMENT '所属月份',
  `sum_salary_mny` decimal(28, 0) NULL DEFAULT NULL COMMENT '工资单总金额',
  `employee_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人id',
  `employee_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人',
  `department_id` bigint(20) NULL DEFAULT NULL COMMENT '经办人部门id',
  `department_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT ' 经办人部门',
  `sum_worker_salary_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '工人工资(实发工资汇总)',
  `sum_extra_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '额外费用(额外费用汇总)',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT ' 备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_salary_detail`  (
  `id` bigint(20) NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` int(11) NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` int(11) NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) NULL DEFAULT NULL COMMENT '版本锁',
  `salary_id` bigint(20) NULL DEFAULT NULL COMMENT '工人工资单主表id',
  `worker_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工人',
  `work_type` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工种',
  `id_card` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '身份证号码',
  `bank_card` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '银行卡号',
  `bank_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '开户行',
  `measurement_type` tinyint(4) NULL DEFAULT NULL COMMENT '计量方式 （0:计日，1计件）',
  `workload` decimal(28, 8) NULL DEFAULT NULL COMMENT '工作量',
  `price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价',
  `overtime_measure_type` tinyint(4) NULL DEFAULT NULL COMMENT '加班计量方式',
  `overtime_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '加班工作量',
  `should_salary_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '应发工资:工作量*单价+加班工作量*单价',
  `deduct_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '扣款费用',
  `salary_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '实发工资',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_salary_extra`  (
  `id` bigint(20) NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` int(11) NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` int(11) NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int(11) NULL DEFAULT NULL COMMENT '版本锁',
  `salary_id` bigint(20) NULL DEFAULT NULL COMMENT '工人工资单主表id',
  `expense_item` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '费用项',
  `represent` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `extra_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_settle`  (
  `id` bigint(20) NULL DEFAULT NULL,
  `create_user_id` bigint(20) NULL DEFAULT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `update_time` datetime(0) NULL DEFAULT NULL,
  `dr` tinyint(4) NULL DEFAULT NULL,
  `tenant_id` bigint(20) NULL DEFAULT NULL,
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL,
  `version` int(11) NULL DEFAULT NULL,
  `bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `bill_state` tinyint(4) NULL DEFAULT NULL,
  `settle_type` tinyint(4) NULL DEFAULT NULL,
  `commit_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `commit_user_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `commit_date` datetime(0) NULL DEFAULT NULL,
  `effective_date` datetime(0) NULL DEFAULT NULL,
  `org_id` bigint(20) NULL DEFAULT NULL,
  `org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `parent_org_id` bigint(20) NULL DEFAULT NULL,
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `parent_org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `contract_id` bigint(20) NULL DEFAULT NULL,
  `contract_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `contract_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `contract_type` tinyint(4) NULL DEFAULT NULL,
  `supplement_flag` tinyint(4) NULL DEFAULT NULL,
  `project_id` bigint(20) NULL DEFAULT NULL,
  `project_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `project_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `supplier_id` bigint(20) NULL DEFAULT NULL,
  `supplier_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `settle_date` date NULL DEFAULT NULL,
  `employee_id` bigint(20) NULL DEFAULT NULL,
  `employee_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `department_id` bigint(20) NULL DEFAULT NULL,
  `department_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `sign_status` tinyint(4) NULL DEFAULT NULL,
  `signature_status` tinyint(4) NULL DEFAULT NULL,
  `tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `mny` decimal(28, 8) NULL DEFAULT NULL,
  `tax` decimal(28, 8) NULL DEFAULT NULL,
  `detail_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `detail_mny` decimal(28, 8) NULL DEFAULT NULL,
  `detail_tax` decimal(28, 8) NULL DEFAULT NULL,
  `picking_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `picking_mny` decimal(28, 8) NULL DEFAULT NULL,
  `picking_tax` decimal(28, 8) NULL DEFAULT NULL,
  `oddjob_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `oddjob_mny` decimal(28, 8) NULL DEFAULT NULL,
  `oddjob_tax` decimal(28, 8) NULL DEFAULT NULL,
  `deduct_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `deduct_mny` decimal(28, 8) NULL DEFAULT NULL,
  `deduct_tax` decimal(28, 8) NULL DEFAULT NULL,
  `other_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `other_mny` decimal(28, 8) NULL DEFAULT NULL,
  `other_tax` decimal(28, 8) NULL DEFAULT NULL,
  `contract_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `contract_mny` decimal(28, 8) NULL DEFAULT NULL,
  `tax_rate` decimal(28, 8) NULL DEFAULT NULL,
  `salary_mny` decimal(28, 8) NULL DEFAULT NULL,
  `total_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `total_mny` decimal(28, 8) NULL DEFAULT NULL,
  `last_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `last_mny` decimal(28, 8) NULL DEFAULT NULL,
  `contract_pay_mny` decimal(28, 8) NULL DEFAULT NULL,
  `contract_bill_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `contract_bill_mny` decimal(28, 8) NULL DEFAULT NULL,
  `picking_process_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `picking_process_mny` decimal(28, 8) NULL DEFAULT NULL,
  `picking_current_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `picking_current_mny` decimal(28, 8) NULL DEFAULT NULL,
  `oddjob_process_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `oddjob_process_mny` decimal(28, 8) NULL DEFAULT NULL,
  `oddjob_current_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `oddjob_current_mny` decimal(28, 8) NULL DEFAULT NULL,
  `deduct_process_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `deduct_process_mny` decimal(28, 8) NULL DEFAULT NULL,
  `deduct_current_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `deduct_current_mny` decimal(28, 8) NULL DEFAULT NULL,
  `other_process_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `other_process_mny` decimal(28, 8) NULL DEFAULT NULL,
  `other_current_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `other_current_mny` decimal(28, 8) NULL DEFAULT NULL,
  `total_process_tax_Mny` decimal(28, 8) NULL DEFAULT NULL,
  `total_process_mny` decimal(28, 8) NULL DEFAULT NULL,
  `total_process_tax_difference` decimal(28, 8) NULL DEFAULT NULL,
  `total_process_difference` decimal(28, 8) NULL DEFAULT NULL,
  `total_node_tax_Mny` decimal(28, 8) NULL DEFAULT NULL,
  `total_node_mny` decimal(28, 8) NULL DEFAULT NULL,
  `total_node_tax_difference` decimal(28, 8) NULL DEFAULT NULL,
  `total_node_difference` decimal(28, 8) NULL DEFAULT NULL,
  `sup_operator_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `sup_operator_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `sup_operator_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `sup_operate_time` datetime(0) NULL DEFAULT NULL,
  `last_node_tax_mny` decimal(28, 8) NULL DEFAULT NULL,
  `last_node_mny` decimal(28, 8) NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_settle_deduct`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `use_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否引用过,否-0，是-1',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `settle_type` tinyint(4) NULL DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `settle_date` date NULL DEFAULT NULL COMMENT '结算日期',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '奖罚扣款单id',
  `source_bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据单号',
  `reward_deduction_type` tinyint(4) NULL DEFAULT NULL COMMENT '单据类型:默认奖励,奖励-0、扣款-1、罚款-2',
  `deduct_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额',
  `deduct_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额(无税)',
  `deduct_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税额',
  `deduct_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `input_cost_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否入成本,否-0，是-1',
  `happen_date` date NULL DEFAULT NULL COMMENT '发生日期',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '非必填，0-30字',
  `settle_id` bigint(20) NULL DEFAULT NULL COMMENT '结算id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '结算-奖罚扣款单' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_settle_detail`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `use_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否引用过,否-0，是-1',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `settle_type` tinyint(4) NULL DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `settle_date` date NULL DEFAULT NULL COMMENT '结算日期',
  `source_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源:合同，分包计量',
  `settle_id` bigint(20) NULL DEFAULT NULL COMMENT '结算id',
  `source_bill_id` bigint(20) NULL DEFAULT NULL COMMENT '来源主单据id',
  `source_bill_date` date NULL DEFAULT NULL COMMENT '来源主单据日期',
  `source_bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源主单据编号',
  `contract_detail_id` bigint(20) NULL DEFAULT NULL COMMENT '合同清单id',
  `doc_id` bigint(20) NULL DEFAULT NULL COMMENT '档案id',
  `doc_category_id` bigint(20) NULL DEFAULT NULL COMMENT '档案分类id',
  `detail_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '清单名称',
  `detail_measurement_rules` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作计量规则',
  `detail_work_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工作内容',
  `detail_unit` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单位',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '来源id',
  `total_process_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '含本期累计过程结算量：取该清单在已生效过程结算单中累计结算量+本期结算量；如果有多行对应合同同一个清单，本期结算量是多行的累计值',
  `last_process_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '历史过程结算量：该清单在已生效过程结算单中累计结算量',
  `total_node_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '累计节点结算量：取该清单在已生效的节点结算单中累计结算量+本期结算量',
  `last_node_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '历史节点结算量：该清单在已生效节点结算单中累计结算量',
  `settle_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期结算量：=累计节点结算量—过程累计结算量',
  `detail_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价(含税)',
  `detail_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价(无税)',
  `detail_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `settle_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期结算金额',
  `settle_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期结算金额(无税)',
  `settle_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期结算税额',
  `process_tax_difference` decimal(28, 8) NULL DEFAULT NULL COMMENT '过程结算差额',
  `process_difference` decimal(28, 8) NULL DEFAULT NULL COMMENT '过程结算差额（无税）',
  `node_tax_difference` decimal(28, 8) NULL DEFAULT NULL COMMENT '节点结算差额',
  `node_difference` decimal(28, 8) NULL DEFAULT NULL COMMENT '节点结算差额（无税）',
  `memo` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `tree_index` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '序号',
  `detail_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同量',
  `parent_id` bigint(20) NULL DEFAULT NULL COMMENT '父id',
  `total_settle_dif_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '累计结算差量',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '结算-分包清单' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_settle_oddjob`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `use_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否引用过,否-0，是-1',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `settle_type` tinyint(4) NULL DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `settle_date` date NULL DEFAULT NULL COMMENT '结算日期',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '零工id',
  `source_bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据单号',
  `oddjob_type` tinyint(4) NULL DEFAULT NULL COMMENT '类别 0.零工登记,1.零工转扣',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注 默认为空，非必填，0-30字',
  `oddjob_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额(无税)',
  `oddjob_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '金额',
  `oddjob_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '税额',
  `oddjob_date` datetime(0) NULL DEFAULT NULL COMMENT '用工日期',
  `use_work_detail` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用工内容',
  `settle_id` bigint(20) NULL DEFAULT NULL COMMENT '结算id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '结算-零工登记' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_settle_other`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `use_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否引用过,否-0，是-1\n',
  `settle_id` bigint(20) NULL DEFAULT NULL COMMENT '结算id',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `settle_type` tinyint(4) NULL DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `settle_date` date NULL DEFAULT NULL COMMENT '结算日期',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '其他费用id',
  `cost_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '费用名称',
  `cost_tax_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价',
  `cost_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '单价（无税）',
  `cost_tax_rate` decimal(28, 8) NULL DEFAULT NULL COMMENT '税率',
  `cost_num` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同量',
  `num` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期结算量',
  `tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期结算金额，本期结算金额=本期结算量*单价',
  `mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期结算金额(无税)',
  `tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '本期结算税额',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `source_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源:合同、新增',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '结算-其他费用' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_settle_picking`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `use_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否引用过,否-0，是-1',
  `settle_id` bigint(20) NULL DEFAULT NULL COMMENT '结算id',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `settle_type` tinyint(4) NULL DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `settle_date` date NULL DEFAULT NULL COMMENT '结算日期',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '领料结算id',
  `source_bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据单号',
  `picking_tax_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '领料扣款金额',
  `picking_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '领料扣款金额(无税)',
  `picking_tax` decimal(28, 8) NULL DEFAULT NULL COMMENT '领料扣款金额税额',
  `picking_date` datetime(0) NULL DEFAULT NULL COMMENT '领料结算日期',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注 默认为空，非必填，0-30字',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '结算-领料结算' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-prosub`.`ejc_prosub_settle_salary`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `use_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否引用过,否-0，是-1',
  `settle_id` bigint(20) NULL DEFAULT NULL COMMENT '结算id',
  `contract_id` bigint(20) NULL DEFAULT NULL COMMENT '合同id',
  `contract_type` tinyint(4) NULL DEFAULT NULL COMMENT '合同类型：0-劳务合同 1-专业合同',
  `settle_type` tinyint(4) NULL DEFAULT NULL COMMENT '结算类型：0-过程，1-完工，2-节点',
  `project_id` bigint(20) NULL DEFAULT NULL COMMENT '项目Id',
  `settle_date` date NULL DEFAULT NULL COMMENT '结算日期',
  `source_id` bigint(20) NULL DEFAULT NULL COMMENT '工人工资单id',
  `source_bill_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工资单号',
  `belong_month` date NULL DEFAULT NULL COMMENT '所属月份',
  `salary_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '工人工资',
  `extra_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '额外费用',
  `sum_salary_mny` decimal(28, 8) NULL DEFAULT NULL COMMENT '工资总额',
  `memo` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '结算-工人工资单' ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS=1;