package com.ejianc;

import org.springframework.boot.Banner;
import org.springframework.boot.ResourceBanner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableEurekaClient
@EnableFeignClients
@EnableRetry
@EnableAsync
@SpringBootApplication
@ConfigurationProperties
@ComponentScan
public class ProsubServerApp {
	
	public static void main(String[] args) {
        Resource bannerResource = new ClassPathResource("banner.txt");
        Banner banner = new ResourceBanner(bannerResource);

        new SpringApplicationBuilder(ProsubServerApp.class).banner(banner).run(args);
    }

}
