

-- 分包价格库-根据清单id汇总表
CREATE TABLE `ejc_prosub_price_contract_collect`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者账号',
  `update_time` datetime(0) DEFAULT NULL COMMENT '修改时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者账号',
  `dr` tinyint(4) DEFAULT 0 COMMENT '删除标识',
  `tenant_id` bigint(20) DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) DEFAULT 0 COMMENT '版本号',

  `doc_id` bigint(20) DEFAULT NULL COMMENT '清单id-档案Id',
  `doc_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '清单编码-档案编码',
  `doc_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '清单名称-档案名称',
  `doc_category_id` bigint(20) DEFAULT NULL COMMENT '所属上级id-档案分类Id',
  `doc_category_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所属上级名称-档案分类名称',
  `doc_inner_code` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '分类内码',
  `unit_id` bigint(20) DEFAULT NULL COMMENT '计量单位主键',
  `unit_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '计量单位',
  `price_type_id` bigint(20) DEFAULT NULL COMMENT '价格类型id',
  `price_type_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '价格类型',

  `contract_price_area` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '合同价格区间（无税）',
  `contract_max_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同最高价(无税)',
  `contract_min_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同最低价（无税）',

  `contract_tax_price_area` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '合同价格区间（含税）',
  `contract_tax_max_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同最高价（含税）',
  `contract_tax_min_price` decimal(28, 8) NULL DEFAULT NULL COMMENT '合同最低价（含税）',


  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分包价格库-根据清单档案id汇总历史表' ROW_FORMAT = Compact;


