CREATE TABLE `ejc_prosub_salary`  (
  `id` bigint NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `dr` int NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `bill_state` int NULL DEFAULT NULL COMMENT '单据状态',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编码',
  `tenant_id` bigint NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` int NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int NULL DEFAULT NULL COMMENT '版本锁',
  `contract_id` bigint NULL COMMENT '合同id',
  `contract_name` varchar(50) NULL COMMENT '合同名称',
  `contract_code` varchar(64) NULL COMMENT '合同编码',
  `contract_type` tinyint NULL COMMENT '合同类型：劳务合同-0，专业合同-1',
  `org_id` bigint NULL DEFAULT NULL COMMENT '所属项目部Id',
  `org_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目部名称',
  `parent_org_id` bigint NULL DEFAULT NULL COMMENT '项目部上级组织Id',
  `parent_org_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织名称',
  `parent_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '项目部上级组织编码',
  `project_id` bigint NULL DEFAULT NULL COMMENT '所属项目Id',
  `project_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属项目名称',
  `project_code` varchar(64) NULL COMMENT '所属项目编码',
  `supplier_id` bigint NULL COMMENT '供应商Id（乙方id）',
  `supplier_name` varchar(50) NULL COMMENT '供应商名称（乙方名称）',
  `supplier_project_manager_id` bigint NULL COMMENT '乙方项目经理Id（乙方负责人id）',
  `supplier_project_manager_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '乙方项目经理名称（乙方负责人名称）',
  `belong_month` date NULL COMMENT '所属月份',
  `sum_salary_mny` decimal(28) NULL COMMENT '工资单总金额',
  `employee_id` bigint NULL COMMENT '经办人id',
  `employee_name` varchar(32) NULL COMMENT '经办人',
  `department_id` bigint NULL COMMENT '经办人部门id',
  `department_name` varchar(64) NULL COMMENT ' 经办人部门',
  `sum_worker_salary_mny` decimal(28, 8) NULL COMMENT '工人工资(实发工资汇总)',
  `sum_extra_mny` decimal(28, 8) NULL COMMENT '额外费用(额外费用汇总)',
  `memo` varchar(1024) NULL COMMENT ' 备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_salary_detail`  (
  `id` bigint NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `dr` int NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` int NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int NULL DEFAULT NULL COMMENT '版本锁',
  `salary_id` bigint NULL DEFAULT NULL COMMENT '工人工资单主表id',
  `worker_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工人',
  `work_type` varchar(64) NULL COMMENT '工种',
  `id_card` varchar(20) NULL COMMENT '身份证号码',
  `bank_card` varchar(32) NULL COMMENT '银行卡号',
  `bank_name` varchar(255) NULL COMMENT '开户行',
  `measurement_type` tinyint NULL COMMENT '计量方式 （0:计日，1计件）',
  `workload` decimal(28, 8) NULL COMMENT '工作量',
  `price` decimal(28, 8) NULL COMMENT '单价',
  `overtime_measure_type` tinyint NULL COMMENT '加班计量方式',
  `overtime_num` decimal(28, 8) NULL COMMENT '加班工作量',
  `should_salary_mny` decimal(28, 8) NULL COMMENT '应发工资:工作量*单价+加班工作量*单价',
  `deduct_mny` decimal(28, 8) NULL COMMENT '扣款费用',
  `salary_mny` decimal(28, 8) NULL COMMENT '实发工资',
  `memo` varchar(512) NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

CREATE TABLE `ejc_prosub_salary_extra`  (
  `id` bigint NOT NULL,
  `create_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `dr` int NULL DEFAULT NULL COMMENT '删除标识（0：未删， 1：删除）',
  `tenant_id` bigint NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` int NULL DEFAULT NULL COMMENT '是否同步es',
  `version` int NULL DEFAULT NULL COMMENT '版本锁',
  `salary_id` bigint NULL DEFAULT NULL COMMENT '工人工资单主表id',
  `expense_item` varchar(64) NULL COMMENT '费用项',
  `describe` varchar(512) NULL COMMENT '描述',
  `extra_mny` decimal(28, 8) NULL COMMENT '金额',
  `memo` varchar(512) NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

