SET FOREIGN_KEY_CHECKS=0;

CREATE TABLE `ejc-signmgr`.`ejc_signmgr`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `bill_id` bigint(20) NULL DEFAULT NULL COMMENT '业务id',
  `bill_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源业务单据类型',
  `bill_ref_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'refCode',
  `source_bill_id` bigint(20) NULL DEFAULT NULL COMMENT '业务id（第三方系统返回的）',
  `source_doc_id` bigint(20) NULL DEFAULT NULL COMMENT '业务文档id（第三方系统返回的）',
  `bill_doc_id` bigint(20) NULL DEFAULT NULL COMMENT '业务文件id',
  `bill_document_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务文件名称',
  `bill_document_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务文件类型',
  `sign_requirements` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署要求',
  `creator_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `creator_contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人联系方式',
  `tenant_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发起方名称',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `contract_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '签章管理' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-signmgr`.`ejc_signmgr_log`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `bill_id` bigint(20) NULL DEFAULT NULL COMMENT '业务id',
  `bill_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源业务单据类型',
  `bill_ref_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'refcode',
  `bill_doc_id` bigint(20) NULL DEFAULT NULL COMMENT '业务文件id',
  `bill_document_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务文件名称',
  `bill_document_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务文件类型',
  `sign_requirements` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署要求',
  `signature_type` int(11) NULL DEFAULT NULL COMMENT '签署方类型：0-内部单位，1-外部单位',
  `tenant_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签约主体名称',
  `tenant_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签约主体类型：COMPANY（外部企业），PERSONAL（个人）',
  `signature_id` bigint(20) NULL DEFAULT NULL COMMENT '签署方Id',
  `signature_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方名称',
  `sign_order` int(11) NULL DEFAULT NULL COMMENT '签署顺序,前置设置1，后置逐渐增大，无序设置相同',
  `sign_action_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署动作名称,根据签署动作类型填写',
  `source_seal_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章id第三方系统返回的）',
  `source_seal_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章name（第三方系统返回的）',
  `seal_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '平台印章id',
  `seal_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '平台印章name',
  `signature_user_ids` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章使用平台用户id范围（静态）多个逗号分隔',
  `actual_signatory_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '实际签署人',
  `actual_signatory_contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '实际签署人联系方式',
  `seal_sign_order` int(11) NULL DEFAULT NULL COMMENT '签章顺序,前置设置1，后置逐渐增大，无序设置相同',
  `job_status` int(11) NULL DEFAULT NULL COMMENT '0-待激活，1-待签章，2-已完成',
  `sign_result` int(11) NULL DEFAULT NULL COMMENT '已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4',
  `mark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注，描述签署状态',
  `start_time` datetime(0) NULL DEFAULT NULL COMMENT '开始时间：状态由待激活变为待签章，可以开始签署动作的时间',
  `end_time` datetime(0) NULL DEFAULT NULL COMMENT '结束时间：状态为完成签署动作的时间',
  `pid` bigint(20) NULL DEFAULT NULL COMMENT '签章管理表id',
  `third_sys_callback_contract_id` bigint(20) NULL DEFAULT NULL COMMENT '文件编号',
  `third_sys_callback_tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '签署方ID',
  `third_sys_callback_tenant_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方名称',
  `third_sys_callback_sn` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件自定义编号',
  `third_sys_callback_status` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件状态',
  `third_sys_callback_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '回调事件',
  `third_sys_callback_contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '联系方式',
  `third_sys_callback_operator_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人姓名',
  `third_sys_callback_operator_mobile` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人手机号',
  `send_bill_sys_bill_id` bigint(20) NULL DEFAULT NULL COMMENT '业务id',
  `send_bill_sys_bill_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源业务单据类型',
  `send_bill_sys_signature_id` bigint(20) NULL DEFAULT NULL COMMENT '签署方Id',
  `send_bill_sys_signature_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方名称',
  `send_bill_sys_actual_signatory_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '实际签署人',
  `send_bill_sys_actual_signatory_contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '实际签署人联系方式',
  `send_bill_sys_job_status` int(11) NULL DEFAULT NULL COMMENT '0-待激活，1-待签章，2-已完成',
  `send_bill_sys_sign_result` int(11) NULL DEFAULT NULL COMMENT '已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4',
  `send_bill_sys_start_time` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '开始时间：状态由待激活变为待签章，可以开始签署动作的时间',
  `send_bill_sys_end_time` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '结束时间：状态为完成签署动作的时间',
  `bill_sys_resp` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '调用业务系统结果',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '异常情况描述：例如未匹配到签署方信息',
  `creator_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `creator_contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人联系方式',
  `receiver_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接收人姓名',
  `contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接收人手机号',
  `signature_contact` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方手机号',
  `signatory_no` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方编号',
  `action_no` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署动作编号，唯一',
  `actual_signatory_id` bigint(20) NULL DEFAULT NULL COMMENT '实际签署方Id，我们平台内的签署方id（外部单位为空）',
  `third_sys_callback_signatory_serial_no` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方编号',
  `third_sys_callback_operator_number` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作人员工编号',
  `third_sys_callback_receiver_number` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '经办人员工编号',
  `third_sys_callback_serial_no` int(11) NULL DEFAULT NULL COMMENT '签署顺序',
  `third_sys_callback_action_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '当前签署节点名称',
  `third_sys_callback_action_no` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署节点编号',
  `send_bill_sys_bill_ref_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'refcode',
  `send_bill_sys_creator_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `send_bill_sys_creator_contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人联系方式',
  `send_bill_sys_receiver_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接收人姓名',
  `send_bill_sys_contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接收人手机号',
  `send_bill_sys_signature_contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方手机号',
  `send_bill_sys_signatory_no` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方编号',
  `send_bill_sys_action_no` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署动作编号，唯一',
  `send_bill_sys_actual_signatory_id` bigint(20) NULL DEFAULT NULL COMMENT '实际签署方Id，我们平台内的签署方id（外部单位为空）',
  `accept_time` datetime(0) NULL DEFAULT NULL COMMENT '接收时间',
  `bill_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单据编号',
  `contract_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '合同名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '签章管理日志记录表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-signmgr`.`ejc_signmgr_preview`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `bill_id` bigint(20) NULL DEFAULT NULL COMMENT '业务id',
  `bill_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '来源业务单据类型',
  `source_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '当前状态:signature_4',
  `file_id` bigint(20) NULL DEFAULT NULL COMMENT '文件id',
  `file_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件名称',
  `file_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件路径',
  `file_size` bigint(20) NULL DEFAULT NULL COMMENT '文件大小',
  `online_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '线上地址',
  `true_path` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '真实地址',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '文件状态预览' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-signmgr`.`ejc_signmgr_sendmsg`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `channel` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息发送渠道类型',
  `receivers` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接收人，逗号分开',
  `msgType` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息类型',
  `subject` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息主题',
  `content` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息内容',
  `mobile_content` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '手机消息内容',
  `receiver_tenant_id` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接收人租户ID',
  `send_user_id` bigint(20) NULL DEFAULT NULL COMMENT '发送的用户id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '重发通知记录表' ROW_FORMAT = Dynamic;

CREATE TABLE `ejc-signmgr`.`ejc_signmgr_signatory`  (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `create_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建者账号',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_user_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改者账号',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `dr` tinyint(4) NULL DEFAULT NULL COMMENT '删除标识',
  `tenant_id` bigint(20) NULL DEFAULT NULL COMMENT '租户ID',
  `sync_es_flag` tinyint(4) NULL DEFAULT NULL COMMENT '是否同步es(1:是，0：否)',
  `version` int(11) NULL DEFAULT NULL COMMENT '乐观锁',
  `signature_type` int(11) NULL DEFAULT NULL COMMENT '签署方类型：0-内部单位，1-外部单位',
  `tenant_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签约主体名称',
  `tenant_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签约主体类型：COMPANY（外部企业），PERSONAL（个人）',
  `receiver_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接收人名称',
  `contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接受人手机号',
  `signature_id` bigint(20) NULL DEFAULT NULL COMMENT '签署方Id，我们平台内的签署方id（外部单位为空）',
  `signature_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方名称',
  `signature_contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方手机号',
  `sign_order` int(11) NULL DEFAULT NULL COMMENT '签署顺序,前置设置1，后置逐渐增大，无序设置相同',
  `sign_action_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）',
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署动作名称,根据签署动作类型填写',
  `source_seal_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章id第三方系统返回的）',
  `source_seal_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章name（第三方系统返回的）',
  `seal_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '平台印章id',
  `seal_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '平台印章name',
  `signature_user_ids` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '印章使用平台用户id范围（静态）多个逗号分隔',
  `signatory_no` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署方编号',
  `action_no` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '签署动作编号，唯一',
  `actual_signatory_id` bigint(20) NULL DEFAULT NULL COMMENT '实际签署方Id，我们平台内的签署方id（外部单位为空）',
  `actual_signatory_name` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '实际签署人',
  `actual_signatory_contact` char(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '实际签署人联系方式',
  `seal_sign_order` int(11) NULL DEFAULT NULL COMMENT '签章顺序,前置设置1，后置逐渐增大，无序设置相同',
  `job_status` int(11) NULL DEFAULT NULL COMMENT '0-待激活，1-待签章，2-已完成',
  `sign_result` int(11) NULL DEFAULT NULL COMMENT '已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4，其他-5',
  `mark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注，描述签署状态',
  `start_time` datetime(0) NULL DEFAULT NULL COMMENT '开始时间：状态由待激活变为待签章，可以开始签署动作的时间',
  `end_time` datetime(0) NULL DEFAULT NULL COMMENT '结束时间：状态为完成签署动作的时间',
  `accept_time` datetime(0) NULL DEFAULT NULL COMMENT '接收时间',
  `pid` bigint(20) NULL DEFAULT NULL COMMENT '签章管理表id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '签章管理-签署方子表' ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS=1;