create table `ejc-prosub`.ejc_prosub_process_picking
(
    id                       bigint         not null comment '主键ID'
        primary key,
    create_user_code         varchar(50)    null comment '创建者账号',
    create_time              datetime       null comment '创建时间',
    update_user_code         varchar(50)    null comment '修改者账号',
    update_time              datetime       null comment '修改时间',
    dr                       tinyint        null comment '删除标识',
    tenant_id                bigint         null comment '租户ID',
    sync_es_flag             tinyint        null comment '是否同步es(1:是，0：否)',
    version                  int            null comment '乐观锁',


    contract_id              bigint         null comment '合同id',
    contract_name            varchar(50)    null comment '合同名称',
    contract_code            varchar(50)    null comment '合同编码',
    `contract_category_id`   bigint(20)   DEFAULT NULL COMMENT '合同类别id',
    `contract_category_code` varchar(64)  DEFAULT NULL COMMENT '合同类别编码',
    `contract_category_name` varchar(128) DEFAULT NULL COMMENT '合同类别名称',
    `supplement_flag`        tinyint(4)   DEFAULT NULL COMMENT '是否主合同：0-主合同 1-补充协议',

    project_id               bigint         null comment '项目Id',
    project_name             varchar(50)    null comment '项目名称（带入）',
    project_code             varchar(50)    null comment '项目编号',


    employee_name            varchar(50)    null comment '申请人名 即经办人',
    employee_id              bigint         null comment '申请人id 即经办人',
    department_id            bigint         null comment '经办部门id',
    department_name          varchar(50)    null comment '经办部门',
    supplier_id              bigint         null comment '乙方id',
    supplier_name            varchar(50)    null comment '乙方名称',
    org_id                   bigint         null comment '项目组织ID',
    org_name                 varchar(128)   null comment '项目组织名称',
    parent_org_code          varchar(50)    null comment '组织编码',
    parent_org_name          varchar(50)    null comment '组织名称',
    parent_org_id            bigint         null comment '组织id',
    memo                     varchar(1024)  null comment '备注',
    settle_date              date           null comment '结算日期：默认显示当天',
    mny                      decimal(28, 8) null comment '本期扣款金额(无税)',
    tax_mny                  decimal(28, 8) null comment '本期扣款金额(含税)',
    tax                      decimal(28, 8) null comment '本期扣款税额',
    out_mny                  decimal(28, 8) null comment ' 出库结算金额(无税)',
    out_tax_mny              decimal(28, 8) null comment '出库结算金额（含税）',
    out_tax                  decimal(28, 8) null comment '出库结算税额',
    exit_tax                 decimal(28, 8) null comment '退库税额',
    exit_mny                 decimal(28, 8) null comment '退库金额（无税）',
    exit_tax_mny             decimal(28, 8) null comment '退库金额（含税）',

    equipment_deduct_tax     decimal(28, 8) null comment '设备扣款税额',
    equipment_deduct_mny     decimal(28, 8) null comment '设备扣款金额（无税）',
    equipment_deduct_tax_mny decimal(28, 8) null comment '设备扣款金额（含税）',


    commit_data              datetime       null comment '提交日期',
    bill_state               tinyint        null comment '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',
    bill_code                varchar(50)    null comment '编码',
    commit_date              datetime       null comment '提交日期',
    effective_date           datetime       null comment '生效日期',
    commit_user_code         varchar(50)    null comment '提交人账号',
    commit_user_name         varchar(50)    null comment '提交人名字'
) comment '领料结算主表';

create table `ejc-prosub`.ejc_prosub_process_picking_store
(
    id                 bigint(20)     not null comment '主键ID'
        primary key,
    create_user_code   varchar(50)    null comment '创建者账号',
    create_time        datetime       null comment '创建时间',
    update_user_code   varchar(50)    null comment '修改者账号',
    update_time        datetime       null comment '修改时间',
    dr                 tinyint        null comment '删除标识',
    tenant_id          bigint(20)     null comment '租户ID',
    sync_es_flag       tinyint        null comment '是否同步es(1:是，0：否)',
    version            int            null comment '乐观锁',
    store_id          bigint(20)     null comment '来源id',
    bill_code        varchar(64)    null comment '来源主单据编号',
    picking_id         bigint(20)     null comment '父表id',
    pick_contract_id   bigint(20)     null comment '合同id',
    pick_contract_name varchar(50)    null comment '合同',
    effective_date datetime       null comment '出库日期',

    material_type      varchar(50)    null comment '材料分类',
    material_type_name varchar(50)    null comment '材料名称',
    material_spec      varchar(50)    null comment '规格型号',
    material_unit_id   bigint(20)     null comment '单位id',
    material_unit_name varchar(50)    null comment '单位名称',
    admixture_id       varchar(50)    null comment '外加剂id',
    admixture_name     varchar(50)    null comment '外加剂',
    return_store_flag  tinyint        null comment '是否退库 1是 0否',
    payment_flag       tinyint        null comment '0：仅扣款 1：不扣款 2：扣款入成本',
    num                decimal(28, 8) null comment '数量',
    tax_price          decimal(28, 8) null comment '单价',
    price              decimal(28, 8) null comment '单价（无税）',
    tax_mny            decimal(28, 8) null comment '金额',
    mny                decimal(28, 8) null comment '金额(无税)',
    tax_rate           decimal(28, 8) null comment '税率',
    tax                decimal(28, 8) null comment '税额',
    memo               varchar(1024)  null comment '备注'
) comment '领料仓库明细';
create table `ejc-prosub`.ejc_prosub_process_picking_total
(
    id                 bigint(20)     not null comment '主键ID'
        primary key,
    create_user_code   varchar(50)    null comment '创建者账号',
    create_time        datetime       null comment '创建时间',
    update_user_code   varchar(50)    null comment '修改者账号',
    update_time        datetime       null comment '修改时间',
    dr                 tinyint        null comment '删除标识',
    tenant_id          bigint(20)     null comment '租户ID',
    sync_es_flag       tinyint        null comment '是否同步es(1:是，0：否)',
    version            int            null comment '乐观锁',
    picking_id         bigint(20)     null comment '父表id',
    material_type      varchar(50)    null comment '材料分类',
    material_type_name varchar(50)    null comment '材料名称',
    material_spec      varchar(50)    null comment '规格型号',
    brand              varchar(50)    null comment '规格型号',
    material_unit_id   bigint(20)     null comment '单位id',
    material_unit_name varchar(50)    null comment '单位名称',#
    pick_out_num       decimal(28, 8) null comment '领料出库数量',
    exit_num           decimal(28, 8) null comment '退库数量',
    actual_out_num     decimal(28, 8) null comment '实际出库数量',
    total_out_num      decimal(28, 8) null comment '累计出库数量',
    memo               varchar(1024)  null comment '备注'

) comment '领料汇总';