create table ejc_prosub_settle
(
    #   基础字段
    id               bigint(20)   not null comment '主键ID'
        primary key,
    create_user_code varchar(64)  null comment '创建者账号',
    create_time      datetime     null comment '创建时间',
    update_user_code varchar(64)  null comment '修改者账号',
    update_time      datetime     null comment '修改时间',
    dr               tinyint(4)   null comment '删除标识',
    tenant_id        bigint(20)   null comment '租户ID',
    sync_es_flag     tinyint(4)   null comment '是否同步es(1:是，0：否)',
    version          int(11)      null comment '乐观锁',

    bill_code        varchar(50)  null comment '单据编码',
    bill_state       tinyint(4)   null comment '单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中',

    settle_type      tinyint(4)   null comment '结算类型：0-过程，1-完工，2-节点',

#   审批字段
    commit_user_code varchar(64)  null comment '提交人账号',
    commit_user_name varchar(64)  null comment '提交人名称',
    commit_data      datetime     null comment '提交日期',
    effective_date   datetime     null comment '生效日期',

#   组织字段
    org_id           bigint(20)   null comment '项目部id',
    org_code         varchar(50)  null comment '项目部编码',
    org_name         varchar(128) null comment '项目部名称',
    parent_org_id    bigint(20)       null comment '项目部所属组织id',
    parent_org_code  varchar(64)  null comment '项目部所属组织编码',
    parent_org_name  varchar(128)  null comment '项目部所属组织名称',


#   合同字段
    contract_id      bigint       null comment '合同id',
    contract_name    varchar(50)  null comment '合同名称',
    contract_code    varchar(64)  null comment '合同编码',
    contract_type         tinyint(4)     null comment '合同类型：0-劳务合同 1-专业合同',
    supplement_flag       tinyint(4)     null comment '合同类别：0-主合同 1-补充协议',
#   项目字段
    project_id            bigint         null comment '项目Id',
    project_name          varchar(50)    null comment '项目名称',
    project_code          varchar(64)    null comment '项目编号',

#   乙方
    supplier_id           bigint         null comment '乙方id',
    supplier_name         varchar(50)    null comment '乙方名称',

    settle_date           date           null comment '结算日期：默认显示当天,必须大于该合同的最近一次生效的结算日期（含过程结算、节点结算）；',

#   经办人
    employee_id           bigint         null comment '经办人id',
    employee_name         varchar(50)    null comment '经办人名称',
    department_id         bigint         null comment '经办部门id',
    department_name       varchar(128)    null comment '经办部门名称',

    memo                  varchar(1024)  null comment '非必填，0-300字',

    sign_status           tinyint(4)     null comment '签字状态：1-未签字、2-待乙方签字、3-待甲方签字、4-已签字',
    signature_status      tinyint(4)     null comment '签章状态：1-未签章、2-待乙方签章、3-待甲方签章、4-已签章',

#   本期结算金额
    tax_mny               decimal(28, 8) null comment '本期结算金额:分包清单金额—领料扣款金额+零工登记金额+奖罚单金额+其他费用金额',
    mny                   decimal(28, 8) null comment '本期结算金额(无税)',
    tax                   decimal(28, 8) null comment '本期结算税额',
#   分包清单金额
    detail_tax_mny        decimal(28, 8) null comment '分包清单金额',
    detail_mny            decimal(28, 8) null comment '分包清单金额(无税)',
    detail_tax            decimal(28, 8) null comment '分包清单税额',
#   领料扣款金额
    picking_tax_mny       decimal(28, 8) null comment '领料扣款金额',
    picking_mny           decimal(28, 8) null comment '领料扣款金额(无税)',
    picking_tax           decimal(28, 8) null comment '领料扣款税额',
#   零工金额
    oddjob_tax_mny        decimal(28, 8) null comment '零工金额金额',
    oddjob_mny            decimal(28, 8) null comment '零工金额金额(无税)',
    oddjob_tax            decimal(28, 8) null comment '零工金额税额',
#   扣奖罚单金额
    deduct_tax_mny        decimal(28, 8) null comment '奖罚扣款单金额',
    deduct_mny            decimal(28, 8) null comment '奖罚扣款单金额(无税)',
    deduct_tax            decimal(28, 8) null comment '奖罚扣款单税额',
#   其他金额
    other_tax_mny         decimal(28, 8) null comment '其他金额',
    other_mny             decimal(28, 8) null comment '其他金额(无税)',
    other_tax             decimal(28, 8) null comment '其他税额',
#   合同金额
    contract_tax_mny      decimal(28, 8) null comment '合同金额',
    contract_mny          decimal(28, 8) null comment '合同金额(无税)',
    tax_rate              decimal(28, 8) null comment '税率',
#   工人工资金额
    salary_mny            decimal(28, 8) null comment '工人工资金额',
#   累计过程结算金额
    total_tax_mny         decimal(28, 8) null comment '累计过程结算金额',
    total_mny             decimal(28, 8) null comment '累计过程结算金额(无税)',
#   不含本期过程结算金额
    last_tax_mny          decimal(28, 8) null comment '不含本期累计过程结算金额',
    last_mny              decimal(28, 8) null comment '不含本期累计过程结算金额(无税)',
#   含本期累计节点结算金额
    total_node_tax_mny          decimal(28, 8) null comment '累计节点结算金额',
    total_node_mny             decimal(28, 8) null comment '累计过程结算金额(无税)',
#   合同已付金额
    contract_pay_mny      decimal(28, 8) null comment '合同已付金额',

#   合同收票金额
    contract_bill_tax_mny decimal(28, 8) null comment '合同收票金额',
    contract_bill_mny     decimal(28, 8) null comment '合同收票金额(无税)',


#   完工结算特殊字段
    picking_process_tax_mny   decimal(28, 8) null comment '领料过程结算金额',
    picking_process_mny   decimal(28, 8) null comment '领料过程结算金额（无税）',
    picking_current_tax_mny   decimal(28, 8) null comment '领料本期结算金额',
    picking_current_mny   decimal(28, 8) null comment '领料本期结算金额（无税）',

    oddjob_process_tax_mny    decimal(28, 8) null comment '零工登记过程结算金额',
    oddjob_process_mny    decimal(28, 8) null comment '零工登记过程结算金额（无税）',
    oddjob_current_tax_mny    decimal(28, 8) null comment '零工登记本期结算金额',
    oddjob_current_mny    decimal(28, 8) null comment '零工登记本期结算金额（无税）',

    deduct_process_tax_mny    decimal(28, 8) null comment '奖罚扣款单过程结算金额',
    deduct_process_mny    decimal(28, 8) null comment '奖罚扣款单过程结算金额（无税）',
    deduct_current_tax_mny    decimal(28, 8) null comment '奖罚扣款单本期结算金额',
    deduct_current_mny    decimal(28, 8) null comment '奖罚扣款单本期结算金额（无税）',

    other_process_tax_mny     decimal(28, 8) null comment '其他过程结算金额',
    other_process_mny     decimal(28, 8) null comment '其他过程结算金额（无税）',
    other_current_tax_mny     decimal(28, 8) null comment '其他本期结算金额',
    other_current_mny     decimal(28, 8) null comment '其他本期结算金额（无税）',


    total_process_tax_difference    decimal(28, 8) NULL COMMENT '过程结算差额',
    total_process_difference    decimal(28, 8) NULL COMMENT '过程结算差额（无税）',
    total_node_tax_difference       decimal(28, 8) NULL COMMENT '节点结算差额',
    total_node_difference       decimal(28, 8) NULL COMMENT '节点结算差额（无税）'

)
    comment '结算表';



create table ejc_prosub_settle_detail
(
    #   基础字段
    id                       bigint(20)     not null comment '主键ID'
        primary key,
    create_user_code         varchar(64)    null comment '创建者账号',
    create_time              datetime       null comment '创建时间',
    update_user_code         varchar(64)    null comment '修改者账号',
    update_time              datetime       null comment '修改时间',
    dr                       tinyint(4)     null comment '删除标识',
    tenant_id                bigint(20)     null comment '租户ID',
    sync_es_flag             tinyint(4)     null comment '是否同步es(1:是，0：否)',
    version                  int(11)        null comment '乐观锁',
    settle_id                bigint(20)     null comment '结算id',

    contract_id              bigint(20)     null comment '合同id',
    settle_type              tinyint(4)     null comment '结算类型：0-过程，1-完工，2-节点',
    project_id               bigint(20)     null comment '项目Id',
    settle_date              date           null comment '结算日期',

#   分包清单字段
    source_type              varchar(20)    null comment '来源:合同，分包计量',
    source_id                bigint         null comment '来源id',
    source_bill_id           bigint         null comment '来源主单据id',
    source_bill_date         date           null comment '来源主单据日期',
    source_bill_code         varchar(64)    null comment '来源主单据编号',

    contract_detail_id       bigint(20)     null comment '合同清单id',
    doc_id                   bigint(20)     null comment '档案id',
    doc_category_id          bigint(20)     null comment '档案分类id',

    detail_name              varchar(64)    null comment '清单名称',
    detail_measurement_rules varchar(128)   null comment '工作计量规则',
    detail_work_content      varchar(50)    null comment '工作内容',
    detail_unit              varchar(128)   null comment '单位',
    detail_num               decimal(28, 8) null comment '合同量',
    total_process_num        decimal(28, 8) null comment '含本期累计过程结算量：取该清单在已生效过程结算单中累计结算量+本期结算量；如果有多行对应合同同一个清单，本期结算量是多行的累计值',
    total_node_num           decimal(28, 8) null comment '累计节点结算量：取该清单在已生效的节点结算单中累计结算量+本期结算量',
    settle_num               decimal(28, 8) null comment '本期结算量：=累计节点结算量—过程累计结算量',
    detail_tax_price         decimal(28, 8) null comment '单价(含税)',
    detail_price             decimal(28, 8) null comment '单价(无税)',
    detail_tax_rate          decimal(28, 8) null comment '税率',
    settle_tax_mny           decimal(28, 8) null comment '本期结算金额',
    settle_mny               decimal(28, 8) null comment '本期结算金额(无税)',
    settle_tax               decimal(28, 8) null comment '本期结算税额',

#   完工结算特殊字段
    process_tax_difference    decimal(28, 8) NULL COMMENT '过程结算差额',
    process_difference    decimal(28, 8) NULL COMMENT '过程结算差额（无税）',
    node_tax_difference       decimal(28, 8) NULL COMMENT '节点结算差额',
    node_difference       decimal(28, 8) NULL COMMENT '节点结算差额（无税）',

    memo                     varchar(1024)  null comment '备注'
)
    comment '结算-分包清单';



create table ejc_prosub_settle_picking
(
#   基础字段
    id               bigint(20)     not null comment '主键ID'
        primary key,
    create_user_code varchar(64)    null comment '创建者账号',
    create_time      datetime       null comment '创建时间',
    update_user_code varchar(64)    null comment '修改者账号',
    update_time      datetime       null comment '修改时间',
    dr               tinyint(4)     null comment '删除标识',
    tenant_id        bigint(20)     null comment '租户ID',
    sync_es_flag     tinyint(4)     null comment '是否同步es(1:是，0：否)',
    version          int(11)        null comment '乐观锁',
    settle_id        bigint(20)     null comment '结算id',

    contract_id      bigint(20)     null comment '合同id',
    settle_type      tinyint(4)     null comment '结算类型：0-过程，1-完工，2-节点',
    project_id       bigint(20)     null comment '项目Id',
    settle_date      date           null comment '结算日期',

#   基础字段
    source_id        bigint(20)     null comment '领料结算id',
    source_bill_code varchar(64)    null comment '单据单号',
    picking_tax_mny  decimal(28, 8) null comment '领料扣款金额',
    picking_mny      decimal(28, 8) null comment '领料扣款金额(无税)',
    picking_tax      decimal(28, 8) null comment '领料扣款金额税额',
    picking_date     datetime       null comment '领料结算日期',
    memo             varchar(512)   null comment '备注 默认为空，非必填，0-30字'
)
    comment '结算-领料结算';



create table ejc_prosub_settle_oddjob
(
    #   基础字段
    id               bigint(20)     not null comment '主键ID'
        primary key,
    create_user_code varchar(64)    null comment '创建者账号',
    create_time      datetime       null comment '创建时间',
    update_user_code varchar(64)    null comment '修改者账号',
    update_time      datetime       null comment '修改时间',
    dr               tinyint(4)     null comment '删除标识',
    tenant_id        bigint(20)     null comment '租户ID',
    sync_es_flag     tinyint(4)     null comment '是否同步es(1:是，0：否)',
    version          int(11)        null comment '乐观锁',
    settle_id        bigint(20)     null comment '结算id',

    contract_id      bigint(20)     null comment '合同id',
    settle_type      tinyint(4)     null comment '结算类型：0-过程，1-完工，2-节点',
    project_id       bigint(20)     null comment '项目Id',
    settle_date      date           null comment '结算日期',

#   零工字段
    source_id        bigint(20)     null comment '零工id',
    source_bill_code varchar(64)    null comment '单据单号',
    oddjob_type      tinyint        null comment '类别 0.零工登记,1.零工转扣',
    memo             varchar(512)   null comment '备注 默认为空，非必填，0-30字',
    oddjob_mny       decimal(28, 8) null comment '金额(无税)',
    oddjob_tax_mny   decimal(28, 8) null comment '金额',
    oddjob_tax       decimal(28, 8) null comment '税额',
    oddjob_date      datetime       null comment '用工日期',
    use_work_detail  varchar(50)    null comment '用工内容'
)
    comment '结算-零工登记';



create table ejc_prosub_settle_deduct
(
    #   基础字段
    id                    bigint(20)     not null comment '主键ID'
        primary key,
    create_user_code      varchar(64)    null comment '创建者账号',
    create_time           datetime       null comment '创建时间',
    update_user_code      varchar(64)    null comment '修改者账号',
    update_time           datetime       null comment '修改时间',
    dr                    tinyint(4)     null comment '删除标识',
    tenant_id             bigint(20)     null comment '租户ID',
    sync_es_flag          tinyint(4)     null comment '是否同步es(1:是，0：否)',
    version               int(11)        null comment '乐观锁',
    settle_id             bigint(20)     null comment '结算id',

    contract_id           bigint(20)     null comment '合同id',
    settle_type           tinyint(4)     null comment '结算类型：0-过程，1-完工，2-节点',
    project_id            bigint(20)     null comment '项目Id',
    settle_date           date           null comment '结算日期',

    source_id             bigint(20)     null comment '奖罚扣款单id',
    source_bill_code      varchar(64)    null comment '单据单号',
    reward_deduction_type tinyint(4)     null comment '单据类型:默认奖励,奖励-0、扣款-1、罚款-2',

    deduct_tax_mny        decimal(28, 8) null comment '金额',
    deduct_mny            decimal(28, 8) null comment '金额(无税)',
    deduct_tax            decimal(28, 8) null comment '税额',
    deduct_tax_rate       decimal(28, 8) null comment '税率',

    input_cost_flag       tinyint(4)     null comment '是否入成本,否-0，是-1',
    happen_date           date           null comment '发生日期',
    memo                  varchar(512)   null comment '非必填，0-30字'

)
    comment '结算-奖罚扣款单';



create table ejc_prosub_settle_other
(
    #   基础字段
    id               bigint(20)     not null comment '主键ID'
        primary key,
    create_user_code varchar(64)    null comment '创建者账号',
    create_time      datetime       null comment '创建时间',
    update_user_code varchar(64)    null comment '修改者账号',
    update_time      datetime       null comment '修改时间',
    dr               tinyint(4)     null comment '删除标识',
    tenant_id        bigint(20)     null comment '租户ID',
    sync_es_flag     tinyint(4)     null comment '是否同步es(1:是，0：否)',
    version          int(11)        null comment '乐观锁',
    settle_id        bigint(20)     null comment '结算id',

    contract_id      bigint(20)     null comment '合同id',
    settle_type      tinyint(4)     null comment '结算类型：0-过程，1-完工，2-节点',
    project_id       bigint(20)     null comment '项目Id',
    settle_date      date           null comment '结算日期',

    source_id        bigint(20)     null comment '其他费用id',
    cost_name        varchar(64)    null comment '费用名称',

    cost_tax_price   decimal(28, 8) null comment '单价',
    cost_price       decimal(28, 8) null comment '单价（无税）',
    cost_tax_rate    decimal(28, 8) null comment '税率',
    cost_num         decimal(28, 8) null comment '合同量',
    num              decimal(28, 8) null comment '本期结算量',
    tax_mny          decimal(28, 8) null comment '本期结算金额，本期结算金额=本期结算量*单价',
    mny              decimal(28, 8) null comment '本期结算金额(无税)',
    tax              decimal(28, 8) null comment '本期结算税额',
    memo             varchar(512)   null comment '备注'


)
    comment '结算-其他费用';



create table ejc_prosub_settle_salary
(
    #   基础字段
    id               bigint(20)     not null comment '主键ID'
        primary key,
    create_user_code varchar(64)    null comment '创建者账号',
    create_time      datetime       null comment '创建时间',
    update_user_code varchar(64)    null comment '修改者账号',
    update_time      datetime       null comment '修改时间',
    dr               tinyint(4)     null comment '删除标识',
    tenant_id        bigint(20)     null comment '租户ID',
    sync_es_flag     tinyint(4)     null comment '是否同步es(1:是，0：否)',
    version          int(11)        null comment '乐观锁',
    settle_id        bigint(20)     null comment '结算id',

    contract_id      bigint(20)     null comment '合同id',
    settle_type      tinyint(4)     null comment '结算类型：0-过程，1-完工，2-节点',
    project_id       bigint(20)     null comment '项目Id',
    settle_date      date           null comment '结算日期',

    source_id        bigint(20)     null comment '工人工资单id',
    source_bill_code varchar(50)    null comment '工资单号',
    belong_month     date           null comment '所属月份',

    salary_mny       decimal(28, 8) null comment '工人工资',
    extra_mny        decimal(28, 8) null comment '额外费用',
    sum_salary_mny   decimal(28, 8) null comment '工资总额',
    memo             varchar(512)   null comment '备注'

)
    comment '结算-工人工资单';




