package com.ejianc.business.pro.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 供应商考察主表
 * 
 * @author generator
 * 
 */
public class InvestigateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code;
    private String supplierName; // 供应商名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date date; // 考察日期
    private String score; // 考察得分
    private String memo; // 综合评价
    private Long canInId; // 准入表id
    private String investigateResults;//考察结果
    private String supplyContent; // 供货内容
    private String enterpriseType; // 制造商：maker,经销商：seller
    private String state; // 考察状态：to待考察，did已考察

    private List<InvestigateContentVO> investigateContentEntities = new ArrayList<>(); // 供应商考察内容

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getScore() {
        return score;
    }

    public void setScore(String score) {
        this.score = score;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getCanInId() {
        return canInId;
    }

    public void setCanInId(Long canInId) {
        this.canInId = canInId;
    }

    public String getInvestigateResults() {
        return investigateResults;
    }

    public void setInvestigateResults(String investigateResults) {
        this.investigateResults = investigateResults;
    }

    public List<InvestigateContentVO> getInvestigateContentEntities() {
        return investigateContentEntities;
    }

    public void setInvestigateContentEntities(List<InvestigateContentVO> investigateContentEntities) {
        this.investigateContentEntities = investigateContentEntities;
    }

    public String getSupplyContent() {
        return supplyContent;
    }

    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }

    public String getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }
}
