package com.ejianc.business.pro.change.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 供应商变更主表
 * 
 * @author generator
 * 
 */
public class ChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long originId; // 原供应商id
    private String changState; // 供应商自己变更状态：未生效free、审核中checking、已生效pass，审核驳回returned
    private String originFrom; // 谁发起的：supplier供应商，runner运营商
    private String returnReason; // 驳回原因
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private String name; // 供方名称
    private Long enterpriseNature; // 企业性质
    private String enterpriseNatureName; // 企业性质名称
    private String enterpriseType; // 制造商：maker,经销商：seller
    private String socialCreditCode; // 统一社会信用代码
    private String address; // 公司地址
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registerTime; // 注册日期
    private Long registerCountryId; // 注册国家id
    private String registerCountryName; // 注册国家名称
    private String legal; // 法定代表人
    private String legalPhone; // 法人电话
    private String businessPerson; // 业务代表
    private String businessPhone; // 业务代表电话
    private BigDecimal turnover; // 年营业额
    private BigDecimal registeredCapital; // 注册资金
    private String supplyContentId; // 供货内容ids
    private String supplyContent; // 供货内容
    private String businessScope; // 经营范围
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date blTime; // 营业执照有效期
    private String taxPayerType; // 纳税人类型:commonly 一般纳税人 smallScale 小规模纳税
    private String billingAddress; // 开票地址
    private String billingPhone; // 开票电话
    private String bankName; // 开户银行
    private String bankAccount; // 银行账号
    private Long gradeId; // 供应商等级id
    private String gradeName; // 供应商等级Name
    private String memo; // 变更说明
    private Integer billState; // 变更单据状态
    private String billCode; // 变更单编码

    private List<ChangeCertsVO> certs = new ArrayList<>(); // 供应商准入---证书
    private List<ChangeBankVO> banks = new ArrayList<>(); // 供应商准入---单位银行信息
    private List<ChangeBrandVO> brandList = new ArrayList<>(); // 供应商准入---品牌子表
    private List<ChangeProductVO> productionList = new ArrayList<>(); // 供应商准入---产品信息子表
    private List<ChangeFinanceReportVO> financeReportList = new ArrayList<>(); // 供应商准入---财报

    public List<ChangeCertsVO> getCerts() {
        return certs;
    }

    public void setCerts(List<ChangeCertsVO> certs) {
        this.certs = certs;
    }

    public List<ChangeBankVO> getBanks() {
        return banks;
    }

    public void setBanks(List<ChangeBankVO> banks) {
        this.banks = banks;
    }

    public List<ChangeBrandVO> getBrandList() {
        return brandList;
    }

    public void setBrandList(List<ChangeBrandVO> brandList) {
        this.brandList = brandList;
    }

    public List<ChangeProductVO> getProductionList() {
        return productionList;
    }

    public void setProductionList(List<ChangeProductVO> productionList) {
        this.productionList = productionList;
    }

    public List<ChangeFinanceReportVO> getFinanceReportList() {
        return financeReportList;
    }

    public void setFinanceReportList(List<ChangeFinanceReportVO> financeReportList) {
        this.financeReportList = financeReportList;
    }

    public Long getOriginId() {
        return originId;
    }

    public void setOriginId(Long originId) {
        this.originId = originId;
    }
    public String getChangState() {
        return changState;
    }

    public void setChangState(String changState) {
        this.changState = changState;
    }

    public String getOriginFrom() {
        return originFrom;
    }

    public void setOriginFrom(String originFrom) {
        this.originFrom = originFrom;
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }
    @ReferDeserialTransfer
    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }
    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }
    public String getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }
    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getRegisterCountryId() {
        return registerCountryId;
    }
    @ReferDeserialTransfer
    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }
    public String getRegisterCountryName() {
        return registerCountryName;
    }

    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }
    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }
    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }
    public String getBusinessPerson() {
        return businessPerson;
    }

    public void setBusinessPerson(String businessPerson) {
        this.businessPerson = businessPerson;
    }
    public String getBusinessPhone() {
        return businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }
    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }
    public BigDecimal getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(BigDecimal registeredCapital) {
        this.registeredCapital = registeredCapital;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getSupplyContentId() {
        return supplyContentId;
    }
    @ReferDeserialTransfer
    public void setSupplyContentId(String supplyContentId) {
        this.supplyContentId = supplyContentId;
    }
    public String getSupplyContent() {
        return supplyContent;
    }

    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }
    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }
    public Date getBlTime() {
        return blTime;
    }

    public void setBlTime(Date blTime) {
        this.blTime = blTime;
    }
    public String getTaxPayerType() {
        return taxPayerType;
    }

    public void setTaxPayerType(String taxPayerType) {
        this.taxPayerType = taxPayerType;
    }
    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }
    public String getBillingPhone() {
        return billingPhone;
    }

    public void setBillingPhone(String billingPhone) {
        this.billingPhone = billingPhone;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGradeId() {
        return gradeId;
    }
    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
