package com.ejianc.business.pro.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 供应商准入表
 * 
 * @author generator
 * 
 */
public class CanInVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String code; // 准入编码
    private String name; // 供应商名称
    private Long enterpriseNature; // 企业性质
    private String enterpriseNatureName; // 企业性质名称
    private String enterpriseType; // 制造商：maker,经销商：seller
    private String socialCreditCode; // 统一社会信用代码
    private String address; // 公司地址
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registerTime; // 注册日期
    private Long registerCountryId; // 注册国家id
    private String registerCountryName; // 注册国家名称
    private String legal; // 法定代表人
    private String legalPhone; // 法人电话
    private String businessPerson; // 业务代表
    private String businessPhone; // 业务代表电话
    private BigDecimal turnover; // 年营业额
    private BigDecimal registeredCapital; // 注册资金
    private String supplyContentId; // 供货内容ids
    private String supplyContent; // 供货内容
    private String businessScope; // 经营范围
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date blTime; // 营业执照有效期
    private String taxPayerType; // 纳税人类型:commonly 一般纳税人 smallScale 小规模纳税
    private String billingAddress; // 开票地址
    private String billingPhone; // 开票电话
    private String bankName; // 开户银行
    private String bankAccount; // 银行账号
    private String tenantPhone; // 生成租户手机号（供方协同）
    private String tenantUserName; // 生成租户管理员名称（供方协同）
    private Boolean needCo; // 是否协同
    private Long orgId; // 申请单位id
    private String orgName; // 申请单位
    private String personal; // 个人：p，企业：e，默认e
    private String canInMemo; // 准入说明
    private Long gradeId; // 供应商等级id
    private String gradeName; // 供应商等级Name
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date ignoreDate; // 忽略处理日期
    private String ignoreName; // 忽略处理人
    private Boolean investigate; // 是否需要考察
    private String canInState; // 准入处理状态：toIn待准入，canIn准入，ignore忽略
    private Integer billState; // 单据状态

    private List<CanInExpertVO> exportList = new ArrayList<>(); // 供应商准入---考察专家列表
    private List<CertsVO> certs = new ArrayList<>(); // 供应商准入---证书
    private List<BankVO> banks = new ArrayList<>(); // 供应商准入---单位银行信息
    private List<BrandVO> brandList = new ArrayList<>(); // 供应商准入---品牌子表
    private List<ProductionVO> productionList = new ArrayList<>(); // 供应商准入---产品信息子表
    private List<FinanceReportVO> financeReportList = new ArrayList<>(); // 供应商准入---财报
    private List<HistoryVO> history = new ArrayList<>(); // 供应商准入---历史业绩


    public List<CanInExpertVO> getExportList() {
        return exportList;
    }

    public void setExportList(List<CanInExpertVO> exportList) {
        this.exportList = exportList;
    }

    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String getBillingPhone() {
        return billingPhone;
    }

    public void setBillingPhone(String billingPhone) {
        this.billingPhone = billingPhone;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEnterpriseNature() {
        return enterpriseNature;
    }
    @ReferDeserialTransfer
    public void setEnterpriseNature(Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }

    public String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    public void setEnterpriseNatureName(String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }

    public String getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public String getSocialCreditCode() {
        return socialCreditCode;
    }

    public void setSocialCreditCode(String socialCreditCode) {
        this.socialCreditCode = socialCreditCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Date getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getRegisterCountryId() {
        return registerCountryId;
    }
    @ReferDeserialTransfer
    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }

    public String getRegisterCountryName() {
        return registerCountryName;
    }

    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }

    public String getLegal() {
        return legal;
    }

    public void setLegal(String legal) {
        this.legal = legal;
    }

    public String getLegalPhone() {
        return legalPhone;
    }

    public void setLegalPhone(String legalPhone) {
        this.legalPhone = legalPhone;
    }

    public String getBusinessPerson() {
        return businessPerson;
    }

    public void setBusinessPerson(String businessPerson) {
        this.businessPerson = businessPerson;
    }

    public String getBusinessPhone() {
        return businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }

    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }

    public BigDecimal getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(BigDecimal registeredCapital) {
        this.registeredCapital = registeredCapital;
    }
    @ReferSerialTransfer(referCode="support-defdoc",isString = "true")
    public String getSupplyContentId() {
        return supplyContentId;
    }
    @ReferDeserialTransfer
    public void setSupplyContentId(String supplyContentId) {
        this.supplyContentId = supplyContentId;
    }

    public String getSupplyContent() {
        return supplyContent;
    }

    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }

    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }

    public Date getBlTime() {
        return blTime;
    }

    public void setBlTime(Date blTime) {
        this.blTime = blTime;
    }

    public String getTaxPayerType() {
        return taxPayerType;
    }

    public void setTaxPayerType(String taxPayerType) {
        this.taxPayerType = taxPayerType;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getTenantPhone() {
        return tenantPhone;
    }

    public void setTenantPhone(String tenantPhone) {
        this.tenantPhone = tenantPhone;
    }

    public String getTenantUserName() {
        return tenantUserName;
    }

    public void setTenantUserName(String tenantUserName) {
        this.tenantUserName = tenantUserName;
    }

    public Boolean getNeedCo() {
        return needCo;
    }

    public void setNeedCo(Boolean needCo) {
        this.needCo = needCo;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getPersonal() {
        return personal;
    }

    public void setPersonal(String personal) {
        this.personal = personal;
    }

    public String getCanInMemo() {
        return canInMemo;
    }

    public void setCanInMemo(String canInMemo) {
        this.canInMemo = canInMemo;
    }
    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGradeId() {
        return gradeId;
    }
    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }

    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }

    public Date getIgnoreDate() {
        return ignoreDate;
    }

    public void setIgnoreDate(Date ignoreDate) {
        this.ignoreDate = ignoreDate;
    }

    public String getIgnoreName() {
        return ignoreName;
    }

    public void setIgnoreName(String ignoreName) {
        this.ignoreName = ignoreName;
    }

    public Boolean getInvestigate() {
        return investigate;
    }

    public void setInvestigate(Boolean investigate) {
        this.investigate = investigate;
    }

    public String getCanInState() {
        return canInState;
    }

    public void setCanInState(String canInState) {
        this.canInState = canInState;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<BankVO> getBanks() {
        return banks;
    }

    public void setBanks(List<BankVO> banks) {
        this.banks = banks;
    }

    public List<CertsVO> getCerts() {
        return certs;
    }

    public void setCerts(List<CertsVO> certs) {
        this.certs = certs;
    }

    public List<HistoryVO> getHistory() {
        return history;
    }

    public void setHistory(List<HistoryVO> history) {
        this.history = history;
    }

    public List<BrandVO> getBrandList() {
        return brandList;
    }

    public void setBrandList(List<BrandVO> brandList) {
        this.brandList = brandList;
    }

    public List<ProductionVO> getProductionList() {
        return productionList;
    }

    public void setProductionList(List<ProductionVO> productionList) {
        this.productionList = productionList;
    }

    public List<FinanceReportVO> getFinanceReportList() {
        return financeReportList;
    }

    public void setFinanceReportList(List<FinanceReportVO> financeReportList) {
        this.financeReportList = financeReportList;
    }
}
