package com.ejianc.business.pro.supplier.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 移除黑名单申请
 *
 * @author generator
 *
 */
public class RmBlackVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 编码
    private Long supplyId; // 供应商id
    private String supplyName; // 供应商名称
    private Long punishType; // 当前状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date overDate; // 预计结束时间
    private String enterpriseType; // 制造商：maker,经销商：seller
    private String oldGradeName; // 原等级
    private Long gradeId; // 移出后等级
    private String gradeName; // 移出后等级
    private String legalPerson; // 法人
    private String supplyContent; // 供货内容
    private String area; // 所在地区
    private Long applyOrgId; // 申请单位
    private String applyOrg; // 申请单位
    private Long applyPersonId; // 申请人
    private String applyPerson; // 申请人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请时间
    private String memo; // 申请理由
    private String applyType; // 移除申请单类别：供应商、分包负责人
    private String sourceType; // 标识单据是谁的业务，是运营租户YY还是采购租户CG
    public String getApplyType() {
        return applyType;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ReferSerialTransfer(referCode="support-supplier,tenant-supplier")
    public Long getSupplyId() {
        return supplyId;
    }
    @ReferDeserialTransfer
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }

    @ReferSerialTransfer(referCode="abnormal_grade")
    public Long getPunishType() {
        return punishType;
    }

    @ReferDeserialTransfer
    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }
    public Date getOverDate() {
        return overDate;
    }

    public void setOverDate(Date overDate) {
        this.overDate = overDate;
    }

    public String getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public String getOldGradeName() {
        return oldGradeName;
    }

    public void setOldGradeName(String oldGradeName) {
        this.oldGradeName = oldGradeName;
    }

    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGradeId() {
        return gradeId;
    }

    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    public String getSupplyContent() {
        return supplyContent;
    }

    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    @ReferDeserialTransfer
    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    public String getApplyOrg() {
        return applyOrg;
    }

    public void setApplyOrg(String applyOrg) {
        this.applyOrg = applyOrg;
    }

    @ReferSerialTransfer(referCode="idm-user")
    public Long getApplyPersonId() {
        return applyPersonId;
    }

    @ReferDeserialTransfer
    public void setApplyPersonId(Long applyPersonId) {
        this.applyPersonId = applyPersonId;
    }
    public String getApplyPerson() {
        return applyPerson;
    }

    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
}
