package com.ejianc.business.pro.supplier.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 供应商评级
 * 
 * @author generator
 * 
 */
public class UpgradeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long supplyId; // 供应商id
    private String supplyCode; // 供应商编码
    private String supplyName; // 供应商名称
    private String legalPerson; // 法人
    private String enterpriseType; // 制造商：maker,经销商：seller
    private Long upgradeType; // 评级理由
    private String upgradeTypeName; // 评级理由
    private Long gradeId;
    private String grade; // 评定等级
    private String gradeName; // 评定等级
    private Long applyOrgId; // 申请单位
    private String applyOrg; // 申请单位
    private Long applyPersonId; // 申请人
    private String applyPerson; // 申请人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date applyDate; // 申请时间
    private String memo; // 理由描述
    private String code;
    private String oldGrade;
    private String supplyContent;
    private String billStateName;
    private Long oldGradeId; // 原等级Id
    private String sourceType; // 标识单据是谁的业务，是运营租户YY还是采购租户CG
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 供应商id
     */
    @ReferSerialTransfer(referCode="support-supplier,tenant-supplier")
    public Long getSupplyId() {
        return supplyId;
    }

    /**
     * 供应商id
     */
    @ReferDeserialTransfer
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }

    /**
     * 供应商编码
     */
    public String getSupplyCode() {
        return supplyCode;
    }

    /**
     * 供应商编码
     */
    public void setSupplyCode(String supplyCode) {
        this.supplyCode = supplyCode;
    }
    /**
     * 供应商名称
     */
    public String getSupplyName() {
        return supplyName;
    }

    /**
     * 供应商名称
     */
    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    /**
     * 法人
     */
    public String getLegalPerson() {
        return legalPerson;
    }

    /**
     * 法人
     */
    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    /**
     * 评级理由
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getUpgradeType() {
        return upgradeType;
    }

    /**
     * 评级理由
     */
    @ReferDeserialTransfer
    public void setUpgradeType(Long upgradeType) {
        this.upgradeType = upgradeType;
    }
    /**
     * 评级理由
     */
    public String getUpgradeTypeName() {
        return upgradeTypeName;
    }

    /**
     * 评级理由
     */
    public void setUpgradeTypeName(String upgradeTypeName) {
        this.upgradeTypeName = upgradeTypeName;
    }
    /**
     * 评定等级
     */
    public String getGrade() {
        return grade;
    }

    /**
     * 评定等级
     */
    public void setGrade(String grade) {
        this.grade = grade;
    }
    /**
     * 评定等级
     */
    public String getGradeName() {
        return gradeName;
    }

    /**
     * 评定等级
     */
    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    /**
     * 申请单位
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    /**
     * 申请单位
     */
    @ReferDeserialTransfer
    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    /**
     * 申请单位
     */
    public String getApplyOrg() {
        return applyOrg;
    }

    /**
     * 申请单位
     */
    public void setApplyOrg(String applyOrg) {
        this.applyOrg = applyOrg;
    }
    /**
     * 申请人
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getApplyPersonId() {
        return applyPersonId;
    }

    /**
     * 申请人
     */
    @ReferDeserialTransfer
    public void setApplyPersonId(Long applyPersonId) {
        this.applyPersonId = applyPersonId;
    }
    /**
     * 申请人
     */
    public String getApplyPerson() {
        return applyPerson;
    }

    /**
     * 申请人
     */
    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }
    /**
     * 申请时间
     */
    public java.util.Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请时间
     */
    public void setApplyDate(java.util.Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 理由描述
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 理由描述
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGradeId() {
        return gradeId;
    }

    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }

    public String getOldGrade() {
        return oldGrade;
    }

    public void setOldGrade(String oldGrade) {
        this.oldGrade = oldGrade;
    }

    public String getSupplyContent() {
        return supplyContent;
    }

    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getOldGradeId() {
        return oldGradeId;
    }

    public void setOldGradeId(Long oldGradeId) {
        this.oldGradeId = oldGradeId;
    }

    public String getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
}
