package com.ejianc.business.pro.supplier.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 分包供应商事件评价
 * 
 * @author generator
 * 
 */
public class SubcontractProcessVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String name; // 单据名称
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 单据编码
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private String contractCode; //合同编码
    private String contractTypeName; // 
    private String contractType; // 合同类型
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private BigDecimal contractAmount; // 合同金额
    private Long supplyId; // 供应商id
    private String supplyName; // 供应商名称
    private String source; // 评价来源
    private Long checkOrgId; // 考核单位id
    private String checkOrgName; // 考核单位名称
    private BigDecimal buckleBranch; //
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date; // 评价时间
    private Long processId; // 经办人id
    private String process; // 经办人
    private String memo; // 备注
    private Long createUserId; // 评价人id
    private String createUserName; // 评价人名称
    private String phone; // 评价人手机
    private String headUserName;//分包负责人
    private Long headUserId;//分包负责人
    private Long subcontractTypeId;
    private String subcontractTypeName;
    private BigDecimal totalBuckle;
    private List<ProcessContentVO> processContentEntities = new ArrayList<>(); // 过程评价内容
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    private Long orgId; // 项目id
    private String orgName; // 项目名称
    private String orgCode; // 项目编码
    private Long parentOrgId; // 项目所属组织id
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    @ReferSerialTransfer(referCode="contractPool")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public Long getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
    public Long getCheckOrgId() {
        return checkOrgId;
    }

    public void setCheckOrgId(Long checkOrgId) {
        this.checkOrgId = checkOrgId;
    }
    public String getCheckOrgName() {
        return checkOrgName;
    }

    public void setCheckOrgName(String checkOrgName) {
        this.checkOrgName = checkOrgName;
    }
    public BigDecimal getBuckleBranch() {
        return buckleBranch;
    }

    public void setBuckleBranch(BigDecimal buckleBranch) {
        this.buckleBranch = buckleBranch;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public Long getProcessId() {
        return processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }
    public String getProcess() {
        return process;
    }

    public void setProcess(String process) {
        this.process = process;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public List<ProcessContentVO> getProcessContentEntities() {
        return processContentEntities;
    }

    public void setProcessContentEntities(List<ProcessContentVO> processContentEntities) {
        this.processContentEntities = processContentEntities;
    }

    public String getHeadUserName() {
        return headUserName;
    }

    public void setHeadUserName(String headUserName) {
        this.headUserName = headUserName;
    }

    public Long getSubcontractTypeId() {
        return subcontractTypeId;
    }

    public void setSubcontractTypeId(Long subcontractTypeId) {
        this.subcontractTypeId = subcontractTypeId;
    }

    public String getSubcontractTypeName() {
        return subcontractTypeName;
    }

    public void setSubcontractTypeName(String subcontractTypeName) {
        this.subcontractTypeName = subcontractTypeName;
    }

    public BigDecimal getTotalBuckle() {
        return totalBuckle;
    }

    public void setTotalBuckle(BigDecimal totalBuckle) {
        this.totalBuckle = totalBuckle;
    }

    public Long getHeadUserId() {
        return headUserId;
    }

    public void setHeadUserId(Long headUserId) {
        this.headUserId = headUserId;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
}
