package com.ejianc.business.pro.supplier.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 供应商处置
 * 
 * @author generator
 * 
 */
public class PunishVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long supplyId; // 供应商id
    private String supplyCode; // 供应商编码
    private String supplyName; // 供应商名称
    private String legalPerson; // 法人
    private String supplyTypeName; // 供应类别
    private String area; // 所在地区
    private Long punishType; // 处置方式
    private String punishTypeName; // 处置方式

    private Long gradeId;//评定等级ID
    private String grade; // 评定等级
    private String gradeName; // 评定等级
    private Long applyOrgId; // 申请单位
    private String applyOrg; // 申请单位
    private Long applyPersonId; // 申请人
    private String applyPerson; // 申请人
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date applyDate; // 申请时间
    private String memo; // 处置理由
    private String code;
    private Long oldGrade;
    private String oldGradeName;
    private String supplyContent;
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    private String supplyType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub



    private String billStateName;

    /**
     * 是否可以点击
     */
    private Boolean clickable;

    private String url;

    //是否降级
    private String isLower;

    private java.lang.Long reason; // 处置理由


    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getReason() {
        return reason;
    }

    @ReferDeserialTransfer
    public void setReason(Long reason) {
        this.reason = reason;
    }

    public String getIsLower() {
        return isLower;
    }

    public void setIsLower(String isLower) {
        this.isLower = isLower;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }


    public Boolean getClickable() {
        return clickable;
    }

    public void setClickable(Boolean clickable) {
        this.clickable = clickable;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getSupplyType() {
        return supplyType;
    }

    public void setSupplyType(String supplyType) {
        this.supplyType = supplyType;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 供应商id
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplyId() {
        return supplyId;
    }

    /**
     * 供应商id
     */
    @ReferDeserialTransfer
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    /**
     * 供应商编码
     */
    public String getSupplyCode() {
        return supplyCode;
    }

    /**
     * 供应商编码
     */
    public void setSupplyCode(String supplyCode) {
        this.supplyCode = supplyCode;
    }
    /**
     * 供应商名称
     */
    public String getSupplyName() {
        return supplyName;
    }

    /**
     * 供应商名称
     */
    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    /**
     * 法人
     */
    public String getLegalPerson() {
        return legalPerson;
    }

    /**
     * 法人
     */
    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }
    /**
     * 供应类别
     */
    public String getSupplyTypeName() {
        return supplyTypeName;
    }

    /**
     * 供应类别
     */
    public void setSupplyTypeName(String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    /**
     * 所在地区
     */
    public String getArea() {
        return area;
    }

    /**
     * 所在地区
     */
    public void setArea(String area) {
        this.area = area;
    }
    /**
     * 处置方式
     */
    @ReferSerialTransfer(referCode="abnormal_grade")
    public Long getPunishType() {
        return punishType;
    }

    /**
     * 处置方式
     */
    @ReferDeserialTransfer
    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }
    /**
     * 处置方式
     */
    public String getPunishTypeName() {
        return punishTypeName;
    }

    /**
     * 处置方式
     */
    public void setPunishTypeName(String punishTypeName) {
        this.punishTypeName = punishTypeName;
    }
    /**
     * 评定等级
     */
    public String getGrade() {
        return grade;
    }

    /**
     * 评定等级
     */
    public void setGrade(String grade) {
        this.grade = grade;
    }
    /**
     * 评定等级
     */
    public String getGradeName() {
        return gradeName;
    }

    /**
     * 评定等级
     */
    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    /**
     * 申请单位
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    /**
     * 申请单位
     */
    @ReferDeserialTransfer
    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    /**
     * 申请单位
     */
    public String getApplyOrg() {
        return applyOrg;
    }

    /**
     * 申请单位
     */
    public void setApplyOrg(String applyOrg) {
        this.applyOrg = applyOrg;
    }
    /**
     * 申请人
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getApplyPersonId() {
        return applyPersonId;
    }

    /**
     * 申请人
     */
    @ReferDeserialTransfer
    public void setApplyPersonId(Long applyPersonId) {
        this.applyPersonId = applyPersonId;
    }
    /**
     * 申请人
     */
    public String getApplyPerson() {
        return applyPerson;
    }

    /**
     * 申请人
     */
    public void setApplyPerson(String applyPerson) {
        this.applyPerson = applyPerson;
    }
    /**
     * 申请时间
     */
    public java.util.Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请时间
     */
    public void setApplyDate(java.util.Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 处置理由
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 处置理由
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getGradeId() {
        return gradeId;
    }

    @ReferDeserialTransfer
    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }

    @ReferSerialTransfer(referCode="pro-supply-grade")
    public Long getOldGrade() {
        return oldGrade;
    }

    @ReferDeserialTransfer
    public void setOldGrade(Long oldGrade) {
        this.oldGrade = oldGrade;
    }

    public String getOldGradeName() {
        return oldGradeName;
    }

    public void setOldGradeName(String oldGradeName) {
        this.oldGradeName = oldGradeName;
    }

    public String getSupplyContent() {
        return supplyContent;
    }

    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }
}
