/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.CanInExpertEntity;
import com.ejianc.business.pro.supplier.bean.InvExpertEntity;
import com.ejianc.business.pro.supplier.bean.InvExpertLeaderEntity;
import com.ejianc.business.pro.supplier.bean.InvestigateContentEntity;
import com.ejianc.business.pro.supplier.bean.InvestigateModleContentEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IInvExpertLeaderService;
import com.ejianc.business.pro.supplier.service.IInvExpertService;
import com.ejianc.business.pro.supplier.service.IInvestigateModleService;
import com.ejianc.business.pro.supplier.vo.InvExpertLeaderVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="canIn")
public class CanInBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICanInService service;
    @Autowired
    private ISupplierApi iProSupplierApi;
    @Autowired
    private IInvExpertService iInvExpertService;
    @Autowired
    private IInvExpertLeaderService iInvExpertLeaderService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IInvestigateModleService iInvestigateModleService;
    @Autowired
    private IPushMessageApi pushMessageApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        CanInEntity canInEntity = (CanInEntity)((Object)this.service.selectById(billId));
        if (canInEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u8be5\u51c6\u5165\u5355\uff01");
        }
        if (canInEntity.getInvestigate() != null && canInEntity.getInvestigate().booleanValue()) {
            if (ListUtil.isEmpty(canInEntity.getExportList())) {
                return CommonResponse.error((String)"\u8be5\u51c6\u5165\u5355,\u9700\u8981\u8003\u5bdf\uff0c\u8bf7\u6dfb\u52a0\u8003\u5bdf\u4e13\u5bb6\uff01");
            }
            boolean noLeader = true;
            int num = 0;
            for (CanInExpertEntity expertEntity : canInEntity.getExportList()) {
                if (!expertEntity.getLeader().booleanValue()) continue;
                noLeader = false;
                ++num;
            }
            if (noLeader) {
                return CommonResponse.error((String)"\u8be5\u51c6\u5165\u5355,\u9700\u8981\u8003\u5bdf\uff0c\u8003\u5bdf\u4e13\u5bb6\u9700\u8981\u6709\u4e00\u4e2a\u7ec4\u957f\uff01");
            }
            if (num > 1) {
                return CommonResponse.error((String)"\u8be5\u51c6\u5165\u5355,\u9700\u8981\u8003\u5bdf\uff0c\u8003\u5bdf\u4e13\u5bb6\u53ea\u80fd\u6709\u4e00\u4e2a\u7ec4\u957f\uff01");
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("ne", (Object)billId));
        param.getParams().put("socialCreditCode", new Parameter("eq", (Object)canInEntity.getSocialCreditCode()));
        List canInEntities = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)canInEntities)) {
            if ("p".equals(canInEntity.getPersonal())) {
                return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u8eab\u4efd\u8bc1\u53f7\u4e3a\u3010" + canInEntity.getSocialCreditCode() + "\u3011\u7684\u4e2a\u4eba\u4f9b\u5e94\u5546\uff01"));
            }
            return CommonResponse.error((String)("\u4f9b\u5e94\u5546\u5e93\u5df2\u5b58\u5728\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u3010" + canInEntity.getSocialCreditCode() + "\u3011\u7684\u4f01\u4e1a\u4f9b\u5e94\u5546\uff01"));
        }
        this.logger.info("canInEntity:{}", (Object)JSONObject.toJSONString((Object)((Object)canInEntity)));
        CommonResponse exist = this.iProSupplierApi.judgeTaxpayerNumIsRepeat(canInEntity.getSocialCreditCode(), "e");
        if (!exist.isSuccess()) {
            return exist;
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CanInEntity canInEntity = (CanInEntity)((Object)this.service.selectById(billId));
        if (canInEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u8be5\u51c6\u5165\u5355\uff01");
        }
        if (canInEntity.getInvestigate() == null || !canInEntity.getInvestigate().booleanValue()) {
            return this.service.pushSupplierToShare(canInEntity, billTypeCode);
        }
        InvExpertLeaderEntity leaderEntity = new InvExpertLeaderEntity();
        BillCodeParam billCodeParam = BillCodeParam.build((String)"INVESTIGATE-EX", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)leaderEntity), InvExpertLeaderVO.class)));
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        leaderEntity.setId(IdWorker.getId());
        if (billCode.isSuccess()) {
            leaderEntity.setCode((String)billCode.getData());
        } else {
            leaderEntity.setCode(("HZ-" + IdWorker.getId()).substring(0, 8));
        }
        leaderEntity.setCanInId(billId);
        leaderEntity.setBillState(0);
        leaderEntity.setSupplierName(canInEntity.getName());
        leaderEntity.setApplyOrgId(canInEntity.getOrgId());
        leaderEntity.setApplyOrgName(canInEntity.getOrgName());
        for (Object expertEntity : canInEntity.getExportList()) {
            if (!expertEntity.getLeader().booleanValue()) continue;
            leaderEntity.setLeader(expertEntity.getExpertName());
            leaderEntity.setLeaderId(expertEntity.getExpertId());
        }
        leaderEntity.setExportIds(Strings.join((Iterable)canInEntity.getExportList().stream().map(CanInExpertEntity::getExpertId).collect(Collectors.toList()), (char)','));
        leaderEntity.setExportNames(Strings.join((Iterable)canInEntity.getExportList().stream().map(CanInExpertEntity::getExpertName).collect(Collectors.toList()), (char)','));
        leaderEntity.setSchedule("0/" + canInEntity.getExportList().size());
        leaderEntity.setStartDate(new Date());
        leaderEntity.setScore(0);
        leaderEntity.setResult("\u4e0d\u5408\u683c");
        leaderEntity.setGradeId(canInEntity.getGradeId());
        List<InvestigateModleContentEntity> modelContentEntities = this.iInvestigateModleService.queryTypeName(canInEntity.getEnterpriseType());
        if (ListUtil.isEmpty(modelContentEntities)) {
            return CommonResponse.error((String)("\u672a\u627e\u5230\u3010" + canInEntity.getEnterpriseType() + "\u3011\u5bf9\u5e94\u7684\u8003\u5bdf\u6a21\u677f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\uff01"));
        }
        this.iInvExpertLeaderService.saveOrUpdate((Object)leaderEntity, false);
        for (CanInExpertEntity canInExpertEntity : canInEntity.getExportList()) {
            InvExpertEntity expertEntity = (InvExpertEntity)((Object)BeanMapper.map((Object)((Object)leaderEntity), InvExpertEntity.class));
            expertEntity.setId(IdWorker.getId());
            expertEntity.setCollectId(leaderEntity.getId());
            billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                expertEntity.setCode((String)billCode.getData());
            } else {
                expertEntity.setCode(("HZ-" + IdWorker.getId()).substring(0, 8));
            }
            expertEntity.setCanSubId(canInExpertEntity.getId());
            expertEntity.setExportId(canInExpertEntity.getExpertId());
            expertEntity.setExportName(canInExpertEntity.getExpertName());
            expertEntity.setState("1");
            expertEntity.setScore(0);
            for (InvestigateModleContentEntity modelContentEntity : modelContentEntities) {
                InvestigateContentEntity contentEntity = (InvestigateContentEntity)((Object)BeanMapper.map((Object)((Object)modelContentEntity), InvestigateContentEntity.class));
                contentEntity.setId(IdWorker.getId());
                contentEntity.setPid(expertEntity.getId());
                contentEntity.setSubScore("0");
                expertEntity.getInvestigateContentEntities().add(contentEntity);
            }
            this.iInvExpertService.saveOrUpdateNoES((Object)expertEntity);
        }
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("sys");
        channel.add("dingding");
        JSONObject dingdingParams = new JSONObject();
        dingdingParams.put("maurl", (Object)"");
        dingdingParams.put("pcurl", (Object)"");
        dingdingParams.put("title", (Object)("\u60a8\u6709\u4e00\u6761\u65b0\u7684\u4f9b\u5e94\u5546\u8003\u5bdf\u4fe1\u606f\uff0c\u4f9b\u5e94\u5546\u540d\u79f0\uff1a\u3010" + canInEntity.getName() + "\u3011,\u8bf7\u53ca\u65f6\u767b\u5f55\u7cfb\u7edf\u5904\u7406\u3002"));
        dingdingParams.put("content", (Object)("\u60a8\u6709\u4e00\u6761\u65b0\u7684\u4f9b\u5e94\u5546\u8003\u5bdf\u4fe1\u606f\uff0c\u4f9b\u5e94\u5546\u540d\u79f0\uff1a\u3010" + canInEntity.getName() + "\u3011,\u8bf7\u53ca\u65f6\u767b\u5f55\u7cfb\u7edf\u5904\u7406\u3002"));
        parameter.setDingdingParams(dingdingParams);
        parameter.setReceivers((String[])canInEntity.getExportList().stream().map(CanInExpertEntity::getExpertId).map(String::valueOf).toArray(String[]::new));
        parameter.setChannel(channel.toArray(new String[0]));
        parameter.setMsgType("notice");
        parameter.setSubject("\u60a8\u6709\u4e00\u6761\u65b0\u7684\u4f9b\u5e94\u5546\u8003\u5bdf\u4fe1\u606f\uff0c\u4f9b\u5e94\u5546\u540d\u79f0\uff1a\u3010" + canInEntity.getName() + "\u3011,\u8bf7\u53ca\u65f6\u767b\u5f55\u7cfb\u7edf\u5904\u7406\u3002");
        parameter.setContent("\u60a8\u6709\u4e00\u6761\u65b0\u7684\u4f9b\u5e94\u5546\u8003\u5bdf\u4fe1\u606f\uff0c\u4f9b\u5e94\u5546\u540d\u79f0\uff1a\u3010" + canInEntity.getName() + "\u3011,\u8bf7\u53ca\u65f6\u767b\u5f55\u7cfb\u7edf\u5904\u7406\u3002");
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u4e0d\u652f\u6301\u64a4\u56de\u6216\u8005\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

