/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.CertificateEntity;
import com.ejianc.business.pro.supplier.service.ICertificateService;
import com.ejianc.business.pro.supplier.vo.CertificateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"certificate"})
public class CertificateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ICertificateService service;
    @Autowired
    private IDefdocApi defdocApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CertificateVO> saveOrUpdate(@RequestBody CertificateVO saveorUpdateVO) {
        CertificateEntity entity = (CertificateEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CertificateEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        CertificateVO vo = (CertificateVO)BeanMapper.map((Object)((Object)entity), CertificateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CertificateVO> queryDetail(Long id) {
        CertificateEntity entity = (CertificateEntity)((Object)this.service.selectById(id));
        CertificateVO vo = (CertificateVO)BeanMapper.map((Object)((Object)entity), CertificateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CertificateVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/bathSave"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> bathSave(@RequestBody List<CertificateVO> vos) {
        List list = BeanMapper.mapList(vos, CertificateEntity.class);
        this.service.saveBatch(list);
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CertificateVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("orders", "asc");
        Page page = new Page();
        param.setOrderMap(orderMap);
        try {
            page = this.service.queryPage(param, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertificateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Certificate-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"certificate-import.xlsx", (String)"\u8bc1\u4ef6\u6863\u6848\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<CertificateVO> successList = new ArrayList<CertificateVO>();
        ArrayList<CertificateVO> errorList = new ArrayList<CertificateVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 3) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            CommonResponse defList = this.defdocApi.getDefDocByDefCode("supplier_the_scope");
            Map<String, String> defMap = this.getDefMap((List)defList.getData());
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                CertificateVO certificateVO = new CertificateVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    certificateVO.setErrorMessage("\u8bc1\u4ef6\u540d\u79f0\u80fd\u4e0d\u4e3a\u7a7a!");
                } else {
                    certificateVO.setName((String)datas.get(0));
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    certificateVO.setErrorMessage("\u5e94\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!");
                } else {
                    String name = CertificateController.repeatName((String)datas.get(1));
                    String[] theScopeArray = name.split(",");
                    String theScopIds = "";
                    for (int k = 0; k < theScopeArray.length; ++k) {
                        String theScopeId = defMap.get(theScopeArray[k]);
                        if (StringUtils.isNotEmpty((CharSequence)theScopeId)) {
                            theScopIds = theScopIds + theScopeId + ",";
                            certificateVO.setTheScope(theScopIds);
                            continue;
                        }
                        certificateVO.setErrorMessage("\u5e94\u7528\u8303\u56f4\u5b58\u5728\u975e\u6cd5\u503c! " + theScopeArray[k] + " \u4e0d\u5728\u5bfc\u5165\u8303\u56f4");
                    }
                    certificateVO.setTheScopeName(name);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    certificateVO.setOrders(Integer.valueOf(0));
                } else {
                    try {
                        certificateVO.setOrders(new Integer((String)datas.get(2)));
                    }
                    catch (Exception e) {
                        certificateVO.setErrorMessage("\u6392\u5e8f\u5fc5\u987b\u662f\u6570\u5b57\u683c\u5f0f");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)certificateVO.getErrorMessage())) {
                    errorList.add(certificateVO);
                    continue;
                }
                successList.add(certificateVO);
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success((Object)json);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @RequestMapping(value={"/refCertificateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CertificateVO>> refCertificateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        String theScope = null;
        String theScopeName = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            JSONObject conditionJson = JSONObject.parseObject((String)condition);
            theScope = conditionJson.getString("theScope");
            theScopeName = conditionJson.getString("theScopeName");
        }
        if (StringUtils.isNotEmpty(theScope)) {
            param.getParams().put("theScope", new Parameter("like", (Object)theScope));
        }
        if (StringUtils.isNotEmpty(theScopeName)) {
            String[] names = theScopeName.split(",");
            ComplexParam p = new ComplexParam();
            for (String name : names) {
                ComplexParam c = new ComplexParam();
                c.setLogic("or");
                c.getParams().put("theScopeName", new Parameter("like", (Object)name));
                p.getComplexParams().add(c);
            }
            param.getComplexParams().add(p);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertificateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public Map<String, String> getDefMap(List<DefdocDetailVO> defList) {
        return defList.stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getInnerCode));
    }

    public static String repeatName(String name) {
        String[] str = name.split(",");
        if (str.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            if (list.contains(str[i])) continue;
            list.add(str[i]);
            sb.append(str[i] + ",");
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }
}

