/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.CertsEntity;
import com.ejianc.business.pro.supplier.mapper.CanInMapper;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.vo.BrandReportVO;
import com.ejianc.business.pro.supplier.vo.CanInReportVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="canInService")
public class CanInServiceImpl
extends BaseServiceImpl<CanInMapper, CanInEntity>
implements ICanInService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplierApi iProSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IAbnormalService abnormalService;

    @Override
    public CommonResponse<String> afterInvestigate(Long canInId, Long gradeId, String gradeName) {
        CanInEntity canInEntity = (CanInEntity)((Object)this.selectById(canInId));
        canInEntity.setGradeId(gradeId);
        canInEntity.setGradeName(gradeName);
        return this.pushSupplierToShare(canInEntity, "BT211210000000001");
    }

    @Override
    public CommonResponse<String> pushSupplierToShare(CanInEntity canInEntity, String billTypeCode) {
        Long billId = canInEntity.getId();
        SupplierVO supplierVO = (SupplierVO)BeanMapper.map((Object)((Object)canInEntity), SupplierVO.class);
        supplierVO.setCoordination(canInEntity.getNeedCo());
        this.logger.info("billTypeCode---{}", (Object)billTypeCode);
        CommonResponse fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "attachMgr", String.valueOf(billId), "BT200422000000028", "attachMgr");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384111794", String.valueOf(billId), "BT200422000000028", "K1639384111794");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384112713", String.valueOf(billId), "BT200422000000028", "K1639384112713");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384499212", String.valueOf(billId), "BT200422000000028", "K1639384499212");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384662753", String.valueOf(billId), "BT200422000000028", "K1639384662753");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384663721", String.valueOf(billId), "BT200422000000028", "K1639384663721");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K16393844992144", String.valueOf(billId), "BT200422000000028", "K16393844992144");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        if (ListUtil.isNotEmpty(canInEntity.getCerts())) {
            for (CertsEntity cert : canInEntity.getCerts()) {
                this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(cert.getId()), billTypeCode, "K1639386256873", String.valueOf(cert.getId()), "BT200422000000028", "K1639386256873");
            }
        }
        this.logger.info("pushSupplierToShare----{}", (Object)JSONObject.toJSONString((Object)supplierVO));
        return this.iProSupplierApi.pushSupplierToBaseStore(supplierVO);
    }

    @Override
    public List<BrandReportVO> queryBrandTypeList(Page pages, QueryWrapper queryWrapper, List<Long> supplierIds) {
        return ((CanInMapper)this.baseMapper).queryBrandTypeList(pages, queryWrapper, supplierIds);
    }

    @Override
    public List<BrandReportVO> queryBrandList(List<Long> supplierIds) {
        return ((CanInMapper)this.baseMapper).queryBrandList(supplierIds);
    }

    @Override
    public List<CanInReportVO> querySupplierList(Page pages, QueryWrapper queryWrapper, Long brandId, List<Long> supplierIds) {
        return ((CanInMapper)this.baseMapper).querySupplierList(pages, queryWrapper, brandId, supplierIds);
    }
}

