package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.supplier.bean.CertificateEntity;
import com.ejianc.business.pro.supplier.bean.LimitEntity;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.pro.supplier.service.ICertificateService;
import com.ejianc.business.pro.supplier.service.ICheckSupplierService;
import com.ejianc.business.pro.supplier.service.ILimitService;
import com.ejianc.business.pro.supplier.vo.LimitVO;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.share.vo.dto.CertsDTO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 校验供应商是否合格
 *
 * @author xuannl
 */
@Service("checkSupplierService")
public class CheckSupplierServiceImpl implements ICheckSupplierService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ISupplierApi proSupplierApi;
    @Autowired
    private ILimitService limitService;
    @Autowired
    private ICertificateService certificateService;

    @Override
    public CheckSupplierDTO queryCheckDTO(Long id,Long firstContentId) {
        CommonResponse<SupplierVO> supplierDTOCommonResponse = proSupplierApi.getSupplierInfo(id);
        logger.info("supplierDTOCommonResponse:" + JSONObject.toJSONString(supplierDTOCommonResponse));
        if (!supplierDTOCommonResponse.isSuccess() || supplierDTOCommonResponse.getData() == null) {
            logger.info("根据id查询供应商失败！");
            return null;
        }
        SupplierVO supplierDTO = supplierDTOCommonResponse.getData();
        CheckSupplierDTO checkSupplierDTO = BeanMapper.map(supplierDTO, CheckSupplierDTO.class);

        //查询本等级各个分类的限额
       Long gradeId = checkSupplierDTO.getGradeId();
        String supplyType = checkSupplierDTO.getSupplyType();
        List<String> types = new ArrayList<>();
        if (!StringUtils.isEmpty(supplyType)) {
            String[] split = supplyType.split(",");
            for (String str : split
            ) {
                types.add(str);
            }
        }
        logger.info("types:" + types);
        if (types.size() > 0) {
            QueryWrapper<LimitEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("gread_id", gradeId);
            wrapper.eq("state", 1);//默认查询启用的
            wrapper.in("supply_type", types);
            List<LimitEntity> limitList = limitService.list(wrapper);
            List<LimitVO> limitVOS = BeanMapper.mapList(limitList, LimitVO.class);
            checkSupplierDTO.setLimitVOS(limitVOS);
        }

        //父级证件
        List<CertsDTO> certs = checkSupplierDTO.getCerts();
        //子级的档案
        List<CertificateEntity> childrenList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(certs)){
            List<Long> certIds = new ArrayList<>();
            for (CertsDTO dto : certs
            ) {
//                certIds.add(dto.getCertId());
                QueryWrapper<CertificateEntity> queryChildrenWrapper = new QueryWrapper<>();
                queryChildrenWrapper.like("superior_id",dto.getCertId());
                List<CertificateEntity> list = certificateService.list(queryChildrenWrapper);
                childrenList.addAll(list);
            }
            if (CollectionUtils.isNotEmpty(childrenList)){
                for (CertificateEntity certificateEntity : childrenList) {
                    CertsDTO certsDTO = new CertsDTO();
                    certsDTO.setCertId(certificateEntity.getId());
                    certsDTO.setCertName(certificateEntity.getName());
                    certs.add(certsDTO);
                }
            }
            checkSupplierDTO.setCerts(certs);
        }


        //本年度累计合同额
        List<Long> supplierIds = new ArrayList<>();
        supplierIds.add(id);

        logger.info("checkSupplierDTO:" + JSONObject.toJSONString(checkSupplierDTO));
        return checkSupplierDTO;
    }

}
