/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.utils.OuterInterface;
import com.ejianc.business.pro.supplier.vo.BankVO;
import com.ejianc.business.pro.supplier.vo.CanInVO;
import com.ejianc.business.pro.supplier.vo.CertsVO;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.QRCodeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"canIn"})
public class CanInController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "pro-supplier-code";
    @Autowired
    private ICanInService service;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private QRCodeUtil qrCodeUtil;
    @Autowired
    private OuterInterface outerInterface;
    @Autowired
    private IProSupplierApi iProSupplierApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CanInVO> saveOrUpdate(@RequestBody CanInVO saveOrUpdateVO) {
        List entities;
        CommonResponse same;
        CanInEntity entity = (CanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CanInEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)this.getBillCode(entity), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(same = this.iProSupplierApi.checkTaxpayerNumOrNameIsSame(saveOrUpdateVO.getTaxpayerNum(), saveOrUpdateVO.getName())).isSuccess() || same.isSuccess() && !((Boolean)same.getData()).booleanValue()) {
            return CommonResponse.error((String)same.getMsg());
        }
        CommonResponse exist = this.iProSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getTaxpayerNum(), saveOrUpdateVO.getPersonal(), saveOrUpdateVO.getSupplyType());
        if (!exist.isSuccess()) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5e93\u4e2d\uff1a\u8be5\u7c7b\u578b\u4f9b\u5e94\u5546\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u65b0\u589e!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum", new Parameter("eq", (Object)saveOrUpdateVO.getTaxpayerNum()));
        String[] supplyType = saveOrUpdateVO.getSupplyType().split(",");
        ComplexParam c = new ComplexParam();
        c.setLogic("and");
        for (int i = 0; i < supplyType.length; ++i) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic("or");
            t.getParams().put("supplyType", new Parameter("like", (Object)type));
            c.getComplexParams().add(t);
        }
        param.getComplexParams().add(c);
        if (entity.getId() != null) {
            param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        }
        if (ListUtil.isNotEmpty((List)(entities = this.service.queryList(param)))) {
            return CommonResponse.error((String)("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((CanInEntity)((Object)entities.get(0))).getApplyOrgName() + "\u3011\u7684\u3010" + ((CanInEntity)((Object)entities.get(0))).getSupplyTypeName() + "\u3011\u51c6\u5165\u6d41\u7a0b\uff0c\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u91cd\u590d!"));
        }
        entity.setSupplyQueryType("materialEquipment");
        QueryParam params = new QueryParam();
        params.getParams().put("name", new Parameter("eq", (Object)saveOrUpdateVO.getName()));
        c = new ComplexParam();
        c.setLogic("and");
        for (int i = 0; i < supplyType.length; ++i) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic("or");
            t.getParams().put("supplyType", new Parameter("like", (Object)type));
            c.getComplexParams().add(t);
        }
        params.getComplexParams().add(c);
        if (entity.getId() != null) {
            params.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(entities = this.service.queryList(params)))) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((CanInEntity)((Object)entities.get(0))).getApplyOrgName() + "\u3011\u7684\u3010" + ((CanInEntity)((Object)entities.get(0))).getSupplyTypeName() + "\u3011\u51c6\u5165\u6d41\u7a0b\uff0c\u540d\u79f0\u91cd\u590d!");
        }
        this.service.saveOrUpdate((Object)entity, false);
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private String getBillCode(CanInEntity canInEntity) {
        if ("material".equals(canInEntity.getSupplyType())) {
            return "pro-supplier-zr-wz";
        }
        if ("equipment".equals(canInEntity.getSupplyType())) {
            return "pro-supplier-zr-sb";
        }
        if ("other".equals(canInEntity.getSupplyType())) {
            return "pro-supplier-zr-qt";
        }
        return "pro-supplier-zr-wz";
    }

    @RequestMapping(value={"/saveSupplier"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CanInVO> saveSupplier(@RequestBody CanInVO saveOrUpdateVO) {
        CanInEntity entity = (CanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CanInEntity.class));
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setCode((String)billCode.getData());
        if (entity.getInviteId() != null) {
            InviteEntity inviteEntity = (InviteEntity)((Object)this.inviteService.selectById(entity.getInviteId()));
            inviteEntity.setCanInNum("1");
            this.inviteService.saveOrUpdate((Object)inviteEntity, false);
        }
        entity.setSupplyQueryType("materialEquipment");
        this.service.saveOrUpdate((Object)entity, false);
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CanInVO> queryDetail(Long id) {
        CanInEntity entity = (CanInEntity)((Object)this.service.selectById(id));
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CanInVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List canInEntityList = this.service.queryList(queryParam);
        ArrayList<Long> inviteIds = new ArrayList<Long>();
        if (canInEntityList.size() != 0) {
            for (CanInEntity canInEntity : canInEntityList) {
                if (canInEntity.getInviteId() == null) continue;
                inviteIds.add(canInEntity.getInviteId());
            }
        }
        if (ListUtil.isNotEmpty(inviteIds)) {
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("in", inviteIds));
            List inviteEntities = this.inviteService.queryList(param);
            if (inviteEntities.size() != 0) {
                for (InviteEntity inviteEntity : inviteEntities) {
                    inviteEntity.setCanInNum("0");
                    this.inviteService.saveOrUpdate((Object)inviteEntity);
                }
            }
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("material_content");
        param.getFuzzyFields().add("equipment_content");
        param.getFuzzyFields().add("major_content");
        param.getFuzzyFields().add("apply_org_name");
        param.getFuzzyFields().add("taxpayerNum");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("applyOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CanIn-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCanInData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> refCanInData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryInviteEntityDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CanInVO> queryInviteEntityDetail(Long id, String supplyType, Long userId, String userName) {
        CommonResponse<CanInVO> responseVO;
        int i;
        InviteEntity entity = (InviteEntity)((Object)this.inviteService.selectById(id));
        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum", new Parameter("eq", (Object)entity.getTaxpayerNum()));
        param.getParams().put("supplyType", new Parameter("eq", (Object)entity.getSupplyType()));
        List canInEntities = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)canInEntities)) {
            return CommonResponse.error((String)"\u51c6\u5165\u5df2\u5b58\u5728\u8be5\u4f9b\u5e94\u5546\uff0c\u65e0\u6cd5\u518d\u6b21\u51c6\u5165!");
        }
        entity.setHandlePersonId(userId);
        entity.setHandlePerson(userName);
        entity.setHandleTime(new Date());
        entity.setCanInNum("1");
        this.inviteService.saveOrUpdate((Object)entity);
        InviteVO inviteVO = (InviteVO)BeanMapper.map((Object)((Object)entity), InviteVO.class);
        CanInVO vo = (CanInVO)BeanMapper.map((Object)inviteVO, CanInVO.class);
        if (supplyType.equals("material")) {
            vo.setSupplyType("material");
        } else if (supplyType.equals("equipment")) {
            vo.setSupplyType("equipment");
        } else if (supplyType.equals("other")) {
            vo.setSupplyType("other");
        }
        vo.setId(Long.valueOf(IdWorker.getId()));
        vo.setCreateTime(null);
        vo.setInviteId(inviteVO.getId());
        vo.setApplyOrgId(InvocationInfoProxy.getOrgId());
        vo.setInOrOut(Integer.valueOf(1));
        BillCodeParam billCodeParam = BillCodeParam.build((String)this.getBillCode((CanInEntity)((Object)BeanMapper.map((Object)vo, CanInEntity.class))), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        vo.setCode((String)billCode.getData());
        vo.setRegisterCountryName("\u4e2d\u56fd");
        vo.setApplyOrgName(((OrgVO)this.iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData()).getName());
        vo.setBillState(Integer.valueOf(0));
        vo.setRegisterCountryId(Long.valueOf(493873812443236045L));
        if (ListUtil.isNotEmpty((List)vo.getBanks())) {
            for (i = 0; i < vo.getBanks().size(); ++i) {
                BankVO bankVO = (BankVO)vo.getBanks().get(i);
                bankVO.setPid(vo.getId());
                bankVO.setId(Long.valueOf(IdWorker.getId()));
                bankVO.setRowState("add");
            }
        }
        if (ListUtil.isNotEmpty((List)vo.getCerts())) {
            for (i = 0; i < vo.getCerts().size(); ++i) {
                CertsVO certsVO = (CertsVO)vo.getCerts().get(i);
                certsVO.setId(Long.valueOf(IdWorker.getId()));
                certsVO.setRowState("add");
                certsVO.setPid(vo.getId());
            }
        }
        if ((responseVO = this.saveOrUpdate(vo)).isSuccess()) {
            vo = (CanInVO)responseVO.getData();
            CommonResponse fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384111794", String.valueOf(vo.getId()), "BT211210000000001", "K1639384111794");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384112713", String.valueOf(vo.getId()), "BT211210000000001", "K1639384112713");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384499212", String.valueOf(vo.getId()), "BT211210000000001", "K1639384499212");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384662753", String.valueOf(vo.getId()), "BT211210000000001", "K1639384662753");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384663721", String.valueOf(vo.getId()), "BT211210000000001", "K1639384663721");
        }
        return responseVO;
    }

    @RequestMapping(value={"/getQrCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getQrCode() {
        return CommonResponse.success((String)"", (Object)this.qrCodeUtil.getBase64QRCode("https://www.baidu.com/"));
    }

    @RequestMapping(value={"/getLicenceOcrInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getLicenceOcrInfo(@RequestParam String imageUrl) {
        return CommonResponse.success((String)"", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.outerInterface.getBusinessLicenseInfoFromBaidu(imageUrl))));
    }

    @RequestMapping(value={"/getIdCardOcrInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getIdCardOcrInfo(@RequestParam String imageUrl) {
        return CommonResponse.success((String)"", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.outerInterface.getIdCardInfoFromBaidu(imageUrl))));
    }

    @RequestMapping(value={"/checkEnterprise"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkEnterprise(@RequestParam(value="name") String name, @RequestParam(value="code") String code) {
        return CommonResponse.success((String)"\u6210\u529f", (Object)this.outerInterface.checkEnterpriseFromQcc(name, code));
    }

    @RequestMapping(value={"/checkPerson"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkPerson(@RequestParam(value="name") String name, @RequestParam(value="code") String code) {
        return CommonResponse.success((String)"\u6210\u529f", (Object)this.outerInterface.checkPersonFromAly(name, code));
    }
}

