/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractCanInEntity;
import com.ejianc.business.pro.supplier.bean.SubleadersEntity;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.service.ISubcontractCanInService;
import com.ejianc.business.pro.supplier.service.ISubleadersService;
import com.ejianc.business.pro.supplier.utils.OuterInterface;
import com.ejianc.business.pro.supplier.vo.BankVO;
import com.ejianc.business.pro.supplier.vo.CanInVO;
import com.ejianc.business.pro.supplier.vo.CertsVO;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.business.pro.supplier.vo.SubcontractCanInVO;
import com.ejianc.business.pro.supplier.vo.SubleadersVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subcontractCanIn"})
public class SubcontractCanInController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "pro-supplier-code";
    @Autowired
    private ISubcontractCanInService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISubleadersService subleadersService;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private OuterInterface outerInterface;
    @Autowired
    private IProSupplierApi iProSupplierApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubcontractCanInVO> saveOrUpdate(@RequestBody SubcontractCanInVO saveOrUpdateVO) {
        List entities;
        SubcontractCanInEntity entity = (SubcontractCanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SubcontractCanInEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)this.getBillCode(entity), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setSupplyQueryType("laborSub");
        CommonResponse same = this.iProSupplierApi.checkTaxpayerNumOrNameIsSame(saveOrUpdateVO.getTaxpayerNum(), saveOrUpdateVO.getName());
        if (!same.isSuccess() || same.isSuccess() && !((Boolean)same.getData()).booleanValue()) {
            this.logger.info("\u6821\u9a8c\u4f9b\u5e94\u5546\u51c6\u5165\u524d\u6821\u9a8c\u4fe1\u606f\u662f\u5426\u4e00\u81f4\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)same));
            return CommonResponse.error((String)same.getMsg());
        }
        CommonResponse exist = this.iProSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getTaxpayerNum(), saveOrUpdateVO.getPersonal(), saveOrUpdateVO.getSupplyType());
        if (!exist.isSuccess()) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5e93\u4e2d\uff1a\u8be5\u7c7b\u578b\u4f9b\u5e94\u5546\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u65b0\u589e!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum", new Parameter("eq", (Object)saveOrUpdateVO.getTaxpayerNum()));
        String[] supplyType = saveOrUpdateVO.getSupplyType().split(",");
        ComplexParam c = new ComplexParam();
        c.setLogic("and");
        for (int i = 0; i < supplyType.length; ++i) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic("or");
            t.getParams().put("supplyType", new Parameter("like", (Object)type));
            c.getComplexParams().add(t);
        }
        param.getComplexParams().add(c);
        if (entity.getId() != null) {
            param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        }
        if (ListUtil.isNotEmpty((List)(entities = this.service.queryList(param)))) {
            return CommonResponse.error((String)("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((SubcontractCanInEntity)((Object)entities.get(0))).getApplyOrgName() + "\u3011\u7684\u3010" + ((SubcontractCanInEntity)((Object)entities.get(0))).getSupplyTypeName() + "\u3011\u51c6\u5165\u6d41\u7a0b\uff0c\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u91cd\u590d!"));
        }
        QueryParam params = new QueryParam();
        params.getParams().put("name", new Parameter("eq", (Object)saveOrUpdateVO.getName()));
        c = new ComplexParam();
        c.setLogic("and");
        for (int i = 0; i < supplyType.length; ++i) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic("or");
            t.getParams().put("supplyType", new Parameter("like", (Object)type));
            c.getComplexParams().add(t);
        }
        params.getComplexParams().add(c);
        if (entity.getId() != null) {
            params.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(entities = this.service.queryList(params)))) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((SubcontractCanInEntity)((Object)entities.get(0))).getApplyOrgName() + "\u3011\u7684\u3010" + ((SubcontractCanInEntity)((Object)entities.get(0))).getSupplyTypeName() + "\u3011\u51c6\u5165\u6d41\u7a0b\uff0c\u540d\u79f0\u91cd\u590d!");
        }
        if (entity.getSupplyType().contains("labor") && ListUtil.isNotEmpty(entity.getSubLeaders())) {
            ArrayList<String> idCards = new ArrayList<String>();
            for (SubleadersEntity subLeader : entity.getSubLeaders()) {
                if (idCards.contains(subLeader.getIdNum())) {
                    return CommonResponse.error((String)("\u5206\u5305\u8d1f\u8d23\u4eba\u8eab\u4efd\u8bc1\u53f7:" + subLeader.getIdNum() + "\u91cd\u590d"));
                }
                idCards.add(subLeader.getIdNum());
            }
        }
        if (entity.getInviteId() != null) {
            InviteEntity inviteEntity = (InviteEntity)((Object)this.inviteService.selectById(entity.getInviteId()));
            inviteEntity.setCanInNum("1");
            this.inviteService.saveOrUpdate((Object)inviteEntity, false);
        }
        this.service.saveOrUpdate((Object)entity, false);
        SubcontractCanInVO vo = (SubcontractCanInVO)BeanMapper.map((Object)((Object)entity), SubcontractCanInVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private String getBillCode(SubcontractCanInEntity canInEntity) {
        if ("labor".equals(canInEntity.getSupplyType())) {
            return "pro-supplier-zr-lw";
        }
        if ("major".equals(canInEntity.getSupplyType())) {
            return "pro-supplier-zr-zy";
        }
        return "pro-supplier-zr-lw";
    }

    @RequestMapping(value={"/saveSupplier"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CanInVO> saveSupplier(@RequestBody SubcontractCanInVO saveOrUpdateVO) {
        SubcontractCanInEntity entity = (SubcontractCanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SubcontractCanInEntity.class));
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setCode((String)billCode.getData());
        InviteEntity inviteEntity = (InviteEntity)((Object)this.inviteService.selectById(entity.getId()));
        inviteEntity.setCanInNum("1");
        this.inviteService.saveOrUpdate((Object)inviteEntity, false);
        entity.setSupplyQueryType("laborSub");
        this.service.saveOrUpdate((Object)entity, false);
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractCanInVO> queryDetail(Long id) {
        SubcontractCanInEntity entity = (SubcontractCanInEntity)((Object)this.service.selectById(id));
        SubcontractCanInVO vo = (SubcontractCanInVO)BeanMapper.map((Object)((Object)entity), SubcontractCanInVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractCanInVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        List subcontractCanInEntityList = this.service.queryList(queryParam);
        ArrayList<Long> inviteIds = new ArrayList<Long>();
        if (subcontractCanInEntityList.size() != 0) {
            for (SubcontractCanInEntity subCanInEntity : subcontractCanInEntityList) {
                if (subCanInEntity.getInviteId() == null) continue;
                inviteIds.add(subCanInEntity.getInviteId());
            }
        }
        if (ListUtil.isNotEmpty(inviteIds)) {
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("in", inviteIds));
            List inviteEntities = this.inviteService.queryList(param);
            if (inviteEntities.size() != 0) {
                for (InviteEntity inviteEntity : inviteEntities) {
                    inviteEntity.setCanInNum("0");
                    this.inviteService.saveOrUpdate((Object)inviteEntity);
                }
            }
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubcontractCanInVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("material_content");
        param.getFuzzyFields().add("equipment_content");
        param.getFuzzyFields().add("major_content");
        param.getFuzzyFields().add("apply_org_name");
        param.getFuzzyFields().add("taxpayerNum");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplyQueryType", new Parameter("eq", (Object)"laborSub"));
        param.getParams().put("applyOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), SubcontractCanInVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            for (SubcontractCanInVO record : records) {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("pid", new Parameter("eq", (Object)record.getId()));
                List subLeadersEntities = this.subleadersService.queryList(queryParam);
                if (!ListUtil.isNotEmpty((List)subLeadersEntities)) continue;
                for (SubleadersEntity subLeadersEntitie : subLeadersEntities) {
                    if (record.getHeadUserName() != null && !record.getHeadUserName().equals("")) {
                        record.setHeadUserName(record.getHeadUserName() + "," + subLeadersEntitie.getName());
                        continue;
                    }
                    record.setHeadUserName(subLeadersEntitie.getName());
                }
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubcontractCanIn-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubcontractCanInData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubcontractCanInVO>> refSubcontractCanInData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractCanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refSubleadersData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubleadersVO>> refSubleadersData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).getLong("pid") != null) {
            param.getParams().put("pid", new Parameter("eq", (Object)_con.getLong("pid")));
        }
        IPage page = this.subleadersService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubleadersVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryInviteEntityDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractCanInVO> queryInviteEntityDetail(Long id, String supplyType, Long userId, String userName) {
        CommonResponse<SubcontractCanInVO> responseVO;
        int i;
        InviteEntity entity = (InviteEntity)((Object)this.inviteService.selectById(id));
        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum", new Parameter("eq", (Object)entity.getTaxpayerNum()));
        param.getParams().put("supplyType", new Parameter("eq", (Object)entity.getSupplyType()));
        List canInEntities = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)canInEntities)) {
            return CommonResponse.error((String)"\u51c6\u5165\u5df2\u5b58\u5728\u8be5\u4f9b\u5e94\u5546\uff0c\u65e0\u6cd5\u518d\u6b21\u51c6\u5165!");
        }
        entity.setHandlePersonId(userId);
        entity.setHandlePerson(userName);
        entity.setHandleTime(new Date());
        entity.setCanInNum("1");
        this.inviteService.saveOrUpdate((Object)entity);
        InviteVO inviteVO = (InviteVO)BeanMapper.map((Object)((Object)entity), InviteVO.class);
        SubcontractCanInVO vo = (SubcontractCanInVO)BeanMapper.map((Object)inviteVO, SubcontractCanInVO.class);
        if (supplyType.equals("labor")) {
            vo.setSupplyType("labor");
        } else if (supplyType.equals("major")) {
            vo.setSupplyType("major");
        }
        vo.setId(Long.valueOf(IdWorker.getId()));
        vo.setCreateTime(null);
        vo.setInviteId(inviteVO.getId());
        vo.setApplyOrgId(InvocationInfoProxy.getOrgId());
        vo.setApplyOrgName(((OrgVO)this.iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData()).getName());
        vo.setInOrOut(Integer.valueOf(1));
        vo.setRegisterCountryName("\u4e2d\u56fd");
        vo.setRegisterCountryId(Long.valueOf(493873812443236045L));
        vo.setBillState(Integer.valueOf(0));
        BillCodeParam billCodeParam = BillCodeParam.build((String)this.getBillCode((SubcontractCanInEntity)((Object)BeanMapper.map((Object)vo, SubcontractCanInEntity.class))), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        vo.setCode((String)billCode.getData());
        if (ListUtil.isNotEmpty((List)vo.getBanks())) {
            for (i = 0; i < vo.getBanks().size(); ++i) {
                BankVO bankVO = (BankVO)vo.getBanks().get(i);
                bankVO.setId(Long.valueOf(IdWorker.getId()));
                bankVO.setPid(vo.getId());
                bankVO.setRowState("add");
            }
        }
        if (ListUtil.isNotEmpty((List)vo.getCerts())) {
            for (i = 0; i < vo.getCerts().size(); ++i) {
                CertsVO certsVO = (CertsVO)vo.getCerts().get(i);
                certsVO.setId(Long.valueOf(IdWorker.getId()));
                certsVO.setPid(vo.getId());
                certsVO.setRowState("add");
            }
        }
        if ((responseVO = this.saveOrUpdate(vo)).isSuccess()) {
            vo = (SubcontractCanInVO)responseVO.getData();
            CommonResponse fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384111794", String.valueOf(vo.getId()), "BT211210000000001", "K1639384111794");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384112713", String.valueOf(vo.getId()), "BT211210000000001", "K1639384112713");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384499212", String.valueOf(vo.getId()), "BT211210000000001", "K1639384499212");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1642125492056", String.valueOf(vo.getId()), "BT211210000000001", "K1639384662753");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1639384663721", String.valueOf(vo.getId()), "BT211210000000001", "K1639384663721");
        }
        return responseVO;
    }

    @RequestMapping(value={"/getLicenceOcrInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getLicenceOcrInfo(@RequestParam String imageUrl) {
        return CommonResponse.success((String)"", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.outerInterface.getBusinessLicenseInfoFromBaidu(imageUrl))));
    }

    @RequestMapping(value={"/getIdCardOcrInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getIdCardOcrInfo(@RequestParam String imageUrl) {
        return CommonResponse.success((String)"", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.outerInterface.getIdCardInfoFromBaidu(imageUrl))));
    }

    @RequestMapping(value={"/checkEnterprise"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkEnterprise(@RequestParam(value="name") String name, @RequestParam(value="code") String code) {
        return CommonResponse.success((String)"\u6210\u529f", (Object)this.outerInterface.checkEnterpriseFromQcc(name, code));
    }

    @RequestMapping(value={"/checkPerson"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkPerson(@RequestParam(value="name") String name, @RequestParam(value="code") String code) {
        return CommonResponse.success((String)"\u6210\u529f", (Object)this.outerInterface.checkPersonFromAly(name, code));
    }
}

