/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.bean.PunishEntity;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.warn.vo.CustomWarnSettingVO;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="punish")
public class PunishBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Autowired
    private IPunishService punishService;
    @Autowired
    private IAbnormalService abnormalService;
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PunishVO punishVO = new PunishVO();
        PunishEntity entity = (PunishEntity)((Object)this.punishService.selectById(billId));
        this.logger.info("PunishEntity:{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        punishVO.setSupplierId(entity.getSupplyId());
        punishVO.setPunishType(entity.getPunishType());
        punishVO.setPunishDate(entity.getCreateTime());
        AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)this.abnormalService.getById(entity.getPunishType()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (abnormalEntity.getLastTime() != null) {
                String exceptionEndDate = PunishBpmServiceImpl.getLastMonthDate(entity.getCreateTime(), abnormalEntity.getLastTime());
                Date date = simpleDateFormat.parse(exceptionEndDate);
                punishVO.setExceptionEndDate(date);
            } else {
                Date date = simpleDateFormat.parse("3000-01-01");
                punishVO.setExceptionEndDate(date);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        punishVO.setPunishApplyOrg(entity.getApplyOrg());
        punishVO.setPunishApplyPerson(entity.getApplyPerson());
        punishVO.setPunishGrade(entity.getGradeName());
        punishVO.setPunishGradeId(entity.getGradeId());
        punishVO.setPunishOldGrade(entity.getOldGradeName());
        punishVO.setPunishMemo(entity.getMemo());
        CommonResponse response = this.iProSupplierApi.punishSupplier(punishVO);
        if (response.isSuccess()) {
            this.sendMsg(entity);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)response.getMsg());
    }

    private void sendMsg(PunishEntity entity) {
        String CODE = "WARNING000110";
        CommonResponse response = this.warnCenterApi.getWarnSet(CODE, entity.getApplyOrgId());
        this.logger.info("\u67e5\u8be2\u9884\u8b66\u4e2d\u5fc3\u8bbe\u7f6e\uff1a{} ", (Object)JSONObject.toJSONString((Object)response));
        if (response.isSuccess()) {
            WarningDTO orgSet = (WarningDTO)response.getData();
            QueryParam param = new QueryParam();
            param.getParams().put("partybId", new Parameter("eq", (Object)entity.getSupplyId()));
            CommonResponse commonResponse = this.contractPoolApi.queryList(param);
            if (commonResponse.isSuccess() && ListUtil.isNotEmpty((List)((List)commonResponse.getData()))) {
                String sendOrgId = ((List)commonResponse.getData()).stream().map(ContractPoolVO::getOrgId).map(Objects::toString).collect(Collectors.joining(","));
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getModuleName() + "-" + entity.getCode());
                vo.setPcTitle("\u4f9b\u5e94\u5546\u5904\u7f6e");
                vo.setOrgId(entity.getApplyOrgId());
                OrgVO orgVO = (OrgVO)this.orgApi.getOneById(entity.getApplyOrgId()).getData();
                vo.setOrgName(orgVO == null ? "" : orgVO.getName());
                vo.setSendOrgId(sendOrgId);
                vo.setSourceId(entity.getId().toString());
                vo.setTenantId(InvocationInfoProxy.getTenantid());
                vo.setWarnSetId(orgSet.getId());
                vo.setEarlywarnName(orgSet.getName());
                vo.setWarnType(orgSet.getWarnType() + "");
                vo.setWarnLevel(((CustomWarnSettingVO)orgSet.getWarningSetings().get(0)).getWarningLevel());
                vo.setWarnSetParamId(((CustomWarnSettingVO)orgSet.getWarningSetings().get(0)).getId());
                vo.setEarlywarnContent(orgSet.getWarningContentTemplate().replaceAll("#supplierName#", entity.getSupplyName()).replaceAll("#applyOrgName#", vo.getOrgName()).replaceAll("#punishTypeName#", entity.getPunishTypeName()));
                ArrayList<EarlyWarnTransVO> earlyWarnTransVOS = new ArrayList<EarlyWarnTransVO>();
                earlyWarnTransVOS.add(vo);
                CommonResponse warnCenterByCode = this.warnCenterApi.sendToWarnCenterByCode(earlyWarnTransVOS, CODE);
                this.logger.info("\u9884\u8b66\u4e2d\u5fc3\u54cd\u5e94\uff1a{}", (Object)JSONObject.toJSONString((Object)warnCenterByCode));
            } else {
                this.logger.info("\u5408\u540c\u6c60\u6ca1\u627e\u5230\u76f8\u5173\u4f9b\u5e94\u5546\u5408\u540c\u6570\u636e\uff0c\u4e0d\u53d1\u9884\u8b66\uff01");
            }
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5904\u7f6e\u4e0d\u652f\u6301\u6d4b\u56de");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public static String getLastMonthDate(Date dataTime, int num) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(dataTime);
        LocalDate today = LocalDate.parse(date);
        today = today.minusMonths(-num);
        return today.toString();
    }
}

