/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractPunishEntity;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.ISubcontractPunishService;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subcontractPunish")
public class SubcontractPunishBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IAbnormalService abnormalService;
    @Autowired
    private ISubcontractPunishService subcontractPunishService;
    @Autowired
    private IProSupplierApi iProSupplierApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PunishVO punishVO = new PunishVO();
        SubcontractPunishEntity entity = (SubcontractPunishEntity)((Object)this.subcontractPunishService.selectById(billId));
        if (entity.getSubcontractType().equals(1)) {
            punishVO.setSubLeaderId(entity.getPersonId());
        }
        punishVO.setSupplierId(entity.getSupplyId());
        punishVO.setPunishType(entity.getPunishType());
        punishVO.setPunishDate(entity.getCreateTime());
        AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)this.abnormalService.getById(entity.getPunishType()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (abnormalEntity.getLastTime() != null) {
                String exceptionEndDate = SubcontractPunishBpmServiceImpl.getLastMonthDate(entity.getCreateTime(), abnormalEntity.getLastTime());
                Date date = simpleDateFormat.parse(exceptionEndDate);
                punishVO.setExceptionEndDate(date);
            } else {
                Date date = simpleDateFormat.parse("3000-01-01");
                punishVO.setExceptionEndDate(date);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        punishVO.setPunishApplyOrg(entity.getApplyOrg());
        punishVO.setPunishApplyPerson(entity.getApplyPerson());
        punishVO.setPunishGrade(entity.getGradeName());
        punishVO.setPunishGradeId(entity.getGradeId());
        punishVO.setPunishOldGrade(entity.getOldGradeName());
        punishVO.setPunishMemo(entity.getMemo());
        CommonResponse response = this.iProSupplierApi.punishSupplier(punishVO);
        if (response.isSuccess()) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)response.getMsg());
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u4e0d\u652f\u6301\u6d4b\u56de");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public static String getLastMonthDate(Date dataTime, int num) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(dataTime);
        LocalDate today = LocalDate.parse(date);
        today = today.minusMonths(-num);
        return today.toString();
    }
}

