/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpHelper {
    private static final String REQ_ENCODEING_UTF8 = "utf-8";
    private static PoolingHttpClientConnectionManager httpClientConnectionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url, Header[] headers) throws Exception {
        HttpGet uriRequest = new HttpGet(url);
        if (null != headers) {
            uriRequest.setHeaders(headers);
        }
        CloseableHttpClient httpClient = null;
        try {
            String result;
            httpClient = HttpHelper.declareHttpClientSSL(url);
            CloseableHttpResponse httpresponse = httpClient.execute((HttpUriRequest)uriRequest);
            HttpEntity httpEntity = httpresponse.getEntity();
            String string = result = EntityUtils.toString((HttpEntity)httpEntity, (String)REQ_ENCODEING_UTF8);
            return string;
        }
        catch (ClientProtocolException e) {
            System.out.println(String.format("http\u8bf7\u6c42\u5931\u8d25\uff0curi{%s},exception{%s}", new Object[]{url, e}));
        }
        catch (IOException e) {
            System.out.println(String.format("IO Exception\uff0curi{%s},exception{%s}", url, e));
        }
        finally {
            if (null != httpClient) {
                httpClient.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, String params) throws Exception {
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/json;charset=utf-8");
        StringEntity stringEntity = new StringEntity(params, REQ_ENCODEING_UTF8);
        stringEntity.setContentEncoding(REQ_ENCODEING_UTF8);
        post.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse httpresponse = null;
        CloseableHttpClient httpClient = null;
        try {
            String result;
            httpClient = HttpHelper.declareHttpClientSSL(url);
            httpresponse = httpClient.execute((HttpUriRequest)post);
            HttpEntity httpEntity = httpresponse.getEntity();
            String string = result = EntityUtils.toString((HttpEntity)httpEntity, (String)REQ_ENCODEING_UTF8);
            return string;
        }
        catch (ClientProtocolException e) {
            System.out.println(String.format("http\u8bf7\u6c42\u5931\u8d25\uff0curi{%s},exception{%s}", new Object[]{url, e}));
        }
        catch (IOException e) {
            System.out.println(String.format("IO Exception\uff0curi{%s},exception{%s}", url, e));
        }
        finally {
            if (null != httpClient) {
                httpClient.close();
            }
        }
        return null;
    }

    private static CloseableHttpClient declareHttpClientSSL(String url) {
        if (url.startsWith("https://")) {
            return HttpHelper.sslClient();
        }
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
    }

    private static CloseableHttpClient sslClient() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLConnectionSocketFactory sslConnectionSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpHelper() {
        httpClientConnectionManager = new PoolingHttpClientConnectionManager();
        httpClientConnectionManager.setMaxTotal(100);
        httpClientConnectionManager.setDefaultMaxPerRoute(20);
    }

    public static String httpGet(String url) throws Exception {
        return HttpHelper.httpGet(url, null);
    }

    public static HttpResponse doGet(String host, String path, String method, Map<String, String> headers, Map<String, String> querys) throws Exception {
        HttpClient httpClient = HttpHelper.wrapClient(host);
        HttpGet request = new HttpGet(HttpHelper.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, Map<String, String> bodys) throws Exception {
        HttpClient httpClient = HttpHelper.wrapClient(host);
        HttpPost request = new HttpPost(HttpHelper.buildUrl(host, path, querys));
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
        if (bodys != null) {
            ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
            for (String key : bodys.keySet()) {
                nameValuePairList.add(new BasicNameValuePair(key, bodys.get(key)));
            }
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(nameValuePairList, REQ_ENCODEING_UTF8);
            urlEncodedFormEntity.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
            request.setEntity((HttpEntity)urlEncodedFormEntity);
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, String body) throws Exception {
        HttpClient httpClient = HttpHelper.wrapClient(host);
        HttpPost request = new HttpPost(HttpHelper.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, REQ_ENCODEING_UTF8));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doPost(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, byte[] body) throws Exception {
        HttpClient httpClient = HttpHelper.wrapClient(host);
        HttpPost request = new HttpPost(HttpHelper.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (body != null) {
            request.setEntity((HttpEntity)new ByteArrayEntity(body));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doPut(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, String body) throws Exception {
        HttpClient httpClient = HttpHelper.wrapClient(host);
        HttpPut request = new HttpPut(HttpHelper.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, REQ_ENCODEING_UTF8));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doPut(String host, String path, String method, Map<String, String> headers, Map<String, String> querys, byte[] body) throws Exception {
        HttpClient httpClient = HttpHelper.wrapClient(host);
        HttpPut request = new HttpPut(HttpHelper.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (body != null) {
            request.setEntity((HttpEntity)new ByteArrayEntity(body));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static HttpResponse doDelete(String host, String path, String method, Map<String, String> headers, Map<String, String> querys) throws Exception {
        HttpClient httpClient = HttpHelper.wrapClient(host);
        HttpDelete request = new HttpDelete(HttpHelper.buildUrl(host, path, querys));
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    private static String buildUrl(String host, String path, Map<String, String> querys) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(host);
        if (!StringUtils.isBlank((CharSequence)path)) {
            sbUrl.append(path);
        }
        if (null != querys) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : querys.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtils.isBlank((CharSequence)query.getKey()) && !StringUtils.isBlank((CharSequence)query.getValue())) {
                    sbQuery.append(query.getValue());
                }
                if (StringUtils.isBlank((CharSequence)query.getKey())) continue;
                sbQuery.append(query.getKey());
                if (StringUtils.isBlank((CharSequence)query.getValue())) continue;
                sbQuery.append("=");
                sbQuery.append(URLEncoder.encode(query.getValue(), REQ_ENCODEING_UTF8));
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        return sbUrl.toString();
    }

    private static HttpClient wrapClient(String host) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (host.startsWith("https://")) {
            HttpHelper.sslClient((HttpClient)httpClient);
        }
        return httpClient;
    }

    private static void sslClient(HttpClient httpClient) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = httpClient.getConnectionManager();
            SchemeRegistry registry = ccm.getSchemeRegistry();
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

