/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invite"})
public class InviteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IInviteService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdate(@RequestBody InviteVO saveOrUpdateVO) {
        CommonResponse<String> exist;
        InviteEntity entity = (InviteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InviteEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(exist = this.service.checkExist(entity.getId(), entity.getTaxpayerNum(), entity.getPersonal(), entity.getName())).isSuccess()) {
            return CommonResponse.error((String)("\u4fdd\u5b58\u5931\u8d25\uff01" + exist.getMsg()));
        }
        this.service.saveOrUpdate((Object)entity, false);
        InviteVO vo = (InviteVO)BeanMapper.map((Object)((Object)entity), InviteVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/noAuth/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdateNoAuth(@RequestBody InviteVO saveOrUpdateVO) {
        this.logger.info("\u65e0\u9274\u6743\u65b0\u589e\u6216\u8005\u4fee\u6539:{}", (Object)JSONObject.toJSONString((Object)saveOrUpdateVO));
        InviteEntity entity = (InviteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InviteEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        InviteVO vo = (InviteVO)BeanMapper.map((Object)((Object)entity), InviteVO.class);
        return CommonResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InviteVO> queryDetail(Long id) {
        InviteEntity entity = (InviteEntity)((Object)this.service.selectById(id));
        InviteVO vo = (InviteVO)BeanMapper.map((Object)((Object)entity), InviteVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("taxpayer_num");
        param.getFuzzyFields().add("area_name");
        param.getFuzzyFields().add("code");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("applyOrgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("applyOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("checkResult", new Parameter("eq", (Object)1));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InviteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryHandleList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryHandleList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("taxpayer_num");
        param.getFuzzyFields().add("area_name");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("applyOrgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("applyOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("checkResult", new Parameter("ne", (Object)1));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InviteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Invite-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInviteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> refInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("taxpayer_num");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("checkResult", new Parameter("eq", (Object)1));
        param.getParams().put("canInNum", new Parameter("eq", (Object)0));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InviteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/ignoreData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InviteVO> ignoreData(Long id, Long userId, String userName) {
        InviteEntity entity = (InviteEntity)((Object)this.service.selectById(id));
        InviteVO inviteVO = (InviteVO)BeanMapper.map((Object)((Object)entity), InviteVO.class);
        inviteVO.setBillState(Integer.valueOf(2));
        inviteVO.setHandlePerson(userName);
        inviteVO.setHandlePersonId(userId);
        inviteVO.setHandleTime(new Date());
        CommonResponse<InviteVO> inviteVOCommonResponse = this.saveOrUpdate(inviteVO);
        if (inviteVOCommonResponse.isSuccess()) {
            return CommonResponse.success((String)"\u5ffd\u7565\u6210\u529f\uff01", (Object)inviteVOCommonResponse.getData());
        }
        return CommonResponse.error((String)"\u5ffd\u7565\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/ignoreDatas"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> ignoreDatas(@RequestBody String data) {
        QueryParam param = new QueryParam();
        JSONObject json = JSONObject.parseObject((String)data);
        JSONArray jsonArray = json.getJSONArray("ids");
        List ids = JSONObject.parseArray((String)jsonArray.toJSONString(), Long.class);
        param.getParams().put("id", new Parameter("in", (Object)ids));
        List inviteEntities = this.service.queryList(param);
        for (InviteEntity VO : inviteEntities) {
            VO.setBillState(2);
            VO.setHandleTime(new Date());
            VO.setHandlePerson(json.getString("userName"));
            VO.setHandlePersonId(json.getLong("userId"));
        }
        boolean b = this.service.saveOrUpdateBatch(inviteEntities);
        if (b) {
            return CommonResponse.success((String)"\u5ffd\u7565\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u5ffd\u7565\u5931\u8d25\uff01");
    }
}

