/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.InviteLinkEntity;
import com.ejianc.business.pro.supplier.service.IInviteLinkService;
import com.ejianc.business.pro.supplier.vo.InviteLinkVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.api.IidmWebEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.QRCodeUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"inviteLink"})
public class InviteLinkController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IidmWebEnterpriseApi iidmWebEnterpriseApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IInviteLinkService service;
    @Autowired
    private QRCodeUtil qrCodeUtil;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InviteLinkVO> saveOrUpdate(@RequestBody InviteLinkVO saveorUpdateVO) {
        InviteLinkEntity entity = (InviteLinkEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InviteLinkEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        InviteLinkVO vo = (InviteLinkVO)BeanMapper.map((Object)((Object)entity), InviteLinkVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u9080\u8bf7\u4fe1\u606f\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InviteLinkVO> queryLink(@RequestParam(value="orgName") String orgName) {
        QueryParam param = new QueryParam();
        param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        List list = this.service.queryList(param, false);
        InviteLinkEntity entity = new InviteLinkEntity();
        if (ListUtil.isNotEmpty((List)list)) {
            entity = (InviteLinkEntity)((Object)list.get(0));
        } else {
            entity.setOrgId(InvocationInfoProxy.getOrgId());
            entity.setOrgName(orgName);
            CommonResponse response = this.iidmWebEnterpriseApi.getEnterpriseByTenantId(InvocationInfoProxy.getTenantid());
            if (response.isSuccess()) {
                EnterpriseVO enterpriseVO = (EnterpriseVO)response.getData();
                entity.setLogoPath(enterpriseVO.getLogoPath());
                entity.setDescription(enterpriseVO.getDescription());
            }
            entity.setStartTime(new Date());
            entity.setEndTime((Date)DateUtil.endOfMonth((Date)new Date()));
            this.service.saveOrUpdateNoES((Object)entity);
        }
        InviteLinkVO vo = (InviteLinkVO)BeanMapper.map((Object)((Object)entity), InviteLinkVO.class);
        if (vo.getEndTime().before(new Date())) {
            vo.setPassTime(Boolean.valueOf(true));
        } else {
            vo.setPassTime(Boolean.valueOf(false));
        }
        vo.setLinkUrl(this.baseHost + "/ejc-prosupplier-frontend/#/invitationSupplier/no_auth/enterpriseCertificationCard?_ivt=" + vo.getId());
        vo.setQrCode(this.qrCodeUtil.getBase64QRCode(this.baseHost + "ejc-prosupplier-mobile/#/no_auth/main/inviteIndex?_ivt=" + vo.getId()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"noAuth/queryLink"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InviteLinkVO> queryLinkNoAuth(@RequestParam(value="id") Long id) {
        InviteLinkEntity entity = (InviteLinkEntity)((Object)this.service.selectById(id));
        InviteLinkVO vo = (InviteLinkVO)BeanMapper.map((Object)((Object)entity), InviteLinkVO.class);
        if (vo.getEndTime().before(new Date())) {
            vo.setPassTime(Boolean.valueOf(true));
        } else {
            vo.setPassTime(Boolean.valueOf(false));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InviteLinkVO> queryDetail(Long id) {
        InviteLinkEntity entity = (InviteLinkEntity)((Object)this.service.selectById(id));
        InviteLinkVO vo = (InviteLinkVO)BeanMapper.map((Object)((Object)entity), InviteLinkVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteLinkVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InviteLinkVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InviteLinkVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InviteLink-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInviteLinkData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InviteLinkVO>> refInviteLinkData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InviteLinkVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

