/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.pro.supplier.bean.SubcontractYearEntity;
import com.ejianc.business.pro.supplier.service.ISubcontractYearService;
import com.ejianc.business.pro.supplier.service.appraise.RuleBAppraiseStrategy;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.SubcontractYearVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subcontractYear"})
public class SubcontractYearController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private RuleBAppraiseStrategy rule;
    private static final String BILL_CODE = "YEAY_EVALUATE";
    @Autowired
    private ISubcontractYearService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubcontractYearVO> saveOrUpdate(@RequestBody SubcontractYearVO saveorUpdateVO) {
        SubcontractYearEntity entity = (SubcontractYearEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SubcontractYearEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setCreateUserId(InvocationInfoProxy.getUserid());
        CommonResponse voCommonResponse = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (voCommonResponse.isSuccess()) {
            UserVO user = (UserVO)voCommonResponse.getData();
            entity.setCreateUserName(user.getUserName());
            entity.setPhone(user.getUserMobile());
        }
        entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
        entity.setOrgCode(this.sessionManager.getUserContext().getOrgCode());
        entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
        this.service.saveOrUpdate((Object)entity, false);
        SubcontractYearVO vo = (SubcontractYearVO)BeanMapper.map((Object)((Object)entity), SubcontractYearVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractYearVO> queryDetail(Long id) {
        SubcontractYearEntity entity = (SubcontractYearEntity)((Object)this.service.selectById(id));
        SubcontractYearVO vo = (SubcontractYearVO)BeanMapper.map((Object)((Object)entity), SubcontractYearVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractYearVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubcontractYearVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("cooperationOrgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractYearVO.class));
        List records = pageData.getRecords();
        records.forEach(item -> {
            if (item.getContractType() != null && ContractTypeEnum.getByCode((String)item.getContractType()) != null) {
                item.setContractTypeName(ContractTypeEnum.getByCode((String)item.getContractType()).getTypeName());
            }
            if (null != item.getEvaluationObjState() && item.getEvaluationObjState() == 2) {
                item.setName(item.getHeadUserName());
            } else {
                item.setName(item.getSupplyName());
            }
        });
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Year-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refYearData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubcontractYearVO>> refYearData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractYearVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/querySubcontractRecordList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> querySubcontractRecordList(Long id, Long supplyId) {
        SubcontractYearEntity subcontractYearEntity = (SubcontractYearEntity)((Object)this.service.selectById(id));
        String startDate = subcontractYearEntity.getOldStartDate();
        Integer evaluationObjState = subcontractYearEntity.getEvaluationObjState();
        String endDate = DateUtil.format(subcontractYearEntity.getEndDate(), "yyyy-MM-dd");
        List<Map<String, Object>> subGrade = this.rule.getSubGrade2(supplyId, startDate, endDate, evaluationObjState, subcontractYearEntity.getContractType(), subcontractYearEntity.getHeadUserId());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", subGrade);
    }
}

