/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.appraise;

import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.appraise.PushProcessLogic;
import com.ejianc.business.pro.supplier.vo.IncidentVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pushProcessLogic")
public class PushProcessRuleALogic
implements PushProcessLogic {
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "INCIDENT";
    @Autowired
    private SessionManager sessionManager;

    @Override
    public List<IncidentVO> logicOne(AppraiseParamVO appraiseParamVO) {
        List contractPoolVOList;
        ArrayList<ContractPoolVO> pushProcessList = new ArrayList<ContractPoolVO>();
        List<IncidentVO> processList = new ArrayList<IncidentVO>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode()));
        queryParam.getParams().put("sourceType", new Parameter("in", Arrays.asList(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode(), ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode(), ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode(), ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u5176\u4ed6\u6536\u5165\u5408\u540c.getTypeCode())));
        CommonResponse listCommonResponse = this.contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(contractPoolVOList = (List)listCommonResponse.getData()))) {
            List contractList = contractPoolVOList.stream().filter(s -> s.getContractTaxMny() != null).filter(s -> s.getContractTaxMny().compareTo(appraiseParamVO.getContractMny()) != -1).collect(Collectors.toList());
            Map<Long, ContractPoolVO> contractPoolMap = contractList.stream().collect(Collectors.toMap(k -> k.getId(), k -> k));
            if (CollectionUtils.isNotEmpty(contractList)) {
                List settlePoolList;
                List contractIds = contractList.stream().map(BaseVO::getId).collect(Collectors.toList());
                QueryParam settleQueryParam = new QueryParam();
                settleQueryParam.getParams().put("contractId", new Parameter("in", contractIds));
                CommonResponse settleCommonResponse = this.settlePoolApi.queryList(settleQueryParam);
                if (settleCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(settlePoolList = (List)settleCommonResponse.getData()))) {
                    Map<Long, BigDecimal> settlePoolMap = settlePoolList.stream().filter(s -> s.getContractId() != null).collect(Collectors.groupingBy(SettlePoolVO::getContractId, Collectors.reducing(BigDecimal.ZERO, SettlePoolVO::getCurTaxMny, BigDecimal::add)));
                    Set<Long> contractIdSet = settlePoolMap.keySet();
                    for (Long contractId : contractIdSet) {
                        BigDecimal settleContractRatio;
                        BigDecimal settleContractMny;
                        BigDecimal contractTaxMny = contractPoolMap.get(contractId).getContractTaxMny();
                        BigDecimal settleTaxMny = settlePoolMap.get(contractId);
                        if (settleTaxMny.compareTo(settleContractMny = ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)(settleContractRatio = ComputeUtil.safeDiv((BigDecimal)appraiseParamVO.getSettleContractRatio(), (BigDecimal)new BigDecimal(100))))) == -1) continue;
                        pushProcessList.add(contractPoolMap.get(contractId));
                    }
                    List pushProcessContractIds = pushProcessList.stream().map(BaseVO::getId).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(pushProcessContractIds)) {
                        return null;
                    }
                    QueryParam queryIncidentParam = new QueryParam();
                    queryIncidentParam.getParams().put("contractId", new Parameter("in", pushProcessContractIds));
                    queryIncidentParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode()));
                    List incidentEntities = this.incidentService.queryList(queryIncidentParam, false);
                    if (incidentEntities.size() == pushProcessContractIds.size()) {
                        return null;
                    }
                    PushProcessRuleALogic pushProcessRuleALogic = new PushProcessRuleALogic();
                    if (incidentEntities.size() == 0) {
                        processList = pushProcessRuleALogic.getProcessList(pushProcessList, null, this.userApi, this.billCodeApi, this.sessionManager);
                        return processList;
                    }
                    Map<Long, List<IncidentEntity>> map = incidentEntities.stream().collect(Collectors.groupingBy(IncidentEntity::getContractId));
                    processList = pushProcessRuleALogic.getProcessList(pushProcessList, map, this.userApi, this.billCodeApi, this.sessionManager);
                    return processList;
                }
            }
        }
        return processList;
    }

    @Override
    public List<IncidentVO> logicTwo(AppraiseParamVO appraiseParamVO) {
        List contractPoolVOList;
        List<IncidentVO> processList = new ArrayList<IncidentVO>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode()));
        queryParam.getParams().put("sourceType", new Parameter("in", Arrays.asList(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode(), ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode(), ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode(), ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u5176\u4ed6\u6536\u5165\u5408\u540c.getTypeCode())));
        CommonResponse listCommonResponse = this.contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(contractPoolVOList = (List)listCommonResponse.getData()))) {
            List contractPoolIds = contractPoolVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryParam queryIncidentParam = new QueryParam();
            queryIncidentParam.getParams().put("contractId", new Parameter("in", contractPoolIds));
            queryIncidentParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode()));
            List incidentEntities = this.incidentService.queryList(queryIncidentParam, false);
            PushProcessRuleALogic pushProcessRuleALogic = new PushProcessRuleALogic();
            if (incidentEntities.size() == 0) {
                processList = pushProcessRuleALogic.getProcessList(contractPoolVOList, null, this.userApi, this.billCodeApi, this.sessionManager);
                return processList;
            }
            Map<Long, List<IncidentEntity>> map = incidentEntities.stream().collect(Collectors.groupingBy(IncidentEntity::getContractId));
            processList = pushProcessRuleALogic.getProcessList(contractPoolVOList, map, this.userApi, this.billCodeApi, this.sessionManager);
            return processList;
        }
        return processList;
    }

    public List<IncidentVO> getProcessList(List<ContractPoolVO> pushProcessList, Map<Long, List<IncidentEntity>> map, IUserApi userApi, IBillCodeApi billCodeApi, SessionManager sessionManager) {
        ArrayList<IncidentVO> list = new ArrayList<IncidentVO>();
        pushProcessList.forEach(e -> {
            if (map == null) {
                IncidentVO incidentVO = new IncidentVO();
                CommonResponse billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                incidentVO.setCode((String)billCode.getData());
                incidentVO.setContractId(e.getContractId());
                incidentVO.setPerformanceStatus(e.getPerformanceStatus());
                incidentVO.setStatus(Integer.valueOf(0));
                incidentVO.setCreateUserId(InvocationInfoProxy.getUserid());
                CommonResponse voCommonResponse = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
                if (voCommonResponse.isSuccess()) {
                    UserVO user = (UserVO)voCommonResponse.getData();
                    incidentVO.setCreateUserName(user.getUserName());
                    incidentVO.setPhone(user.getUserMobile());
                }
                incidentVO.setProcessId(sessionManager.getUserContext().getUserId());
                incidentVO.setProcess(sessionManager.getUserContext().getUserName());
                incidentVO.setContractType(e.getSourceType());
                incidentVO.setContractName(e.getContractName());
                incidentVO.setProjectId(e.getProjectId());
                incidentVO.setProjectName(e.getProjectName());
                incidentVO.setContractAmount(e.getContractTaxMny());
                incidentVO.setSupplyId(e.getPartybId());
                incidentVO.setSupplyName(e.getPartyaName());
                String supplyQueryType = SupplyQueryTypeUtil.get((String)"RULE_A", (String)e.getSourceType());
                incidentVO.setSupplyQueryType(supplyQueryType);
                incidentVO.setCheckOrgId(sessionManager.getUserContext().getOrgId());
                incidentVO.setCheckOrgName(sessionManager.getUserContext().getOrgName());
                incidentVO.setDate(new Date());
                incidentVO.setSource("\u5b9a\u65f6\u63a8\u9001");
                list.add(incidentVO);
            } else if (!map.containsKey(e.getContractId())) {
                IncidentVO incidentVO = new IncidentVO();
                CommonResponse billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                incidentVO.setCode((String)billCode.getData());
                incidentVO.setContractId(e.getContractId());
                incidentVO.setPerformanceStatus(e.getPerformanceStatus());
                incidentVO.setStatus(Integer.valueOf(0));
                incidentVO.setCreateUserId(InvocationInfoProxy.getUserid());
                CommonResponse voCommonResponse = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
                if (voCommonResponse.isSuccess()) {
                    UserVO user = (UserVO)voCommonResponse.getData();
                    incidentVO.setCreateUserName(user.getUserName());
                    incidentVO.setPhone(user.getUserMobile());
                }
                incidentVO.setProcessId(sessionManager.getUserContext().getUserId());
                incidentVO.setProcess(sessionManager.getUserContext().getUserName());
                incidentVO.setContractType(e.getSourceTypeName());
                incidentVO.setContractName(e.getContractName());
                incidentVO.setProjectId(e.getProjectId());
                incidentVO.setProjectName(e.getProjectName());
                incidentVO.setContractAmount(e.getContractTaxMny());
                incidentVO.setSupplyId(e.getPartybId());
                incidentVO.setSupplyName(e.getPartyaName());
                String supplyQueryType = SupplyQueryTypeUtil.get((String)"RULE_A", (String)e.getSourceType());
                incidentVO.setSupplyQueryType(supplyQueryType);
                incidentVO.setCheckOrgId(sessionManager.getUserContext().getOrgId());
                incidentVO.setCheckOrgName(sessionManager.getUserContext().getOrgName());
                incidentVO.setDate(new Date());
                incidentVO.setSource("\u5b9a\u65f6\u63a8\u9001");
                list.add(incidentVO);
            }
        });
        return list;
    }
}

