/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.appraise;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.service.appraise.IPushProcessRuleBLogic;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pushProcessRuleBLogic")
public class PushProcessRuleBLogic
implements IPushProcessRuleBLogic {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProcessService processService;
    private static final String BILL_CODE = "INCIDENT";

    @Override
    public void logicOne(AppraiseParamVO appraiseParamVO) {
        CommonResponse listCommonResponse;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode()));
        ArrayList<String> contractType = new ArrayList<String>();
        String subManageFlag = appraiseParamVO.getSubManageFlag();
        if (StringUtils.isNotBlank((String)appraiseParamVO.getContractType())) {
            if ("material".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
                contractType.add(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
                contractType.add(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
            }
            if ("equipment".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
                contractType.add(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
            }
            if ("proSub".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
            }
            if ("laborSub".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
            }
            queryParam.getParams().put("sourceType", new Parameter("in", contractType));
        }
        if ((listCommonResponse = this.contractPoolApi.queryList(queryParam)).isSuccess()) {
            List contractPoolVOList = (List)listCommonResponse.getData();
            this.logger.info("\u5408\u540c\u6c60\u67e5\u8be2\u6210\u529f=============================\u6570\u91cf\u4e3a\uff1a" + contractPoolVOList.size());
            if (CollectionUtils.isNotEmpty((Collection)contractPoolVOList)) {
                HashSet<String> laborPushSet = new HashSet<String>();
                ArrayList<ContractPoolVO> pushList = new ArrayList<ContractPoolVO>();
                for (ContractPoolVO item : contractPoolVOList) {
                    boolean laborFlag = ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(item.getSourceType());
                    Date date = new Date();
                    QueryWrapper wrapper = new QueryWrapper();
                    if (laborFlag && "1".equals(subManageFlag)) {
                        int days;
                        String laborKey = String.valueOf(item.getProjectId()) + item.getPartybId();
                        if (laborPushSet.contains(laborKey)) continue;
                        wrapper.eq((Object)"project_id", (Object)item.getProjectId());
                        wrapper.eq((Object)"supply_id", (Object)item.getPartybId());
                        wrapper.orderByDesc((Object)"date");
                        List list = this.incidentService.list((Wrapper)wrapper);
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            date = ((IncidentEntity)((Object)list.get(0))).getDate();
                            days = DateUtil.differentDays(new Date(), date);
                            if ((days = Math.abs(days)) < appraiseParamVO.getSpaceLastDays()) {
                                laborPushSet.add(laborKey);
                                continue;
                            }
                        } else {
                            date = item.getSignDate();
                        }
                        days = DateUtil.differentDays(new Date(), date);
                        if ((days = Math.abs(days)) < appraiseParamVO.getSpaceLastDays()) continue;
                        laborPushSet.add(laborKey);
                        pushList.add(item);
                        continue;
                    }
                    wrapper.eq((Object)"contract_id", (Object)item.getContractId());
                    wrapper.eq((Object)"performance_status", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
                    wrapper.eq((Object)"dr", (Object)0);
                    if (StringUtils.isNotBlank((String)subManageFlag)) {
                        wrapper.eq((Object)"evaluation_obj_state", (Object)subManageFlag);
                    }
                    wrapper.orderByDesc((Object)"date");
                    List list = this.incidentService.list((Wrapper)wrapper);
                    date = CollectionUtils.isNotEmpty((Collection)list) ? ((IncidentEntity)((Object)list.get(0))).getDate() : item.getSignDate();
                    int days = DateUtil.differentDays(new Date(), date);
                    if ((days = Math.abs(days)) < appraiseParamVO.getSpaceLastDays()) continue;
                    pushList.add(item);
                }
                if (pushList.size() > 0) {
                    this.saveIncident(pushList, subManageFlag, false);
                    this.logger.info("\u6700\u7ec8\u63a8\u9001\u6570\u91cf=============================\u6570\u91cf\u4e3a\uff1a" + pushList.size());
                }
            }
        }
    }

    @Override
    public void logicTwo(AppraiseParamVO appraiseParamVO) {
        CommonResponse listCommonResponse;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode()));
        ArrayList<String> contractType = new ArrayList<String>();
        String subManageFlag = appraiseParamVO.getSubManageFlag();
        if (StringUtils.isNotBlank((String)appraiseParamVO.getContractType())) {
            if ("material".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
                contractType.add(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
                contractType.add(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
            }
            if ("equipment".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
                contractType.add(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
            }
            if ("proSub".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
            }
            if ("laborSub".equals(appraiseParamVO.getContractType())) {
                contractType.add(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
            }
            queryParam.getParams().put("sourceType", new Parameter("in", contractType));
        }
        if ((listCommonResponse = this.contractPoolApi.queryList(queryParam)).isSuccess()) {
            ArrayList<ContractPoolVO> pushList = new ArrayList<ContractPoolVO>();
            List conList = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)conList)) {
                List contractPoolIds = conList.stream().map(BaseVO::getId).collect(Collectors.toList());
                QueryParam queryIncidentParam = new QueryParam();
                queryIncidentParam.getParams().put("contractId", new Parameter("in", contractPoolIds));
                queryIncidentParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode()));
                if (StringUtils.isNotBlank((String)subManageFlag)) {
                    queryIncidentParam.getParams().put("evaluationObjState", new Parameter("eq", (Object)subManageFlag));
                }
                List incidentList = this.incidentService.queryList(queryIncidentParam, false);
                Map<Long, IncidentEntity> map = incidentList.stream().collect(Collectors.toMap(k -> k.getContractId(), k -> k));
                if (incidentList.size() == 0) {
                    pushList.addAll(conList);
                } else {
                    conList.forEach(item -> {
                        if (!map.containsKey(item.getContractId())) {
                            pushList.add((ContractPoolVO)item);
                        }
                    });
                }
                this.saveIncident(pushList, subManageFlag, false);
            }
        }
    }

    @Override
    public void checkAndPushProcessAppraise(AppraiseParamVO appraiseParamVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter("in", (Object)new String[]{ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode(), ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode()}));
        ArrayList<String> contractType = new ArrayList<String>();
        contractType.add(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
        contractType.add(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
        contractType.add(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
        contractType.add(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
        contractType.add(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
        contractType.add(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
        contractType.add(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
        queryParam.getParams().put("sourceType", new Parameter("in", contractType));
        queryParam.getOrderMap().put("signDate", "asc");
        CommonResponse listCommonResponse = this.contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()) {
            List contractPoolVOList = (List)listCommonResponse.getData();
            this.logger.info("\u5408\u540c\u6c60\u67e5\u8be2\u6210\u529f=============================\u6570\u91cf\u4e3a\uff1a" + contractPoolVOList.size());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            String curYear = sdf.format(new Date());
            if (CollectionUtils.isNotEmpty((Collection)contractPoolVOList)) {
                HashSet<String> laborPushSet = new HashSet<String>();
                ArrayList<ContractPoolVO> pushList = new ArrayList<ContractPoolVO>();
                ArrayList<ContractPoolVO> pushWithSubLeaderList = new ArrayList<ContractPoolVO>();
                QueryWrapper wrapper = null;
                QueryWrapper processWrapper = null;
                for (ContractPoolVO item : contractPoolVOList) {
                    String laborKey;
                    wrapper = new QueryWrapper();
                    processWrapper = new QueryWrapper();
                    boolean laborFlag = ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(item.getSourceType());
                    if (laborFlag && !laborPushSet.contains(laborKey = String.valueOf(item.getProjectId()) + item.getPartybId())) {
                        wrapper.eq((Object)"project_id", (Object)item.getProjectId());
                        wrapper.eq((Object)"supply_id", (Object)item.getPartybId());
                        wrapper.eq((Object)"date_format(create_time,'%Y')", (Object)curYear);
                        wrapper.eq((Object)"evaluation_obj_state", (Object)1);
                        List list = this.incidentService.list((Wrapper)wrapper);
                        if (CollectionUtils.isEmpty((Collection)list)) {
                            processWrapper.eq((Object)"project_id", (Object)item.getProjectId());
                            processWrapper.eq((Object)"supply_id", (Object)item.getPartybId());
                            processWrapper.eq((Object)"date_format(create_time,'%Y')", (Object)curYear);
                            processWrapper.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
                            List processList = this.processService.list((Wrapper)processWrapper);
                            if (CollectionUtils.isEmpty((Collection)processList)) {
                                laborPushSet.add(laborKey);
                                pushList.add(item);
                            } else {
                                this.logger.info("\u5408\u540c\u3010id-{},name-{}\u3011\u5b58\u5728\u5386\u53f2\u4f9b\u5e94\u5546\u8fc7\u7a0b\u4e8b\u4ef6\u8bc4\u4ef7\uff0c\u8df3\u8fc7", (Object)item.getId(), (Object)item.getContractName());
                                laborPushSet.add(laborKey);
                            }
                        } else {
                            this.logger.info("\u5408\u540c\u3010id-{},name-{}\u3011\u5b58\u5728\u5386\u53f2\u8fc7\u7a0b\u8bc4\u4ef7\uff0c\u8df3\u8fc7\u3002", (Object)item.getId(), (Object)item.getContractName());
                            laborPushSet.add(laborKey);
                        }
                    }
                    wrapper = new QueryWrapper();
                    wrapper.eq((Object)"contract_id", (Object)item.getId());
                    wrapper.in((Object)"performance_status", (Object[])new String[]{ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode(), ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode()});
                    wrapper.eq((Object)"date_format(create_time,'%Y')", (Object)curYear);
                    if (laborFlag) {
                        wrapper.eq((Object)"evaluation_obj_state", (Object)2);
                    }
                    wrapper.eq((Object)"dr", (Object)0);
                    List list = this.incidentService.list((Wrapper)wrapper);
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        this.logger.info("\u5408\u540c\u3010id-{},name-{}\u3011\u5b58\u5728{}\u8bc4\u4ef7\uff0c\u8df3\u8fc7\u3002", new Object[]{item.getId(), laborFlag ? "\u5206\u5305\u8d1f\u8d23\u4eba" : "\u5386\u53f2\u4f9b\u5e94\u5546\u8fc7\u7a0b", item.getContractName()});
                        continue;
                    }
                    processWrapper.eq((Object)"contract_id", (Object)item.getId());
                    processWrapper.eq((Object)"date_format(create_time,'%Y')", (Object)curYear);
                    processWrapper.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
                    List processList = this.processService.list((Wrapper)processWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)processList)) {
                        this.logger.info("\u5408\u540c\u3010id-{},name-{}\u3011\u5b58\u5728\u5386\u53f2\u4e8b\u4ef6\u8bc4\u4ef7\uff0c\u8df3\u8fc7", (Object)item.getId(), (Object)item.getContractName());
                        continue;
                    }
                    if (laborFlag) {
                        pushWithSubLeaderList.add(item);
                        continue;
                    }
                    pushList.add(item);
                }
                if (pushList.size() > 0) {
                    this.saveIncident(pushList, null, true);
                    this.logger.info("\u6700\u7ec8\u63a8\u9001\u4f9b\u5e94\u5546\u8bc4\u4ef7\u6570\u91cf=============================\u6570\u91cf\u4e3a\uff1a" + pushList.size());
                }
                if (pushWithSubLeaderList.size() > 0) {
                    this.saveIncident(pushWithSubLeaderList, "2", false);
                    this.logger.info("\u6700\u7ec8\u63a8\u9001\u5206\u5305\u8d1f\u8d23\u4eba\u8bc4\u4ef7\u6570\u91cf=============================\u6570\u91cf\u4e3a\uff1a" + pushWithSubLeaderList.size());
                }
            }
        }
    }

    public void saveIncident(List<ContractPoolVO> list, String subManageFlag, boolean byContractType) {
        ArrayList pushList = new ArrayList();
        list.forEach(e -> {
            IncidentEntity entity = new IncidentEntity();
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setContractId(e.getContractId());
            entity.setPerformanceStatus(e.getPerformanceStatus());
            entity.setStatus(0);
            entity.setContractType(e.getSourceType());
            ContractTypeEnum contractTypeEnum = ContractTypeEnum.getByCode((String)e.getSourceType());
            if (contractTypeEnum != null) {
                String contractTypeName = ContractTypeEnum.getByCode((String)e.getSourceType()).getTypeName();
                entity.setContractTypeName(contractTypeName);
            }
            entity.setSupplyQueryType(SupplyQueryTypeUtil.get((String)"RULE_B", (String)e.getSourceType()));
            entity.setContractName(e.getContractName());
            entity.setProjectId(e.getProjectId());
            entity.setProjectName(e.getProjectName());
            entity.setContractAmount(e.getContractTaxMny());
            entity.setSupplyId(e.getPartybId());
            entity.setSupplyName(e.getPartybName());
            entity.setOrgId(e.getOrgId());
            entity.setOrgName(e.getOrgName());
            entity.setOrgCode(e.getOrgCode());
            entity.setParentOrgId(e.getParentOrgId());
            entity.setParentOrgName(e.getParentOrgName());
            entity.setParentOrgCode(e.getParentOrgCode());
            entity.setHeadUserId(e.getSupplierProjectManagerId());
            entity.setHeadUserName(e.getSupplierProjectManagerName());
            entity.setDate(new Date());
            if (ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode().equals(e.getPerformanceStatus())) {
                entity.setSource("\u6700\u7ec8\u7ed3\u7b97");
            } else {
                entity.setSource("\u5b9a\u65f6\u63a8\u9001");
            }
            entity.setBuckleBranch(BigDecimal.ZERO);
            if (byContractType && ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode().equals(e.getSourceType())) {
                entity.setEvaluationObjState(1);
                entity.setEvaluationObjName("\u52b3\u52a1\u4f9b\u5e94\u5546");
            } else if (StringUtils.isNotBlank((String)subManageFlag)) {
                entity.setEvaluationObjState(Integer.parseInt(subManageFlag));
                entity.setEvaluationObjName("2".equals(subManageFlag) ? "\u5206\u5305\u8d1f\u8d23\u4eba" : "\u52b3\u52a1\u4f9b\u5e94\u5546");
            }
            pushList.add(entity);
        });
        if (pushList.size() > 0) {
            this.incidentService.saveOrUpdateBatch(pushList, pushList.size());
        }
    }
}

