/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.bean.YearEntity;
import com.ejianc.business.pro.supplier.mapper.YearMapper;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.YearBatchOperateParam;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="yearService")
public class YearServiceImpl
extends BaseServiceImpl<YearMapper, YearEntity>
implements IYearService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private YearMapper yearMapper;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAbnormalService abnormalService;
    @Autowired
    IProSupplierApi proSupplierApi;

    @Override
    public Map<Long, Integer> queryGrade(Map<String, List<Long>> map) {
        List<Long> suplyIds = map.get("suplyIds");
        List<YearEntity> yearEntities = this.yearMapper.queryGrade(suplyIds);
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        yearEntities.forEach(item -> resultMap.put(item.getSupplyId(), item.getYearDeduct()));
        return resultMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchOperate(YearBatchOperateParam yearBatchOperateParam) {
        CommonResponse punishRs;
        CommonResponse updateRs;
        List yearList = this.yearMapper.selectBatchIds(yearBatchOperateParam.getYearIdList());
        List abnormalEntities = null;
        Map<Long, AbnormalEntity> abnormalMap = null;
        for (YearEntity year : yearList) {
            if (!BillStateEnum.APPROVING_HAS_STATE.getBillStateCode().equals(year.getBillState()) && !BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode().equals(year.getBillState())) continue;
            throw new BusinessException("\u53ea\u80fd\u6279\u91cf\u8c03\u6574\u81ea\u7531\u6001\u7684\u5355\u636e\uff01");
        }
        List punishIds = yearList.stream().filter(item -> null != item.getPunishType()).map(YearEntity::getPunishType).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(punishIds)) {
            QueryWrapper abnormalQuery = new QueryWrapper();
            abnormalQuery.in((Object)"id", punishIds);
            abnormalQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            abnormalEntities = this.abnormalService.list((Wrapper)abnormalQuery);
            abnormalMap = abnormalEntities.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        }
        ArrayList<JSONObject> updateParams = new ArrayList<JSONObject>();
        JSONObject updateParam = null;
        ArrayList<PunishVO> punishVOS = new ArrayList<PunishVO>();
        for (YearEntity year : yearList) {
            year.setBillState(1);
            if ("adjust".equals(yearBatchOperateParam.getOperateType()) && !year.getGrade().equals(yearBatchOperateParam.getAdjustedGrade())) {
                year.setGrade(yearBatchOperateParam.getAdjustedGrade());
                year.setGradeName(yearBatchOperateParam.getAdjustedGradeName());
                year.setTotalBranch(yearBatchOperateParam.getAdjustedScore());
            }
            year.setStatus(1);
            if (year.getProcessId() == null) {
                UserContext userContext = this.sessionManager.getUserContext();
                year.setProcessId(userContext.getUserId());
                year.setProcess(userContext.getUserName());
            }
            updateParam = new JSONObject();
            if (year.getEvaluationObjState() != null && year.getEvaluationObjState() == 2) {
                updateParam.put("id", (Object)year.getHeadUserId());
                updateParam.put("type", (Object)"subLeader");
            } else {
                updateParam.put("id", (Object)year.getSupplyId());
                updateParam.put("type", (Object)"supplier");
            }
            updateParam.put("grade", (Object)year.getGrade());
            updateParam.put("gradeName", (Object)year.getGradeName());
            updateParams.add(updateParam);
            if (null == year.getPunishType()) continue;
            PunishVO punishVO = new PunishVO();
            punishVO.setSupplierId(year.getSupplyId());
            punishVO.setPunishType(year.getPunishType());
            punishVO.setPunishDate(new Date());
            AbnormalEntity abnormalEntity = abnormalMap.get(year.getPunishType());
            if (null == abnormalEntity) {
                this.logger.error("\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u5e94\u5f02\u5e38\u7b49\u7ea7\u7684\u6570\u636e");
                return;
            }
            Date endDate = DateUtil.monthAdd(new Date(), abnormalEntity.getLastTime() == null ? 0 : abnormalEntity.getLastTime());
            punishVO.setExceptionEndDate(endDate);
            punishVO.setPunishApplyPerson(year.getProcess());
            punishVO.setPunishGradeId(year.getGrade());
            punishVO.setPunishGrade(year.getGradeName());
            punishVO.setPunishOldGrade(year.getPrimaryGrade());
            punishVO.setPunishApplyOrg(year.getOrgName());
            if (year.getEvaluationObjState() != null && year.getEvaluationObjState() == 2) {
                punishVO.setSubLeaderId(year.getHeadUserId());
            }
            punishVOS.add(punishVO);
        }
        if (CollectionUtils.isNotEmpty(updateParams) && !(updateRs = this.proSupplierApi.updateSupplierAndSubLeaderBatch(JSONObject.toJSONString(updateParams))).isSuccess()) {
            this.logger.error("\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba/\u4f9b\u5e94\u5546\u7b49\u7ea7\u4fe1\u606f\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)updateRs));
            throw new BusinessException("\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba/\u4f9b\u5e94\u5546\u7b49\u7ea7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isNotEmpty(punishVOS) && !(punishRs = this.proSupplierApi.punishSupplierBatch(punishVOS)).isSuccess()) {
            this.logger.error("\u4f9b\u5e94\u5546\u3001\u5206\u5305\u8d1f\u8d23\u4eba\u5904\u7f6e\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)punishRs));
            throw new BusinessException("\u4f9b\u5e94\u5546\u3001\u5206\u5305\u8d1f\u8d23\u4eba\u5904\u7f6e\u5931\u8d25\uff01");
        }
        super.saveOrUpdateBatch(yearList, yearList.size(), false);
    }

    @Override
    public Map<Long, BigDecimal> queryTotalBranch(Map<String, List<Long>> map) {
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>();
        List<Long> suplyIds = map.get("suplyIds");
        if (CollectionUtils.isEmpty(suplyIds)) {
            return resultMap;
        }
        List<YearEntity> yearEntities = this.yearMapper.queryGrade(suplyIds);
        yearEntities.forEach(item -> resultMap.put(item.getSupplyId(), item.getTotalBranch()));
        return resultMap;
    }
}

