/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.utils;

import com.alibaba.fastjson.JSONObject;
import com.baidu.aip.ocr.AipOcr;
import com.ejianc.business.pro.supplier.utils.HttpHelper;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OuterInterface {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${outInterface.baidu.AppID}")
    private String baiduAppId;
    @Value(value="${outInterface.baidu.APIKey}")
    private String baiduApiKey;
    @Value(value="${outInterface.baidu.SecretKey}")
    private String baiduSecretKey;
    @Value(value="${outInterface.qichacha.key}")
    private String qichachaKey;
    @Value(value="${outInterface.qichacha.SecretKey}")
    private String qichachaSecretKey;
    @Value(value="${outInterface.aliyun.AppKey}")
    private String aliyunAppKey;
    @Value(value="${outInterface.aliyun.AppSecret}")
    private String aliyunAppSecret;
    @Value(value="${outInterface.aliyun.AppCode}")
    private String aliyunAppCode;
    private AipOcr client;

    private AipOcr getClient() {
        if (this.client == null) {
            this.client = new AipOcr(this.baiduAppId, this.baiduApiKey, this.baiduSecretKey);
        }
        return this.client;
    }

    public JSONObject getBusinessLicenseInfoFromBaidu(String imageUrl) {
        String words;
        org.json.JSONObject object = this.getClient().businessLicense(OuterInterface.getImageFromURL(imageUrl), new HashMap());
        if (object.has("error_code")) {
            this.logger.error("\u8425\u4e1a\u6267\u7167\u8bc6\u522b\u5931\u8d25\uff01{}", (Object)JSONObject.toJSONString((Object)object));
            throw new BusinessException("\u8425\u4e1a\u6267\u7167\u8bc6\u522b\u5931\u8d25\uff01\u672a\u8bc6\u522b\u5230\u5185\u5bb9\uff0c\u8bf7\u786e\u8ba4\u60a8\u4e0a\u4f20\u4e86\u6e05\u6670\u7684\u8425\u4e1a\u6267\u7167\u7167\u7247\uff01");
        }
        JSONObject res = new JSONObject();
        int wordsResultNum = object.getInt("words_result_num");
        if (wordsResultNum == 0) {
            throw new BusinessException("\u8425\u4e1a\u6267\u7167\u8bc6\u522b\u5931\u8d25\uff01\u672a\u8bc6\u522b\u5230\u5185\u5bb9\uff0c\u8bf7\u786e\u8ba4\u60a8\u4e0a\u4f20\u4e86\u6e05\u6670\u7684\u8425\u4e1a\u6267\u7167\u7167\u7247\uff01");
        }
        org.json.JSONObject wordsResult = object.getJSONObject("words_result");
        if (wordsResult.has("\u5355\u4f4d\u540d\u79f0") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u5355\u4f4d\u540d\u79f0").getString("words"))) {
            res.put("name", (Object)words);
        }
        if (wordsResult.has("\u7ecf\u8425\u8303\u56f4") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u7ecf\u8425\u8303\u56f4").getString("words"))) {
            res.put("businessRange", (Object)words);
        }
        if (wordsResult.has("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801").getString("words"))) {
            res.put("taxpayerNum", (Object)words);
        }
        if (wordsResult.has("\u5730\u5740") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u5730\u5740").getString("words"))) {
            res.put("address", (Object)words);
        }
        if (wordsResult.has("\u6cd5\u4eba") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u6cd5\u4eba").getString("words"))) {
            res.put("legalPerson", (Object)words);
        }
        if (wordsResult.has("\u6709\u6548\u671f") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u6709\u6548\u671f").getString("words")) && !"\u957f\u671f".equals(words)) {
            String timeOut = null;
            try {
                timeOut = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateFormatUtil.parseDate((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)words));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            res.put("timeOut", (Object)timeOut);
        }
        if (wordsResult.has("\u6210\u7acb\u65e5\u671f") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u6210\u7acb\u65e5\u671f").getString("words"))) {
            String registerDate = null;
            try {
                registerDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateFormatUtil.parseDate((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)words));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            res.put("registerDate", (Object)registerDate);
        }
        res.put("ocrJsonStr", (Object)JSONObject.toJSONString((Object)wordsResult));
        return res;
    }

    public JSONObject getIdCardInfoFromBaidu(String imageUrl) {
        String words;
        org.json.JSONObject object = this.getClient().idcard(OuterInterface.getImageFromURL(imageUrl), "front", new HashMap());
        if (object.has("error_code")) {
            this.logger.error("\u8eab\u4efd\u8bc1\u8bc6\u522b\u5931\u8d25\uff01{}", (Object)JSONObject.toJSONString((Object)object));
            throw new BusinessException("\u8eab\u4efd\u8bc1\u8bc6\u522b\u5931\u8d25\uff01\u672a\u8bc6\u522b\u5230\u5185\u5bb9\uff0c\u8bf7\u786e\u8ba4\u60a8\u4e0a\u4f20\u4e86\u6e05\u6670\u7684\u8eab\u4efd\u8bc1\u7167\u7247\uff01");
        }
        JSONObject res = new JSONObject();
        int wordsResultNum = object.getInt("words_result_num");
        if (wordsResultNum == 0) {
            throw new BusinessException("\u8eab\u4efd\u8bc1\u8bc6\u522b\u5931\u8d25\uff01\u672a\u8bc6\u522b\u5230\u5185\u5bb9\uff0c\u8bf7\u786e\u8ba4\u60a8\u4e0a\u4f20\u4e86\u6e05\u6670\u7684\u8eab\u4efd\u8bc1\u7167\u7247\uff01");
        }
        org.json.JSONObject wordsResult = object.getJSONObject("words_result");
        if (wordsResult.has("\u59d3\u540d") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u59d3\u540d").getString("words"))) {
            res.put("name", (Object)words);
        }
        if (wordsResult.has("\u516c\u6c11\u8eab\u4efd\u53f7\u7801") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u516c\u6c11\u8eab\u4efd\u53f7\u7801").getString("words"))) {
            res.put("taxpayerNum", (Object)words);
        }
        if (wordsResult.has("\u4f4f\u5740") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u4f4f\u5740").getString("words"))) {
            res.put("address", (Object)words);
        }
        if (wordsResult.has("\u59d3\u540d") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u59d3\u540d").getString("words"))) {
            res.put("legalPerson", (Object)words);
        }
        if (wordsResult.has("\u5931\u6548\u65e5\u671f") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u5931\u6548\u65e5\u671f").getString("words")) && !"\u957f\u671f".equals(words)) {
            String timeOut = null;
            try {
                timeOut = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateFormatUtil.parseDate((String)"yyyyMMdd", (String)words));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            res.put("timeOut", (Object)timeOut);
        }
        if (wordsResult.has("\u51fa\u751f") && !"\u65e0".equals(words = wordsResult.getJSONObject("\u51fa\u751f").getString("words"))) {
            String registerDate = null;
            try {
                registerDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateFormatUtil.parseDate((String)"yyyyMMdd", (String)words));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            res.put("registerDate", (Object)registerDate);
        }
        res.put("ocrJsonStr", (Object)JSONObject.toJSONString((Object)wordsResult));
        return res;
    }

    private static byte[] getImageFromURL(String urlPath) {
        byte[] data = null;
        InputStream is = null;
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlPath);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoInput(true);
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(6000);
            is = conn.getInputStream();
            data = conn.getResponseCode() == 200 ? OuterInterface.readInputStream(is) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8425\u4e1a\u6267\u7167\u8bc6\u522b\u5931\u8d25\uff01");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            conn.disconnect();
        }
        return data;
    }

    private static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    public boolean checkEnterpriseFromQcc(String name, String code) {
        String reqInterNme = "http://api.qichacha.com/ECITwoElVerify/GetInfo";
        String paramStr = "creditCode=" + code + "&verifyName=" + name + "&verifyType=1";
        try {
            HttpHead reqHeader = new HttpHead();
            String[] autherHeader = this.randomAuthentHeader();
            reqHeader.setHeader("Token", autherHeader[0]);
            reqHeader.setHeader("Timespan", autherHeader[1]);
            String reqUri = reqInterNme.concat("?key=").concat(this.qichachaKey).concat("&").concat(paramStr);
            String tokenJson = HttpHelper.httpGet(reqUri, reqHeader.getAllHeaders());
            JSONObject res = this.formatJson(tokenJson);
            if (res.getInteger("Status") == 200) {
                if (res.getJSONObject("Result").getInteger("VerifyResult") == 1) {
                    return true;
                }
                if (res.getJSONObject("Result").getInteger("VerifyResult") == 0) {
                    throw new BusinessException("\u4f01\u4e1a\u6821\u9a8c\u5931\u8d25\uff01\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u6709\u8bef!");
                }
                throw new BusinessException("\u4f01\u4e1a\u6821\u9a8c\u5931\u8d25\uff01\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u548c\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4!");
            }
            throw new BusinessException("\u4f01\u4e1a\u6821\u9a8c\u5931\u8d25\uff01" + res.getString("Message"));
        }
        catch (Exception e1) {
            this.logger.error("\u4f01\u67e5\u67e5\u63a5\u53e3\u4f01\u4e1a\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)e1.getMessage());
            throw new BusinessException(e1.getMessage());
        }
    }

    protected final String[] randomAuthentHeader() {
        String timeSpan = String.valueOf(System.currentTimeMillis() / 1000L);
        return new String[]{DigestUtils.md5Hex((String)this.qichachaKey.concat(timeSpan).concat(this.qichachaSecretKey)).toUpperCase(), timeSpan};
    }

    protected JSONObject formatJson(String jsonString) throws JSONException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object obj = mapper.readValue(jsonString, Object.class);
            String indented = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            System.out.println("*****************indented====" + indented);
            return JSONObject.parseObject((String)indented);
        }
        catch (Exception e) {
            this.logger.error("\u4f01\u67e5\u67e5\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)jsonString);
            throw new BusinessException("\u4f01\u4e1a\u6821\u9a8c\u5931\u8d25\uff01\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\u683c\u5f0f\u4e0d\u5bf9\uff01");
        }
    }

    public boolean checkPersonFromAly(String name, String code) {
        String host = "http://checkone.market.alicloudapi.com";
        String path = "/chinadatapay/1882";
        String method = "POST";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + this.aliyunAppCode);
        headers.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        HashMap<String, String> querys = new HashMap<String, String>();
        HashMap<String, String> bodys = new HashMap<String, String>();
        bodys.put("idcard", code);
        bodys.put("name", name);
        try {
            this.logger.info("\u963f\u91cc\u6821\u9a8c\u8eab\u4efd\u4fe1\u606f\uff1ahost---{}, path---{}\uff0cbodys---{}", new Object[]{host, path, JSONObject.toJSONString(bodys)});
            HttpResponse response = HttpHelper.doPost(host, path, method, headers, querys, bodys);
            JSONObject res = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()));
            this.logger.info(name + "  " + code + "\u8eab\u4efd\u4fe1\u606f\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)res);
            if (res != null && res.getInteger("code") == 10000) {
                if (res.getJSONObject("data").getInteger("result") == 1) {
                    return true;
                }
                throw new BusinessException("\u8eab\u4efd\u8bc1\u4fe1\u606f\u672a\u6821\u9a8c\u901a\u8fc7\uff01");
            }
            throw new BusinessException("\u8eab\u4efd\u8bc1\u4fe1\u606f\u672a\u6821\u9a8c\u901a\u8fc7\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u8bc6\u522b\u51fa\u9519", (Throwable)e);
            e.printStackTrace();
            throw new BusinessException("\u8eab\u4efd\u8bc1\u4fe1\u606f\u672a\u6821\u9a8c\u901a\u8fc7\uff01");
        }
    }
}

