package com.ejianc.business.pro.supplier.service.impl;

import bsh.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.pro.supplier.vo.EvaluateHistoryVO;
import com.ejianc.business.pro.supplier.vo.ProcessVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.ProcessMapper;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.service.IProcessService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 事件评价
 * 
 * @author generator
 * 
 */
@Service("processService")
public class ProcessServiceImpl extends BaseServiceImpl<ProcessMapper, ProcessEntity> implements IProcessService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProcessMapper processMapper;
    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Override
    public List<EvaluateHistoryVO> queryHistoryList(Long supplyId) {
        return processMapper.queryHistoryList(supplyId);
    }

    @Override
    public CommonResponse<String> syncProcess(ProcessVO saveOrUpdateVO) {
        logger.info("i8传输-供应商事件评价-接收传参-saveOrUpdateVO" + JSONObject.toJSONString(saveOrUpdateVO));

        List<String> createDataCodeList = new ArrayList<>();
        List<Long> updateDataIdList = new ArrayList<>();
        List<String> updateDataCodeList = new ArrayList<>();



        if (StringUtils.isEmpty(saveOrUpdateVO.getUnitI8Code())){
            return CommonResponse.error("接口传输失败，i8单位编码未传值 ！");
        }
        List<ProcessEntity> processList = super.list(new QueryWrapper<ProcessEntity>().eq("unit_i8_code", saveOrUpdateVO.getUnitI8Code()));
        ProcessEntity processEntity = null;

        CommonResponse<List<SupplierDTO>> listCommonResponse = iProSupplierApi.selectByUnitCodeOrTaxPayerIdentifier(Arrays.asList(saveOrUpdateVO.getUnitI8Code()));
        if (!listCommonResponse.isSuccess()){
            return CommonResponse.error("为找对应i8单位编码供应商，请推送供应商后再做评价！");
        }
        SupplierDTO supplierDTO = listCommonResponse.getData().get(0);
        logger.info("查出对应供应商-----" + JSONObject.toJSONString(supplierDTO));

        if (CollectionUtils.isNotEmpty(processList) && processList.size() > 0){
            processEntity = processList.get(0);
            updateDataCodeList.add(saveOrUpdateVO.getCode());
            updateDataIdList.add(saveOrUpdateVO.getId());
        }else {
            processEntity = new ProcessEntity();
            processEntity.setId(IdWorker.getId());
            processEntity.setTenantId(999999L);

            //编号重复校验
            QueryWrapper<ProcessEntity> query = new QueryWrapper();
            query.eq("code", saveOrUpdateVO.getCode());
            List<ProcessEntity> billCodeEntityList = super.list(query);
            if(CollectionUtils.isNotEmpty(billCodeEntityList)) {
                return CommonResponse.error("保存失败，编码重复！");
            }

            processEntity.setCode(saveOrUpdateVO.getCode());
            createDataCodeList.add(saveOrUpdateVO.getCode());
        }

        processEntity.setProjectId(saveOrUpdateVO.getProjectId());
        processEntity.setProjectName(saveOrUpdateVO.getProjectName());
        processEntity.setContractId(saveOrUpdateVO.getContractId());
        processEntity.setContractCode(saveOrUpdateVO.getContractCode());
        processEntity.setContractName(saveOrUpdateVO.getContractName());

        processEntity.setSupplyId(supplierDTO.getId());
        processEntity.setSupplyName(supplierDTO.getSupplyTypeName());
//        processEntity.setSupplyId(saveOrUpdateVO.getSupplyId());
//        processEntity.setSupplyName(saveOrUpdateVO.getSupplyName());

        processEntity.setBuckleBranch(saveOrUpdateVO.getBuckleBranch());
        processEntity.setDate(saveOrUpdateVO.getDate());
        processEntity.setUnitI8Code(saveOrUpdateVO.getUnitI8Code());
        processEntity.setI8Url(saveOrUpdateVO.getI8Url());

        processEntity.setBillState(1);
        processEntity.setSourceType("i8");

        processEntity.setSupplyQueryType(supplierDTO.getSupplyQueryType());
        super.saveOrUpdate(processEntity, false);


        logger.info("i8传输-供应商事件评价-保存成功-saveOrUpdateVO");
        return CommonResponse.success("保存或修改单据成功！");
    }
}
