package com.ejianc.business.pro.supplier.controller;

import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupHisPerformanceVO;
import com.ejianc.business.pro.supplier.bean.HistoryEntity;
import com.ejianc.business.pro.supplier.bean.PunishEntity;
import com.ejianc.business.pro.supplier.service.IHistoryService;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.pro.supplier.service.ISubcontractProcessService;
import com.ejianc.business.pro.supplier.vo.EvaluateHistoryVO;
import com.ejianc.business.pro.supplier.vo.HistoryVO;
import com.ejianc.business.pro.supplier.vo.PunishVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author jxy
 * @version 1.0
 * @date 2022/1/11 14:38
 * 供应商企业历史&评价历史
 */
@Controller
@RequestMapping("evaluateHistory")
public class EvaluateHistoryController implements Serializable {
    @Autowired
    private IHistoryService historyService;

    @Autowired
    private IProcessService processService;

    @Autowired
    private IPunishService punishService;

    @Autowired
    private ISubcontractProcessService subcontractProcessService;

    @Autowired
    private IContractPoolApi contractPoolApi;

    /**
     * 查询(企业)历史评价记录
     * @param supplyId
     * @return
     */
    @RequestMapping(value = "/evaluate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<HistoryVO>> evaluateHistory(Long supplyId){
        QueryParam param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.EQ,supplyId));
        List<HistoryEntity> list =historyService.queryList(param);
        List<HistoryVO> successList = BeanMapper.mapList(list, HistoryVO.class);
        List<SupHisPerformanceVO> supHisPerformanceList = new ArrayList<>();
        CommonResponse<List<SupHisPerformanceVO>> commonResponse  =contractPoolApi.supHisPerformanceList(supplyId);
        if(commonResponse.isSuccess()){
            for(SupHisPerformanceVO sup:commonResponse.getData()){
                HistoryVO vo = new HistoryVO();
                vo.setContractName(sup.getContractName());
                vo.setContractCategoryName(sup.getContractCategoryName());
                vo.setEngineeringName(sup.getEngineeringName());
                vo.setContacts(sup.getContacts());
                vo.setContactsPhone(sup.getContactsPhone());
                vo.setContractMny(sup.getContractMny());
                vo.setCooperationContent(sup.getCooperationContent());
                vo.setEndDay(sup.getEndDay());
                vo.setStartDay(sup.getStartDay());
                vo.setEngineeringAddress(sup.getEngineeringAddress());
                vo.setCooperationOrg(sup.getCooperationOrg());
                vo.setId(IdWorker.getId());
                vo.setSupplierManagerName(sup.getSupplierManagerName());
                vo.setSupplierManagerLink(sup.getSupplierManagerLink());
                vo.setContractCategoryProperty(sup.getContractCategoryProperty());
                successList.add(vo);
            }
        }
        return CommonResponse.success("查询数据成功！",successList);
    }

    /**
     * 查询历史评价记录
     * @param supplyId
     * @return
     */
    @RequestMapping(value = "/history", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<EvaluateHistoryVO>> history(Long supplyId){
        List<EvaluateHistoryVO> list= processService.queryHistoryList(supplyId);
        return CommonResponse.success("查询数据成功！",list);
    }

    /**
     * 查询历史评价记录
     * @param supplyId
     * @return
     */
    @RequestMapping(value = "/subcontractHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<EvaluateHistoryVO>> subcontractHistory(Long supplyId,Long headUserId){
        List<EvaluateHistoryVO> list= subcontractProcessService.queryHistoryList(supplyId,headUserId);
        return CommonResponse.success("查询数据成功！",list);
    }

    /**
     * 查询(企业)历史评价记录
     * @return
     */
    @RequestMapping(value = "/subcontractEvaluate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<HistoryVO>> subcontractEvaluate(String headUserName){
        QueryParam param = new QueryParam();
        param.getParams().put("head_user_name",new Parameter(QueryParam.EQ,headUserName));
        List<HistoryEntity> list =historyService.queryList(param);
        List<HistoryVO> successList = BeanMapper.mapList(list, HistoryVO.class);

        return CommonResponse.success("查询数据成功！",successList);
    }

    /**
     * 查询处置记录
     * @param supplyId
     * @return
     */
    @RequestMapping(value = "/punish", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PunishVO>> supplierPunish(Long supplyId){
        QueryParam param = new QueryParam();
        param.getParams().put("supplyId",new Parameter(QueryParam.EQ,supplyId));
        List<PunishEntity> list =punishService.queryList(param);
        List<PunishVO> successList = BeanMapper.mapList(list, PunishVO.class);
        return CommonResponse.success("查询数据成功！",successList);
    }
    /**
     * 查询等级评价记录
     * @param supplyId
     * @return
     */
    @RequestMapping(value = "/upgrades", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PunishVO>> supplierUpgrades(Long supplyId){
        QueryParam param = new QueryParam();
        param.getParams().put("supplyId",new Parameter(QueryParam.EQ,supplyId));
        List<PunishEntity> list =punishService.queryList(param);
        List<PunishVO> successList = BeanMapper.mapList(list, PunishVO.class);
        return CommonResponse.success("查询数据成功！",successList);
    }

}
