package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.IncidentVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("pushProcessLogic")
public class PushProcessRuleALogic implements PushProcessLogic {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "INCIDENT";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;

    @Override
    public List<IncidentVO> logicOne(AppraiseParamVO appraiseParamVO) {
        List<ContractPoolVO> pushProcessList = new ArrayList<>();
        List<IncidentVO> processList = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ,
                ContractPerformanceStateEnum.履约中.getStateCode()));
        String contractType = appraiseParamVO.getContractType();
        if (StringUtils.isNotEmpty(contractType)){
            List<String> contractTypeList = new ArrayList<>();
            if ("materialEquipment".equals(contractType)){
                contractTypeList.add(ContractTypeEnum.物资采购合同.getTypeCode());
                contractTypeList.add(ContractTypeEnum.设备采购.getTypeCode());
                contractTypeList.add(ContractTypeEnum.设备租赁.getTypeCode());
                contractTypeList.add(ContractTypeEnum.混凝土合同.getTypeCode());
                contractTypeList.add(ContractTypeEnum.周转材合同.getTypeCode());
           }
           else if ("sub".equals(contractType)){
                contractTypeList.add(ContractTypeEnum.劳务分包合同.getTypeCode());
                contractTypeList.add(ContractTypeEnum.专业分包合同.getTypeCode());
           }
           else if ("other".equals(contractType)){
                contractTypeList.add(ContractTypeEnum.其他支出.getTypeCode());
           }
            queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN,contractTypeList ));
        }
//        queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN,
//                Arrays.asList(new String[]{ContractTypeEnum.设备采购.getTypeCode(), ContractTypeEnum.设备租赁.getTypeCode(),ContractTypeEnum.混凝土合同.getTypeCode(),
//                        ContractTypeEnum.物资采购合同.getTypeCode(), ContractTypeEnum.周转材合同.getTypeCode(),ContractTypeEnum.劳务分包合同.getTypeCode(),ContractTypeEnum.专业分包合同.getTypeCode(),ContractTypeEnum.其他支出.getTypeCode()})));
        CommonResponse<List<ContractPoolVO>> listCommonResponse = contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()) {
            List<ContractPoolVO> contractPoolVOList = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(contractPoolVOList)) {
                //逻辑一 条件一: 合同金额大于设置的金额
                BigDecimal contractMny = appraiseParamVO.getContractMny();
                //设置的金额 单位为万元
                BigDecimal setContractMny = ComputeUtil.safeMultiply(contractMny, new BigDecimal(10000));
                List<ContractPoolVO> contractList =
                        contractPoolVOList.stream().filter(s->s.getContractTaxMny()!=null).filter(s -> (s.getContractTaxMny().compareTo(setContractMny) != -1)).collect(Collectors.toList());
                Map<Long, ContractPoolVO> contractPoolMap =
                        contractList.stream().collect(Collectors.toMap(k -> k.getId(), (k) -> k));
                if (CollectionUtils.isNotEmpty(contractList)) {
                    List<Long> contractIds =
                            contractList.stream().map(ContractPoolVO::getId).collect(Collectors.toList());
                    //逻辑一 条件二: 合同结算金额大于合同金额
                    QueryParam settleQueryParam = new QueryParam();
                    settleQueryParam.getParams().put("contractId", new Parameter(QueryParam.IN, contractIds));
                    CommonResponse<List<SettlePoolVO>> settleCommonResponse = settlePoolApi.queryList(settleQueryParam);
                    if (settleCommonResponse.isSuccess()) {
                        List<SettlePoolVO> settlePoolList = settleCommonResponse.getData();
                        if (CollectionUtils.isNotEmpty(settlePoolList)) {
                            Map<Long, BigDecimal> settlePoolMap = settlePoolList.stream().filter(s->s.getContractId()!=null).
                                    collect(Collectors.groupingBy(SettlePoolVO::getContractId,
                                            Collectors.reducing(BigDecimal.ZERO, SettlePoolVO::getCurTaxMny,
                                                    BigDecimal::add)));
                            Set<Long> contractIdSet = settlePoolMap.keySet();
                            for (Long contractId : contractIdSet) {
                                //合同金额 添加
                                BigDecimal contractTaxMny = contractPoolMap.get(contractId).getContractTaxMny();
                                //结算金额
                                BigDecimal settleTaxMny = settlePoolMap.get(contractId);
                                //建百分比转成小数
                                BigDecimal settleContractRatio =
                                        ComputeUtil.safeDiv(appraiseParamVO.getSettleContractRatio(),
                                        new BigDecimal(100));
                                BigDecimal settleContractMny = ComputeUtil.safeMultiply(contractTaxMny,
                                        settleContractRatio);
                                //结算金额 大于 合同金额
                                if (settleTaxMny.compareTo(settleContractMny) != -1) {
                                    pushProcessList.add(contractPoolMap.get(contractId));
                                }
                            }
                            List<Long> pushProcessContractIds =
                                    pushProcessList.stream().map(ContractPoolVO::getId).collect(Collectors.toList());

                            logger.info("满足调度参数合同Id列表：{}", JSONObject.toJSONString(pushProcessContractIds));

                            //没有满足两个条件 返回 null
                            if (CollectionUtils.isEmpty(pushProcessContractIds)) {
                                return null;
                            }
                            QueryParam queryIncidentParam = new QueryParam();
                            queryIncidentParam.getParams().put("contractId", new Parameter(QueryParam.IN,
                                    pushProcessContractIds));
                            queryIncidentParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ,
                                    ContractPerformanceStateEnum.履约中.getStateCode()));
                            List<IncidentEntity> incidentEntities = incidentService.queryList(queryIncidentParam, false);

                            logger.info("根据合同Id查询出合同对应过程评价数量：", incidentEntities.size());

                            //在一个逻辑中一个履约中合同只能存在一个过程评价
                            //1:合同id 和过程评价的数量相等 这些合同id 全部做过程评价
                            if (incidentEntities.size() == pushProcessContractIds.size()) {
                                return null;
                            }
                            //这些合同id 没有做过工程评价
                            PushProcessRuleALogic pushProcessRuleALogic = new PushProcessRuleALogic();
                            if (incidentEntities.size() == 0) {
                                processList = pushProcessRuleALogic.getProcessList(pushProcessList, null,userApi,billCodeApi,sessionManager);
                                return processList;
                            }
                            //找出没有做过程结算的合同
                            Map<Long, List<IncidentEntity>> map =
                                    incidentEntities.stream().collect(Collectors.groupingBy(IncidentEntity::getContractId));
                            processList = pushProcessRuleALogic.getProcessList(pushProcessList, map,userApi,billCodeApi,sessionManager);
                            return processList;
                        }
                    }
                }
            }
        } else {
            logger.error("供应商过程评价逻辑一：查询合同列表失败, {}", JSONObject.toJSONString(listCommonResponse));
        }
        return processList;
    }

    @Override
    public List<IncidentVO> logicTwo(AppraiseParamVO appraiseParamVO) {
        List<IncidentVO> processList = new ArrayList<>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ,
                ContractPerformanceStateEnum.已终止.getStateCode()));
        String contractType = appraiseParamVO.getContractType();
        if (StringUtils.isNotEmpty(contractType)){
            List<String> contractTypeList = new ArrayList<>();
            if ("materialEquipment".equals(contractType)){
                contractTypeList.add(ContractTypeEnum.物资采购合同.getTypeCode());
                contractTypeList.add(ContractTypeEnum.设备采购.getTypeCode());
                contractTypeList.add(ContractTypeEnum.设备租赁.getTypeCode());
                contractTypeList.add(ContractTypeEnum.混凝土合同.getTypeCode());
                contractTypeList.add(ContractTypeEnum.周转材合同.getTypeCode());
            }
            else if ("sub".equals(contractType)){
                contractTypeList.add(ContractTypeEnum.劳务分包合同.getTypeCode());
                contractTypeList.add(ContractTypeEnum.专业分包合同.getTypeCode());
            }
            else if ("other".equals(contractType)){
                contractTypeList.add(ContractTypeEnum.其他支出.getTypeCode());
            }
            queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN,contractTypeList ));
        }
//        queryParam.getParams().put("sourceType", new Parameter(QueryParam.IN,
//                Arrays.asList(new String[]{ContractTypeEnum.设备采购.getTypeCode(), ContractTypeEnum.设备租赁.getTypeCode(),ContractTypeEnum.混凝土合同.getTypeCode(),
//                        ContractTypeEnum.物资采购合同.getTypeCode(), ContractTypeEnum.周转材合同.getTypeCode(),ContractTypeEnum.劳务分包合同.getTypeCode(),ContractTypeEnum.专业分包合同.getTypeCode(),ContractTypeEnum.其他支出.getTypeCode()})));
        CommonResponse<List<ContractPoolVO>> listCommonResponse = contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()) {
            List<ContractPoolVO> contractPoolVOList = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(contractPoolVOList)) {
                List<Long> contractPoolIds =
                        contractPoolVOList.stream().map(ContractPoolVO::getId).collect(Collectors.toList());
                QueryParam queryIncidentParam = new QueryParam();
                queryIncidentParam.getParams().put("contractId", new Parameter(QueryParam.IN, contractPoolIds));
                queryIncidentParam.getParams().put("performanceStatus", new Parameter(QueryParam.EQ,
                        ContractPerformanceStateEnum.已终止.getStateCode()));
                List<IncidentEntity> incidentEntities = incidentService.queryList(queryIncidentParam, false);
                //找出没有做过程评价的
                PushProcessRuleALogic pushProcessRuleALogic = new PushProcessRuleALogic();
                if (incidentEntities.size() == 0) {
                    processList = pushProcessRuleALogic.getProcessList(contractPoolVOList, null,userApi,billCodeApi,sessionManager);
                    return processList;
                } else {
                    Map<Long, List<IncidentEntity>> map =
                            incidentEntities.stream().collect(Collectors.groupingBy(IncidentEntity::getContractId));
                    processList = pushProcessRuleALogic.getProcessList(contractPoolVOList, map,userApi,billCodeApi,sessionManager);
                    return processList;
                }
            }
        }
        return processList;
    }

    @Override
    public List<IncidentVO> getAnnualIncidentPushList(AppraiseParamVO appraiseParamVO, String startDate) {
        QueryParam queryParam = new QueryParam();
        //查询履约中、已冻结 的支出合同列表
        queryParam.getParams().put("performanceStatus", new Parameter(QueryParam.IN,
                new String[]{ContractPerformanceStateEnum.履约中.getStateCode(),
                        ContractPerformanceStateEnum.已冻结.getStateCode()}));
        queryParam.getParams().put("contractProperty", new Parameter(QueryParam.EQ, 0));
        CommonResponse<List<ContractPoolVO>> listCommonResponse = contractPoolApi.queryList(queryParam);
        if(!listCommonResponse.isSuccess()) {
            logger.error("获取履约中、已冻结的支出合同列表失败, {}", JSONObject.toJSONString(listCommonResponse));
            throw new BusinessException("获取履约中、已冻结的支出合同列表失败！");
        }
        List<ContractPoolVO> contractList = listCommonResponse.getData();
        if(CollectionUtils.isEmpty(contractList)) {
            logger.error("获取履约中、已冻结的支出合同列表为空");
            return null;
        }
        List<Long> pushProcessContractIds =
                contractList.stream().map(ContractPoolVO::getId).collect(Collectors.toList());


        String endDate = DateUtil.getYear() + "-" + appraiseParamVO.getYearPushDate();
        QueryWrapper<IncidentEntity> incidentQuery = new QueryWrapper<>();
        incidentQuery.select("distinct(contract_id)");
        incidentQuery.eq("dr", BaseVO.DR_UNDELETE);
        incidentQuery.in("contract_id", pushProcessContractIds);
        incidentQuery.ge("date_format(create_time,'%Y-%m-%d')", startDate);
        incidentQuery.le("date_format(create_time,'%Y-%m-%d')", endDate);
        List<Long> incidentIds = incidentService.listObjs(incidentQuery, (item) -> Long.valueOf(item.toString()));

        if(CollectionUtils.isNotEmpty(incidentIds)) {
            //排除掉已经存在过程评价的合同
            pushProcessContractIds.removeAll(incidentIds);
        }
        if(CollectionUtils.isEmpty(pushProcessContractIds)) {
            logger.info("排除掉已存在过程评价的合同,可推送过程评价合同列表为空，供应商过程评价年度推送任务结束。。。。");
            return null;
        }
        QueryWrapper<ProcessEntity> processQuery = new QueryWrapper<>();
        processQuery.select("distinct(contract_id)");
        processQuery.in("contract_id", pushProcessContractIds);
        processQuery.eq("dr", BaseVO.DR_UNDELETE);
        processQuery.in("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        processQuery.ge("date_format(create_time,'%Y-%m-%d')", startDate);
        processQuery.le("date_format(create_time,'%Y-%m-%d')", endDate);
        List<Long> processIds = incidentService.listObjs(incidentQuery, (item) -> Long.valueOf(item.toString()));
        if(CollectionUtils.isNotEmpty(processIds)) {
            //排除掉已经存在过程评价的合同
            pushProcessContractIds.removeAll(processIds);
        }
        if(CollectionUtils.isEmpty(pushProcessContractIds)) {
            logger.info("排除掉已存在生效事件评价的合同,可推送过程评价合同列表为空，供应商过程评价年度推送任务结束。。。。");
            return null;
        }


        return getAnnualIncidentList(contractList.stream().filter(item -> pushProcessContractIds.contains(item.getId())).collect(Collectors.toList()));
    }

    private List<IncidentVO> getAnnualIncidentList(List<ContractPoolVO> contractList) {
        List<IncidentVO> list = new ArrayList<>();
        IncidentVO incidentVO = null;

        CommonResponse<List<String>> billCodes = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,
                InvocationInfoProxy.getTenantid(), contractList.size());
        if (!billCodes.isSuccess()) {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        List<String> billCodeList = billCodes.getData();

        int billCodeIdx = 0;
        for(ContractPoolVO e : contractList) {
            incidentVO = new IncidentVO();
            incidentVO.setCode(billCodeList.get(billCodeIdx));
            incidentVO.setContractId(null != e.getContractId() ? e.getContractId() : e.getId());
            incidentVO.setPerformanceStatus(e.getPerformanceStatus());
            incidentVO.setStatus(0);
            incidentVO.setContractType(e.getSourceType());
            ContractTypeEnum contractTypeEnum = ContractTypeEnum.getByCode(e.getSourceType());
            if (contractTypeEnum!=null){
                String contractTypeName = ContractTypeEnum.getByCode(e.getSourceType()).getTypeName();
                incidentVO.setContractTypeName(contractTypeName);
            }
            incidentVO.setContractName(e.getContractName());
            incidentVO.setContractCode(e.getContractCode());
            incidentVO.setProjectId(e.getProjectId());
            incidentVO.setProjectName(e.getProjectName());
            incidentVO.setContractAmount(e.getContractTaxMny());
            incidentVO.setSupplyId(e.getPartybId());
            incidentVO.setSupplyName(e.getPartybName());
            String supplyQueryType = SupplyQueryTypeUtil.get("RULE_A", e.getSourceType());
            incidentVO.setSupplyQueryType(supplyQueryType);
            incidentVO.setOrgId(e.getOrgId());
            incidentVO.setOrgName(e.getOrgName());
            incidentVO.setOrgCode(e.getOrgCode());
            incidentVO.setParentOrgId(e.getParentOrgId());
            incidentVO.setParentOrgName(e.getParentOrgName());
            incidentVO.setParentOrgCode(e.getParentOrgCode());
            incidentVO.setDate(new Date());
            incidentVO.setBuckleBranch(BigDecimal.ZERO);
            incidentVO.setSource("定时推送");
            incidentVO.setHeadUserId(e.getSupplierProjectManagerId());
            incidentVO.setHeadUserName(e.getSupplierProjectManagerName());
            list.add(incidentVO);
            billCodeIdx++;
        }

        return list;
    }

    public   List<IncidentVO> getProcessList(List<ContractPoolVO> pushProcessList,  Map<Long, List<IncidentEntity>> map, IUserApi userApi,IBillCodeApi billCodeApi,SessionManager sessionManager) {
        List<IncidentVO> list = new ArrayList<>();
        pushProcessList.forEach(e -> {
            if (map == null) {
                IncidentVO incidentVO = new IncidentVO();
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,
                        InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {
                    incidentVO.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                incidentVO.setContractId(null != e.getContractId() ? e.getContractId() : e.getId());
                incidentVO.setPerformanceStatus(e.getPerformanceStatus());
                incidentVO.setStatus(0);
                incidentVO.setContractType(e.getSourceType());
                incidentVO.setContractName(e.getContractName());
                incidentVO.setContractCode(e.getContractCode());
                ContractTypeEnum contractTypeEnum = ContractTypeEnum.getByCode(e.getSourceType());
                if (contractTypeEnum!=null){
                    String contractTypeName = ContractTypeEnum.getByCode(e.getSourceType()).getTypeName();
                    incidentVO.setContractTypeName(contractTypeName);
                }
                incidentVO.setProjectId(e.getProjectId());
                incidentVO.setProjectName(e.getProjectName());
                incidentVO.setContractAmount(e.getContractTaxMny());
                incidentVO.setSupplyId(e.getPartybId());
                incidentVO.setSupplyName(e.getPartybName());
                String supplyQueryType = SupplyQueryTypeUtil.get("RULE_A", e.getSourceType());
                incidentVO.setSupplyQueryType(supplyQueryType);
                incidentVO.setOrgId(e.getOrgId());
                incidentVO.setOrgName(e.getOrgName());
                incidentVO.setOrgCode(e.getOrgCode());
                incidentVO.setParentOrgId(e.getParentOrgId());
                incidentVO.setParentOrgName(e.getParentOrgName());
                incidentVO.setParentOrgCode(e.getParentOrgCode());
//                incidentVO.setCheckOrgId(e.getOrgId());
//                incidentVO.setCheckOrgName(e.getOrgName());
                incidentVO.setDate(new Date());
                incidentVO.setBuckleBranch(BigDecimal.ZERO);
                if (e.getPerformanceStatus().equals(ContractPerformanceStateEnum.已终止.getStateCode())){
                    incidentVO.setSource("最终结算");
                }else {
                    incidentVO.setSource("定时推送");
                }
                incidentVO.setHeadUserId(e.getSupplierProjectManagerId());
                incidentVO.setHeadUserName(e.getSupplierProjectManagerName());
                list.add(incidentVO);
            } else {
                if (!map.containsKey(null != e.getContractId() ? e.getContractId() : e.getId())) {
                    IncidentVO incidentVO = new IncidentVO();
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,
                            InvocationInfoProxy.getTenantid());
                    if (billCode.isSuccess()) {
                        incidentVO.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                    } else {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    incidentVO.setContractId(null != e.getContractId() ? e.getContractId() : e.getId());
                    incidentVO.setPerformanceStatus(e.getPerformanceStatus());
                    incidentVO.setStatus(0);
                    incidentVO.setContractType(e.getSourceType());
                    ContractTypeEnum contractTypeEnum = ContractTypeEnum.getByCode(e.getSourceType());
                    if (contractTypeEnum!=null){
                        String contractTypeName = ContractTypeEnum.getByCode(e.getSourceType()).getTypeName();
                        incidentVO.setContractTypeName(contractTypeName);
                    }
                    incidentVO.setContractName(e.getContractName());
                    incidentVO.setContractCode(e.getContractCode());
                    incidentVO.setProjectId(e.getProjectId());
                    incidentVO.setProjectName(e.getProjectName());
                    incidentVO.setContractAmount(e.getContractTaxMny());
                    incidentVO.setSupplyId(e.getPartybId());
                    incidentVO.setSupplyName(e.getPartybName());
                    String supplyQueryType = SupplyQueryTypeUtil.get("RULE_A", e.getSourceType());
                    incidentVO.setSupplyQueryType(supplyQueryType);
//                    incidentVO.setCheckOrgId(e.getOrgId());
//                    incidentVO.setCheckOrgName(e.getOrgName());
                    incidentVO.setOrgId(e.getOrgId());
                    incidentVO.setOrgName(e.getOrgName());
                    incidentVO.setOrgCode(e.getOrgCode());
                    incidentVO.setParentOrgId(e.getParentOrgId());
                    incidentVO.setParentOrgName(e.getParentOrgName());
                    incidentVO.setParentOrgCode(e.getParentOrgCode());
                    incidentVO.setDate(new Date());
                    incidentVO.setBuckleBranch(BigDecimal.ZERO);
                    if (e.getPerformanceStatus().equals(ContractPerformanceStateEnum.已终止.getStateCode())){
                        incidentVO.setSource("最终结算");
                    }else {
                        incidentVO.setSource("定时推送");
                    }
                    incidentVO.setHeadUserId(e.getSupplierProjectManagerId());
                    incidentVO.setHeadUserName(e.getSupplierProjectManagerName());
                    list.add(incidentVO);
                }
            }
        });
        return list;
    }
}
