/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.supplier.bean.SupplierGroupEntity;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.service.ISupplierGroupService;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.vo.ProcessVO;
import com.ejianc.business.pro.supplier.vo.SupplierGroupVO;
import com.ejianc.business.pro.supplier.vo.YearVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sync"})
public class SyncI8Controller
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProcessService processService;
    @Autowired
    private IYearService yearService;
    @Autowired
    private ISupplierGroupService supplierGroupService;
    @Autowired
    IProSupplierApi proSupplierApi;

    @RequestMapping(value={"/syncSupplierGroup"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncSupplierGroup(@RequestBody List<SupplierGroupVO> saveOrUpdateVOs) {
        return this.supplierGroupService.syncSupplierGroup(saveOrUpdateVOs);
    }

    @RequestMapping(value={"/syncSupplierGroupDelete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncSupplierGroupDelete(@RequestBody List<SupplierGroupVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            List supplierGroupList = this.supplierGroupService.list((Wrapper)new QueryWrapper().in((Object)"code", (Collection)vos.stream().map(SupplierGroupVO::getCode).collect(Collectors.toList())));
            for (SupplierGroupEntity entity : supplierGroupList) {
                CommonResponse supplierVOCommonResponse = this.proSupplierApi.selectBySupplierGroupId(entity.getId());
                if (!supplierVOCommonResponse.isSuccess() || ((SupplierVO)supplierVOCommonResponse.getData()).getId() <= 0L) continue;
                return CommonResponse.error((String)("\u4f9b\u5e94\u5546" + entity.getName() + "\u5df2\u51c6\u5165\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
            }
            this.supplierGroupService.removeByIds(supplierGroupList.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/syncProcess"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncProcess(@RequestBody ProcessVO saveOrUpdateVO) {
        return this.processService.syncProcess(saveOrUpdateVO);
    }

    @RequestMapping(value={"/syncProcessDelete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncProcessDelete(@RequestBody ProcessVO saveOrUpdateVO) {
        return CommonResponse.error((String)"\u5df2\u6709\u4e0b\u6e38\u4e1a\u52a1\uff0c\u4e0d\u53ef\u5220\u9664\uff01");
    }

    @RequestMapping(value={"/syncYear"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncYear(@RequestBody YearVO saveOrUpdateVO) {
        return this.yearService.syncYear(saveOrUpdateVO);
    }

    @RequestMapping(value={"/syncYearDelete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncYearDelete(@RequestBody YearVO saveOrUpdateVO) {
        return CommonResponse.error((String)"\u5df2\u6709\u4e0b\u6e38\u4e1a\u52a1\uff0c\u4e0d\u53ef\u5220\u9664\uff01");
    }
}

