package com.ejianc.business.pro.supplier.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包供应商事件评价
 * 
 * @author generator
 * 
 */
 @TableName("ejc_pro_supplier_process")
public class SubcontractProcessEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private String code; // 单据编码
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value = "contract_code")
    private String contractCode; //合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_type_name")
    private String contractTypeName; // 
    @TableField(value="contract_type")
    private String contractType; // 合同类型
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_amount")
    private BigDecimal contractAmount; // 合同金额
    @TableField(value="supply_id")
    private Long supplyId; // 供应商id
    @TableField(value="supply_name")
    private String supplyName; // 供应商名称
    @TableField(value="source")
    private String source; // 评价来源
    @TableField(value="check_org_id")
    private Long checkOrgId; // 考核单位id
    @TableField(value="check_org_name")
    private String checkOrgName; // 考核单位名称
    @TableField(value="buckle_branch")
    private BigDecimal buckleBranch; // 
    @TableField(value="date")
    private Date date; // 评价时间
    @TableField(value="process_id")
    private Long processId; // 经办人id
    @TableField(value="process")
    private String process; // 经办人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="create_user_id")
    private Long createUserId; // 评价人id
    @TableField(value="create_user_name")
    private String createUserName; // 评价人名称
    @TableField(value="phone")
    private String phone; // 评价人手机
    @TableField(value="head_user_name")
    private String headUserName;//分包负责人
    @TableField(value="head_user_id")
    private Long headUserId;//分包负责人id
    @TableField(value="subcontract_type_id")
    private Long subcontractTypeId;
    @TableField(value="subcontract_type_name")
    private String subcontractTypeName;
    @TableField(value="total_buckle")
    private BigDecimal totalBuckle;
    @TableField(value="supply_query_type")
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    @TableField(exist=false)
    @SubEntity(serviceName="processContentService")
    private List<ProcessContentEntity> processContentEntities = new ArrayList<>(); // 过程评价内容
    @TableField(value="org_id")
    private Long orgId; // 项目id
    @TableField(value="org_name")
    private String orgName; // 项目名称
    @TableField(value="org_code")
    private String orgCode; // 项目编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }
    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public Long getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }
    public Long getCheckOrgId() {
        return checkOrgId;
    }

    public void setCheckOrgId(Long checkOrgId) {
        this.checkOrgId = checkOrgId;
    }
    public String getCheckOrgName() {
        return checkOrgName;
    }

    public void setCheckOrgName(String checkOrgName) {
        this.checkOrgName = checkOrgName;
    }
    public BigDecimal getBuckleBranch() {
        return buckleBranch;
    }

    public void setBuckleBranch(BigDecimal buckleBranch) {
        this.buckleBranch = buckleBranch;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public Long getProcessId() {
        return processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }
    public String getProcess() {
        return process;
    }

    public void setProcess(String process) {
        this.process = process;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public List<ProcessContentEntity> getProcessContentEntities() {
        return processContentEntities;
    }

    public void setProcessContentEntities(List<ProcessContentEntity> processContentEntities) {
        this.processContentEntities = processContentEntities;
    }

    public String getHeadUserName() {
        return headUserName;
    }

    public void setHeadUserName(String headUserName) {
        this.headUserName = headUserName;
    }

    public Long getSubcontractTypeId() {
        return subcontractTypeId;
    }

    public void setSubcontractTypeId(Long subcontractTypeId) {
        this.subcontractTypeId = subcontractTypeId;
    }

    public String getSubcontractTypeName() {
        return subcontractTypeName;
    }

    public void setSubcontractTypeName(String subcontractTypeName) {
        this.subcontractTypeName = subcontractTypeName;
    }

    public BigDecimal getTotalBuckle() {
        return totalBuckle;
    }

    public void setTotalBuckle(BigDecimal totalBuckle) {
        this.totalBuckle = totalBuckle;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }

    public Long getHeadUserId() {
        return headUserId;
    }

    public void setHeadUserId(Long headUserId) {
        this.headUserId = headUserId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
}
