package com.ejianc.business.pro.supplier.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 分包供应商准入表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_pro_supplier_can_in")
public class SubcontractCanInEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private java.lang.String code; // 供应商编号
    @TableField(value="name")
    private java.lang.String name; // 供应商名称/个人姓名
    @TableField(value="supply_type")
    private java.lang.String supplyType; // 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
    @TableField(value="supply_type_name")
    private java.lang.String supplyTypeName; // 供方类别名称
    @TableField(value="personal")
    private java.lang.String personal; // 个人：p，企业：e
    @TableField(value="group_in_or_out")
    private java.lang.String groupInOrOut; // 集团内外：内in，外out
    @TableField(value="material_content_id")
    private java.lang.String materialContentId; // 物资供货内容id
    @TableField(value="material_content")
    private java.lang.String materialContent; // 物资供货内容名称
    @TableField(value="material_memo")
    private java.lang.String materialMemo; // 物资补充描述
    @TableField(value="equipment_content_id")
    private java.lang.String equipmentContentId; // 设备供货内容id
    @TableField(value="equipment_content")
    private java.lang.String equipmentContent; // 设备供货内容
    @TableField(value="equipment_memo")
    private java.lang.String equipmentMemo; // 设备补充描述
    @TableField(value="major_content_id")
    private java.lang.String majorContentId; // 专业分包供货内容id
    @TableField(value="major_content")
    private java.lang.String majorContent; // 专业分包供货内容
    @TableField(value="major_memo")
    private java.lang.String majorMemo; // 专业分包补充描述
    @TableField(value="labor_content_id")
    private java.lang.String laborContentId; // 劳务分包供货内容id
    @TableField(value="labor_content")
    private java.lang.String laborContent; // 劳务分包供货内容
    @TableField(value="labor_memo")
    private java.lang.String laborMemo; // 劳务分包补充描述
    @TableField(value="sub_content_id")
    private java.lang.String subContentId; // 分包班组供货内容id
    @TableField(value="sub_content")
    private java.lang.String subContent; // 分包班组供货内容
    @TableField(value="sub_memo")
    private java.lang.String subMemo; // 分包班组补充描述
    @TableField(value="other_content_id")
    private java.lang.String otherContentId; // 其他供货内容id
    @TableField(value="other_content")
    private java.lang.String otherContent; // 其他供货内容
    @TableField(value="other_memo")
    private java.lang.String otherMemo; // 其他补充描述
    @TableField(value="apply_org_name")
    private java.lang.String applyOrgName; // 申请单位
    @TableField(value="apply_org_id")
    private java.lang.Long applyOrgId; // 申请单位id
    @TableField(value="enterprise_nature")
    private java.lang.Long enterpriseNature; // 企业性质id
    @TableField(value="enterprise_nature_name")
    private java.lang.String enterpriseNatureName; // 企业性质名称

    @TableField(value="register_country_id")
    private java.lang.Long registerCountryId; // 注册国家id
    @TableField(value="register_country_name")
    private java.lang.String registerCountryName; // 注册国家名称

    @TableField(value="taxpayer_num")
    private java.lang.String taxpayerNum; // 纳税人识别号/身份证号
    @TableField(value="legal_person")
    private java.lang.String legalPerson; // 法人代表/别名
    @TableField(value="legal_phone")
    private java.lang.String legalPhone; // 法人电话/联系电话
    @TableField(value="area")
    private java.lang.String area; // 所在地区
    @TableField(value="area_name")
    private java.lang.String areaName; // 所在地区
    @TableField(value="in_or_out")
    private java.lang.Integer inOrOut; // 国内外：1国内，2国外
    @TableField(value="address")
    private java.lang.String address; // 公司地址
    @TableField(value="grade_id")
    private java.lang.Long gradeId; // 供应商等级
    @TableField(value="grade_name")
    private java.lang.String gradeName; // 供应商等级
    @TableField(value="business_range")
    private java.lang.String businessRange; // 经营范围
    @TableField(value="memo")
    private java.lang.String memo; // 准入说明
    @TableField(value="time_out")
    private java.util.Date timeOut; // 有效期
    @TableField(value="coordination")
    private Boolean coordination; // 是否协同
    @TableField(value="coordination_name")
    private java.lang.String coordinationName; // 协同姓名
    @TableField(value="coordination_phone")
    private java.lang.String coordinationPhone; // 协同手机号
    @TableField(value="register_date")
    private java.util.Date registerDate; // 注册日期
    @TableField(value="register_mny")
    private java.math.BigDecimal registerMny; // 注册资金
    @TableField(value="turnover")
    private java.math.BigDecimal turnover; // 年营业额
    @TableField(value="investigate")
    private java.lang.Boolean investigate; // 是否需要考察
    @TableField(value="has_investigate")
    private java.lang.Boolean hasInvestigate; // 是否考察
    @TableField(value="head_user_name")
    private String headUserName;//分包负责人
    @TableField(value="supply_query_type")
    private String supplyQueryType; // 查询供方列表时候使用的分类， 物资设备供应商：materialEquipment，劳务分包供应商：laborSub
    @TableField(exist=false)
    @SubEntity(serviceName="bankService")
    private List<BankEntity> banks = new ArrayList<>(); // 供应商准入---单位银行信息
    @TableField(exist=false)
    @SubEntity(serviceName="certsService")
    private List<CertsEntity> certs = new ArrayList<>(); // 供应商准入---证书
    @TableField(exist=false)
    @SubEntity(serviceName="historyService")
    private List<HistoryEntity> history = new ArrayList<>(); // 供应商准入---历史业绩
    @TableField(exist=false)
    @SubEntity(serviceName="subleadersService")
    private List<SubleadersEntity> subLeaders = new ArrayList<>(); // 供应商准入---分包供应商
    @TableField(exist=false)
    @SubEntity(serviceName="canInExpertService")
    private List<CanInExpertEntity> exportList = new ArrayList<>(); // 供应商准入---考察专家列表

    @TableField(value="business_person")
    private String businessPerson;	//业务代表
    @TableField(value="business_phone")
    private String businessPhone;	//业务代表电话
    @TableField(value="weight")
    private String weight; // 权重
    @TableField(value="main_business_category")
    private String mainBusinessCategory; // 主营类别
    @TableField(value="distributer_or_manufactor")
    private String distributerOrManufactor; // 厂家经销商
    @TableField(value="taxpayer_type")
    private String taxpayerType;//纳税人类型
    @TableField(value="billing_address")
    private String billingAddress;//开票地址
    @TableField(value="billing_phone")
    private String billingPhone;//开票电话
    @TableField(value="bank_account_id")
    private Long bankAccountId;//开票银行
    @TableField(value="bank_account_name")
    private String bankAccountName;//开票银行
    @TableField(value="bank_account_code")
    private String bankAccountCode;//开票银行账户

    @TableField(value="in_exception")
    private Boolean inException; // 是否拉黑
    @TableField(value="punish_type")
    private Long punishType; // 拉黑方式

    @TableField(value="unit_i8_code")
    private String unitI8Code; // I8单位编码
    @TableField(value="supplier_group_id")
    private Long supplierGroupId; // 集团供应商库来源id

    public String getUnitI8Code() {
        return unitI8Code;
    }

    public void setUnitI8Code(String unitI8Code) {
        this.unitI8Code = unitI8Code;
    }

    public Long getSupplierGroupId() {
        return supplierGroupId;
    }

    public void setSupplierGroupId(Long supplierGroupId) {
        this.supplierGroupId = supplierGroupId;
    }

    public Boolean getInException() {
        return inException;
    }

    public void setInException(Boolean inException) {
        this.inException = inException;
    }

    public Long getPunishType() {
        return punishType;
    }

    public void setPunishType(Long punishType) {
        this.punishType = punishType;
    }

    public List<CanInExpertEntity> getExportList() {
        return exportList;
    }

    public void setExportList(List<CanInExpertEntity> exportList) {
        this.exportList = exportList;
    }

    public String getTaxpayerType() {
        return taxpayerType;
    }

    public void setTaxpayerType(String taxpayerType) {
        this.taxpayerType = taxpayerType;
    }

    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String getBillingPhone() {
        return billingPhone;
    }

    public void setBillingPhone(String billingPhone) {
        this.billingPhone = billingPhone;
    }

    public Long getBankAccountId() {
        return bankAccountId;
    }

    public void setBankAccountId(Long bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public String getBankAccountName() {
        return bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName;
    }

    public String getBankAccountCode() {
        return bankAccountCode;
    }

    public void setBankAccountCode(String bankAccountCode) {
        this.bankAccountCode = bankAccountCode;
    }

    public String getMainBusinessCategory() {
        return mainBusinessCategory;
    }

    public void setMainBusinessCategory(String mainBusinessCategory) {
        this.mainBusinessCategory = mainBusinessCategory;
    }

    public String getDistributerOrManufactor() {
        return distributerOrManufactor;
    }

    public void setDistributerOrManufactor(String distributerOrManufactor) {
        this.distributerOrManufactor = distributerOrManufactor;
    }

    public String getBusinessPerson() {
        return businessPerson;
    }

    public void setBusinessPerson(String businessPerson) {
        this.businessPerson = businessPerson;
    }

    public String getBusinessPhone() {
        return businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 供应商编号
     */
    public java.lang.String getCode() {
        return code;
    }

    /**
     * 供应商编号
     */
    public void setCode(java.lang.String code) {
        this.code = code;
    }
    /**
     * 供应商名称/个人姓名
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 供应商名称/个人姓名
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }
    /**
     * 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
     */
    public java.lang.String getSupplyType() {
        return supplyType;
    }

    /**
     * 供方类别：专业分包：major，劳务分包：labor，分包班组：sub，材料：material，设备：equipment，其他：other
     */
    public void setSupplyType(java.lang.String supplyType) {
        this.supplyType = supplyType;
    }
    /**
     * 供方类别名称
     */
    public java.lang.String getSupplyTypeName() {
        return supplyTypeName;
    }

    /**
     * 供方类别名称
     */
    public void setSupplyTypeName(java.lang.String supplyTypeName) {
        this.supplyTypeName = supplyTypeName;
    }
    /**
     * 个人：p，企业：e
     */
    public java.lang.String getPersonal() {
        return personal;
    }

    /**
     * 个人：p，企业：e
     */
    public void setPersonal(java.lang.String personal) {
        this.personal = personal;
    }
    /**
     * 集团内外：内in，外out
     */
    public java.lang.String getGroupInOrOut() {
        return groupInOrOut;
    }

    /**
     * 集团内外：内in，外out
     */
    public void setGroupInOrOut(java.lang.String groupInOrOut) {
        this.groupInOrOut = groupInOrOut;
    }
    /**
     * 物资供货内容id
     */
    public java.lang.String getMaterialContentId() {
        return materialContentId;
    }

    /**
     * 物资供货内容id
     */
    public void setMaterialContentId(java.lang.String materialContentId) {
        this.materialContentId = materialContentId;
    }
    /**
     * 物资供货内容名称
     */
    public java.lang.String getMaterialContent() {
        return materialContent;
    }

    /**
     * 物资供货内容名称
     */
    public void setMaterialContent(java.lang.String materialContent) {
        this.materialContent = materialContent;
    }
    /**
     * 物资补充描述
     */
    public java.lang.String getMaterialMemo() {
        return materialMemo;
    }

    /**
     * 物资补充描述
     */
    public void setMaterialMemo(java.lang.String materialMemo) {
        this.materialMemo = materialMemo;
    }
    /**
     * 设备供货内容id
     */
    public java.lang.String getEquipmentContentId() {
        return equipmentContentId;
    }

    /**
     * 设备供货内容id
     */
    public void setEquipmentContentId(java.lang.String equipmentContentId) {
        this.equipmentContentId = equipmentContentId;
    }
    /**
     * 设备供货内容
     */
    public java.lang.String getEquipmentContent() {
        return equipmentContent;
    }

    /**
     * 设备供货内容
     */
    public void setEquipmentContent(java.lang.String equipmentContent) {
        this.equipmentContent = equipmentContent;
    }
    /**
     * 设备补充描述
     */
    public java.lang.String getEquipmentMemo() {
        return equipmentMemo;
    }

    /**
     * 设备补充描述
     */
    public void setEquipmentMemo(java.lang.String equipmentMemo) {
        this.equipmentMemo = equipmentMemo;
    }
    /**
     * 专业分包供货内容id
     */
    public java.lang.String getMajorContentId() {
        return majorContentId;
    }

    /**
     * 专业分包供货内容id
     */
    public void setMajorContentId(java.lang.String majorContentId) {
        this.majorContentId = majorContentId;
    }
    /**
     * 专业分包供货内容
     */
    public java.lang.String getMajorContent() {
        return majorContent;
    }

    /**
     * 专业分包供货内容
     */
    public void setMajorContent(java.lang.String majorContent) {
        this.majorContent = majorContent;
    }
    /**
     * 专业分包补充描述
     */
    public java.lang.String getMajorMemo() {
        return majorMemo;
    }

    /**
     * 专业分包补充描述
     */
    public void setMajorMemo(java.lang.String majorMemo) {
        this.majorMemo = majorMemo;
    }
    /**
     * 劳务分包供货内容id
     */
    public java.lang.String getLaborContentId() {
        return laborContentId;
    }

    /**
     * 劳务分包供货内容id
     */
    public void setLaborContentId(java.lang.String laborContentId) {
        this.laborContentId = laborContentId;
    }
    /**
     * 劳务分包供货内容
     */
    public java.lang.String getLaborContent() {
        return laborContent;
    }

    /**
     * 劳务分包供货内容
     */
    public void setLaborContent(java.lang.String laborContent) {
        this.laborContent = laborContent;
    }
    /**
     * 劳务分包补充描述
     */
    public java.lang.String getLaborMemo() {
        return laborMemo;
    }

    /**
     * 劳务分包补充描述
     */
    public void setLaborMemo(java.lang.String laborMemo) {
        this.laborMemo = laborMemo;
    }
    /**
     * 分包班组供货内容id
     */
    public java.lang.String getSubContentId() {
        return subContentId;
    }

    /**
     * 分包班组供货内容id
     */
    public void setSubContentId(java.lang.String subContentId) {
        this.subContentId = subContentId;
    }
    /**
     * 分包班组供货内容
     */
    public java.lang.String getSubContent() {
        return subContent;
    }

    /**
     * 分包班组供货内容
     */
    public void setSubContent(java.lang.String subContent) {
        this.subContent = subContent;
    }
    /**
     * 分包班组补充描述
     */
    public java.lang.String getSubMemo() {
        return subMemo;
    }

    /**
     * 分包班组补充描述
     */
    public void setSubMemo(java.lang.String subMemo) {
        this.subMemo = subMemo;
    }
    /**
     * 其他供货内容id
     */
    public java.lang.String getOtherContentId() {
        return otherContentId;
    }

    /**
     * 其他供货内容id
     */
    public void setOtherContentId(java.lang.String otherContentId) {
        this.otherContentId = otherContentId;
    }
    /**
     * 其他供货内容
     */
    public java.lang.String getOtherContent() {
        return otherContent;
    }

    /**
     * 其他供货内容
     */
    public void setOtherContent(java.lang.String otherContent) {
        this.otherContent = otherContent;
    }
    /**
     * 其他补充描述
     */
    public java.lang.String getOtherMemo() {
        return otherMemo;
    }

    /**
     * 其他补充描述
     */
    public void setOtherMemo(java.lang.String otherMemo) {
        this.otherMemo = otherMemo;
    }
    /**
     * 申请单位
     */
    public java.lang.String getApplyOrgName() {
        return applyOrgName;
    }

    /**
     * 申请单位
     */
    public void setApplyOrgName(java.lang.String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    /**
     * 申请单位id
     */
    public java.lang.Long getApplyOrgId() {
        return applyOrgId;
    }

    /**
     * 申请单位id
     */
    public void setApplyOrgId(java.lang.Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    /**
     * 企业性质id
     */
    public java.lang.Long getEnterpriseNature() {
        return enterpriseNature;
    }

    /**
     * 企业性质id
     */
    public void setEnterpriseNature(java.lang.Long enterpriseNature) {
        this.enterpriseNature = enterpriseNature;
    }
    /**
     * 企业性质名称
     */
    public java.lang.String getEnterpriseNatureName() {
        return enterpriseNatureName;
    }

    /**
     * 企业性质名称
     */
    public void setEnterpriseNatureName(java.lang.String enterpriseNatureName) {
        this.enterpriseNatureName = enterpriseNatureName;
    }

    public Long getRegisterCountryId() {
        return registerCountryId;
    }

    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }

    public String getRegisterCountryName() {
        return registerCountryName;
    }

    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }

    /**
     * 纳税人识别号/身份证号
     */
    public java.lang.String getTaxpayerNum() {
        return taxpayerNum;
    }

    /**
     * 纳税人识别号/身份证号
     */
    public void setTaxpayerNum(java.lang.String taxpayerNum) {
        this.taxpayerNum = taxpayerNum;
    }
    /**
     * 法人代表/别名
     */
    public java.lang.String getLegalPerson() {
        return legalPerson;
    }

    /**
     * 法人代表/别名
     */
    public void setLegalPerson(java.lang.String legalPerson) {
        this.legalPerson = legalPerson;
    }
    /**
     * 法人电话/联系电话
     */
    public java.lang.String getLegalPhone() {
        return legalPhone;
    }

    /**
     * 法人电话/联系电话
     */
    public void setLegalPhone(java.lang.String legalPhone) {
        this.legalPhone = legalPhone;
    }
    /**
     * 所在地区
     */
    public java.lang.String getArea() {
        return area;
    }

    /**
     * 所在地区
     */
    public void setArea(java.lang.String area) {
        this.area = area;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    /**
     * 国内外：1国内，2国外
     */
    public java.lang.Integer getInOrOut() {
        return inOrOut;
    }

    /**
     * 国内外：1国内，2国外
     */
    public void setInOrOut(java.lang.Integer inOrOut) {
        this.inOrOut = inOrOut;
    }
    /**
     * 公司地址
     */
    public java.lang.String getAddress() {
        return address;
    }

    /**
     * 公司地址
     */
    public void setAddress(java.lang.String address) {
        this.address = address;
    }
    /**
     * 供应商等级
     */
    public java.lang.Long getGradeId() {
        return gradeId;
    }

    /**
     * 供应商等级
     */
    public void setGradeId(java.lang.Long gradeId) {
        this.gradeId = gradeId;
    }
    /**
     * 供应商等级
     */
    public java.lang.String getGradeName() {
        return gradeName;
    }

    /**
     * 供应商等级
     */
    public void setGradeName(java.lang.String gradeName) {
        this.gradeName = gradeName;
    }
    /**
     * 经营范围
     */
    public java.lang.String getBusinessRange() {
        return businessRange;
    }

    /**
     * 经营范围
     */
    public void setBusinessRange(java.lang.String businessRange) {
        this.businessRange = businessRange;
    }
    /**
     * 准入说明
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 准入说明
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }
    /**
     * 有效期
     */
    public java.util.Date getTimeOut() {
        return timeOut;
    }

    /**
     * 有效期
     */
    public void setTimeOut(java.util.Date timeOut) {
        this.timeOut = timeOut;
    }
    /**
     * 是否协同
     */
    public Boolean getCoordination() {
        return coordination;
    }

    /**
     * 是否协同
     */
    public void setCoordination(Boolean coordination) {
        this.coordination = coordination;
    }
    /**
     * 协同姓名
     */
    public java.lang.String getCoordinationName() {
        return coordinationName;
    }

    /**
     * 协同姓名
     */
    public void setCoordinationName(java.lang.String coordinationName) {
        this.coordinationName = coordinationName;
    }
    /**
     * 协同手机号
     */
    public java.lang.String getCoordinationPhone() {
        return coordinationPhone;
    }

    /**
     * 协同手机号
     */
    public void setCoordinationPhone(java.lang.String coordinationPhone) {
        this.coordinationPhone = coordinationPhone;
    }

    public Boolean getInvestigate() {
        return investigate;
    }

    public void setInvestigate(Boolean investigate) {
        this.investigate = investigate;
    }

    public Boolean getHasInvestigate() {
        return hasInvestigate;
    }

    public void setHasInvestigate(Boolean hasInvestigate) {
        this.hasInvestigate = hasInvestigate;
    }

    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }

    public BigDecimal getRegisterMny() {
        return registerMny;
    }

    public void setRegisterMny(BigDecimal registerMny) {
        this.registerMny = registerMny;
    }

    public BigDecimal getTurnover() {
        return turnover;
    }

    public void setTurnover(BigDecimal turnover) {
        this.turnover = turnover;
    }

    public List<BankEntity> getBanks() {
        return banks;
    }

    public void setBanks(List<BankEntity> banks) {
        this.banks = banks;
    }

    public List<CertsEntity> getCerts() {
        return certs;
    }

    public void setCerts(List<CertsEntity> certs) {
        this.certs = certs;
    }

    public List<HistoryEntity> getHistory() {
        return history;
    }

    public void setHistory(List<HistoryEntity> history) {
        this.history = history;
    }

    public List<SubleadersEntity> getSubLeaders() {
        return subLeaders;
    }

    public void setSubLeaders(List<SubleadersEntity> subLeaders) {
        this.subLeaders = subLeaders;
    }

    public String getHeadUserName() {
        return headUserName;
    }

    public void setHeadUserName(String headUserName) {
        this.headUserName = headUserName;
    }

    public String getSupplyQueryType() {
        return supplyQueryType;
    }

    public void setSupplyQueryType(String supplyQueryType) {
        this.supplyQueryType = supplyQueryType;
    }
}
