/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.GroupMemberEntity;
import com.ejianc.business.pro.supplier.bean.InvestigateEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IGroupMemberService;
import com.ejianc.business.pro.supplier.service.IInvestigateService;
import com.ejianc.business.pro.supplier.vo.GroupMemberInvestigate;
import com.ejianc.business.pro.supplier.vo.GroupMemberVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"groupMember"})
public class GroupMemberController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IGroupMemberService service;
    @Autowired
    private IInvestigateService investigateService;
    @Autowired
    private ICanInService canInService;
    @Autowired
    private IBillTypeApi billTypeApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GroupMemberVO> saveOrUpdate(@RequestBody GroupMemberVO saveorUpdateVO) {
        GroupMemberEntity entity = (GroupMemberEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, GroupMemberEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        GroupMemberVO vo = (GroupMemberVO)BeanMapper.map((Object)((Object)entity), GroupMemberVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GroupMemberVO> queryDetail(Long id) {
        GroupMemberEntity entity = (GroupMemberEntity)((Object)this.service.selectById(id));
        GroupMemberVO vo = (GroupMemberVO)BeanMapper.map((Object)((Object)entity), GroupMemberVO.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"member_id", (Object)vo.getId());
        List list = this.investigateService.list((Wrapper)queryWrapper);
        ArrayList<GroupMemberInvestigate> allList = new ArrayList<GroupMemberInvestigate>();
        for (InvestigateEntity v : list) {
            GroupMemberInvestigate groupMemberInvestigate = new GroupMemberInvestigate();
            groupMemberInvestigate.setCode(v.getCode());
            CanInEntity canInEntity = (CanInEntity)((Object)this.canInService.getById(v.getCanInId()));
            groupMemberInvestigate.setName(canInEntity.getName());
            groupMemberInvestigate.setApplyOrgName(canInEntity.getApplyOrgName());
            groupMemberInvestigate.setDate(v.getDate());
            allList.add(groupMemberInvestigate);
        }
        vo.setInvestigateList(allList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GroupMemberVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (GroupMemberVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote("BT211225000000004", vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GroupMemberVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("phone");
        param.getFuzzyFields().add("email");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GroupMemberVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("phone");
        param.getFuzzyFields().add("email");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List voList = new ArrayList();
        if (list.size() > 0) {
            voList = BeanMapper.mapList((Iterable)list, GroupMemberVO.class);
            for (GroupMemberVO vo : voList) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getState() == null) continue;
                if (vo.getState().booleanValue()) {
                    vo.setStateName("\u662f");
                    continue;
                }
                vo.setStateName("\u5426");
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", voList);
        ExcelExport.getInstance().export("groupMember-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refGroupMemberData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<GroupMemberVO>> refGroupMemberData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GroupMemberVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

