package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.ejianc.business.pro.supplier.bean.InvExpertLeaderEntity;
import com.ejianc.business.pro.supplier.service.IInvExpertLeaderService;
import com.ejianc.business.pro.supplier.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.InvExpertEntity;
import com.ejianc.business.pro.supplier.service.IInvExpertService;
import com.ejianc.business.pro.supplier.vo.InvExpertVO;

/**
 * 供应商每个专家考察列表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("invExpert")
public class InvExpertController implements Serializable {
	private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IInvExpertService service;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IInvExpertLeaderService iInvExpertLeaderService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InvExpertVO> saveOrUpdate(@RequestBody InvExpertVO saveOrUpdateVO) {
    	InvExpertEntity entity = BeanMapper.map(saveOrUpdateVO, InvExpertEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	InvExpertVO vo = BeanMapper.map(entity, InvExpertVO.class);
    	return queryDetail(entity.getId());
    }

    /**
     * @Description submit 提交
     */
    @RequestMapping(value = "/submit", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvExpertVO> submit(@RequestParam Long id) {
    	InvExpertEntity entity = service.getById(id);
    	entity.setState("2");
    	entity.setSubmitDate(new Date());
        QueryParam param = new QueryParam();
        service.saveOrUpdate(entity, false);
    	param.getParams().put("canInId",new Parameter(QueryParam.EQ, entity.getCanInId()));
    	List<InvExpertEntity> list = service.queryList(param);
    	int score = 0;
    	int num = 0;
        for (InvExpertEntity expertEntity : list) {
            if("2".equals(expertEntity.getState())){
                score+=expertEntity.getScore();
                num++;
            }
        }
        List<InvExpertLeaderEntity> leaderEntities = iInvExpertLeaderService.queryList(param,false);
        if(ListUtil.isEmpty(leaderEntities)){
            return CommonResponse.error("未找到汇总单据，提交失败！");
        }
        InvExpertLeaderEntity leaderEntity = leaderEntities.get(0);
        if(num>0){
            score = score/num;
            leaderEntity.setScore(score);
            if(score>69){
                leaderEntity.setResult("合格");
            }else {
                leaderEntity.setResult("不合格");
            }
            leaderEntity.setSchedule(num+"/"+list.size());
            if(num == list.size()){
                /** 最后一个提交完，发送消息给组长 */
                sendMsg(leaderEntity.getSupplierName(),leaderEntity.getLeaderId());
            }
        }else {
            leaderEntity.setScore(0);
            leaderEntity.setResult("不合格");
            leaderEntity.setSchedule("0/"+list.size());
        }
        iInvExpertLeaderService.saveOrUpdate(leaderEntity,false);

    	InvExpertVO vo = BeanMapper.map(entity, InvExpertVO.class);
    	return CommonResponse.success("提交成功！",vo);
    }

    private void sendMsg(String supplierName,Long userId){
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        // 系统消息
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        channel.add(PushMsgParameter.CHANNEL_TYPE_DINGDING);
        JSONObject dingdingParams = new JSONObject();
        dingdingParams.put("maurl", "");
        dingdingParams.put("pcurl", "");
        dingdingParams.put("title", "【"+supplierName+"】所有专家已全部考察完毕,请及时汇总。");
        dingdingParams.put("content", "【"+supplierName+"】所有专家已全部考察完毕,请及时汇总。");
        parameter.setDingdingParams(dingdingParams);
        parameter.setReceivers(new String[]{userId.toString()});// 收信人
        parameter.setChannel(channel.toArray(new String[0]));// 消息类型
        parameter.setMsgType("notice");
        parameter.setSubject("【"+supplierName+"】所有专家已全部考察完毕,请及时汇总。");// 标题
        parameter.setContent( "【"+supplierName+"】所有专家已全部考察完毕,请及时汇总。");// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }

    /**
     * @Description reject 驳回
     */
    @RequestMapping(value = "/reject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> reject(@RequestParam("id") Long id,@RequestParam("reason") String reason) {
    	InvExpertEntity entity = service.getById(id);
    	entity.setState("3");
    	entity.setReason(reason);
        entity.setSubmitDate(null);
    	service.saveOrUpdate(entity, false);
    	QueryParam param = new QueryParam();
    	param.getParams().put("canInId",new Parameter(QueryParam.EQ, entity.getCanInId()));
    	List<InvExpertEntity> list = service.queryList(param);
        int num = 0;
        int score = 0;
        for (InvExpertEntity expertEntity : list) {
            if("2".equals(expertEntity.getState())){
                num++;
                score+=expertEntity.getScore();
            }
        }
        List<InvExpertLeaderEntity> leaderEntities = iInvExpertLeaderService.queryList(param,false);
        if(ListUtil.isEmpty(leaderEntities)){
            return CommonResponse.error("未找到汇总单据，提交失败！");
        }
        InvExpertLeaderEntity leaderEntity = leaderEntities.get(0);
        if(num>0){
            score = score/num;
            leaderEntity.setScore(score);
            if(score>69){
                leaderEntity.setResult("合格");
            }else {
                leaderEntity.setResult("不合格");
            }
            leaderEntity.setSchedule(num+"/"+list.size());
        }else {
            leaderEntity.setScore(0);
            leaderEntity.setSchedule("0/"+list.size());
            leaderEntity.setResult("不合格");
        }
        iInvExpertLeaderService.saveOrUpdate(leaderEntity,false);
    	return CommonResponse.success("驳回成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InvExpertVO> queryDetail(Long id) {
    	InvExpertEntity entity = service.selectById(id);
    	InvExpertVO vo = BeanMapper.map(entity, InvExpertVO.class);
        if(CollectionUtils.isNotEmpty(vo.getInvestigateContentEntities())){
            vo.setInvestigateContentEntities(TreeNodeBUtil.buildTree(vo.getInvestigateContentEntities()));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvExpertVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (InvExpertVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(InvExpertVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InvExpertVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyOrgName");
        fuzzyFields.add("exportNames");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("exportId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));

        IPage<InvExpertEntity> page = service.queryPage(param,false);
        IPage<InvExpertVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvExpertVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryForLeaderList 根据准入单，查询该准入单下所有的专家考察列表
     * @param canInId
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryForLeaderList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<InvExpertVO>> queryForLeaderList(@RequestParam Long canInId) {

        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("canInId", new Parameter(QueryParam.EQ, canInId));

        List<InvExpertEntity> page = service.queryList(param,false);
        List<InvExpertVO> pageData = BeanMapper.mapList(page, InvExpertVO.class);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        fuzzyFields.add("code");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyOrgName");
        fuzzyFields.add("exportNames");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("exportId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        List<InvExpertEntity> list = service.queryList(param);
        if(ListUtil.isNotEmpty(list)){
            List<InvExpertVO> voList = BeanMapper.mapList(list,InvExpertVO.class);
            for (InvExpertVO invExpertVO : voList) {
                invExpertVO.setMainBusiness(invExpertVO.getBusinessName(invExpertVO.getMainBusiness()));
                invExpertVO.setState(invExpertVO.getStateName(invExpertVO.getState()));
            }
            //todo:字段翻译等等
            Map<String, Object> beans = new HashMap<>();
            beans.put("records", voList);
            ExcelExport.getInstance().export("expert-export.xlsx", beans, response);
        }
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refInvExpertData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InvExpertVO>> refInvExpertData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InvExpertEntity> page = service.queryPage(param,false);
        IPage<InvExpertVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InvExpertVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
