package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.CanInMapper;
import com.ejianc.business.pro.supplier.service.ICanInService;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 供应商准入表
 *
 * @author generator
 */
@Service("canInService")
public class CanInServiceImpl extends BaseServiceImpl<CanInMapper, CanInEntity> implements ICanInService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IAbnormalService abnormalService;

    @Override
    public CommonResponse<String> afterInvestigate(Long canInId, Long gradeId, String gradeName) {
        CanInEntity canInEntity = selectById(canInId);
        canInEntity.setGradeId(gradeId);
        canInEntity.setGradeName(gradeName);
        canInEntity.setHasInvestigate(true);
        return pushSupplierToShare(canInEntity, "BT211210000000001");

    }

    @Override
    public CommonResponse<String> pushSupplierToShare(CanInEntity canInEntity, String billTypeCode) {
        Long billId = canInEntity.getId();
        //不需要考察 推送到共享中心
        SupplierVO supplierVO = BeanMapper.map(canInEntity, SupplierVO.class);
        supplierVO.setTaxPayerIdentifier(canInEntity.getTaxpayerNum());//纳税人识别号/身份证号
        supplierVO.setLegal(canInEntity.getLegalPerson());//法人代表/别名
        supplierVO.setBusinessScope(canInEntity.getBusinessRange());//经营范围
        supplierVO.setBlTime(canInEntity.getTimeOut());//营业执照有效期
        supplierVO.setCoordination(canInEntity.getCoordination());
        supplierVO.setTenantUserName(canInEntity.getCoordinationName());//// 协同姓名
        supplierVO.setTenantPhone(canInEntity.getCoordinationPhone());//// 协同手机号
        supplierVO.setRegisterTime(canInEntity.getRegisterDate());//注册日期
        supplierVO.setRegisteredCapital(canInEntity.getRegisterMny());// 注册资金
        supplierVO.setSupplyQueryType(canInEntity.getSupplyQueryType());//查询类型
        supplierVO.setSupplierGroupId(canInEntity.getSupplierGroupId());

        if (!canInEntity.getBanks().isEmpty()) {
            List<BankAccountVO> list = new ArrayList<>();
            for (BankEntity bank : canInEntity.getBanks()) {
                BankAccountVO vo1 = BeanMapper.map(bank, BankAccountVO.class);
                vo1.setBankAddress(bank.getAddress());
                list.add(vo1);
            }
            supplierVO.setBanks(list);
        }
        supplierVO.setAccessId(billId);//准入id
        if(canInEntity.getInException()!= null && canInEntity.getInException()){
            //准入时候 直接拉黑
            supplierVO.setInException(canInEntity.getInException());
            AbnormalEntity abnormalEntity= abnormalService.getById(canInEntity.getPunishType());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");//注意月份是MM
            try {
                if(abnormalEntity.getLastTime() != null){
                    String exceptionEndDate = PunishBpmServiceImpl.getLastMonthDate(new Date(),abnormalEntity.getLastTime());
                    Date date = simpleDateFormat.parse(exceptionEndDate);
                    supplierVO.setExceptionEndDate(date);
                }else{
                    Date date = simpleDateFormat.parse("3000-01-01");
                    supplierVO.setExceptionEndDate(date);
                }
                supplierVO.setPunishApplyOrg(canInEntity.getApplyOrgName());
                supplierVO.setPunishDate(new Date());
                supplierVO.setPunishGrade(canInEntity.getGradeName());
                supplierVO.setPunishMemo("准入时直接拉黑！");
                supplierVO.setPunishType(canInEntity.getPunishType());
            }catch (Exception e){
                logger.info("准入时候 直接拉黑出错---{},----billId : {}", e.getMessage(),billId);
            }
        }

        logger.info("billTypeCode---{}", billTypeCode);
        // 处理附件
        CommonResponse<String> fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "attachMgr",
                String.valueOf(billId), "BT200422000000028", "attachMgr");//附件
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384111794",
                String.valueOf(billId), "BT200422000000028", "K1639384111794");//法人委托授权书
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384112713",
                String.valueOf(billId), "BT200422000000028", "K1639384112713");//法人身份复印件
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384499212",
                String.valueOf(billId), "BT200422000000028", "K1639384499212");//营业执照
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384662753",
                String.valueOf(billId), "BT200422000000028", "K1639384662753");//身份证正面
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384663721",
                String.valueOf(billId), "BT200422000000028", "K1639384663721");//身份证反面
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K16393844992144",
                String.valueOf(billId), "BT200422000000028", "K16393844992144");//开户行许可证
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        if (ListUtil.isNotEmpty(canInEntity.getCerts())) {
            for (CertsEntity cert : canInEntity.getCerts()) {
                attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(cert.getId()), billTypeCode, "K1639386256873",
                        String.valueOf(cert.getId()), "BT200422000000028", "K1639386256873");//证件附件
            }
        }
        if (ListUtil.isNotEmpty(canInEntity.getSubLeaders())) {
            for (SubleadersEntity subLeader : canInEntity.getSubLeaders()) {
                attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(subLeader.getId()), billTypeCode, "K1639443798330",
                        String.valueOf(subLeader.getId()), "BT200422000000028", "K1639443798330");//分包负责人 社保证明
            }
        }

        logger.info("pushSupplierToShare----{}", JSONObject.toJSONString(supplierVO));
        return iProSupplierApi.pushSupplierToShare(JSONObject.toJSONString(supplierVO).getBytes(StandardCharsets.UTF_8));
    }
}
