/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.contractbase.utils.EJCDateUtil;
import com.ejianc.business.pro.rmat.api.IRentCalculateApi;
import com.ejianc.business.pro.supplier.consts.ComerateAnalysisEnum;
import com.ejianc.business.pro.supplier.service.ISupplierStatisticsService;
import com.ejianc.business.pro.supplier.vo.CooperateSourceBliVO;
import com.ejianc.business.promaterial.plan.api.IBatPlanApi;
import com.ejianc.business.promaterial.plan.vo.SourceBliVO;
import com.ejianc.business.prosub.api.IContractApi;
import com.ejianc.business.settle.api.ISettleApi;
import com.ejianc.business.settlement.api.IPurchaseSettleApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ISupplierStatisticsService")
public class SupplierStatisticsImpl
implements ISupplierStatisticsService {
    @Autowired
    private IContractApi contractApi;
    @Autowired
    private IBatPlanApi batPlanApi;
    @Autowired
    private IPurchaseSettleApi purchaseSettleApi;
    @Autowired
    private ISettleApi settleApi;
    @Autowired
    private IRentCalculateApi rentCalculateApi;

    @Override
    public CommonResponse<List<CooperateSourceBliVO>> cooperateAnalysis(Long supplierId, String dateIn) {
        com.ejianc.business.prosub.vo.SourceBliVO data;
        CommonResponse commonResponse;
        CommonResponse rmatCommonResponse;
        if (ComerateAnalysisEnum.THISYEAR.getCode().equals(dateIn)) {
            dateIn = EJCDateUtil.getYear() + "";
        } else if (ComerateAnalysisEnum.ALLDATE.getCode().equals(dateIn)) {
            dateIn = null;
        }
        ArrayList<CooperateSourceBliVO> resultList = new ArrayList<CooperateSourceBliVO>();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        CommonResponse materialSourceBliVO = this.batPlanApi.getSourceBliVO(supplierId, dateIn);
        if (materialSourceBliVO.isSuccess() && materialSourceBliVO.getData() != null) {
            CooperateSourceBliVO cooperateSourceBliVO;
            List list = (List)materialSourceBliVO.getData();
            Map<String, SourceBliVO> map = list.stream().collect(Collectors.toMap(k -> k.getType(), k -> k));
            if (map.containsKey("material")) {
                SourceBliVO material = map.get("material");
                cooperateSourceBliVO = new CooperateSourceBliVO();
                cooperateSourceBliVO.setSourceNum(material.getSourceNum());
                cooperateSourceBliVO.setCoordinationNum(material.getCoordinationNum());
                if (material.getRatio() == null) {
                    cooperateSourceBliVO.setRatio(BigDecimal.ZERO);
                } else {
                    cooperateSourceBliVO.setRatio(material.getRatio());
                }
                cooperateSourceBliVO.setType(material.getType());
                cooperateSourceBliVO.setName("\u6750\u6599\u7ba1\u7406");
                resultList.add(cooperateSourceBliVO);
            }
            if (map.containsKey("concrete")) {
                SourceBliVO concrete = map.get("concrete");
                cooperateSourceBliVO = new CooperateSourceBliVO();
                cooperateSourceBliVO.setSourceNum(concrete.getSourceNum());
                cooperateSourceBliVO.setCoordinationNum(concrete.getCoordinationNum());
                if (concrete.getRatio() == null) {
                    cooperateSourceBliVO.setRatio(BigDecimal.ZERO);
                } else {
                    cooperateSourceBliVO.setRatio(concrete.getRatio());
                }
                cooperateSourceBliVO.setType(concrete.getType());
                cooperateSourceBliVO.setName("\u6df7\u51dd\u571f\u7ba1\u7406");
                resultList.add(cooperateSourceBliVO);
            }
        }
        if ((rmatCommonResponse = this.rentCalculateApi.getSourceBliVO(supplierId, dateIn)).isSuccess() && rmatCommonResponse.getData() != null) {
            com.ejianc.business.pro.rmat.vo.SourceBliVO rmatVo = (com.ejianc.business.pro.rmat.vo.SourceBliVO)rmatCommonResponse.getData();
            CooperateSourceBliVO cooperateSourceBliVO = new CooperateSourceBliVO();
            cooperateSourceBliVO.setSourceNum(rmatVo.getSourceNum());
            cooperateSourceBliVO.setCoordinationNum(rmatVo.getCoordinationNum());
            if (rmatVo.getRatio() == null) {
                cooperateSourceBliVO.setRatio(BigDecimal.ZERO);
            } else {
                cooperateSourceBliVO.setRatio(rmatVo.getRatio());
            }
            cooperateSourceBliVO.setType(rmatVo.getType());
            cooperateSourceBliVO.setName("\u5468\u8f6c\u6750\u7ba1\u7406");
            resultList.add(cooperateSourceBliVO);
        }
        ArrayList<CooperateSourceBliVO> eqList = new ArrayList<CooperateSourceBliVO>();
        CommonResponse purchaseCommonResponse = this.purchaseSettleApi.getSourceBliVO(supplierId, dateIn);
        if (purchaseCommonResponse.isSuccess()) {
            com.ejianc.business.settlement.vo.SourceBliVO data2 = (com.ejianc.business.settlement.vo.SourceBliVO)purchaseCommonResponse.getData();
            CooperateSourceBliVO sourceBlivo = new CooperateSourceBliVO();
            sourceBlivo.setSourceNum(data2.getSourceNum());
            sourceBlivo.setCoordinationNum(data2.getCoordinationNum());
            sourceBlivo.setType(data2.getType());
            eqList.add(sourceBlivo);
        }
        if ((commonResponse = this.settleApi.getSourceBliVO(supplierId, dateIn)).isSuccess()) {
            com.ejianc.business.settle.vo.SourceBliVO data3 = (com.ejianc.business.settle.vo.SourceBliVO)commonResponse.getData();
            CooperateSourceBliVO sourceBlivo = new CooperateSourceBliVO();
            sourceBlivo.setSourceNum(data3.getSourceNum());
            sourceBlivo.setCoordinationNum(data3.getCoordinationNum());
            sourceBlivo.setType(data3.getType());
            eqList.add(sourceBlivo);
        }
        BigDecimal sourceNum = BigDecimal.ZERO;
        BigDecimal coordinationNum = BigDecimal.ZERO;
        BigDecimal ratio = BigDecimal.ZERO;
        for (CooperateSourceBliVO sourceBliVO : eqList) {
            sourceNum = ComputeUtil.safeAdd((BigDecimal)sourceBliVO.getSourceNum(), (BigDecimal)sourceNum);
            coordinationNum = ComputeUtil.safeAdd((BigDecimal)sourceBliVO.getSourceNum(), (BigDecimal)coordinationNum);
        }
        ratio = ComputeUtil.safeDiv((BigDecimal)sourceNum, (BigDecimal)coordinationNum);
        CooperateSourceBliVO cooperateSourceBliVO = new CooperateSourceBliVO();
        cooperateSourceBliVO.setSourceNum(sourceNum);
        cooperateSourceBliVO.setCoordinationNum(coordinationNum);
        cooperateSourceBliVO.setRatio(ratio);
        cooperateSourceBliVO.setType("equipment");
        cooperateSourceBliVO.setName("\u8bbe\u5907\u7ba1\u7406");
        resultList.add(cooperateSourceBliVO);
        CommonResponse subCommonResponse = this.contractApi.getSourceBliVO(supplierId, dateIn);
        if (subCommonResponse.isSuccess() && (data = (com.ejianc.business.prosub.vo.SourceBliVO)subCommonResponse.getData()) != null) {
            CooperateSourceBliVO vo = new CooperateSourceBliVO();
            vo.setSourceNum(data.getSourceNum());
            vo.setCoordinationNum(data.getCoordinationNum());
            if (data.getRatio() == null) {
                vo.setRatio(BigDecimal.ZERO);
            } else {
                vo.setRatio(data.getRatio());
            }
            vo.setType(data.getType());
            vo.setName("\u5206\u5305\u7ba1\u7406");
            resultList.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", resultList);
    }
}

