package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.mapper.SubcontractCanInMapper;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.ISubcontractCanInService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分包供应商准入表
 * 
 * @author generator
 * 
 */
@Service("subcontractCanInService")
public class SubcontractCanInServiceImpl extends BaseServiceImpl<SubcontractCanInMapper, SubcontractCanInEntity> implements ISubcontractCanInService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IAbnormalService abnormalService;

    @Override
    public CommonResponse<String> pushSupplierToShare(SubcontractCanInEntity entity, String billTypeCode) {
        Long billId = entity.getId();
        //不需要考察 推送到共享中心
        SupplierVO supplierVO = BeanMapper.map(entity,SupplierVO.class);
        supplierVO.setTaxPayerIdentifier(entity.getTaxpayerNum());//纳税人识别号/身份证号
        supplierVO.setLegal(entity.getLegalPerson());//法人代表/别名
        supplierVO.setBusinessScope(entity.getBusinessRange());//经营范围
        supplierVO.setBlTime(entity.getTimeOut());//营业执照有效期
        supplierVO.setTenantUserName(entity.getCoordinationName());//// 协同姓名
        supplierVO.setTenantPhone(entity.getCoordinationPhone());//// 协同手机号
        supplierVO.setRegisterTime(entity.getRegisterDate());//注册日期
        supplierVO.setRegisteredCapital(entity.getRegisterMny());// 注册资金
        if(!entity.getBanks().isEmpty()){
            List<BankAccountVO> list = new ArrayList<>();
            for (BankEntity bank : entity.getBanks()) {
                BankAccountVO vo1 = BeanMapper.map(bank,BankAccountVO.class);
                vo1.setBankAddress(bank.getAddress());
                list.add(vo1);
            }
            supplierVO.setBanks(list);
        }
        supplierVO.setAccessId(billId);//准入id
        if(entity.getInException() != null && entity.getInException()){
            //准入时候 直接拉黑
            supplierVO.setInException(entity.getInException());
            AbnormalEntity abnormalEntity= abnormalService.getById(entity.getPunishType());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");//注意月份是MM
            try {
                if(abnormalEntity.getLastTime() != null){
                    String exceptionEndDate = PunishBpmServiceImpl.getLastMonthDate(new Date(),abnormalEntity.getLastTime());
                    Date date = simpleDateFormat.parse(exceptionEndDate);
                    supplierVO.setExceptionEndDate(date);
                }else{
                    Date date = simpleDateFormat.parse("3000-01-01");
                    supplierVO.setExceptionEndDate(date);
                }
                supplierVO.setPunishApplyOrg(entity.getApplyOrgName());
                supplierVO.setPunishDate(new Date());
                supplierVO.setPunishGrade(entity.getGradeName());
                supplierVO.setPunishMemo("准入时直接拉黑！");
                supplierVO.setPunishType(entity.getPunishType());
            }catch (Exception e){
                logger.info("准入时候 直接拉黑出错---{},----billId : {}", e.getMessage(),billId);
            }
        }

        logger.info("billTypeCode---{}",billTypeCode);
        // 处理附件
        billTypeCode="BT211230000000004";
        CommonResponse<String> fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "attachMgr",
                String.valueOf(billId), "BT200422000000028", "attachMgr");//附件
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384111794",
                String.valueOf(billId), "BT200422000000028", "K1639384111794");//法人委托授权书
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384112713",
                String.valueOf(billId), "BT200422000000028", "K1639384112713");//法人身份复印件
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384499212",
                String.valueOf(billId), "BT200422000000028", "K1639384499212");//营业执照
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384662753",
                String.valueOf(billId), "BT200422000000028", "K1639384662753");//身份证正面
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384663721",
                String.valueOf(billId), "BT200422000000028", "K1639384663721");//身份证反面
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K16393844992144",
                String.valueOf(billId), "BT200422000000028", "K16393844992144");//开户许可证
        logger.info("fileRes---{}",JSONObject.toJSONString(fileRes));
        if(ListUtil.isNotEmpty(entity.getCerts())){
            for (CertsEntity cert : entity.getCerts()) {
                attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(cert.getId()), billTypeCode, "K1639386256873",
                        String.valueOf(cert.getId()), "BT200422000000028", "K1639386256873");//证件附件
            }
        }
        if(ListUtil.isNotEmpty(entity.getSubLeaders())){
            CommonResponse<String> copyRs = null;
            for (SubleadersEntity subLeader : entity.getSubLeaders()) {
                copyRs = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(subLeader.getId()), billTypeCode, "K1639443798330",
                        String.valueOf(subLeader.getId()), "BT200422000000028", "K1639443798330");//分包负责人 社保证明
                logger.info("分包负责人-{}, 社保证明同步供应商库结果：{}", subLeader.getId(), JSONObject.toJSONString(copyRs));
                copyRs = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(subLeader.getId()), billTypeCode, "labsubContractFile",
                        String.valueOf(subLeader.getId()), "BT200422000000028", "labsubContractFile");//分包负责人 劳动合同
                logger.info("分包负责人-{}, 劳动合同同步供应商库结果：{}", subLeader.getId(), JSONObject.toJSONString(copyRs));
            }
        }

        logger.info("pushSupplierToShare----{}", JSONObject.toJSONString(supplierVO));
        return iProSupplierApi.pushSupplierToShare(JSONObject.toJSONString(supplierVO).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public List<SubleadersEntity> checkSubLeader(List<String> subLeaderIdNumList, Long subcontractCanInId) {
        return baseMapper.querySubLeader(subLeaderIdNumList, subcontractCanInId);
    }

    @Override
    public CommonResponse<String> afterInvestigate(Long canInId, Long gradeId, String gradeName) {
        SubcontractCanInEntity canInEntity = selectById(canInId);
        canInEntity.setGradeId(gradeId);
        canInEntity.setGradeName(gradeName);
        return pushSupplierToShare(canInEntity,"BT211230000000004");

    }
}
