package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.pro.supplier.bean.InvestigateEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractCanInEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractInvestigateEntity;
import com.ejianc.business.pro.supplier.service.ISubcontractCanInService;
import com.ejianc.business.pro.supplier.service.ISubcontractInvestigateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("subcontractInvestigate") 
public class SubcontractInvestigateBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ISubcontractInvestigateService subcontractInvestigateService;
	@Autowired
	private ISubcontractCanInService subcontractCanInService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SubcontractInvestigateEntity entity= subcontractInvestigateService.getById(billId);
		Long canInId = entity.getCanInId();
		Long gradeId = entity.getGradeId();
		String gradeName = entity.getGrade();
		if(entity.getInvestigateResults().equals(1)){
			CommonResponse<String> response =subcontractCanInService.afterInvestigate(canInId,gradeId,gradeName);
			if(response.isSuccess()){
				return CommonResponse.success();
			}else{
				return CommonResponse.error(response.getMsg());
			}
		}else{
			SubcontractCanInEntity subcontractCanInEntity =subcontractCanInService.getById(canInId);
			subcontractCanInEntity.setHasInvestigate(true);
			subcontractCanInService.saveOrUpdate(subcontractCanInEntity,false);
		}
		return CommonResponse.success();

	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		SubcontractInvestigateEntity entity= subcontractInvestigateService.getById(billId);
		Long canInId = entity.getCanInId();
		Long gradeId = entity.getGradeId();
		String gradeName = entity.getGrade();
		if(!entity.getInvestigateResults().equals(1)){
			SubcontractCanInEntity subcontractCanInEntity =subcontractCanInService.getById(canInId);
			subcontractCanInEntity.setHasInvestigate(false);
			subcontractCanInService.saveOrUpdate(subcontractCanInEntity,false);
			return CommonResponse.success();
		}else{
			return CommonResponse.error("供应商考察不支持撤回");
		}
	}
}
