package com.ejianc.business.pro.supplier.service.appraise;

import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 评价服务
 * @date 2022/4/24
 */
@Service
public class AppraiseService {


    @Autowired
    private Map<String, AppraiseStrategy> appraiseStrategyMap;


    public AppraiseResultVO pushProcessAppraise(AppraiseParamVO appraiseParamVO) {
        return this.appraiseStrategyMap.get(appraiseParamVO.getRuleName().toLowerCase() + "_appraise").pushProcessAppraise(appraiseParamVO);
    }


    public AppraiseResultVO pushYearAppraise(AppraiseParamVO appraiseParamVO) {
        return this.appraiseStrategyMap.get(appraiseParamVO.getRuleName().toLowerCase() + "_appraise").pushYearAppraise(appraiseParamVO);
    }

    public String pushIncidentAppraiseAnnually(AppraiseParamVO appraiseParamVO) {
        return this.appraiseStrategyMap.get(appraiseParamVO.getRuleName().toLowerCase() + "_appraise").pushIncidentAppraiseAnnually(appraiseParamVO);
    }
}
