package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.bean.SupplierGroupEntity;
import com.ejianc.business.pro.supplier.service.*;
import com.ejianc.business.pro.supplier.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.util.QRCodeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * i8接口同步
 *
 *
 */
@RestController
@RequestMapping("sync")
public class SyncI8Controller implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProcessService processService;
    @Autowired
    private IYearService yearService;
    @Autowired
    private ISupplierGroupService supplierGroupService;
    @Autowired
    IProSupplierApi proSupplierApi;

    /**
     * @Description syncSupplierGroup i8数据推送-集团供应商库
     */
    @RequestMapping(value = "/syncSupplierGroup", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncSupplierGroup(@RequestBody List<SupplierGroupVO> saveOrUpdateVOs) {
        return supplierGroupService.syncSupplierGroup(saveOrUpdateVOs);
    }

    /**
     * @Description syncSupplierGroupDelete i8数据推送-集团供应商库删除
     */
    @RequestMapping(value = "/syncSupplierGroupDelete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncSupplierGroupDelete(@RequestBody List<SupplierGroupVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            List<SupplierGroupEntity> supplierGroupList = supplierGroupService.list(new QueryWrapper<SupplierGroupEntity>().in("code", vos.stream().map(SupplierGroupVO::getCode).collect(Collectors.toList())));
            for (SupplierGroupEntity entity : supplierGroupList) {
                CommonResponse<SupplierVO> supplierVOCommonResponse = proSupplierApi.selectBySupplierGroupIdOrI8Code(entity.getId(), entity.getCode());
                if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData().getId() > 0){
                    return CommonResponse.error("供应商" + entity.getName() + "已准入，不能删除！");
                }
            }
            supplierGroupService.removeByIds(supplierGroupList.stream().map(SupplierGroupEntity::getId).collect(Collectors.toList()),true);
        }
        return CommonResponse.success("删除成功！");
    }


    /**
     * @Description syncProcess i8数据推送-供应商评价
     */
    @RequestMapping(value = "/syncProcess", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncProcess(@RequestBody ProcessVO saveOrUpdateVO) {
        return processService.syncProcess(saveOrUpdateVO);
    }

    /**
     * @Description syncProcessDelete i8数据推送-供应商评价
     */
    @RequestMapping(value = "/syncProcessDelete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncProcessDelete(@RequestBody ProcessVO saveOrUpdateVO) {
        return CommonResponse.error("已有下游业务，不可删除！");
    }

    /**
     * @Description syncYear i8数据推送-供应商年度评价
     */
    @RequestMapping(value = "/syncYear", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncYear(@RequestBody YearVO saveOrUpdateVO) {
        return yearService.syncYear(saveOrUpdateVO);
    }


    /**
     * @Description syncYearDelete i8数据推送-供应商年度评价
     */
    @RequestMapping(value = "/syncYearDelete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncYearDelete(@RequestBody YearVO saveOrUpdateVO) {
        return CommonResponse.error("已有下游业务，不可删除！");
    }


}
