/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.vo.CanInVO;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.util.QRCodeUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"canIn"})
public class CanInController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "pro-supplier-code";
    @Autowired
    private ICanInService service;
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private QRCodeUtil qrCodeUtil;
    @Autowired
    private IProSupplierApi iProSupplierApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CanInVO> saveOrUpdate(@RequestBody CanInVO saveOrUpdateVO) {
        List entities;
        CanInEntity entity = (CanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CanInEntity.class));
        if (entity.getCode() == null) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getSupplyType().contains("material") || entity.getSupplyType().contains("equipment") || entity.getSupplyType().contains("revolvMaterial")) {
            entity.setSupplyQueryType("materialEquipment");
        } else {
            entity.setSupplyQueryType("other");
        }
        CommonResponse exist = this.iProSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getTaxpayerNum(), saveOrUpdateVO.getPersonal(), saveOrUpdateVO.getSupplyType());
        if (!exist.isSuccess()) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5e93\u4e2d\uff1a\u8be5\u7c7b\u578b\u4f9b\u5e94\u5546\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u65b0\u589e!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum", new Parameter("eq", (Object)saveOrUpdateVO.getTaxpayerNum()));
        String[] supplyType = saveOrUpdateVO.getSupplyType().split(",");
        ComplexParam c = new ComplexParam();
        c.setLogic("and");
        for (int i = 0; i < supplyType.length; ++i) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic("or");
            t.getParams().put("supplyType", new Parameter("like", (Object)type));
            c.getComplexParams().add(t);
        }
        param.getComplexParams().add(c);
        if (entity.getId() != null) {
            param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        }
        if (ListUtil.isNotEmpty((List)(entities = this.service.queryList(param)))) {
            return CommonResponse.error((String)("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((CanInEntity)((Object)entities.get(0))).getApplyOrgName() + "\u3011\u7684\u3010" + ((CanInEntity)((Object)entities.get(0))).getSupplyTypeName() + "\u3011\u51c6\u5165\u6d41\u7a0b\uff0c\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u91cd\u590d!"));
        }
        QueryParam params = new QueryParam();
        params.getParams().put("name", new Parameter("eq", (Object)saveOrUpdateVO.getName()));
        c = new ComplexParam();
        c.setLogic("and");
        for (int i = 0; i < supplyType.length; ++i) {
            String type = supplyType[i];
            ComplexParam t = new ComplexParam();
            t.setLogic("or");
            t.getParams().put("supplyType", new Parameter("like", (Object)type));
            c.getComplexParams().add(t);
        }
        params.getComplexParams().add(c);
        if (entity.getId() != null) {
            params.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(entities = this.service.queryList(params)))) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((CanInEntity)((Object)entities.get(0))).getApplyOrgName() + "\u3011\u7684\u3010" + ((CanInEntity)((Object)entities.get(0))).getSupplyTypeName() + "\u3011\u51c6\u5165\u6d41\u7a0b\uff0c\u540d\u79f0\u91cd\u590d!");
        }
        this.service.saveOrUpdate((Object)entity, false);
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdates"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CanInVO> saveOrUpdates(@RequestBody CanInVO saveOrUpdateVO) {
        CanInEntity entity = (CanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CanInEntity.class));
        if (entity.getCode() == null) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getSupplyType().contains("material") || entity.getSupplyType().contains("equipment") || entity.getSupplyType().contains("revolvMaterial")) {
            entity.setSupplyQueryType("materialEquipment");
        } else {
            entity.setSupplyQueryType("other");
        }
        this.service.saveOrUpdate((Object)entity, false);
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CanInVO> queryDetail(Long id) {
        CanInEntity entity = (CanInEntity)((Object)this.service.selectById(id));
        CanInVO vo = (CanInVO)BeanMapper.map((Object)((Object)entity), CanInVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CanInVO> vos) {
        QueryParam param = new QueryParam();
        for (CanInVO vo : vos) {
            CanInEntity entity = (CanInEntity)((Object)this.service.selectById(vo.getId()));
            param.getParams().put("taxpayerNum", new Parameter("eq", (Object)entity.getTaxpayerNum()));
            List list = this.inviteService.queryList(param);
            if (!ListUtil.isNotEmpty((List)list)) continue;
            for (InviteEntity inviteEntity : list) {
                inviteEntity.setBillState(0);
            }
            this.inviteService.saveOrUpdateBatch(list);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("material_content");
        param.getFuzzyFields().add("equipment_content");
        param.getFuzzyFields().add("major_content");
        param.getFuzzyFields().add("apply_org_name");
        param.getFuzzyFields().add("taxpayerNum");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CanIn-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCanInData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CanInVO>> refCanInData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryInviteEntityDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CanInVO> queryInviteEntityDetail(Long id, Long userId, String userName) {
        InviteEntity entity = (InviteEntity)((Object)this.inviteService.selectById(id));
        entity.setHandlePersonId(userId);
        entity.setHandlePerson(userName);
        entity.setHandleTime(new Date());
        entity.setBillState(1);
        InviteVO inviteVO = (InviteVO)BeanMapper.map((Object)((Object)entity), InviteVO.class);
        CanInVO vo = (CanInVO)BeanMapper.map((Object)inviteVO, CanInVO.class);
        vo.setId(null);
        vo.setCreateTime(null);
        vo.setInviteId(inviteVO.getId());
        vo.setApplyOrgId(InvocationInfoProxy.getOrgId());
        vo.setInOrOut(Integer.valueOf(1));
        vo.setRegisterCountryName("\u4e2d\u56fd");
        vo.setRegisterCountryId(Long.valueOf(493873812443236045L));
        vo.setBillState(Integer.valueOf(0));
        vo.setCoordination(Boolean.valueOf(false));
        CommonResponse<CanInVO> responseVO = this.saveOrUpdates(vo);
        if (responseVO.isSuccess()) {
            vo = (CanInVO)responseVO.getData();
            entity.setCanInNum(vo.getCode());
            this.inviteService.saveOrUpdate((Object)entity);
            CommonResponse fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K163938414458", String.valueOf(vo.getId()), "BT211210000000001", "K1639384111794");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K163938666354", String.valueOf(vo.getId()), "BT211210000000001", "K1639384112713");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1633365485", String.valueOf(vo.getId()), "BT211210000000001", "K1639384499212");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1642125492056", String.valueOf(vo.getId()), "BT211210000000001", "K1639384662753");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1642125495124", String.valueOf(vo.getId()), "BT211210000000001", "K1639384663721");
            fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(inviteVO.getId()), "BT220117000000001", "K1655538377522", String.valueOf(vo.getId()), "BT211210000000001", "K16393844992144");
        }
        return responseVO;
    }

    @RequestMapping(value={"/getQrCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getQrCode() {
        return CommonResponse.success((String)"", (Object)this.qrCodeUtil.getBase64QRCode("https://www.baidu.com/"));
    }
}

